<tr class="item-row" data-index="{{ $index }}">
    <td>
        <select name="items[{{ $index }}][stock_item_id]" class="form-select stock-item-select" required>
            <option value="">Select Item</option>
            @foreach($stockItems as $item)
                <option value="{{ $item->id }}" data-rate="{{ $item->rate ?? 0 }}">{{ $item->name }}</option>
            @endforeach
        </select>
    </td>
    <td>
        <input type="text" name="items[{{ $index }}][description]" class="form-control item-description" placeholder="Description">
    </td>
    <td>
        <input type="number" name="items[{{ $index }}][quantity]" class="form-control item-quantity" 
               placeholder="Qty" min="1" step="1" required>
    </td>
    <td>
        <input type="number" name="items[{{ $index }}][rate]" class="form-control item-rate" 
               placeholder="Rate" min="0" step="0.01" required>
    </td>
    <td>
        <input type="number" name="items[{{ $index }}][amount]" class="form-control item-amount" 
               placeholder="Amount" readonly>
    </td>
    <td>
        <button type="button" class="btn btn-sm btn-danger remove-item">
            <i class="fas fa-trash"></i>
        </button>
    </td>
</tr>

<script>
$(document).ready(function() {
    // Handle stock item selection
    $('.stock-item-select').on('change', function() {
        var row = $(this).closest('.item-row');
        var selectedOption = $(this).find('option:selected');
        var rate = selectedOption.data('rate') || 0;
        
        row.find('.item-rate').val(rate);
        calculateAmount(row);
    });

    // Handle quantity and rate changes
    $('.item-quantity, .item-rate').on('input', function() {
        calculateAmount($(this).closest('.item-row'));
    });

    // Remove item row
    $('.remove-item').on('click', function() {
        $(this).closest('.item-row').remove();
        updateItemIndexes();
    });

    function calculateAmount(row) {
        var quantity = parseFloat(row.find('.item-quantity').val()) || 0;
        var rate = parseFloat(row.find('.item-rate').val()) || 0;
        var amount = quantity * rate;
        
        row.find('.item-amount').val(amount.toFixed(2));
        calculateTotals();
    }

    function updateItemIndexes() {
        $('.item-row').each(function(index) {
            $(this).attr('data-index', index);
            $(this).find('select, input').each(function() {
                var name = $(this).attr('name');
                if (name) {
                    $(this).attr('name', name.replace(/\[\d+\]/, '[' + index + ']'));
                }
            });
        });
    }

    function calculateTotals() {
        var subtotal = 0;
        $('.item-amount').each(function() {
            subtotal += parseFloat($(this).val()) || 0;
        });
        
        $('#subtotal').val(subtotal.toFixed(2));
        
        // Calculate taxes (assuming 18% GST - 9% CGST + 9% SGST)
        var cgst = subtotal * 0.09;
        var sgst = subtotal * 0.09;
        var igst = 0; // IGST is 0 for same state transactions
        
        $('#cgst_amount').val(cgst.toFixed(2));
        $('#sgst_amount').val(sgst.toFixed(2));
        $('#igst_amount').val(igst.toFixed(2));
        
        // Calculate total
        var additionalCharges = parseFloat($('#additional_charges').val()) || 0;
        var tdsAmount = parseFloat($('#tds_amount').val()) || 0;
        var total = subtotal + cgst + sgst + igst + additionalCharges - tdsAmount;
        
        $('#total_amount').val(total.toFixed(2));
    }
});
</script> 