@extends('layouts.dashboard.superadminapp')

@section('title', 'Manufacturing Planning')

@push('styles')
    <style>
        .page-header-gradient {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            padding: 2rem;
            border-radius: 1rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 20px rgba(78, 115, 223, 0.2);
            position: relative;
            overflow: hidden;
        }
        
        .page-header-bg {
            position: absolute;
            right: -20px;
            bottom: -20px;
            font-size: 10rem;
            opacity: 0.1;
            transform: rotate(-15deg);
        }

        .nav-tabs-custom {
            border-bottom: 2px solid #e3e6f0;
        }

        .nav-tabs-custom .nav-link {
            border: none;
            border-bottom: 3px solid transparent;
            color: #858796;
            font-weight: 600;
            padding: 1rem 1.5rem;
            transition: all 0.2s;
        }

        .nav-tabs-custom .nav-link:hover {
            color: #4e73df;
            background-color: transparent;
        }

        .nav-tabs-custom .nav-link.active {
            color: #4e73df;
            background-color: transparent;
            border-bottom-color: #4e73df;
        }

        .project-card {
            border: none;
            border-radius: 0.75rem;
            background: #fff;
            box-shadow: 0 .15rem 1.75rem 0 rgba(58,59,69,.15)!important;
            transition: transform 0.2s;
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .project-card:hover {
            transform: translateY(-5px);
        }

        .border-left-wait { border-left: 0.25rem solid #f6c23e !important; }
        .border-left-plan { border-left: 0.25rem solid #1cc88a !important; }

        .card-header-custom {
            background-color: #fff;
            border-bottom: 1px solid #f8f9fc;
            padding: 1.25rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-body-custom {
            padding: 1.25rem;
        }

        .info-group {
            margin-bottom: 1rem;
        }

        .info-label {
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            color: #b7b9cc;
            font-weight: 700;
        }

        .info-value {
            font-size: 0.95rem;
            color: #5a5c69;
            font-weight: 600;
        }

        .btn-premium {
            border-radius: 50rem;
            padding: 0.5rem 1.5rem;
            font-weight: 600;
            box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
            transition: all 0.15s ease;
        }
        
        .btn-premium:hover {
            transform: translateY(-1px);
            box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
        }

        .status-badge {
            padding: 0.4em 0.8em;
            border-radius: 0.5rem;
            font-size: 0.75rem;
            font-weight: 700;
            letter-spacing: 0.5px;
        }
        .badge-soft-warning { background-color: #fff8e1; color: #f6c23e; }
        .badge-soft-success { background-color: #e8f5e9; color: #1cc88a; }
        .badge-soft-secondary { background-color: #f1f3f9; color: #858796; }

    </style>
@endpush

@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <div class="container-fluid px-4 py-4">

        <!-- Page Header -->
        <div class="page-header-gradient d-flex justify-content-between align-items-center">
            <div>
                <h1 class="h3 font-weight-bold mb-1">Production Planning</h1>
                <p class="mb-0 text-white-50">Orchestrate your manufacturing schedules & workflows.</p>
            </div>
            <div class="d-none d-md-block text-right">
                <div class="h5 font-weight-bold mb-0">{{ now()->format('F d, Y') }}</div>
                <div class="small text-white-50">{{ now()->format('l') }}</div>
            </div>
            <i class="fas fa-industry page-header-bg"></i>
        </div>

        <!-- Navigation Tabs -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <ul class="nav nav-tabs nav-tabs-custom" id="planningTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="r2plan-tab" data-toggle="tab" href="#r2plan" role="tab" aria-controls="r2plan" aria-selected="true" onclick="updateUrlTab('r2plan')">
                        <i class="fas fa-clipboard-list mr-2"></i>New Orders
                        <span class="badge badge-warning badge-pill ml-2">{{ $read2PlanOrders->count() }}</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="planning-tab" data-toggle="tab" href="#planning" role="tab" aria-controls="planning" aria-selected="false" onclick="updateUrlTab('planning')">
                        <i class="fas fa-tasks mr-2"></i>Active Plans
                        <span class="badge badge-primary badge-pill ml-2">{{ $planningOrders->count() }}</span>
                    </a>
                </li>
            </ul>
            <a href="{{ route('superadmin.routecard.ganttchart') }}" class="btn btn-light shadow-sm text-primary font-weight-bold">
                <i class="fas fa-stream mr-2"></i>Gantt View
            </a>
        </div>

        <div class="tab-content" id="planningTabsContent">
            
            <!-- Ready to Plan Tab -->
            <div class="tab-pane fade show active" id="r2plan" role="tabpanel">
                @if($read2PlanOrders->isEmpty())
                    <div class="card shadow-sm border-0 py-5 text-center">
                        <div class="card-body">
                            <i class="fas fa-clipboard-check fa-4x text-gray-300 mb-3"></i>
                            <h5 class="text-gray-600">All caught up! No orders pending for planning.</h5>
                        </div>
                    </div>
                @endif

                <div class="row">
                    @foreach ($read2PlanOrders as $order)
                        <div class="col-xl-4 col-md-6 mb-4" id="card-{{ $order->routeCard->id ?? '' }}">
                            <div class="project-card border-left-wait">
                                <div class="card-header-custom">
                                    <div class="font-weight-bold text-primary text-truncate" style="max-width: 70%;">
                                        <i class="fas fa-hashtag mr-1 text-gray-400"></i>{{ $order->sales_order_no }}
                                    </div>
                                    <div class="dropdown no-arrow">
                                        <a class="dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in">
                                            <a class="dropdown-item" href="{{ route('superadmin.routecard.index', ['sale_order_id' => $order->id]) }}">
                                                <i class="fas fa-plus mr-2 text-warning"></i> Create Plan
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body-custom">
                                    <div class="row">
                                        <div class="col-6 info-group">
                                            <div class="info-label">Customer</div>
                                            <div class="info-value text-truncate" title="{{ $order->customer?->company }}">{{ $order->customer?->company ?? 'N/A' }}</div>
                                        </div>
                                        <div class="col-6 info-group">
                                            <div class="info-label">Order Date</div>
                                            <div class="info-value">{{ \Carbon\Carbon::parse($order->sales_order_date)->format('d M, Y') }}</div>
                                        </div>
                                    </div>
                                    <div class="mt-3">
                                        <a href="{{ route('superadmin.routecard.index', ['sale_order_id' => $order->id]) }}" class="btn btn-warning btn-premium btn-block text-white">
                                            <i class="fas fa-pen-alt mr-2"></i>Initialize Plan
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Planned Projects Tab -->
            <div class="tab-pane fade" id="planning" role="tabpanel">
                @if($planningOrders->isEmpty())
                     <div class="card shadow-sm border-0 py-5 text-center">
                        <div class="card-body">
                            <i class="fas fa-layer-group fa-4x text-gray-300 mb-3"></i>
                            <h5 class="text-gray-600">No active production plans found.</h5>
                        </div>
                    </div>
                @endif
                <div class="row">
                    @foreach ($planningOrders as $order)
                        <div class="col-xl-4 col-md-6 mb-4" id="card-{{ $order->routeCard->id ?? '' }}">
                            <div class="project-card border-left-plan">
                                <div class="card-header-custom">
                                    <div class="font-weight-bold text-dark text-truncate" style="max-width: 60%;">
                                        {{ $order->sales_order_no }}
                                    </div>
                                    <div>
                                        @if($order->routeCard->status === 'approved')
                                            <span class="status-badge badge-soft-success">APPROVED</span>
                                        @else
                                            <span class="status-badge badge-soft-secondary">DRAFT</span>
                                        @endif
                                        <div class="dropdown no-arrow d-inline-block ml-2">
                                            <a class="dropdown-toggle" href="#" role="button" data-toggle="dropdown">
                                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in">
                                                <a class="dropdown-item" href="{{ url('superadmin/manufacturing/plan') }}/{{ $order->routeCard->id }}"><i class="fas fa-eye mr-2 text-info"></i> View Details</a>
                                                <a class="dropdown-item" href="{{ route('superadmin.routecard.index', ['route_card_id' => $order->routeCard->id]) }}"><i class="fas fa-edit mr-2 text-warning"></i> Edit Plan</a>
                                                <div class="dropdown-divider"></div>
                                                 @if ($order->routeCard->status !== 'approved')
                                                    <a class="dropdown-item" href="#" onclick="approveRouteCard({{ $order->routeCard->id }})"><i class="fas fa-check mr-2 text-success"></i> Approve</a>
                                                 @else
                                                    <a class="dropdown-item" href="#" onclick="rejectRouteCard({{ $order->routeCard->id }})"><i class="fas fa-times mr-2 text-danger"></i> Reject</a>
                                                 @endif
                                                 <a class="dropdown-item" href="#" onclick="window.confirmDelete({{ $order->routeCard->id ?? '' }}, event)"><i class="fas fa-trash-alt mr-2 text-danger"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body-custom">
                                    <div class="row info-group">
                                        <div class="col-12 mb-2">
                                            <div class="info-label">Client</div>
                                            <div class="info-value text-truncate">{{ $order->customer?->company ?? '-' }}</div>
                                        </div>
                                        <div class="col-6">
                                            <div class="info-label">Steps</div>
                                            <div class="info-value"><i class="fas fa-cogs text-primary mr-1"></i> {{ $order->routeCard->processes->count() }} Process</div>
                                        </div>
                                        <div class="col-6">
                                            <div class="info-label">Planner</div>
                                            <div class="info-value"><i class="fas fa-user-circle text-gray-500 mr-1"></i> {{ $order->routeCard->approved_by ?? 'Admin' }}</div>
                                        </div>
                                    </div>
                                    
                                     <div class="mt-4">
                                        @if ($order->routeCard->status === 'approved')
                                             <button class="btn btn-success btn-premium btn-block" onclick="markReadyToProduction({{ $order->routeCard->id }})">
                                                <i class="fas fa-rocket mr-2"></i>Release to Production
                                            </button>
                                        @else
                                            <button class="btn btn-light btn-block text-muted" disabled>
                                                <i class="fas fa-clock mr-2"></i>Waiting Approval
                                            </button>
                                        @endif
                                     </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Update URL tab parameter
        function updateUrlTab(tabName) {
            const url = new URL(window.location);
            url.searchParams.set('tab', tabName);
            window.history.pushState({}, '', url);
        }

        // Initialize tabs based on URL (BS4)
        $(document).ready(function() {
            const urlParams = new URLSearchParams(window.location.search);
            const tab = urlParams.get('tab') || 'r2plan';
            $('#' + tab + '-tab').tab('show');
        });

        // --- Action Functions ---

         function markReadyToProduction(cardId) {
            if (!confirm('CONFIRM: Release this plan to Production? Job Cards will be generated.')) return;

            fetch(`{{ url('/superadmin/routecard') }}/${cardId}/ready-production`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json',
                }
            })
            .then(async res => {
                const text = await res.text();
                try { return JSON.parse(text); } 
                catch (e) { throw new Error('Invalid JSON response'); }
            })
            .then(resp => {
                if (resp.success) {
                    showToast('success', 'Plan Released to Production!');
                    setTimeout(() => window.location.href = "{{ url('/superadmin/ready-to-production') }}", 1000);
                } else {
                    showToast('error', resp.message || 'Operation failed.');
                }
            })
            .catch(err => {
                console.error(err);
                showToast('error', 'Communication Error');
            });
        }

        function approveRouteCard(id) {
            if (!confirm('Approve this production plan?')) return;
            fetch(`{{ url('/superadmin/routecard') }}/${id}/approve`, {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type': 'application/json' }
            })
            .then(res => res.json())
            .then(data => {
                if(data.success) {
                    showToast('success', 'Plan Approved');
                    setTimeout(() => window.location.reload(), 1000);
                } else {
                     showToast('error', data.message || 'Approval failed.');
                }
            })
            .catch(err => showToast('error', 'Network error.'));
        }

        function rejectRouteCard(id) {
            const reason = prompt('Please provide a reason for rejection:');
            if (!reason) return;
            
            fetch(`{{ url('/superadmin/routecard') }}/${id}/reject`, {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type': 'application/json' },
                body: JSON.stringify({ reason: reason })
            })
            .then(res => res.json())
            .then(data => {
                  if(data.success) {
                    showToast('success', 'Plan Rejected');
                    setTimeout(() => window.location.reload(), 1000);
                } else {
                     showToast('error', data.message || 'Rejection failed.');
                }
            })
            .catch(err => showToast('error', 'Network error.'));
        }

        async function confirmDelete(id, event) {
            event.preventDefault();
            if (!confirm('WARNING: Delete this plan? This is irreversible.')) return;

             try {
                const res = await fetch(`{{ url('/superadmin/routecard') }}/${id}`, {
                    method: 'DELETE',
                    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type': 'application/json' }
                });
                const data = await res.json();
                if(res.ok) {
                    const card = document.getElementById(`card-${id}`);
                    if(card) card.remove();
                    showToast('success', 'Plan Deleted');
                } else {
                    throw new Error(data.message);
                }
            } catch (err) {
                 showToast('error', err.message || 'Delete failed.');
            }
        }

        // Toast Helper
        function showToast(type, msg) {
            const color = type === 'success' ? '#1cc88a' : '#e74a3b';
            const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle';
            const div = document.createElement('div');
            div.style.cssText = `position:fixed;bottom:20px;right:20px;background:${color};color:white;padding:15px 25px;border-radius:10px;box-shadow:0 0.5rem 1rem rgba(0,0,0,0.15);z-index:9999;font-weight:600;display:flex;align-items:center;animation:slideUp 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);`;
            div.innerHTML = `<i class="fas ${icon} mr-3 fa-lg"></i> ${msg}`;
            document.body.appendChild(div);
            setTimeout(() => {
                div.style.opacity = '0';
                div.style.transform = 'translateY(20px)';
                setTimeout(() => div.remove(), 400);
            }, 3000);
        }
        
        const style = document.createElement('style');
        style.textContent = `@keyframes slideUp { from { transform: translateY(100px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }`;
        document.head.appendChild(style);
    </script>
@endpush
