<!-- Header -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Debit Notes (Vendor)</h6>
    <button class="btn btn-primary btn-sm" id="addDebitNoteBtn">
        <i class="fas fa-plus mr-1"></i> Add Debit Note
    </button>
</div>

<!-- Filter Section -->
<div class="filter-card mb-3">
    <div class="row">
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Date Range</label>
            <input type="text" class="form-control form-control-sm debit-date-range"
                placeholder="Select date range" readonly>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Vendor</label>
            <select class="form-control form-control-sm" id="debit-party">
                <option value="">All Vendors</option>
                @foreach ($parties ?? [] as $party)
                    <option value="{{ $party->id }}">{{ $party->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Debit Note No</label>
            <input type="text" class="form-control form-control-sm debit-note-filter"
                placeholder="Search by debit note number">
        </div>
        <div class="col-md-3 d-flex align-items-end mb-2">
            <button class="btn btn-primary btn-sm mr-1" id="applyDebitFilters">
                <i class="fas fa-filter"></i> Apply
            </button>
            <button class="btn btn-secondary btn-sm" id="resetDebitFilters">
                <i class="fas fa-undo"></i> Reset
            </button>
        </div>
    </div>
</div>

<!-- Debit Notes Table -->
<div class="table-responsive">
    <table id="debitTable" class="table table-bordered table-striped table-sm w-100">
        <thead class="thead-light">
            <tr>
                <th>Debit Note No</th>
                <th>Date</th>
                <th>Vendor</th>
                <th>Invoice No</th>
                <th class="text-right">Amount</th>
                <th>Reason</th>
                <th class="text-center">Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data loaded via AJAX -->
        </tbody>
    </table>
</div>

<!-- Debit Note Modal -->
<div class="modal fade" id="debitNoteModal" tabindex="-1" aria-labelledby="debitNoteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="debitNoteModalLabel">
                    <i class="fas fa-file-invoice mr-2"></i> Add Debit Note (Vendor)
                </h5>
                <button type="button" class="close text-white" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="debitNoteForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="small font-weight-bold">
                                    Debit Note No <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" id="debit_note_no" name="debit_note_no" placeholder="Auto Generated" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="small font-weight-bold">
                                    Date <span class="text-danger">*</span>
                                </label>
                                <input type="date" class="form-control" id="debit_note_date" name="date" value="{{ date('Y-m-d') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="small font-weight-bold">
                                    Vendor <span class="text-danger">*</span>
                                </label>
                                <select class="form-control" id="debit_note_party" name="party_id" required>
                                    <option value="">Select Vendor</option>
                                    @foreach ($parties ?? [] as $party)
                                        <option value="{{ $party->id }}">{{ $party->company }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="small font-weight-bold">Invoice No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="debit_note_invoice" name="invoice_no" placeholder="Related invoice number" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="small font-weight-bold">
                                    Amount <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" class="form-control" id="debit_note_amount" name="amount" step="0.01" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="small font-weight-bold">
                                    Reason <span class="text-danger">*</span>
                                </label>
                                <select class="form-control" id="debit_note_reason" name="reason" required>
                                    <option value="">Select Reason</option>
                                    <option value="Goods Returned">Goods Returned</option>
                                    <option value="Damaged Goods">Damaged Goods</option>
                                    <option value="Shortage">Shortage</option>
                                    <option value="Price Difference">Price Difference</option>
                                    <option value="Discount Not Received">Discount Not Received</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-3">
                        <label class="small font-weight-bold">Description</label>
                        <textarea class="form-control" id="debit_note_description" name="description" rows="3" placeholder="Additional details..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times mr-1"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save mr-1"></i> Save
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
