@extends('layouts.dashboard.superadminapp')

@section('title', 'Add Machine')

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Add Machine</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if ($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>
        <ul class="mb-0 d-inline-block">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<!-- Machine Form Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-cogs mr-2"></i> Machine Details Form
        </h6>
        <a href="{{ route('superadmin.machine.machinedetails') }}" class="btn btn-light btn-sm">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
    </div>
    <div class="card-body">
        <form id="machineForm" method="POST" action="{{ route('superadmin.machine.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Machine ID <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="machine_id" name="machine_id" value="{{ old('machine_id') }}" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Machine Name</label>
                    <input type="text" class="form-control" id="machine_name" name="machine_name" value="{{ old('machine_name') }}">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Machine SL No <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="machine_sl_no" name="machine_sl_no" value="{{ old('machine_sl_no') }}" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Make</label>
                    <input type="text" class="form-control" id="make" name="make" value="{{ old('make') }}">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Model Type</label>
                    <input type="text" class="form-control" id="model_type" name="model_type" value="{{ old('model_type') }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Diameter (mm) <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="diameter" name="diameter" step="0.01" value="{{ old('diameter') }}" required>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Length (m) <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="length" name="length" step="0.01" value="{{ old('length') }}" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Weight (kg) <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="weight" name="weight" step="0.01" value="{{ old('weight') }}" required>
                </div>
            </div>
            <div class="row">
                <div class="col-12 mb-3">
                    <label class="small font-weight-bold">Remarks</label>
                    <textarea class="form-control" id="remarks" name="remarks" rows="3" placeholder="Optional remarks...">{{ old('remarks') }}</textarea>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <hr>
                    <button class="btn btn-primary btn-sm" type="submit">
                        <i class="fa fa-save mr-1"></i> Save Machine
                    </button>
                    <button class="btn btn-secondary btn-sm" type="reset">
                        <i class="fa fa-undo mr-1"></i> Reset
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
