@extends('layouts.dashboard.superadminapp')

@section('title', 'Machine Dashboard')

@section('styles')
<style>
    .stat-card {
        border-radius: 12px;
        padding: 24px;
        color: #fff;
        transition: transform 0.2s, box-shadow 0.2s;
        position: relative;
        overflow: hidden;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }
    .stat-card .stat-icon {
        position: absolute;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 3.5rem;
        opacity: 0.3;
    }
    .stat-card .stat-value {
        font-size: 2.5rem;
        font-weight: 700;
        line-height: 1;
    }
    .stat-card .stat-label {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 5px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .stat-card .stat-info {
        font-size: 0.8rem;
        margin-top: 10px;
        opacity: 0.8;
    }
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-danger { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-gradient-secondary { background: linear-gradient(135deg, #858796 0%, #5a5c69 100%); }

    .chart-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
    }
    .chart-card .card-header {
        border-radius: 12px 12px 0 0;
        padding: 16px 20px;
    }
    .chart-card .card-body {
        padding: 20px;
    }

    .quick-link-card {
        background: #fff;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        transition: all 0.2s;
        border: 2px solid transparent;
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(78,115,223,0.2);
    }
    .quick-link-card i {
        font-size: 2rem;
        margin-bottom: 10px;
    }
    .quick-link-card .link-title {
        font-weight: 600;
        color: #333;
    }

    .progress-stat {
        margin-bottom: 15px;
    }
    .progress-stat .progress-label {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        font-weight: 500;
    }
    .progress {
        height: 8px;
        border-radius: 4px;
    }

    .operator-card {
        background: #fff;
        border-radius: 10px;
        padding: 15px;
        text-align: center;
        box-shadow: 0 2px 10px rgba(0,0,0,0.08);
        transition: all 0.2s;
    }
    .operator-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.12);
    }
    .operator-avatar {
        width: 70px;
        height: 70px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #4e73df;
        margin-bottom: 10px;
    }
    .operator-name {
        font-weight: 600;
        color: #333;
        margin-bottom: 3px;
    }
    .operator-role {
        font-size: 0.85rem;
        color: #666;
        margin-bottom: 8px;
    }
    .operator-status {
        display: inline-block;
        padding: 3px 12px;
        border-radius: 15px;
        font-size: 0.75rem;
        font-weight: 600;
    }
    .operator-status.available {
        background: #d4edda;
        color: #155724;
    }
    .operator-status.busy {
        background: #fff3cd;
        color: #856404;
    }

    .status-indicator {
        display: inline-block;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        margin-right: 8px;
        animation: pulse 2s infinite;
    }
    .status-indicator.running {
        background: #1cc88a;
    }
    .status-indicator.maintenance {
        background: #f6c23e;
    }
    .status-indicator.idle {
        background: #858796;
    }

    @keyframes pulse {
        0% { opacity: 1; }
        50% { opacity: 0.5; }
        100% { opacity: 1; }
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Machine Dashboard</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

@php
    $capacityRate = $totalMachines > 0 ? round(($runningNow / $totalMachines) * 100, 1) : 0;
    $maintenanceRate = $totalMachines > 0 ? round(($underMaintenance / $totalMachines) * 100, 1) : 0;
    $idleMachines = max($totalMachines - $runningNow - $underMaintenance, 0);
    $idleRate = $totalMachines > 0 ? round(($idleMachines / $totalMachines) * 100, 1) : 0;
@endphp

<!-- Summary Statistics -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-primary shadow">
            <i class="fas fa-industry stat-icon"></i>
            <div class="stat-value">{{ $totalMachines }}</div>
            <div class="stat-label">Total Machines</div>
            <div class="stat-info">
                <i class="fas fa-cogs mr-1"></i> All registered machines
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-success shadow">
            <i class="fas fa-play-circle stat-icon"></i>
            <div class="stat-value">{{ $runningNow }}</div>
            <div class="stat-label">Running Now</div>
            <div class="stat-info">
                <i class="fas fa-chart-line mr-1"></i> {{ $capacityRate }}% capacity utilization
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-warning shadow">
            <i class="fas fa-tools stat-icon"></i>
            <div class="stat-value">{{ $underMaintenance }}</div>
            <div class="stat-label">Under Maintenance</div>
            <div class="stat-info">
                <i class="fas fa-wrench mr-1"></i> {{ $maintenanceRate }}% of total machines
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-danger shadow">
            <i class="fas fa-exclamation-triangle stat-icon"></i>
            <div class="stat-value">{{ $issuesToday }}</div>
            <div class="stat-label">Issues Today</div>
            <div class="stat-info">
                <i class="fas fa-bell mr-1"></i> Requires attention
            </div>
        </div>
    </div>
</div>

<!-- Machine Status Overview -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-tachometer-alt mr-2"></i> Machine Status Overview
        </h6>
    </div>
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="progress-stat">
                    <div class="progress-label">
                        <span><span class="status-indicator running"></span> Running</span>
                        <span>{{ $runningNow }} ({{ $capacityRate }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-success" style="width: {{ $capacityRate }}%"></div>
                    </div>
                </div>
                <div class="progress-stat">
                    <div class="progress-label">
                        <span><span class="status-indicator maintenance"></span> Maintenance</span>
                        <span>{{ $underMaintenance }} ({{ $maintenanceRate }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-warning" style="width: {{ $maintenanceRate }}%"></div>
                    </div>
                </div>
                <div class="progress-stat mb-0">
                    <div class="progress-label">
                        <span><span class="status-indicator idle"></span> Idle</span>
                        <span>{{ $idleMachines }} ({{ $idleRate }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-secondary" style="width: {{ $idleRate }}%"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-center">
                <div class="h1 font-weight-bold {{ $capacityRate >= 70 ? 'text-success' : ($capacityRate >= 40 ? 'text-warning' : 'text-danger') }}">
                    {{ $capacityRate }}%
                </div>
                <p class="text-muted mb-0">Overall Capacity Utilization</p>
            </div>
        </div>
    </div>
</div>

<!-- Live Machine Status -->
<div class="mb-4">
    <h6 class="font-weight-bold text-gray-800 mb-3"><i class="fas fa-microchip mr-2"></i> Live Machine Status</h6>
    <div class="row">
        @foreach($allMachines as $machine)
            @php
                // Check if active process exists for this machine (checking both ID and Name to be safe)
                $machineKey = $activeProcesses->has($machine->machine_id) ? $machine->machine_id : ($activeProcesses->has($machine->machine_name) ? $machine->machine_name : null);
                $activeProcs = $machineKey ? $activeProcesses[$machineKey] : null;
            @endphp
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-{{ $activeProcs ? 'success' : 'secondary' }} shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-{{ $activeProcs ? 'success' : 'secondary' }} text-uppercase mb-1">
                                    {{ $machine->machine_name }}
                                </div>
                                @if($activeProcs && $activeProcs->count() > 0)
                                    @foreach($activeProcs as $proc)
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $proc->routeCard->route_no ?? 'N/A' }}</div>
                                        <div class="text-xs text-muted mb-1">{{ $proc->process }}</div>
                                        <div class="text-xs font-weight-bold text-info"><i class="fas fa-user-circle"></i> User: {{ $proc->operator ?? 'NA' }}</div>
                                    @endforeach
                                @else
                                    <div class="h5 mb-0 font-weight-bold text-gray-400">IDLE</div>
                                    <div class="text-xs text-muted">No active process</div>
                                @endif
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-{{ $activeProcs ? 'cogs fa-spin' : 'pause-circle' }} fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Production Output Chart -->
    <div class="col-lg-8 mb-4">
        <div class="chart-card shadow">
            <div class="card-header" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-line mr-2"></i> Production Output (Last 7 Days)
                </h6>
            </div>
            <div class="card-body">
                <canvas id="productionChart" height="120"></canvas>
            </div>
        </div>
    </div>

    <!-- Machine Status Distribution Chart -->
    <div class="col-lg-4 mb-4">
        <div class="chart-card shadow">
            <div class="card-header" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-pie mr-2"></i> Status Distribution
                </h6>
            </div>
            <div class="card-body">
                <canvas id="statusChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-link mr-2"></i> Quick Actions
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.machine.machinedetails') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-cogs text-primary"></i>
                        <div class="link-title">Machines</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.projectplanning.projectplanning') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-industry text-success"></i>
                        <div class="link-title">Project Planning</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.readytoproduction') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-route text-warning"></i>
                        <div class="link-title">Production</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.report.machinereport') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-chart-bar text-info"></i>
                        <div class="link-title">Machine Report</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ url('superadmin/quality/qc-management') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-clipboard-check text-danger"></i>
                        <div class="link-title">Quality Control</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.sku.skumaster') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-boxes text-secondary"></i>
                        <div class="link-title">SKU Master</div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Current Shift Operators -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-users-cog mr-2"></i> Current Shift Operators
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            @forelse($currentOperators as $operator)
                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 mb-3">
                    <div class="operator-card">
                        <img src="{{ $operator['profile_picture'] }}" alt="{{ $operator['name'] }}" class="operator-avatar">
                        <div class="operator-name">{{ $operator['name'] }}</div>
                        <div class="operator-role">{{ $operator['role'] }}</div>
                        <span class="operator-status {{ strtolower($operator['status']) }}">
                            {{ $operator['status'] }}
                        </span>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-user-slash fa-3x mb-3 d-block"></i>
                        <p class="mb-0">No operators currently on shift</p>
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</div>

<!-- Machine Status Summary Table -->
<div class="row">
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-check-circle mr-2"></i> Running Machines Summary
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th>Status</th>
                            <th class="text-center">Count</th>
                            <th class="text-center">Percentage</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><span class="status-indicator running"></span> Running</td>
                            <td class="text-center"><span class="badge badge-success">{{ $runningNow }}</span></td>
                            <td class="text-center">{{ $capacityRate }}%</td>
                        </tr>
                        <tr>
                            <td><span class="status-indicator maintenance"></span> Maintenance</td>
                            <td class="text-center"><span class="badge badge-warning">{{ $underMaintenance }}</span></td>
                            <td class="text-center">{{ $maintenanceRate }}%</td>
                        </tr>
                        <tr>
                            <td><span class="status-indicator idle"></span> Idle</td>
                            <td class="text-center"><span class="badge badge-secondary">{{ $idleMachines }}</span></td>
                            <td class="text-center">{{ $idleRate }}%</td>
                        </tr>
                    </tbody>
                    <tfoot class="thead-light">
                        <tr class="font-weight-bold">
                            <td>Total</td>
                            <td class="text-center"><span class="badge badge-primary">{{ $totalMachines }}</span></td>
                            <td class="text-center">100%</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exclamation-circle mr-2"></i> Issues & Alerts
                </h6>
            </div>
            <div class="card-body">
                @if($issuesToday > 0)
                    <div class="alert alert-danger mb-3">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <strong>{{ $issuesToday }} issue(s)</strong> reported today requiring attention.
                    </div>
                @else
                    <div class="alert alert-success mb-3">
                        <i class="fas fa-check-circle mr-2"></i>
                        <strong>No issues</strong> reported today. All systems operational.
                    </div>
                @endif

                @if($underMaintenance > 0)
                    <div class="alert alert-warning mb-0">
                        <i class="fas fa-tools mr-2"></i>
                        <strong>{{ $underMaintenance }} machine(s)</strong> currently under maintenance.
                    </div>
                @endif

                @if($idleMachines > ($totalMachines * 0.3))
                    <div class="alert alert-info mt-3 mb-0">
                        <i class="fas fa-info-circle mr-2"></i>
                        <strong>{{ $idleMachines }} machine(s)</strong> are idle. Consider optimizing production schedule.
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script>
    // Pass PHP data to JS
    window.productionLast7 = @json($productionLast7);
    window.machineStatus = @json($machineStatus);

    // Production Output Chart
    const prodLabels = [];
    const prodData = [];

    // Generate last 7 days labels
    for (let i = 6; i >= 0; i--) {
        const date = moment().subtract(i, 'days').format('YYYY-MM-DD');
        prodLabels.push(moment(date).format('DD MMM'));
        prodData.push(window.productionLast7[date] || 0);
    }

    const prodCtx = document.getElementById('productionChart').getContext('2d');
    new Chart(prodCtx, {
        type: 'line',
        data: {
            labels: prodLabels,
            datasets: [{
                label: 'Production Output',
                data: prodData,
                fill: true,
                backgroundColor: 'rgba(78, 115, 223, 0.1)',
                borderColor: 'rgba(78, 115, 223, 1)',
                borderWidth: 2,
                tension: 0.4,
                pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
                pointRadius: 5,
                pointHoverRadius: 7
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: {
                    grid: { display: false }
                }
            }
        }
    });

    // Machine Status Doughnut Chart
    const statusLabels = Object.keys(window.machineStatus);
    const statusData = Object.values(window.machineStatus);

    const statusCtx = document.getElementById('statusChart').getContext('2d');
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: statusLabels,
            datasets: [{
                data: statusData,
                backgroundColor: [
                    '#1cc88a', // Running - Green
                    '#f6c23e', // Maintenance - Yellow
                    '#858796'  // Idle - Gray
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: { padding: 15, usePointStyle: true }
                }
            },
            cutout: '60%'
        }
    });

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday: 'long' });
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = now.toLocaleString('en-us', { month: 'long' });
        document.getElementById('year').textContent = now.getFullYear();
        document.querySelector('.display-time').textContent = now.toLocaleTimeString();
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
</script>
@endsection
