@extends('layouts.dashboard.superadminapp')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid">

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / Dashboard</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Revenue & Financial KPIs -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Monthly Revenue</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($monthlyRevenue, 2) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-rupee-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Annual Revenue</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($annualRevenue, 2) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending Approvals</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalPendingApprovals }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Stock Value</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($totalStockValue, 2) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Sales & Purchase Summary -->
    <div class="row">
        <!-- Sales Pipeline -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Sales Pipeline</h6>
                    <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-sm btn-primary">View All</a>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="border-right">
                                <h4 class="text-primary">{{ $totalRfqs }}</h4>
                                <small class="text-muted">RFQs</small>
                                <br><span class="badge badge-warning">{{ $pendingRfqs }} Pending</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border-right">
                                <h4 class="text-success">{{ $totalQuotations }}</h4>
                                <small class="text-muted">Quotations</small>
                                <br><span class="badge badge-warning">{{ $pendingQuotations }} Pending</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border-right">
                                <h4 class="text-info">{{ $totalSalesOrders }}</h4>
                                <small class="text-muted">Sales Orders</small>
                                <br><span class="badge badge-warning">{{ $pendingSalesOrders }} Pending</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <h4 class="text-danger">{{ $totalInvoices }}</h4>
                            <small class="text-muted">Invoices</small>
                            <br><span class="badge badge-success">Active</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Purchase Pipeline -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-success">Purchase Pipeline</h6>
                    <a href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}" class="btn btn-sm btn-success">View All</a>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="border-right">
                                <h4 class="text-primary">{{ $totalPurchaseRfqs }}</h4>
                                <small class="text-muted">Purchase RFQs</small>
                                <br><span class="badge badge-warning">{{ $pendingPurchaseRfqs }} Pending</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border-right">
                                <h4 class="text-success">{{ $totalPurchaseQuotations }}</h4>
                                <small class="text-muted">Quotations</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border-right">
                                <h4 class="text-info">{{ $totalPurchaseOrders }}</h4>
                                <small class="text-muted">Purchase Orders</small>
                                <br><span class="badge badge-warning">{{ $pendingPurchaseOrders }} Pending</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <h4 class="text-danger">{{ $totalGrns }}</h4>
                            <small class="text-muted">GRNs</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Operations & HR Row -->
    <div class="row">
        <!-- Manufacturing Status -->
        <div class="col-xl-4 col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Manufacturing Status</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6 mb-3">
                            <div class="text-center p-3 bg-light rounded">
                                <h3 class="text-primary mb-0">{{ $totalRouteCards }}</h3>
                                <small>Route Cards</small>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="text-center p-3 bg-light rounded">
                                <h3 class="text-warning mb-0">{{ $runningProjects }}</h3>
                                <small>In Production</small>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-2">
                                <span>Task Completion</span>
                                <span class="float-right">{{ $dayTasksPercent }}%</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-success" role="progressbar" style="width: {{ $dayTasksPercent }}%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inventory Status -->
        <div class="col-xl-4 col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">Inventory Status</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <h4 class="text-success">{{ $totalSkus }}</h4>
                            <small>Total SKUs</small>
                        </div>
                        <div class="col-4">
                            <h4 class="text-warning">{{ $lowStockItems }}</h4>
                            <small>Low Stock</small>
                        </div>
                        <div class="col-4">
                            <h4 class="text-danger">{{ $outOfStockItems }}</h4>
                            <small>Out of Stock</small>
                        </div>
                    </div>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ $totalMachines }}</h5>
                            <small class="text-muted">Machines</small>
                        </div>
                        <div class="col-6">
                            <h5>{{ $totalGrns }}</h5>
                            <small class="text-muted">GRN Received</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Employee Status -->
        <div class="col-xl-4 col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">Employee Status (Today)</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <h4 class="text-primary">{{ $totalEmployees }}</h4>
                            <small>Total</small>
                        </div>
                        <div class="col-4">
                            <h4 class="text-success">{{ $employeePresent }}</h4>
                            <small>Present</small>
                        </div>
                        <div class="col-4">
                            <h4 class="text-danger">{{ $employeeLeave }}</h4>
                            <small>On Leave</small>
                        </div>
                    </div>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ $totalCustomers }}</h5>
                            <small class="text-muted">Customers</small>
                        </div>
                        <div class="col-6">
                            <h5>{{ $totalVendors }}</h5>
                            <small class="text-muted">Vendors</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row">
        <!-- Sales Trend Chart -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Revenue Trend (Last 6 Months)</h6>
                </div>
                <div class="card-body">
                    <canvas id="salesTrendChart" height="100"></canvas>
                </div>
            </div>
        </div>

        <!-- Production Status Pie -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Production Status</h6>
                </div>
                <div class="card-body">
                    <canvas id="productionStatusChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities & Quick Stats -->
    <div class="row">
        <!-- Recent Activities -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Activities</h6>
                </div>
                <div class="card-body" style="max-height: 300px; overflow-y: auto;">
                    @forelse($recentActivities as $activity)
                    <div class="d-flex align-items-center mb-3">
                        <div class="mr-3">
                            <div class="icon-circle bg-{{ $activity['color'] }}">
                                <i class="fas {{ $activity['icon'] }} text-white"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="small text-gray-500">{{ $activity['type'] }}</div>
                            <span class="font-weight-bold">{{ $activity['title'] }}</span>
                            <span class="badge badge-{{ $activity['status'] == 'approved' ? 'success' : ($activity['status'] == 'pending' ? 'warning' : 'secondary') }}">{{ ucfirst($activity['status']) }}</span>
                        </div>
                        <div class="text-right">
                            <small class="text-muted">{{ \Carbon\Carbon::parse($activity['date'])->diffForHumans() }}</small>
                        </div>
                    </div>
                    @empty
                    <p class="text-muted text-center">No recent activities</p>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Top Customers -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Top Customers by Revenue</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Customer</th>
                                    <th class="text-right">Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($topCustomers as $index => $customer)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $customer->company->company ?? 'N/A' }}</td>
                                    <td class="text-right font-weight-bold">{{ number_format($customer->total_revenue, 2) }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted">No data available</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Links -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-2 col-sm-4 col-6 mb-3">
                            <a href="{{ route('superadmin.salesbom.rfq.rfq') }}" class="btn btn-outline-primary btn-block">
                                <i class="fas fa-plus"></i> New RFQ
                            </a>
                        </div>
                        <div class="col-md-2 col-sm-4 col-6 mb-3">
                            <a href="{{ route('superadmin.salesbom.quotation.quotationorder') }}" class="btn btn-outline-success btn-block">
                                <i class="fas fa-file-invoice"></i> New Quotation
                            </a>
                        </div>
                        <div class="col-md-2 col-sm-4 col-6 mb-3">
                            <a href="{{ route('superadmin.sales.salesorder') }}" class="btn btn-outline-info btn-block">
                                <i class="fas fa-shopping-cart"></i> New Sales Order
                            </a>
                        </div>
                        <div class="col-md-2 col-sm-4 col-6 mb-3">
                            <a href="{{ route('superadmin.invoice.invoiceorder') }}" class="btn btn-outline-danger btn-block">
                                <i class="fas fa-file-invoice-dollar"></i> New Invoice
                            </a>
                        </div>
                        <div class="col-md-2 col-sm-4 col-6 mb-3">
                            <a href="{{ route('superadmin.routecard.index') }}" class="btn btn-outline-warning btn-block">
                                <i class="fas fa-industry"></i> Route Card
                            </a>
                        </div>
                        <div class="col-md-2 col-sm-4 col-6 mb-3">
                            <a href="{{ route('superadmin.sku.skumovement') }}" class="btn btn-outline-secondary btn-block">
                                <i class="fas fa-exchange-alt"></i> SKU Movement
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sales Trend Chart
    const salesTrendCtx = document.getElementById('salesTrendChart').getContext('2d');
    new Chart(salesTrendCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode($salesTrend->pluck('month')) !!},
            datasets: [{
                label: 'Revenue',
                data: {!! json_encode($salesTrend->pluck('revenue')) !!},
                borderColor: 'rgb(78, 115, 223)',
                backgroundColor: 'rgba(78, 115, 223, 0.1)',
                fill: true,
                tension: 0.3
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Production Status Pie Chart
    const productionCtx = document.getElementById('productionStatusChart').getContext('2d');
    new Chart(productionCtx, {
        type: 'doughnut',
        data: {
            labels: {!! json_encode(array_keys($productionStatus)) !!},
            datasets: [{
                data: {!! json_encode(array_values($productionStatus)) !!},
                backgroundColor: ['#f6c23e', '#36b9cc', '#1cc88a'],
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>
@endsection
