@extends('layouts.dashboard.superadminapp')
@section('title', 'Inventory Report')

@section('content')
<style>
    body,
    .employee-main-bg {
        background: linear-gradient(135deg, #d8f2ff 0%, #f7e9ff 100%);
        min-height: 100vh;
    }

    .employee-glass-bg {
        background: linear-gradient(120deg, #e0eafc 0%, #cfdef3 100%);
    }

    .card-glass {
        background: rgba(255, 255, 255, 0.75) !important;
        box-shadow: 0 4px 24px 0 rgba(80, 115, 250, 0.05), 0 1.5px 12px rgba(0, 0, 0, 0.03);
        border-radius: 18px !important;
        backdrop-filter: blur(8px);
        border: 1px solid rgba(200, 200, 255, 0.21);
    }

    .float-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        background: linear-gradient(110deg, #4380fa 70%, #6ed6ff 100%);
        border-radius: 24px;
        box-shadow: 0 2px 18px 0 rgba(20, 55, 150, 0.06);
        padding: 32px 38px 24px 38px;
        margin-bottom: -30px;
        z-index: 2;
        position: relative;
    }

    .float-header h1 {
        color: #fff;
        font-size: 2.2rem;
        font-weight: 800;
    }

    .float-header .desc {
        color: #eaf6ff;
        font-size: 1.1rem;
        font-weight: 400;
        letter-spacing: 1px;
    }

    .pulse-dot {
        background: #22eaaa;
        width: 10px;
        height: 10px;
        display: inline-block;
        border-radius: 50%;
        animation: pulse 1s infinite alternate;
    }

    @keyframes pulse {
        0% {
            box-shadow: 0 0 0 0 #22eaaa44;
        }

        100% {
            box-shadow: 0 0 0 8px #22eaaa11;
        }
    }

    .profile-card {
        background: #fff4;
        border-radius: 20px;
        padding: 8px 22px;
        display: flex;
        align-items: center;
        box-shadow: 0 1px 8px #89e2fa22;
    }

    .profile-card .avatar {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        border: 3px solid #fff;
    }

    .profile-info {
        margin-left: 10px;
    }

    .profile-name {
        font-weight: 700;
        color: #fff;
    }

    .profile-role {
        font-size: 0.9rem;
        color: #c2e9ff;
    }

    .stats-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(210px, 1fr));
        gap: 22px;
        margin: 48px 0 30px 0;
    }

    .stat-card {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 30px 24px;
    }

    .stat-label {
        color: #3c5a99;
        font-weight: 500;
    }

    .stat-number {
        font-size: 2.1rem;
        font-weight: 900;
        color: #1d3566;
    }

    .stat-trend {
        font-weight: 700;
        font-size: 1.2rem;
    }

    .stat-trend.up {
        color: #23c181;
    }

    .stat-trend.down {
        color: #e74c3c;
    }

    .stat1 {
        border-left: 7px solid #6ed6ff;
    }

    .stat2 {
        border-left: 7px solid #23c181;
    }

    .stat3 {
        border-left: 7px solid #ffa03a;
    }

    .stat4 {
        border-left: 7px solid #fc5d7c;
    }

    .search-bar {
        display: flex;
        flex-direction: column;
        gap: 20px;
        margin-bottom: 28px;
        padding: 24px 32px;
    }

    .search-input-wrap {
        display: flex;
        align-items: center;
        background: #f3f8ff;
        border-radius: 10px;
        padding: 0 18px;
    }

    .search-input-wrap i {
        color: #8fc3ff;
    }

    .search-input-wrap input {
        border: none;
        outline: none;
        background: transparent;
        padding: 14px 12px;
        width: 250px;
    }

    .filters-row {
        display: flex;
        gap: 18px;
        flex-wrap: wrap;
        align-items: center;
    }

    .filters-row select,
    .filters-row .btn-glass {
        border-radius: 10px;
        padding: 10px 16px;
        font-weight: 500;
    }

    .filters-row select {
        border: 1px solid #e0e9ff;
        background: #f7fbff;
    }

    .btn-glass {
        background: linear-gradient(90deg, #6ed6ff 0%, #80b7ff 100%);
        border: none;
        color: #213b57;
        font-weight: 700;
        transition: all .15s;
        box-shadow: 0 2px 8px #b3e0ff44;
        cursor: pointer;
    }

    .btn-glass:hover {
        background: linear-gradient(100deg, #22eaaa 0%, #3a8dde 100%);
        color: #fff;
    }

    .btn-glass.alt {
        background: linear-gradient(90deg, #f7e9ff 0%, #c7d2fe 100%);
        color: #523e84;
    }

    .btn-glass.alt:hover {
        background: linear-gradient(100deg, #b2a9e6 0%, #88a7fc 100%);
        color: #fff;
    }

    .table-card {
        margin-top: 18px;
        padding: 0 0 18px 0;
    }

    .table-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 24px 32px;
    }

    .tbl-title {
        font-weight: 700;
        font-size: 1.1rem;
        color: #254d88;
    }

    .tbl-desc {
        color: #7a8ebd;
    }

    .tbl-responsive {
        overflow-x: auto;
    }

    .report-table-modern {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
    }

    .report-table-modern thead th {
        background: linear-gradient(90deg, #e0eafc 0%, #cfdef3 100%);
        color: #2c3e50;
        font-weight: 700;
        padding: 14px 16px;
    }

    .report-table-modern tbody td {
        background: #fff;
        padding: 14px 16px;
        border-bottom: 2px solid #e9eefb;
    }

    .tbl-user {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .tbl-user img {
        width: 38px;
        height: 38px;
        border-radius: 50%;
    }

    .badge {
        padding: 7px 16px;
        border-radius: 20px;
        font-weight: 700;
        font-size: .98rem;
    }

    .badge-success {
        background: rgba(45, 220, 139, 0.14);
        color: #23c181;
    }

    .badge-danger {
        background: rgba(240, 52, 52, 0.12);
        color: #e74c3c;
    }

    .badge-warning {
        background: rgba(255, 160, 58, 0.18);
        color: #ffa03a;
    }

    .table-action {
        margin: 0 2px;
        padding: 6px 10px;
        border-radius: 8px;
        background: #f3f8ff;
        cursor: pointer;
        transition: .15s;
    }

    .table-action:hover {
        background: #d4eafc;
        color: #3498db;
    }

    .table-action.danger:hover {
        background: #ffeaea;
        color: #e74c3c;
    }

    .table-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 16px 30px;
    }

    .pagination-modern {
        display: flex;
        gap: 8px;
    }

    .pagination-modern .page-item {
        padding: 8px 15px;
        background: #edf3fa;
        border-radius: 6px;
        cursor: pointer;
        color: #388cff;
        font-weight: 700;
        transition: .15s;
    }

    .pagination-modern .page-item.active {
        background: #3498db;
        color: #fff;
    }

    .pagination-modern .page-item:hover:not(.active) {
        background: #b5daff;
    }

    button {
        width: auto
    }

    .emp-reports-bg {
        background: linear-gradient(135deg, #f8fbff 0%, #f3f1ff 100%);
        min-height: 100vh;
    }

    .emp-card {
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 4px 24px #b4cefc22;
        margin-bottom: 30px;
    }

    .emp-report-header {
        padding: 32px 32px 16px 32px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .emp-report-title {
        font-size: 2rem;
        font-weight: 800;
        color: #354679;
    }

    .emp-report-tabs {
        display: flex;
        gap: 18px;
    }

    .emp-tab {
        background: #f1f5fc;
        color: #3767c7;
        padding: 10px 32px;
        font-weight: 700;
        border-radius: 12px 12px 0 0;
        cursor: pointer;
        border: none;
        font-size: 1rem;
        transition: .2s;
    }

    .emp-tab.active,
    .emp-tab:hover {
        background: #3767c7;
        color: #fff;
    }

    .emp-filter-row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
        padding: 24px 32px 8px 32px;
        align-items: center;
    }

    .emp-filter-row select,
    .emp-filter-row input[type="date"] {
        padding: 10px 18px;
        border-radius: 8px;
        border: 1px solid #c3d7fa;
        font-size: 1rem;
    }

    .emp-filter-row .btn {
        background: #3767c7;
        color: #fff;
        border: none;
        padding: 11px 22px;
        border-radius: 8px;
        font-weight: 700;
    }

    .emp-filter-row .btn:hover {
        background: #233a74;
    }

    .report-output-card {
        padding: 28px 32px 38px 32px;
        min-height: 200px;
    }

    .report-output-placeholder {
        color: #b6bbcb;
        font-size: 1.2rem;
        text-align: center;
        margin-top: 35px;
    }

    @media (max-width: 600px) {

        .emp-report-header,
        .emp-filter-row,
        .report-output-card {
            padding: 14px !important;
        }

        .emp-report-title {
            font-size: 1.2rem;
        }
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

<div class="dashboard employee-glass-bg">
    <div class="main-content employee-main-bg">
        <div class="float-header">
            <div>
                <h1>Inventory Report</h1>
                <div class="desc">Your live workforce insights <span class="pulse-dot"></span></div>
            </div>
            <div class="profile-card">
                <img src="https://umbreyengineering.com/induspro/public/img/undraw_profile.svg" alt="User" class="avatar">
                <div class="profile-info">
                    <span class="profile-name">Superadmin</span>
                    <span class="profile-role">(Admin)</span>
                </div>
            </div>
        </div>
        <div class="container-fluid emp-reports-bg py-4">
            <div class="emp-card">
                <form id="inventoryReportFilters" method="POST" autocomplete="off"
                      action="{{ route('superadmin.report.inventoryreport') }}">
                    @csrf
                    <div class="emp-filter-row">
                        <select name="material_code" onchange="this.form.submit()">
                            <option value="">All Materials</option>
                            @foreach($materialOptions as $code => $desc)
                                <option value="{{ $code }}" {{ $selectedMaterial == $code ? 'selected' : '' }}>
                                    {{ $desc }}
                                </option>
                            @endforeach
                        </select>
                        <input type="date" name="from_date" value="{{ $fromDate }}" placeholder="From">
                        <span>to</span>
                        <input type="date" name="to_date" value="{{ $toDate }}" placeholder="To">
                        <button type="submit" class="btn btn-glass">View</button>
                        <button type="button" class="btn btn-glass alt" id="exportExcelBtn">
                            <i class="fas fa-file-excel"></i> Export to Excel
                        </button>
                    </div>
                </form>

                <div class="report-output-card">
                    <div class="tbl-responsive">
                        <table id="inventoryTable" class="report-table-modern" style="display: inline-table">
                            <thead>
                                <tr>
                                    <th>Material Code</th>
                                    <th>Description</th>
                                    <th>Purchased</th>
                                    <th>Sold</th>
                                    <th>Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($inventory as $row)
                                <tr>
                                    <td>{{ $row['material_code'] }}</td>
                                    <td>{{ $row['description'] }}</td>
                                    <td>{{ $row['purchased'] }}</td>
                                    <td>{{ $row['sold'] }}</td>
                                    <td>{{ $row['balance'] }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#inventoryTable').DataTable({
            paging: true,
            lengthChange: false,
            pageLength: 10,
            info: false,
            searching: true,
            ordering: true,
            language: {
                emptyTable: "No inventory found."
            }
        });
        $('#exportExcelBtn').click(function() {
            let form = $('#inventoryReportFilters');
            form.attr('action', '{{ route('superadmin.report.inventoryreport.export') }}');
            form.attr('target', '_blank');
            form.submit();
            form.attr('action', '{{ route('superadmin.report.inventoryreport') }}');
            form.removeAttr('target');
        });
    });
</script>
@endpush
