@extends('layouts.dashboard.adminapp')

@section('title', 'GRN Details')

@section('content')
    <style>
        .route-card-card {
            background: linear-gradient(120deg, #f6d365 0%, #fda085 100%);
            border: none;
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
        }

        .route-card-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem 1rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .route-card-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .route-card-header .badge {
            font-size: 1rem;
            padding: .5em 1em;
            border-radius: 2rem;
        }

        .route-card-body {
            background: white;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .rc-detail-label {
            color: #4f4f4f;
            font-weight: 600;
            letter-spacing: 0.1px;
        }

        .rc-detail-value {
            font-weight: 700;
            color: #2b2b2b;
            word-break: break-all;
        }

        .rc-detail-row {
            margin-bottom: 1rem;
        }

        .rc-table th {
            background: #fda085;
            color: #fff;
            border: none;
            font-weight: 600;
        }

        .rc-table td,
        .rc-table th {
            vertical-align: middle !important;
        }

        .rc-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }
        @media (max-width: 991px) {
            .route-card-body {
                padding: 1.2rem;
            }
            .route-card-header {
                padding: 1rem 1rem .7rem 1rem;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-10">
                <div class="card route-card-card">
                    <div class="route-card-header">
                        <h3>
                            <i class="fas fa-file-invoice"></i> GRN Details
                        </h3>
                        <a href="{{ route('manager.grn.grndetails') }}" class="btn btn-light rc-back-btn">
                            <i class="fa fa-arrow-left"></i> Back
                        </a>
                    </div>
                    <div class="route-card-body">
                        <div class="row">
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">GRN No:</span>
                                <div class="rc-detail-value">{{ $grn->grn_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">GRN Date:</span>
                                <div class="rc-detail-value">{{ $grn->grn_date }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Order No:</span>
                                <div class="rc-detail-value">{{ $grn->order_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Order Date:</span>
                                <div class="rc-detail-value">{{ $grn->order_date }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Reference No:</span>
                                <div class="rc-detail-value">{{ $grn->order_ref_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Company:</span>
                                <div class="rc-detail-value">{{ $grn->company_name }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Address:</span>
                                <div class="rc-detail-value">{{ $grn->company_address }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">GST No:</span>
                                <div class="rc-detail-value">{{ $grn->company_gst }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Phone:</span>
                                <div class="rc-detail-value">{{ $grn->company_phone }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Email:</span>
                                <div class="rc-detail-value">{{ $grn->company_email }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Quotation No:</span>
                                <div class="rc-detail-value">{{ $grn->quotation_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Quotation Date:</span>
                                <div class="rc-detail-value">{{ $grn->quotation_date }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">RFQ No:</span>
                                <div class="rc-detail-value">{{ $grn->rfq_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">RFQ Date:</span>
                                <div class="rc-detail-value">{{ $grn->rfq_date }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Part No:</span>
                                <div class="rc-detail-value">{{ $grn->part_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Project Material No:</span>
                                <div class="rc-detail-value">{{ $grn->project_material_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Drawing No:</span>
                                <div class="rc-detail-value">{{ $grn->drawing_no }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Drawing Rev:</span>
                                <div class="rc-detail-value">{{ $grn->drawing_rev }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Product Type:</span>
                                <div class="rc-detail-value">{{ $grn->product_type }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Description:</span>
                                <div class="rc-detail-value">{{ $grn->description }}</div>
                            </div>
                            <div class="col-md-6 rc-detail-row">
                                <span class="rc-detail-label">Challan:</span>
                                <div class="rc-detail-value">
                                    @if ($grn->challan)
                                        <a href="{{ Storage::url($grn->challan) }}" target="_blank" class="btn btn-sm btn-info">View</a>
                                    @else
                                        -
                                    @endif
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3"><i class="fas fa-cubes me-2"></i>Product Details</h5>
                        <div class="table-responsive">
                            <table class="table rc-table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Sl No</th>
                                        <th>Description</th>
                                        <th>Qty</th>
                                        <th>Unit</th>
                                        <th>Date</th>
                                        <th>Supplier</th>
                                        <th>Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($grn->products as $product)
                                        <tr>
                                            <td>{{ $product->sl_no }}</td>
                                            <td>{{ $product->description }}</td>
                                            <td>{{ number_format($product->quantity, 2) }}</td>
                                            <td>{{ $product->unit }}</td>
                                            <td>{{ $product->date }}</td>
                                            <td>{{ $product->supplier }}</td>
                                            <td>{{ $product->remarks }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">No Product Rows Found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ route('admin.grn.grndetails') }}" class="btn btn-light rc-back-btn">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
