@extends('layouts.dashboard.managerapp')

@section('title', 'Employee Daily Report')

@section('content')
    <style>
        .table-responsive {
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: #ccc #f5f5f5;
            padding-bottom: 8px;
        }

        .table thead th {
            position: sticky;
            top: 0;
            background-color: #f8f9fa;
            z-index: 10;
        }

        table.table {
            min-width: 1500px;
            white-space: nowrap;
            font-size: 13px;
        }
        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }
    </style>

    <div class="container-fluid bg-white">
        <div class="p-2 d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h5 mb-0 text-gray-800">UEPL / Employee Daily Report</h1>
            <div class="display-date">
                <span id="day">day</span>,
                <span id="daynum">00</span>
                <span id="month">month</span>
                <span id="year">0000</span>
            </div>
            <div class="display-time"></div>
        </div>
        <!-- Header -->
        <div class="row flex">


            <div class="col-md-6 text-end">
                <form action="{{ route('employee.daily.import') }}" method="POST" enctype="multipart/form-data"
                    class="d-flex justify-content-end align-items-center gap-2">
                    @csrf
                    <input type="file" name="import_file" class="form-control form-control-sm w-auto" required>
                    <button type="submit" class="btn btn-sm btn-success">Upload Excel</button>
                </form>
            </div>

            <div class="col-md-6">
                <!-- Filter -->
                <form method="GET" action="{{ url('manager/employeedailyreport') }}"
                    class="row g-2 align-items-center mb-3">
                    <div class="col-md-3">
                        <input type="date" name="date" class="form-control form-control-sm"
                            value="{{ request('date') }}">
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-sm btn-primary" type="submit">Filter</button>
                    </div>
                    <div class="col-md-2">
                        <a href="{{ url('manager/employeedailyreport') }}" class="btn btn-sm btn-secondary">Reset</a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Table Card -->
    <div class="card shadow mb-4">
        <div class="card-header d-flex align-items-center">
            <i class="fas fa-table me-2"></i>
            <span class="fw-bold">Employee Daily Attendance Records</span>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="dailyReportTable" style="display: inline-table;" class="table table-bordered table-hover text-dark w-100" style="font-size: 13px;">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>Date</th>
                            <th>Emp ID</th>
                            <th>Shift</th>
                            <th>IN1</th>
                            <th>OUT1</th>
                            <th>IN2</th>
                            <th>OUT2</th>
                            <th>1st Half</th>
                            <th>2nd Half</th>
                            <th>Late IN</th>
                            <th>Early OUT</th>
                            <th>Paid Leave</th>
                            <th>Unpaid Leave</th>
                            <th>OT</th>
                            <th>Auth OT</th>
                            <th>Auth C-Off</th>
                            <th>Work Hrs</th>
                            <th>Man Entry</th>
                            <th>Reason</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($reports as $report)
                            <tr id="row-{{ $report->id }}">
                                <td>{{ $report->date }}</td>
                                <td>{{ $report->employee_id }}</td>
                                <td>{{ $report->shift }}</td>
                                <td>{{ $report->in_spfid_1 }}</td>
                                <td>{{ $report->out_spfid_1 }}</td>
                                <td>{{ $report->in_spfid_2 }}</td>
                                <td>{{ $report->out_spfid_2 }}</td>
                                <td>{{ $report->first_half }}</td>
                                <td>{{ $report->second_half }}</td>
                                <td>{{ $report->late_in }}</td>
                                <td>{{ $report->early_out }}</td>
                                <td>{{ $report->hourly_paid_leave }}</td>
                                <td>{{ $report->hourly_unpaid_leave }}</td>
                                <td>{{ $report->over_time }}</td>
                                <td>{{ $report->auth_ot }}</td>
                                <td>{{ $report->auth_coff }}</td>
                                <td>{{ $report->work_hours }}</td>
                                <td>{{ $report->man_entry }}</td>
                                <td>{{ $report->reason }}</td>
                                <td>
                                    <button onclick="editReport({{ $report->id }})" class="btn btn-warning btn-sm mb-1">Edit</button>
                                    <button onclick="deleteReport({{ $report->id }})" class="btn btn-danger btn-sm">Delete</button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <form id="editForm" method="POST" class="modal-content">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Edit Attendance</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body row g-2">
                    <input type="hidden" id="edit_id" name="id">
                    <div class="col-md-4"><label>Date</label><input type="date" class="form-control" name="date" id="edit_date" required></div>
                    <div class="col-md-4"><label>Emp ID</label><input type="text" class="form-control" name="employee_id" id="edit_employee_id" required></div>
                    <div class="col-md-4"><label>Shift</label><input type="text" class="form-control" name="shift" id="edit_shift"></div>
                    <div class="col-md-4"><label>IN1</label><input type="text" class="form-control" name="in_spfid_1" id="edit_in_spfid_1"></div>
                    <div class="col-md-4"><label>OUT1</label><input type="text" class="form-control" name="out_spfid_1" id="edit_out_spfid_1"></div>
                    <div class="col-md-4"><label>IN2</label><input type="text" class="form-control" name="in_spfid_2" id="edit_in_spfid_2"></div>
                    <div class="col-md-4"><label>OUT2</label><input type="text" class="form-control" name="out_spfid_2" id="edit_out_spfid_2"></div>
                    <div class="col-md-4"><label>1st Half</label><input type="text" class="form-control" name="first_half" id="edit_first_half"></div>
                    <div class="col-md-4"><label>2nd Half</label><input type="text" class="form-control" name="second_half" id="edit_second_half"></div>
                    <div class="col-md-4"><label>Late IN</label><input type="text" class="form-control" name="late_in" id="edit_late_in"></div>
                    <div class="col-md-4"><label>Early OUT</label><input type="text" class="form-control" name="early_out" id="edit_early_out"></div>
                    <div class="col-md-4"><label>Paid Leave</label><input type="text" class="form-control" name="hourly_paid_leave" id="edit_hourly_paid_leave"></div>
                    <div class="col-md-4"><label>Unpaid Leave</label><input type="text" class="form-control" name="hourly_unpaid_leave" id="edit_hourly_unpaid_leave"></div>
                    <div class="col-md-4"><label>OT</label><input type="text" class="form-control" name="over_time" id="edit_over_time"></div>
                    <div class="col-md-4"><label>Auth OT</label><input type="text" class="form-control" name="auth_ot" id="edit_auth_ot"></div>
                    <div class="col-md-4"><label>Auth C-Off</label><input type="text" class="form-control" name="auth_coff" id="edit_auth_coff"></div>
                    <div class="col-md-4"><label>Work Hrs</label><input type="text" class="form-control" name="work_hours" id="edit_work_hours"></div>
                    <div class="col-md-4"><label>Man Entry</label><input type="text" class="form-control" name="man_entry" id="edit_man_entry"></div>
                    <div class="col-md-8"><label>Reason</label><input type="text" class="form-control" name="reason" id="edit_reason"></div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')

<script>
    $(document).ready(function() {
        $('#dailyReportTable').DataTable({
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', className: 'btn btn-secondary btn-sm' },
                { extend: 'csv', className: 'btn btn-secondary btn-sm' },
                { extend: 'excel', className: 'btn btn-secondary btn-sm' },
                { extend: 'pdf', className: 'btn btn-secondary btn-sm' },
                { extend: 'print', className: 'btn btn-secondary btn-sm' },
                { extend: 'colvis', className: 'btn btn-secondary btn-sm' }
            ],
            responsive: true,
            destroy: true,
            scrollX: true
        });
    });

    function editReport(id) {
        fetch(`{{ url('manager/employeedailyreport/edit') }}/${id}`)
            .then(res => res.json())
            .then(data => {
                for (const key in data) {
                    const field = document.getElementById('edit_' + key);
                    if (field) field.value = data[key];
                }
                document.getElementById('edit_id').value = data.id;
                const modal = new bootstrap.Modal(document.getElementById('editModal'));
                modal.show();
            });
    }

    document.getElementById('editForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const id = document.getElementById('edit_id').value;
        const formData = new FormData(this);
        fetch(`{{ url('manager/employeedailyreport/update') }}/${id}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: new URLSearchParams(formData)
        }).then(() => location.reload());
    });

    function deleteReport(id) {
        if (confirm('Are you sure to delete this entry?')) {
            fetch(`{{ url('manager/employeedailyreport/delete') }}/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            }).then(() => {
                document.getElementById('row-' + id).remove();
            });
        }
    }
</script>
@endsection