<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Indus Pro - Industrial Manufacturing ERP System">
    <meta name="author" content="SRIIN5NET">

    <title>Indus Pro - Login</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            background: linear-gradient(-45deg, #0f172a, #1e3a5f, #0c4a6e, #164e63);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            position: relative;
        }

        @keyframes gradientShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Floating particles */
        .particles {
            position: fixed;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
            z-index: 0;
        }

        .particle {
            position: absolute;
            width: 4px;
            height: 4px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: float 20s infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(100vh) rotate(0deg); opacity: 0; }
            10% { opacity: 1; }
            90% { opacity: 1; }
            100% { transform: translateY(-100vh) rotate(720deg); opacity: 0; }
        }

        /* Main container */
        .login-container {
            width: 100%;
            max-width: 1000px;
            position: relative;
            z-index: 10;
        }

        .login-card {
            display: grid;
            grid-template-columns: 1fr 1fr;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        @media (max-width: 900px) {
            .login-card {
                grid-template-columns: 1fr;
            }
            .branding-panel {
                padding: 40px 30px !important;
            }
            .form-panel {
                padding: 40px 30px !important;
            }
        }

        /* Left Panel - Branding */
        .branding-panel {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            padding: 50px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            position: relative;
            overflow: hidden;
        }

        .branding-panel::before {
            content: '';
            position: absolute;
            top: -100px;
            right: -100px;
            width: 300px;
            height: 300px;
            background: rgba(14, 165, 233, 0.1);
            border-radius: 50%;
            filter: blur(60px);
        }

        .branding-panel::after {
            content: '';
            position: absolute;
            bottom: -50px;
            left: -50px;
            width: 200px;
            height: 200px;
            background: rgba(6, 182, 212, 0.1);
            border-radius: 50%;
            filter: blur(60px);
        }

        .branding-content {
            position: relative;
            z-index: 1;
        }

        .logo {
            margin-bottom: 30px;
        }

        .logo img {
            height: 60px;
            width: auto;
        }

        .headline h1 {
            font-size: 32px;
            font-weight: 700;
            color: #ffffff;
            line-height: 1.2;
            margin-bottom: 16px;
        }

        .headline .gradient-text {
            background: linear-gradient(90deg, #38bdf8, #22d3ee);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .headline p {
            color: #94a3b8;
            font-size: 16px;
            line-height: 1.6;
            max-width: 380px;
        }

        /* Features */
        .features {
            margin-top: 40px;
            position: relative;
            z-index: 1;
        }

        .feature-item {
            display: flex;
            align-items: center;
            gap: 16px;
            padding: 14px;
            border-radius: 12px;
            margin-bottom: 12px;
            transition: all 0.3s ease;
        }

        .feature-item:hover {
            background: rgba(255, 255, 255, 0.05);
            transform: translateX(5px);
        }

        .feature-icon {
            width: 44px;
            height: 44px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .feature-icon.blue { background: rgba(14, 165, 233, 0.2); }
        .feature-icon.green { background: rgba(16, 185, 129, 0.2); }
        .feature-icon.purple { background: rgba(139, 92, 246, 0.2); }

        .feature-icon svg {
            width: 22px;
            height: 22px;
        }

        .feature-icon.blue svg { color: #38bdf8; }
        .feature-icon.green svg { color: #34d399; }
        .feature-icon.purple svg { color: #a78bfa; }

        .feature-text h3 {
            color: #ffffff;
            font-size: 15px;
            font-weight: 600;
            margin-bottom: 2px;
        }

        .feature-text p {
            color: #64748b;
            font-size: 13px;
        }

        /* Right Panel - Form */
        .form-panel {
            background: #ffffff;
            padding: 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .form-container {
            max-width: 360px;
            margin: 0 auto;
            width: 100%;
        }

        .form-header {
            text-align: center;
            margin-bottom: 32px;
        }

        .form-header h2 {
            font-size: 26px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 8px;
        }

        .form-header p {
            color: #64748b;
            font-size: 15px;
        }

        /* Error Alert */
        .error-alert {
            background: #fef2f2;
            border: 1px solid #fecaca;
            border-radius: 12px;
            padding: 14px 16px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .error-alert svg {
            width: 20px;
            height: 20px;
            color: #ef4444;
            flex-shrink: 0;
        }

        .error-alert span {
            color: #b91c1c;
            font-size: 14px;
        }

        /* Form */
        .login-form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .form-group label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            color: #374151;
            margin-bottom: 8px;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af;
            pointer-events: none;
        }

        .input-icon svg {
            width: 20px;
            height: 20px;
        }

        .form-input {
            width: 100%;
            padding: 14px 16px 14px 48px;
            font-size: 15px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            background: #f9fafb;
            color: #1e293b;
            transition: all 0.2s ease;
            outline: none;
        }

        .form-input::placeholder {
            color: #9ca3af;
        }

        .form-input:focus {
            border-color: #0ea5e9;
            background: #ffffff;
            box-shadow: 0 0 0 4px rgba(14, 165, 233, 0.1);
        }

        .form-input.error {
            border-color: #f87171;
            background: #fef2f2;
        }

        /* Password toggle */
        .password-toggle {
            position: absolute;
            right: 14px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            color: #9ca3af;
            padding: 4px;
            transition: color 0.2s;
        }

        .password-toggle:hover {
            color: #0ea5e9;
        }

        .password-toggle svg {
            width: 20px;
            height: 20px;
        }

        /* Remember & Forgot */
        .form-options {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 10px;
        }

        .remember-label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-size: 14px;
            color: #4b5563;
        }

        .remember-label input[type="checkbox"] {
            width: 18px;
            height: 18px;
            border-radius: 4px;
            border: 2px solid #d1d5db;
            cursor: pointer;
            accent-color: #0ea5e9;
        }

        .forgot-link {
            font-size: 14px;
            color: #0ea5e9;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s;
        }

        .forgot-link:hover {
            color: #0284c7;
        }

        /* Submit Button */
        .submit-btn {
            width: 100%;
            padding: 16px 24px;
            font-size: 16px;
            font-weight: 600;
            color: #ffffff;
            background: linear-gradient(135deg, #0ea5e9 0%, #06b6d4 100%);
            border: none;
            border-radius: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 14px 0 rgba(14, 165, 233, 0.4);
            position: relative;
            overflow: hidden;
        }

        .submit-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .submit-btn:hover::before {
            left: 100%;
        }

        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px 0 rgba(14, 165, 233, 0.5);
        }

        .submit-btn:active {
            transform: translateY(0);
        }

        .submit-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
            transform: none;
        }

        .submit-btn svg {
            width: 20px;
            height: 20px;
            transition: transform 0.2s;
        }

        .submit-btn:hover svg {
            transform: translateX(4px);
        }

        /* Spinner */
        .spinner {
            width: 20px;
            height: 20px;
            border: 2px solid transparent;
            border-top-color: currentColor;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            display: none;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Divider */
        .divider {
            position: relative;
            margin: 28px 0;
        }

        .divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 1px;
            background: #e5e7eb;
        }

        .divider span {
            position: relative;
            background: #ffffff;
            padding: 0 16px;
            color: #9ca3af;
            font-size: 13px;
            display: block;
            width: fit-content;
            margin: 0 auto;
        }

        /* Contact */
        .contact-text {
            text-align: center;
            font-size: 14px;
            color: #64748b;
        }

        .contact-text a {
            color: #0ea5e9;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s;
        }

        .contact-text a:hover {
            color: #0284c7;
        }

        /* Footer */
        .footer {
            text-align: center;
            margin-top: 24px;
            color: rgba(255, 255, 255, 0.5);
            font-size: 13px;
        }

        /* Animations */
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-in {
            animation: slideUp 0.5s ease-out forwards;
        }

        .delay-1 { animation-delay: 0.1s; opacity: 0; }
        .delay-2 { animation-delay: 0.2s; opacity: 0; }
        .delay-3 { animation-delay: 0.3s; opacity: 0; }
        .delay-4 { animation-delay: 0.4s; opacity: 0; }

        /* Hide class */
        .hidden {
            display: none !important;
        }
    </style>
</head>

<body>
    <!-- Floating Particles -->
    <div class="particles">
        @for ($i = 0; $i < 15; $i++)
            <div class="particle" style="left: {{ rand(0, 100) }}%; animation-delay: {{ rand(0, 20) }}s; animation-duration: {{ rand(15, 25) }}s;"></div>
        @endfor
    </div>

    <!-- Main Container -->
    <div class="login-container">
        <div class="login-card">
            <!-- Left Panel - Branding -->
            <div class="branding-panel">
                <div class="branding-content">
                    <!-- Logo -->
                    <div class="logo animate-in">
                        <img src="{{ asset('img/INDUS-PRO-LOGO.png') }}" alt="Indus Pro Logo">
                    </div>

                    <!-- Headline -->
                    <div class="headline animate-in delay-1">
                        <h1>Industrial Manufacturing <span class="gradient-text">ERP Solution</span></h1>
                        <p>Boost Productivity, Reduce Waste – Smarter Manufacturing Starts Here</p>
                    </div>
                </div>

                <!-- Features -->
                <div class="features animate-in delay-2">
                    <div class="feature-item">
                        <div class="feature-icon blue">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div class="feature-text">
                            <h3>End-to-End Tracking</h3>
                            <p>From RFQ to production & invoicing</p>
                        </div>
                    </div>

                    <div class="feature-item">
                        <div class="feature-icon green">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <div class="feature-text">
                            <h3>Real-time Analytics</h3>
                            <p>Data-driven manufacturing insights</p>
                        </div>
                    </div>

                    <div class="feature-item">
                        <div class="feature-icon purple">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                            </svg>
                        </div>
                        <div class="feature-text">
                            <h3>Role-Based Access</h3>
                            <p>Secure multi-level permissions</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Panel - Login Form -->
            <div class="form-panel">
                <div class="form-container">
                    <!-- Header -->
                    <div class="form-header animate-in">
                        <h2>Welcome Back</h2>
                        <p>Sign in to access your dashboard</p>
                    </div>

                    <!-- Error Alert -->
                    @if ($errors->any())
                        <div class="error-alert">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <span>{{ $errors->first() }}</span>
                        </div>
                    @endif

                    <!-- Login Form -->
                    <form method="POST" action="{{ route('login') }}" class="login-form animate-in delay-1" id="loginForm">
                        @csrf

                        <!-- Email Input -->
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <div class="input-wrapper">
                                <span class="input-icon">
                                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                                    </svg>
                                </span>
                                <input
                                    type="email"
                                    name="email"
                                    id="email"
                                    class="form-input @error('email') error @enderror"
                                    value="{{ old('email') }}"
                                    required
                                    autofocus
                                    placeholder="name@company.com"
                                >
                            </div>
                        </div>

                        <!-- Password Input -->
                        <div class="form-group">
                            <label for="password">Password</label>
                            <div class="input-wrapper">
                                <span class="input-icon">
                                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                    </svg>
                                </span>
                                <input
                                    type="password"
                                    name="password"
                                    id="password"
                                    class="form-input @error('password') error @enderror"
                                    required
                                    placeholder="Enter your password"
                                >
                                <button type="button" class="password-toggle" onclick="togglePassword()">
                                    <svg id="eyeIcon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                    </svg>
                                    <svg id="eyeOffIcon" class="hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Remember Me & Forgot Password -->
                        <div class="form-options">
                            <label class="remember-label">
                                <input type="checkbox" name="remember">
                                <span>Remember me</span>
                            </label>
                            <a href="{{ route('password.request') }}" class="forgot-link">Forgot password?</a>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="submit-btn" id="loginBtn">
                            <span id="btnText">Sign In</span>
                            <svg id="btnArrow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                            </svg>
                            <div id="btnSpinner" class="spinner"></div>
                        </button>
                    </form>

                    <!-- Divider -->
                    <div class="divider animate-in delay-2">
                        <span>Need access?</span>
                    </div>

                    <!-- Contact Admin -->
                    <div class="contact-text animate-in delay-3">
                        Don't have an account? <a href="mailto:admin@company.com">Contact Administrator</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer animate-in delay-4">
            &copy; {{ date('Y') }} SRIIN5NET. All rights reserved.
        </div>
    </div>

    <script>
        // Password visibility toggle
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eyeIcon');
            const eyeOffIcon = document.getElementById('eyeOffIcon');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.classList.add('hidden');
                eyeOffIcon.classList.remove('hidden');
            } else {
                passwordInput.type = 'password';
                eyeIcon.classList.remove('hidden');
                eyeOffIcon.classList.add('hidden');
            }
        }

        // Form submission with loading state
        document.getElementById('loginForm').addEventListener('submit', function() {
            const btn = document.getElementById('loginBtn');
            const btnText = document.getElementById('btnText');
            const btnArrow = document.getElementById('btnArrow');
            const btnSpinner = document.getElementById('btnSpinner');

            btn.disabled = true;
            btnText.textContent = 'Signing in...';
            btnArrow.style.display = 'none';
            btnSpinner.style.display = 'block';
        });
    </script>
</body>

</html>
