@extends('layouts.dashboard.adminapp')
@section('title', 'Production Execution')
@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        .production-card {
            border-radius: 18px;
            border: none;
            box-shadow: 0 4px 32px 0 rgba(0, 0, 0, .07);
            transition: box-shadow 0.25s;
            background: #fff;
        }

        .production-card:hover {
            box-shadow: 0 8px 36px 0 rgba(60, 60, 100, .11);
        }

        .status-badge {
            font-size: 0.9rem;
            padding: 0.35em 0.9em;
            border-radius: 18px;
            letter-spacing: .5px;
            text-transform: uppercase;
        }

        .status-pending {
            background: #ffe082;
            color: #865700;
        }

        .status-in-progress {
            background: #81d4fa;
            color: #02587e;
        }

        .status-qc {
            background: #fff59d;
            color: #856c00;
        }

        .status-completed {
            background: #c8e6c9;
            color: #226622;
        }

        .operator-badge {
            background: #f5f7fa;
            padding: 0.2em 0.7em;
            border-radius: 15px;
            font-size: 0.93em;
            margin-left: 0.25em;
        }

        .production-btn {
            min-width: 160px;
            font-weight: 600;
            border-radius: 12px;
            box-shadow: 0 2px 12px 0 rgba(80, 200, 140, .07);
            font-size: 1.07em;
            letter-spacing: .1em;
            margin-top: 0.4em;
        }

        .production-btn:active,
        .production-btn:focus {
            box-shadow: none;
        }

        .step-badge {
            background: #2196f3;
            color: #fff;
            font-size: 1.1em;
            border-radius: 50%;
            width: 34px;
            height: 34px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-right: 10px;
        }

        .progress {
            height: 30px;
            border-radius: 16px;
            background: #e3f2fd;
        }

        .progress-bar {
            font-size: 1.13em;
            font-weight: 500;
            border-radius: 14px;
        }
    </style>

    <div class="container py-3">
        <div class="row mb-4">
            <div class="col">
                <h2 class="fw-bold mb-2 text-center" style="letter-spacing:.04em;">Production Board <span
                        class="text-muted fs-5">— RC: {{ $routeCard->route_no }}</span></h2>
                <div class="progress mb-2 mx-auto" style="max-width:500px;">
                    @php
                        $total = $routeCard->processes->count();
                        $done = $routeCard->processes->where('status', 'approved')->count();
                        $percent = $total ? round(($done / $total) * 100) : 0;
                    @endphp
                    <div class="progress-bar bg-success progress-bar-striped" role="progressbar"
                        style="width: {{ $percent }}%;">
                        {{ $percent }}% Complete
                    </div>
                </div>
            </div>
        </div>

        @foreach ($routeCard->processes as $index => $proc)
            <div class="card production-card mb-4 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-1">
                        <div>
                            <span class="step-badge">{{ $index + 1 }}</span>
                            <span class="fs-5 fw-bold">{{ $proc->process }}</span>
                        </div>
                        <span class="status-badge status-{{ str_replace('_', '-', $proc->status) }}">
                            {{ ucfirst(str_replace('_', ' ', $proc->status)) }}
                        </span>
                    </div>
                    <div class="mb-2">
                        <span class="fw-bold text-dark">Description:</span>
                        <span>{{ $proc->description ?: '-' }}</span>
                    </div>
                    <div class="mb-2">
                        <span class="me-3"><i class="fas fa-cogs me-1"></i>
                            <span class="fw-semibold">Machine:</span>
                            <span>{{ $proc->machine }}</span>
                        </span>
                        <span class="me-3"><i class="fas fa-user me-1"></i>
                            <span class="fw-semibold">Operator:</span>
                            @php
                                // Show operator name if actual_start or actual_end is present
                                $showOperator = $proc->actual_start || $proc->actual_end;
                            @endphp
                            <span class="operator-badge">
                                @if ($showOperator && isset($employees[$proc->operator]))
                                    {{ $employees[$proc->operator] }}
                                @else
                                    -
                                @endif
                            </span>
                        </span>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-4 mb-1">
                            <span class="text-muted">Planned Start</span><br>
                            <span>{{ $proc->planned_start_date }}</span>
                        </div>
                        <div class="col-md-4 mb-1">
                            <span class="text-muted">Actual Start</span><br>
                            <span>{{ $proc->actual_start ?? '-' }}</span>
                        </div>
                        <div class="col-md-4 mb-1">
                            <span class="text-muted">Actual End</span><br>
                            <span>{{ $proc->actual_end ?? '-' }}</span>
                        </div>
                    </div>
                    <div class="mt-2">
                        @if ($proc->status == 'pending')
                            <button class="btn btn-success production-btn" onclick="startProcess({{ $proc->id }})"
                                @if ($index > 0 && $routeCard->processes[$index - 1]->status != 'approved') disabled @endif>
                                <i class="fas fa-play me-1"></i> Start Process
                            </button>
                        @elseif ($proc->status == 'qc' || ($proc->status == 'approved' && !$proc->actual_end))
                            @php
                                $anyPendingQC = $proc->qcApprovals->where('status', 'pending')->count();
                                $allApprovedQC =
                                    $proc->qcApprovals->where('status', 'approved')->count() ==
                                    $proc->qcApprovals->count();
                            @endphp

                            @if ($anyPendingQC)
                                <span class="d-block mt-2 fw-bold text-danger">
                                    <i class="fas fa-hourglass-half me-1"></i>
                                    Waiting for Quality Control Approval.<br>
                                    Once approved you can stop the process.
                                </span>
                            @elseif($allApprovedQC && !$proc->actual_end)
                                <button class="btn btn-danger production-btn" onclick="endProcess({{ $proc->id }})">
                                    <i class="fas fa-stop me-1"></i> End Process
                                </button>
                            @endif
                        @elseif($proc->status == 'approved' && $proc->actual_end)
                            <span class="badge bg-success px-3 py-2 fs-6 rounded-pill">Approved</span>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach

        <!-- Add in your CSS -->
        <style>
            .text-danger {
                color: #d90429 !important;
            }
        </style>

    </div>
    <script>
        window.routes = {
            startProcess: "{{ url('admin/manufacturing/production/start-process') }}",
            endProcess: "{{ url('admin/manufacturing/production/end-process') }}",
            approveQC: "{{ url('admin/manufacturing/production/approve-qc') }}"
        };

        function startProcess(id) {
            fetch(`${window.routes.startProcess}/${id}`, {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).then(r => r.json()).then(resp => {
                location.reload();
            });
        }

        function endProcess(id) {
            fetch(`${window.routes.endProcess}/${id}`, {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).then(r => r.json()).then(resp => {
                location.reload();
            });
        }

        function approveQC(id) {
            fetch(`${window.routes.approveQC}/${id}`, {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).then(r => r.json()).then(resp => {
                location.reload();
            });
        }
    </script>
@endsection
