@extends('layouts.dashboard.adminapp')

@section('title', 'GRN Order Details')

<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
        margin-bottom: 1rem;
    }

    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }

    .dt-buttons .btn {
        margin-right: 0.5rem !important;
        padding: 0.25rem 0.75rem !important;
        font-size: 0.95rem !important;
    }

    .btn-delete {
        min-width: 80px;
    }

    .page-header-icon {
        font-size: 2rem;
        color: #506690;
        vertical-align: middle;
    }
</style>

@section('content')
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / GRN Datatable</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3">
            <span class="fw-bold"></span>
            <a href="{{ route('admin.grn.grnorder') }}" class="btn btn-primary" title="Add GRN">
                <i class="fas fa-plus-square"></i> 
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="grnTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>GRN ID</th>
                            <th>GRN Date</th>
                            <th>Order ID</th>
                            <th>Order Date</th>
                            <th>Reference No</th>
                            <th>Quotation ID</th>
                            <th>RFQ ID</th>
                            <th>Company Name</th>
                            <th>Company Email</th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>GST</th>
                            <th>Part No</th>
                            <th>Project Material No</th>
                            <th>Drawing ID</th>
                            <th>Drawing Rev</th>
                            <th>Challan</th>
                            <th>Description</th>
                            <th>Product Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($grns as $grn)
                            <tr class="text-center align-middle" id="row-{{ $grn->id }}">
                                <td>{{ $grn->grn_no }}</td>
                                <td>{{ $grn->grn_date }}</td>
                                <td>{{ $grn->order_no }}</td>
                                <td>{{ $grn->order_date }}</td>
                                <td>{{ $grn->order_ref_no }}</td>
                                <td>{{ $grn->quotation_no }}</td>
                                <td>{{ $grn->rfq_no }}</td>
                                <td>{{ $grn->company_name }}</td>
                                <td>{{ $grn->company_email }}</td>
                                <td>{{ $grn->company_phone }}</td>
                                <td>{{ $grn->company_address }}</td>
                                <td>{{ $grn->company_gst }}</td>
                                <td>{{ $grn->part_no }}</td>
                                <td>{{ $grn->project_material_no }}</td>
                                <td>{{ $grn->drawing_no }}</td>
                                <td>{{ $grn->drawing_rev }}</td>
                                <td>
                                    @if ($grn->challan)
                                        <a href="{{ Storage::url($grn->challan) }}" target="_blank"
                                            class="btn btn-sm btn-info">View</a>
                                    @endif
                                </td>
                                <td>{{ $grn->description }}</td>
                                <td>{{ $grn->product_type }}</td>
                                <td>
                                    <a href="{{ route('admin.grn.view', $grn->id) }}"
                                        class="btn btn-success btn-sm mb-1" title="View"><i class="fa fa-eye"></i></a>
                                    <a href="{{ route('admin.grn.edit', $grn->id) }}"
                                        class="btn btn-primary btn-sm mb-1" title="Edit"> <i class="fa fa-edit"></i></a>
                                    <button class="btn btn-danger btn-sm delete-btn" title="Delete"
                                        data-id="{{ $grn->id }}"><i class="fa fa-trash"></i></button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bulk Import Modal -->
    <div class="modal fade" id="importModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form method="POST" action="{{ route('admin.grn.import') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">Import GRN Excel</h5>
                        <button type="button" class="close" data-dismiss="modal" style="width: auto;">&times;</button>
                    </div>
                    <div class="modal-body">
                        <input type="file" name="file" class="form-control" required accept=".xls,.xlsx">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Import</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // DataTable with export buttons
            $('#grnTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                responsive: true,
                destroy: true,
            });

            // Handle delete button
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                if (confirm('Are you sure you want to delete this GRN?')) {
                    fetch(`{{ url('admin/grn/delete') }}/${id}`, {
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Accept': 'application/json',
                            },
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                $('#row-' + id).remove();
                            } else {
                                alert('Delete failed');
                            }
                        })
                        .catch(() => alert('Error deleting record'));
                }
            });
        });
    </script>
@endsection
