@extends('layouts.dashboard.superadminapp')

@section('title', 'Accounts Receivable')

@section('styles')
<style>
    .stat-card {
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        color: #fff;
        transition: transform 0.2s;
    }
    .stat-card:hover {
        transform: translateY(-3px);
    }
    .stat-card .stat-value {
        font-size: 1.8rem;
        font-weight: bold;
    }
    .stat-card .stat-label {
        font-size: 0.85rem;
        opacity: 0.9;
    }
    .bg-receivable { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-received { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-outstanding { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-overdue { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Accounts Receivable</h1>
    <div class="d-flex gap-2">
        <a href="{{ route('superadmin.accounts.receivable.aging') }}" class="btn btn-warning btn-sm">
            <i class="fas fa-clock mr-1"></i> Aging Report
        </a>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card bg-receivable">
            <div class="stat-value">₹{{ number_format($stats['total_invoices'], 2) }}</div>
            <div class="stat-label"><i class="fas fa-file-invoice-dollar mr-1"></i> Total Invoiced</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card bg-received">
            <div class="stat-value">₹{{ number_format($stats['total_paid'], 2) }}</div>
            <div class="stat-label"><i class="fas fa-check-circle mr-1"></i> Total Received</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card bg-outstanding">
            <div class="stat-value">₹{{ number_format($stats['total_outstanding'], 2) }}</div>
            <div class="stat-label"><i class="fas fa-exclamation-circle mr-1"></i> Outstanding</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card bg-overdue">
            <div class="stat-value">{{ $stats['invoice_count'] }}</div>
            <div class="stat-label"><i class="fas fa-file-alt mr-1"></i> Total Invoices</div>
        </div>
    </div>
</div>

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter mr-2"></i> Filters
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('superadmin.accounts.receivable.index') }}">
            <div class="row align-items-end">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Customer</label>
                    <select name="customer_id" class="form-control">
                        <option value="">All Customers</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                {{ $customer->company }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                </div>
                <div class="col-md-3 mb-3">
                    <button type="submit" class="btn btn-primary btn-sm mr-1">
                        <i class="fas fa-search mr-1"></i> Filter
                    </button>
                    <a href="{{ route('superadmin.accounts.receivable.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-redo mr-1"></i> Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Receivables Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-file-invoice mr-2"></i> Customer Invoices ({{ $invoices->total() }} records)
        </h6>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
                <thead class="thead-dark">
                    <tr>
                        <th>Invoice No</th>
                        <th>Date</th>
                        <th>Customer</th>
                        <th class="text-right">Total</th>
                        <th class="text-right">Paid</th>
                        <th class="text-right">Balance</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                        @php
                            $paid = $payments[$invoice->id] ?? 0;
                            $balance = $invoice->total_amount - $paid;
                            $status = $balance <= 0 ? 'paid' : ($paid > 0 ? 'partial' : 'pending');
                        @endphp
                        <tr>
                            <td>
                                <a href="{{ route('superadmin.accounts.receivable.show', $invoice->id) }}" class="font-weight-bold text-primary">
                                    {{ $invoice->invoice_no }}
                                </a>
                            </td>
                            <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d M Y') }}</td>
                            <td>{{ $invoice->company->company ?? 'N/A' }}</td>
                            <td class="text-right">₹{{ number_format($invoice->total_amount, 2) }}</td>
                            <td class="text-right text-success">₹{{ number_format($paid, 2) }}</td>
                            <td class="text-right text-danger">₹{{ number_format($balance, 2) }}</td>
                            <td class="text-center">
                                @if($status == 'paid')
                                    <span class="badge badge-success">Paid</span>
                                @elseif($status == 'partial')
                                    <span class="badge badge-info">Partial</span>
                                @else
                                    <span class="badge badge-warning">Pending</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <a href="{{ route('superadmin.accounts.receivable.show', $invoice->id) }}" 
                                   class="btn btn-info btn-sm" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">No invoices found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="d-flex justify-content-center">
            {{ $invoices->appends(request()->query())->links() }}
        </div>
    </div>
</div>

@endsection
