@extends('layouts.dashboard.superadminapp')

@section('title', 'Accounts Payable')

@section('styles')
<style>
    :root {
        --primary-color: #4e73df;
        --secondary-color: #858796;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #e74a3b;
        --dark-color: #5a5c69;
        --light-bg: #f8f9fc;
        --card-border-radius: 12px;
    }

    body {
        background-color: var(--light-bg);
    }

    /* Page Header */
    .page-header-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--dark-color);
        margin-bottom: 0.25rem;
    }
    .page-header-subtitle {
        color: var(--secondary-color);
        font-size: 0.9rem;
    }

    /* Stat Cards - Redesigned */
    .stat-card-modern {
        background: #fff;
        border-radius: var(--card-border-radius);
        padding: 1.5rem;
        position: relative;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.05);
        border: 1px solid #eaecf4;
        transition: transform 0.2s;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        overflow: hidden;
    }
    .stat-card-modern:hover {
        transform: translateY(-3px);
        box-shadow: 0 0.5rem 2rem 0 rgba(58, 59, 69, 0.1);
    }
    
    .stat-card-modern::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
    }
    .stat-card-modern.primary::after { background-color: var(--primary-color); }
    .stat-card-modern.success::after { background-color: var(--success-color); }
    .stat-card-modern.warning::after { background-color: var(--warning-color); }
    .stat-card-modern.danger::after { background-color: var(--danger-color); }

    .stat-top {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    .stat-label {
        font-size: 0.8rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 0.5rem;
    }
    .stat-value {
        font-size: 1.8rem;
        font-weight: 700;
        color: var(--dark-color);
        line-height: 1.2;
    }
    
    .stat-icon-wrapper {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
    }
    .stat-card-modern.primary .stat-label { color: var(--primary-color); }
    .stat-card-modern.primary .stat-icon-wrapper { background-color: rgba(78, 115, 223, 0.1); color: var(--primary-color); }
    
    .stat-card-modern.success .stat-label { color: var(--success-color); }
    .stat-card-modern.success .stat-icon-wrapper { background-color: rgba(28, 200, 138, 0.1); color: var(--success-color); }
    
    .stat-card-modern.warning .stat-label { color: var(--warning-color); }
    .stat-card-modern.warning .stat-icon-wrapper { background-color: rgba(246, 194, 62, 0.1); color: var(--warning-color); }
    
    .stat-card-modern.danger .stat-label { color: var(--danger-color); }
    .stat-card-modern.danger .stat-icon-wrapper { background-color: rgba(231, 74, 59, 0.1); color: var(--danger-color); }

    .stat-subtitle {
        font-size: 0.8rem;
        color: #858796;
        display: flex;
        align-items: center;
    }
    
    /* Main Content Card */
    .content-card {
        background: #fff;
        border-radius: var(--card-border-radius);
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.05);
        border: 1px solid #eaecf4;
        overflow: hidden;
    }
    .content-header {
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #eaecf4;
        display: flex;
        align-items: center;
        justify-content: space-between;
        background-color: #fff;
    }
    .content-title {
        font-weight: 700;
        color: var(--primary-color);
        font-size: 1rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin: 0;
    }
    
    /* Filter Section */
    .filter-wrapper {
        padding: 1.5rem;
        background-color: #f8f9fc;
        border-bottom: 1px solid #eaecf4;
    }
    .input-group-modern .form-control {
        border-top-left-radius: 8px;
        border-bottom-left-radius: 8px;
        border: 1px solid #d1d3e2;
    }
    .input-group-modern .input-group-text {
        background-color: #eaecf4;
        border: 1px solid #d1d3e2;
        border-left: 0;
    }
    .form-label-modern {
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
        color: var(--secondary-color);
        margin-bottom: 0.5rem;
        display: block;
    }
    
    /* Table Styling */
    .table-modern {
        width: 100%;
        margin-bottom: 0;
    }
    .table-modern thead th {
        background-color: #fff;
        color: #b7b9cc;
        font-weight: 700;
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        border-bottom: 2px solid #eaecf4;
        padding: 1rem 1.5rem;
        border-top: none;
    }
    .table-modern tbody td {
        padding: 1rem 1.5rem;
        vertical-align: middle;
        color: #5a5c69;
        border-bottom: 1px solid #eaecf4;
        font-size: 0.9rem;
    }
    .table-modern tbody tr:last-child td { border-bottom: none; }
    .table-modern tbody tr:hover { background-color: #f8f9fc; }
    
    /* Components */
    .vendor-avatar-small {
        width: 35px;
        height: 35px;
        background-color: #eef2f7;
        color: var(--primary-color);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 0.9rem;
        margin-right: 1rem;
    }
    
    .status-badge {
        padding: 0.4rem 0.8rem;
        border-radius: 6px;
        font-size: 0.75rem;
        font-weight: 700;
        display: inline-flex;
        align-items: center;
    }
    .status-badge i { margin-right: 0.4rem; font-size: 0.7rem; }
    
    .status-pending { background-color: #FFF4E5; color: #B76E00; }
    .status-partial { background-color: #E3F2FD; color: #0D47A1; }
    .status-paid { background-color: #E8F5E9; color: #1B5E20; }
    
    .currency-value { font-family: 'Consolas', monospace; font-weight: 700; }
    
    .btn-action-view {
        background-color: var(--primary-color); 
        color: #fff;
        padding: 0.4rem 0.8rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        border: none;
        transition: all 0.2s;
    }
    .btn-action-view:hover {
        background-color: #2e59d9;
        text-decoration: none;
        color: #fff;
        transform: translateY(-1px);
        box-shadow: 0 4px 6px rgba(78, 115, 223, 0.25);
    }
</style>
@endsection

@section('content')

<!-- Header -->
<div class="row mb-4 align-items-end">
    <div class="col-md-8">
        <h1 class="page-header-title">Accounts Payable</h1>
        <p class="page-header-subtitle mb-0">Overview of vendor bills, payment status, and outstanding dues.</p>
    </div>
    <div class="col-md-4 text-md-right mt-3 mt-md-0">
        <a href="{{ route('superadmin.accounts.payable.aging') }}" class="btn btn-primary shadow-sm" style="border-radius: 8px;">
            <i class="fas fa-chart-pie mr-2"></i>Aging Report
        </a>
    </div>
</div>

<!-- Stat Cards -->
<div class="row mb-4">
    <!-- Total Payables -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card-modern primary">
            <div class="stat-top">
                <div>
                    <div class="stat-label">Total Payables</div>
                    <div class="stat-value">₹{{ number_format($stats['total_payables'] ?? 0, 0) }}</div>
                </div>
                <div class="stat-icon-wrapper">
                    <i class="fas fa-file-invoice-dollar"></i>
                </div>
            </div>
            <div class="stat-subtitle">
                <i class="fas fa-arrow-up mr-1 text-gray-500"></i> Lifetime Volume
            </div>
        </div>
    </div>

    <!-- Total Paid -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card-modern success">
            <div class="stat-top">
                <div>
                    <div class="stat-label">Total Paid</div>
                    <div class="stat-value">₹{{ number_format($stats['total_paid'] ?? 0, 0) }}</div>
                </div>
                <div class="stat-icon-wrapper">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>
            <div class="stat-subtitle">
                <i class="fas fa-check mr-1 text-success"></i> Settled Payments
            </div>
        </div>
    </div>

    <!-- Outstanding -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card-modern warning">
            <div class="stat-top">
                <div>
                    <div class="stat-label">Outstanding</div>
                    <div class="stat-value">₹{{ number_format($stats['total_outstanding'] ?? 0, 0) }}</div>
                </div>
                <div class="stat-icon-wrapper">
                    <i class="fas fa-balance-scale"></i>
                </div>
            </div>
            <div class="stat-subtitle">
                @php
                    $percent = ($stats['total_payables'] > 0) 
                        ? ($stats['total_outstanding'] / $stats['total_payables']) * 100 
                        : 0;
                @endphp
                <span class="text-warning mr-1 font-weight-bold">{{ number_format($percent, 1) }}%</span> of total
            </div>
        </div>
    </div>

    <!-- Overdue -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card-modern danger">
            <div class="stat-top">
                <div>
                    <div class="stat-label">Overdue Bills</div>
                    <div class="stat-value">{{ $stats['overdue_count'] ?? 0 }}</div>
                </div>
                <div class="stat-icon-wrapper">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
            </div>
            <div class="stat-subtitle">
                <span class="text-danger mr-1">Action Required</span>
            </div>
        </div>
    </div>
</div>

<!-- Content Card -->
<div class="content-card mb-4">
    <div class="content-header">
        <h6 class="content-title">
            <i class="fas fa-list mr-2"></i> Purchase Orders List
        </h6>
        <div>
            <button class="btn btn-sm btn-light border" type="button" data-toggle="collapse" data-target="#filterPanel">
                <i class="fas fa-filter mr-1 text-gray-500"></i> Filter
            </button>
        </div>
    </div>
    
    <!-- Filter Panel -->
    <div id="filterPanel" class="collapse show filter-wrapper">
        <form method="GET" action="{{ route('superadmin.accounts.payable.index') }}">
            <div class="row">
                <div class="col-md-3 mb-3 mb-md-0">
                    <label class="form-label-modern">Vendor Name</label>
                    <select name="vendor_id" class="form-control" style="border-radius: 8px;">
                        <option value="">All Vendors</option>
                        @foreach($vendors as $vendor)
                            <option value="{{ $vendor->id }}" {{ request('vendor_id') == $vendor->id ? 'selected' : '' }}>
                                {{ $vendor->company }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 mb-3 mb-md-0">
                    <label class="form-label-modern">Date Filter</label>
                    <div class="input-group input-group-modern">
                        <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                        <div class="input-group-prepend input-group-append">
                            <span class="input-group-text border-left-0 border-right-0">to</span>
                        </div>
                        <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}" style="border-radius: 0 8px 8px 0;">
                    </div>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary px-4" style="border-radius: 8px; font-weight: 600;">
                        Apply
                    </button>
                    <a href="{{ route('superadmin.accounts.payable.index') }}" class="btn btn-link text-secondary ml-2">
                        Reset
                    </a>
                </div>
            </div>
        </form>
    </div>

    <!-- Table -->
    <div class="table-responsive">
        <table class="table table-modern" cellspacing="0">
            <thead>
                <tr>
                    <th width="15%">PO Reference</th>
                    <th width="15%">Date</th>
                    <th width="20%">Vendor</th>
                    <th width="12%" class="text-right">Total</th>
                    <th width="12%" class="text-right">Paid</th>
                    <th width="12%" class="text-right">Balance</th>
                    <th width="10%" class="text-center">Status</th>
                    <th width="5%" class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($payables as $payable)
                <tr>
                    <td>
                        <div class="font-weight-bold text-primary">{{ $payable->purchase_order_no }}</div>
                        <div class="small text-muted">ID: #{{ $payable->id }}</div>
                    </td>
                    <td>
                        <div class="font-weight-bold text-dark">{{ \Carbon\Carbon::parse($payable->purchase_order_date)->format('d M, Y') }}</div>
                        <div class="small text-muted">{{ \Carbon\Carbon::parse($payable->purchase_order_date)->diffForHumans() }}</div>
                    </td>
                    <td>
                        <div class="d-flex align-items-center">
                            <div class="vendor-avatar-small">
                                {{ strtoupper(substr($payable->vendor->company ?? 'U', 0, 1)) }}
                            </div>
                            <div>
                                <div class="font-weight-bold text-dark">{{ $payable->vendor->company ?? 'Unknown' }}</div>
                                <div class="small text-muted" style="font-size: 0.8rem;">
                                    {{ $payable->vendor->gstno ?? 'GST: N/A' }}
                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="text-right currency-value text-dark">
                        ₹{{ number_format($payable->grand_total, 2) }}
                    </td>
                    <td class="text-right currency-value text-success">
                        ₹{{ number_format($payable->paid_amount ?? 0, 2) }}
                    </td>
                    <td class="text-right currency-value">
                        @if(($payable->balance_amount ?? $payable->grand_total) > 0)
                            <span class="text-danger">₹{{ number_format($payable->balance_amount ?? $payable->grand_total, 2) }}</span>
                        @else
                            <span class="text-success">₹0.00</span>
                        @endif
                    </td>
                    <td class="text-center">
                        @php
                            $topay = $payable->grand_total ?? 0;
                            $paid = $payable->paid_amount ?? 0;
                            $status = 'pending';
                            if($topay > 0 && $paid >= $topay) $status = 'paid';
                            elseif($paid > 0) $status = 'partial';
                        @endphp
                        <span class="status-badge status-{{ $status }}">
                            @if($status=='paid') <i class="fas fa-check-circle"></i>
                            @elseif($status=='partial') <i class="fas fa-adjust"></i>
                            @else <i class="fas fa-clock"></i>
                            @endif
                            {{ ucfirst($status) }}
                        </span>
                    </td>
                    <td class="text-center">
                        <a href="{{ route('superadmin.accounts.payable.show', $payable->id) }}" class="btn-action-view" title="View Details">
                            View <i class="fas fa-arrow-right ml-1" style="font-size: 0.7rem;"></i>
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="text-center py-5">
                        <div class="mb-3">
                            <i class="fas fa-file-invoice fa-3x text-gray-300"></i>
                        </div>
                        <h5 class="text-gray-600 font-weight-bold">No Records Found</h5>
                        <p class="text-gray-500 mb-0">No purchase orders found matching your criteria.</p>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    @if($payables->hasPages())
    <div class="card-footer bg-white py-3 border-top border-light">
        <div class="d-flex justify-content-end">
            {{ $payables->appends(request()->query())->links() }}
        </div>
    </div>
    @endif
</div>

@endsection
