<?php
namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Machines extends Model
{
    use HasFactory;

    protected $table = 'machines';

    protected $fillable = [
        'machine_id', 'machine_name', 'machine_sl_no', 'make',
        'model_type', 'diameter', 'length', 'weight', 'remarks',
    ];

    protected $appends = ['availability', 'available_by'];

    public function processes()
    {
        return $this->belongsToMany(Process::class, 'process_machine', 'machine_id', 'process_id');
    }

    public function routeCardProcesses()
    {
        return $this->hasMany(RouteCardProcess::class, 'machine', 'id');
    }

    public function operators()
    {
        return $this->belongsToMany(EmployeeDetails::class, 'machine_operator', 'machine_id', 'employee_id')
            ->withTimestamps();
    }

    public function getAvailabilityAttribute()
    {
        $routeCard = isset(request()->route_card) ? request()->route_card : null;
        $now = empty($routeCard)? Carbon::now() : Carbon::parse($routeCard->project_start_date);
        $startTime = $now->copy()->startOfDay();
        $endTime = $now->copy()->endOfDay();
        $inUse = $this->routeCardProcesses()
            ->where(function($query) use ($startTime, $endTime) {
                $query->where(function($q) use ($startTime, $endTime) {
                    $q->where('start_date', '<=', $startTime)
                    ->where('end_date', '>=', $endTime);
                })->orWhere(function($q) use ($startTime, $endTime) {
                    $q->where('start_date', '>=', $startTime);
                })->orWhere(function($q) use ($startTime, $endTime) {
                    $q->where('end_date', '<=', $startTime);
                });
            })
            ->exists();
        return $inUse ? 0 : 1;
    }

    public function getAvailableByAttribute()
    {
        $routeCard        = isset(request()->route_card) ? request()->route_card : null;
        $now              = empty($routeCard) ? Carbon::now() : Carbon::parse($routeCard->project_start_date);
        $startTime = $now->copy()->startOfDay();
        $endTime = $now->copy()->endOfDay();
        $nextAvailability = $this->routeCardProcesses()
        ->where(function($query) use ($startTime, $endTime) {
            $query->where(function($q) use ($startTime, $endTime) {
                $q->where('start_date', '<=', $startTime)
                ->where('end_date', '>=', $endTime);
            })->orWhere(function($q) use ($startTime, $endTime) {
                $q->where('start_date', '>=', $startTime);
            })->orWhere(function($q) use ($startTime, $endTime) {
                $q->where('end_date', '<=', $startTime);
            });
        })
        ->orderBy('end_date','desc')
        ->value('end_date');

        return $nextAvailability
            ? Carbon::parse($nextAvailability)->format('Y-m-d H:i')
            : Carbon::parse($now)->format('Y-m-d H:i');
    }
}
