<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeSalaryStructure extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'basic_da',
        'hra',
        'conveyance',
        'washing_allowance',
        'incentive_per_hour',
        'fixed_salary',
        'pf_percentage',
        'esi_percentage',
        'pt_percentage',
    ];

    public function employee()
    {
        return $this->belongsTo(EmployeeDetails::class, 'employee_id');
    }
}
