<?php
// app/Models/EmployeeAttendance.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeAttendance extends Model
{
    use HasFactory;

    protected $table = 'employee_attendances';

    protected $fillable = [
        'date',            // Attendance date
        'employee_id',
        'employee_name',
        'shift',           // GS, NS, etc.
        'check_in',        // Example: 09:00:00
        'break_out',       // Example: 13:00:00
        'break_in',        // Example: 13:30:00
        'check_out',       // Example: 18:30:00
        'first_half',      // PR, AB, etc.
        'second_half',     // PR, AB, etc.
        'late_in',         // Late-In time
        'early_out',       // Early-Out time
        'working_hours',
        'ot_hours',
        'shortage_hours'
    ];

    protected $casts = [
        'date'      => 'date:Y-m-d',
        'check_in'  => 'datetime:H:i:s',
        'break_out' => 'datetime:H:i:s',
        'break_in'  => 'datetime:H:i:s',
        'check_out' => 'datetime:H:i:s',
    ];

    public function employee()
    {
        return $this->belongsTo(EmployeeDetails::class, 'employee_id', 'employee_id');
    }
}
