<?php

//admin controllers
use App\Http\Controllers\Admin\CustomerVendorController;
use App\Http\Controllers\Admin\RfqController;
use App\Http\Controllers\Admin\QuotationController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\SalesController;
use App\Http\Controllers\Admin\PurchaseController;
use App\Http\Controllers\Admin\GRNController;
use App\Http\Controllers\Admin\RouteCardController;
use App\Http\Controllers\Admin\ManufacturingPlanningController;
use App\Http\Controllers\Admin\ProductionController;
use App\Http\Controllers\Admin\ProjectPlanningController;
use App\Http\Controllers\Admin\QualityController;
use App\Http\Controllers\Admin\SKUController;
use App\Http\Controllers\Admin\MachineController;
use App\Http\Controllers\Admin\EmployeeAttendanceController;
use App\Http\Controllers\Admin\EmployeeController;
use App\Http\Controllers\Admin\EmployeeDailyReportController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\CompanyTypeController;
use App\Http\Controllers\Admin\AccountTypeController;
use App\Http\Controllers\Admin\RfqTypeController;
use App\Http\Controllers\Admin\ProductTypeController;
use App\Http\Controllers\Admin\RawMaterialController;
use App\Http\Controllers\Admin\ConversionProcessTypeController;
use App\Http\Controllers\Admin\ProcessController;
use App\Http\Controllers\Admin\StockItemsController;
use App\Http\Controllers\Admin\AccountsPayableController;
use App\Http\Controllers\Admin\AccountsReceivableController;
use App\Http\Controllers\Admin\FinancialReportsController;


use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\SuperAdmin\SuperAdminDashboardController;
use App\Http\Controllers\SuperAdmin\SuperAdminUserController;
use App\Http\Controllers\SuperAdmin\SuperAdminCustomerVendorController;
use App\Http\Controllers\SuperAdmin\SuperAdminRfqController;
use App\Http\Controllers\SuperAdmin\SuperAdminPurchaseRFQController;
use App\Http\Controllers\SuperAdmin\SuperAdminSalesController;
use App\Http\Controllers\SuperAdmin\SuperAdminPurchaseController;
use App\Http\Controllers\SuperAdmin\SuperAdminQuotationController;
use App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController;
use App\Http\Controllers\SuperAdmin\SuperAdminGRNController;
use App\Http\Controllers\SuperAdmin\SuperAdminRouteCardController;
use App\Http\Controllers\SuperAdmin\SuperAdminManufacturingPlanningController;
use App\Http\Controllers\SuperAdmin\SuperAdminProjectPlanningController;
use App\Http\Controllers\SuperAdmin\SuperAdminQualityController;
use App\Http\Controllers\SuperAdmin\SuperAdminSKUController;
use App\Http\Controllers\SuperAdmin\SuperAdminInvoiceController;
use App\Http\Controllers\SuperAdmin\SuperAdminMachineController;
use App\Http\Controllers\SuperAdmin\SuperAdminEmployeeController;
use App\Http\Controllers\SuperAdmin\SuperAdminProductionController;
use App\Http\Controllers\SuperAdmin\SuperAdminCompanyTypeController;
use App\Http\Controllers\SuperAdmin\SuperAdminAccountTypeController;
use App\Http\Controllers\SuperAdmin\SuperAdminRfqTypeController;
use App\Http\Controllers\SuperAdmin\SuperAdminProductTypeController;
use Illuminate\Support\Facades\Artisan;

Route::get('/storage-link', function () {
    try {
        Artisan::call('storage:link');
        return 'Storage link created successfully. <br> output: ' . Artisan::output();
    } catch (\Exception $e) {
        return 'Error creating storage link: ' . $e->getMessage();
    }
});
use App\Http\Controllers\SuperAdmin\SuperAdminConversionProcessController;
use App\Http\Controllers\SuperAdmin\SuperAdminProcessController;
use App\Http\Controllers\SuperAdmin\SuperAdminReportController;
use App\Http\Controllers\SuperAdmin\SuperAdminEmployeeAttendanceController;
use App\Http\Controllers\SuperAdmin\SuperAdminEmployeeDailyReportController;
use App\Http\Controllers\SuperAdmin\SuperAdminStockItemsController;
use App\Http\Controllers\SuperAdmin\PurchaseManagementController;
use App\Http\Controllers\SuperAdmin\SuperAdminSalesManagementController;
use App\Http\Controllers\SuperAdmin\ProfileController as SuperAdminProfileController;
use App\Http\Controllers\SuperAdmin\UserActivityController;


use App\Http\Controllers\Manager\ManagerDashboardController;
use App\Http\Controllers\Manager\ManagerUserController;
use App\Http\Controllers\Manager\ManagerCustomerVendorController;
use App\Http\Controllers\Manager\ManagerRfqController;
use App\Http\Controllers\Manager\ManagerSalesController;
use App\Http\Controllers\Manager\ManagerPurchaseController;
use App\Http\Controllers\Manager\ManagerQuotationController;
use App\Http\Controllers\Manager\ManagerGRNController;
use App\Http\Controllers\Manager\ManagerRouteCardController;
use App\Http\Controllers\Manager\ManagerManufacturingPlanningController;
use App\Http\Controllers\Manager\ManagerProjectPlanningController;
use App\Http\Controllers\Manager\ManagerQualityController;
use App\Http\Controllers\Manager\ManagerSKUController;
use App\Http\Controllers\Manager\ManagerInvoiceController;
use App\Http\Controllers\Manager\ManagerMachineController;
use App\Http\Controllers\Manager\ManagerEmployeeController;
use App\Http\Controllers\Manager\ManagerProductionController;
use App\Http\Controllers\Manager\ManagerCompanyTypeController;
use App\Http\Controllers\Manager\ManagerAccountTypeController;
use App\Http\Controllers\Manager\ManagerRfqTypeController;
use App\Http\Controllers\Manager\ManagerProductTypeController;
use App\Http\Controllers\Manager\ManagerRawMaterialController;
use App\Http\Controllers\Manager\ManagerConversionProcessController;
use App\Http\Controllers\Manager\ManagerProcessController;
use App\Http\Controllers\Manager\ManagerReportController;
use App\Http\Controllers\Manager\ManagerEmployeeAttendanceController;
use App\Http\Controllers\Manager\ManagerEmployeeDailyReportController;
use App\Http\Controllers\Manager\ManagerStockItemsController;
use App\Http\Controllers\Manager\ManagerPurchaseManagementController;


use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;


// Home route
Route::get('/', function () {
    return redirect()->route('login');
});

// Authentication routes
Route::post('/logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout')->middleware('auth');

// Dashboard route
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// Profile routes
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Admin routes
Route::middleware(['auth', 'role:admin'])->group(function () {

     // Dashboard routes
    Route::get('admin/dashboard', [DashboardController::class, 'allDashboard'])->name('admin.dashboard.dashboard');
    Route::get('admin/employeedashboard', [DashboardController::class, 'employeeDashboard'])->name('admin.dashboard.employeedashboard');
    // Route::get('admin/employeedashboard', [DashboardController::class, 'employeeDashboard'])->name('admin.dashboard.empoyeedashboard');
    Route::get('admin/machinedashboard', [DashboardController::class, 'machineDashboard'])->name('admin.dashboard.machinedashboard');
    Route::get('admin/stockdashboard', [DashboardController::class, 'stockDashboard'])->name('admin.dashboard.stockdashboard');
    Route::get('admin/accountdashboard', [DashboardController::class, 'accountDashboard'])->name('admin.dashboard.accountdashboard');
    Route::get('admin/manufactingdashboard', [DashboardController::class, 'manufacturingDashboard'])->name('admin.dashboard.manufacturingdashboard');

    // Master routes
    // Company Type routes
    Route::prefix('admin')->name('admin.')->middleware(['auth', 'role:admin'])->group(function () {
        Route::get('companytypes', [CompanyTypeController::class, 'companyTypes'])->name('companytype.index');
        Route::get('companytypes/list', [CompanyTypeController::class, 'list'])->name('companytype.list');
        Route::post('companytypes/store', [CompanyTypeController::class, 'store'])->name('companytype.store');
        Route::post('companytypes/update/{companytype}', [CompanyTypeController::class, 'update'])->name('companytype.update');
        Route::delete('companytypes/delete/{companytype}', [CompanyTypeController::class, 'delete'])->name('companytype.delete');
    });
    // Account Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('accounttypes', [AccountTypeController::class, 'index'])->name('accounttype.index');
        Route::get('accounttypes/list', [AccountTypeController::class, 'list'])->name('accounttype.list');
        Route::get('accounttypes/{accounttype}', [AccountTypeController::class, 'show']);
        Route::post('accounttypes/store', [AccountTypeController::class, 'store'])->name('accounttype.store');
        Route::put('accounttypes/update/{accounttype}', [AccountTypeController::class, 'update']);
        Route::delete('accounttypes/delete/{accounttype}', [AccountTypeController::class, 'delete']);
    });
    // Rfq Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('rfqtypes', [RfqTypeController::class, 'index'])->name('rfqtype.index');
        Route::get('rfqtypes/list', [RfqTypeController::class, 'list'])->name('rfqtype.list');
        Route::get('rfqtypes/{rfqtype}', [RfqTypeController::class, 'show']);
        Route::post('rfqtypes/store', [RfqTypeController::class, 'store'])->name('rfqtype.store');
        Route::put('rfqtypes/update/{rfqtype}', [RfqTypeController::class, 'update']);
        Route::delete('rfqtypes/delete/{rfqtype}', [RfqTypeController::class, 'delete']);
    });
    // Product Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('producttypes', [ProductTypeController::class, 'index'])->name('producttype.index');
        Route::get('producttypes/list', [ProductTypeController::class, 'list'])->name('producttype.list');
        Route::get('producttypes/{producttype}', [ProductTypeController::class, 'show']);
        Route::post('producttypes/store', [ProductTypeController::class, 'store'])->name('producttype.store');
        Route::put('producttypes/update/{producttype}', [ProductTypeController::class, 'update']);
        Route::delete('producttypes/delete/{producttype}', [ProductTypeController::class, 'delete']);
    });
    // Raw Material routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('rawmaterials', [RawMaterialController::class, 'index'])->name('rawmaterial.index');
        Route::get('rawmaterials/list', [RawMaterialController::class, 'list'])->name('rawmaterial.list');
        Route::post('rawmaterials/store', [RawMaterialController::class, 'store'])->name('rawmaterial.store');
        Route::get('rawmaterials/{rawmaterial}', [RawMaterialController::class, 'show']);
        Route::put('rawmaterials/update/{rawmaterial}', [RawMaterialController::class, 'update']);
        Route::delete('rawmaterials/delete/{rawmaterial}', [RawMaterialController::class, 'delete']);
    });
    // Conversion Process routes
    Route::prefix('admin/conversionprocesses')->group(function () {
        Route::get('/', [ConversionProcessTypeController::class, 'index'])->name('admin.conversionprocess.index'); // returns Blade view
        Route::get('/list', [ConversionProcessTypeController::class, 'list'])->name('admin.conversionprocess.list');
        Route::post('/store', [ConversionProcessTypeController::class, 'store'])->name('admin.conversionprocess.store');
        Route::get('/{id}', [ConversionProcessTypeController::class, 'show']);
        Route::put('/update/{id}', [ConversionProcessTypeController::class, 'update']);
        Route::delete('/delete/{id}', [ConversionProcessTypeController::class, 'destroy']);
    });
    // Process routes
    Route::prefix('admin/processes')->name('admin.process.')->group(function () {
        Route::get('/', [ProcessController::class, 'index'])->name('index');         // Blade view
        Route::get('/api', [ProcessController::class, 'api'])->name('api');          // AJAX data
        Route::post('/store', [ProcessController::class, 'store'])->name('store');   // Create
        Route::get('/{id}', [ProcessController::class, 'show'])->name('show');       // Show (edit)
        Route::put('/update/{id}', [ProcessController::class, 'update'])->name('update'); // Update
        Route::delete('/delete/{id}', [ProcessController::class, 'destroy'])->name('destroy'); // Delete
    });
    // Stock Items routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('stockitems', [StockItemsController::class, 'index'])->name('stockitems.index');
        Route::post('stockitems', [StockItemsController::class, 'store'])->name('stockitems.store');
        Route::put('stockitems/{id}', [StockItemsController::class, 'update'])->name('stockitems.update');
        Route::delete('stockitems/{id}', [StockItemsController::class, 'destroy'])->name('stockitems.destroy');

        Route::post('categories/store', [SuperAdminStockItemsController::class, 'storeCategory'])->name('categories.store');
    });


    // All Admin Customer Routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('/customers', [CustomerVendorController::class, 'getAllCustomers']);
        Route::get('addcustomer', [CustomerVendorController::class, 'addcustomer'])->name('customer.addcustomer');
        Route::post('/customer-vendor/register', [CustomerVendorController::class, 'store'])->name('customer.vendor.store');
        Route::get('customerlist', [CustomerVendorController::class, 'customerList'])->name('customer.customerlist');
        Route::get('/customers/{customer}', [CustomerVendorController::class, 'show'])->name('customer.show');
        Route::get('/customers/{customer}/edit', [CustomerVendorController::class, 'edit'])->name('customer.edit');
        Route::put('/customers/{customer}', [CustomerVendorController::class, 'update'])->name('customer.update');
        Route::delete('/customers/{customer}', [CustomerVendorController::class, 'destroy'])->name('customer.destroy');
        Route::post('/import-customers', [CustomerVendorController::class, 'importCustomers'])->name('customer.import');
    });

    // RFQ routes
    Route::prefix('admin')->group(function () {
        Route::get('rfq', [RfqController::class, 'rfq'])->name('admin.rfq.rfq');
        Route::post('rfq/store', [RfqController::class, 'store'])->name('admin.rfq.store');
        Route::get('rfqdetails', [RfqController::class, 'rfqDetails'])->name('admin.rfq.rfqdetails');
        Route::get('rfq/{id}/view', [RfqController::class, 'view'])->name('admin.rfq.view');
        Route::get('rfq/{id}/edit', [RfqController::class, 'edit'])->name('admin.rfq.edit');
        Route::put('rfq/{id}/update', [RfqController::class, 'update'])->name('admin.rfq.update');
        Route::delete('rfq/{id}', [RfqController::class, 'destroy'])->name('admin.rfq.destroy');
        Route::get('rfq/generate-id', [RfqController::class, 'generateRfqId'])->name('admin.rfq.generateId');
    });
    Route::get('admin/raw-materials', [RfqController::class, 'getRawMaterials'])->name('admin.rawmaterials.list');
    Route::post('admin/raw-materials', [RfqController::class, 'storeRawMaterial'])->name('admin.rawmaterials.store');
    Route::get('admin/rfq/{id}/print', [RfqController::class, 'printRfq'])->name('admin.rfq.print');


    // admin Quotation Routes
    Route::prefix('admin')->group(function () {
        Route::get('quotationorder', [QuotationController::class, 'quotationPage'])->name('admin.quotation.quotationorder');
        Route::get('quotationdetails', [QuotationController::class, 'quotationDetails'])->name('admin.quotation.quotationdetails');
        Route::post('quotations', [QuotationController::class, 'store'])->name('admin.quotations.store');
        Route::get('quotations/{id}/view', [QuotationController::class, 'view'])->name('admin.quotation.view');
        Route::get('quotations/{id}/edit', [QuotationController::class, 'edit'])->name('admin.quotation.edit');
        Route::post('quotations/{id}/update', [QuotationController::class, 'update'])->name('admin.quotation.update');
        Route::delete('quotations/{id}', [QuotationController::class, 'destroy'])->name('admin.quotation.delete');
        Route::get('quotations/ajax', [QuotationController::class, 'quotationListAjax'])->name('admin.quotation.ajax');
        Route::get('quotations/{id}/print', [QuotationController::class, 'print'])->name('admin.quotation.print');
    });
    Route::get('admin/rfq-details/{id}', [QuotationController::class, 'getRfqDetails']);
    Route::get('admin/max-quotation-id', function () {
        $latest = \App\Models\Quotation::orderByDesc('id')->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[2]) ? ((int)$parts[2] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json([
            'newQuotationNo' => $newQuotationNo,
        ]);
    });

    Route::get('admin/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*'); // <-- this allows slashes!


    /// Invoice routes
    Route::get('admin/invoiceorder', [InvoiceController::class, 'invoicePage'])->name('admin.invoice.invoiceorder');
    Route::get('admin/invoicedetails', [InvoiceController::class, 'invoiceDetails'])->name('admin.invoice.invoicedetails');
    Route::post('admin/tax-invoice', [InvoiceController::class, 'store'])->name('admin.tax-invoice.store');
    Route::get('admin/generate-invoice-id', [InvoiceController::class, 'generateInvoiceIdAjax'])->name('admin.invoice.generate');
    Route::get('admin/customer-vendor/{id}', function ($id) {
        $company = \App\Models\CustomerVendor::find($id);
        if (!$company) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'company' => [
                'address' => $company->billing_Address ?: $company->shipping_Address,
                'gst' => $company->gstno,
                'email' => $company->email,
                'mobile' => $company->mobile,
            ],
        ]);
    });
    Route::get('/admin/invoices/{invoice}/print', [InvoiceController::class, 'print'])->name('admin.invoice.print');
    Route::get('/admin/invoices/{invoice}/edit', [InvoiceController::class, 'edit'])->name('admin.invoice.edit');
    Route::put('/admin/invoices/{invoice}', [InvoiceController::class, 'update'])->name('admin.invoice.update');

    //admin sales routes
    Route::prefix('admin')->group(function () {
    Route::get('generate-so-id', [SalesController::class, 'generateSOId']);
    Route::get('generate-grn-id', [SalesController::class, 'generateGRNId']);
    Route::get('salesorder', [SalesController::class, 'salesPage'])->name('admin.sales.salesorder');
    Route::get('salesdetails', [SalesController::class, 'salesDetails'])->name('admin.sales.salesdetails');
    Route::post('/sales/order/store', [SalesController::class, 'store'])->name('admin.sales.order.store');
    Route::get('/customers', [SalesController::class, 'getCustomers']);
    Route::get('/customer/{id}', [SalesController::class, 'getCustomerById']);
    Route::get('/sales/order/{id}', [SalesController::class, 'show'])->name('admin.sales.order.show');
    Route::get('/sales/order/{id}/edit', [SalesController::class, 'edit'])->name('admin.sales.order.edit');
    Route::delete('/sales/order/{id}', [SalesController::class, 'destroy'])->name('admin.sales.order.delete');
    Route::put('/sales/update/{id}', [SalesController::class, 'update'])->name('admin.sales.order.update');
    });
    Route::get('admin/quotations', [SalesController::class, 'getQuotations']);
    Route::get('admin/quotation/{id}', [SalesController::class, 'getQuotationById']);
    Route::get('/admin/sales-order/{id}', [SalesController::class, 'getSalesOrderById']);
    Route::get('/admin/sales/order/{id}/print', [SalesController::class, 'print'])->name('admin.sales.order.print');

    // admin purchase routes
    Route::prefix('admin')->group(function () {
        Route::get('generate-po-id', [PurchaseController::class, 'generatePOId']);
        Route::get('purchaseorder', [PurchaseController::class, 'purchasePage'])->name('admin.purchase.purchaseorder');
        Route::get('purchasedetails', [PurchaseController::class, 'purchaseDetails'])->name('admin.purchase.purchasedetails');
        Route::post('/purchase/order/store', [PurchaseController::class, 'store'])->name('admin.purchase.order.store');
        Route::get('/purchase/order/{id}', [PurchaseController::class, 'show'])->name('admin.purchase.order.show');
        Route::get('/purchase/order/{id}/edit', [PurchaseController::class, 'edit'])->name('admin.purchase.order.edit');
        Route::delete('/purchase/order/{id}', [PurchaseController::class, 'destroy'])->name('admin.purchase.order.delete');
        Route::put('/purchase/update/{id}', [PurchaseController::class, 'update'])->name('admin.purchase.order.update');
    });
    Route::get('admin/purchase/quotations', [PurchaseController::class, 'getQuotations']);
    Route::get('admin/purchase/quotation/{id}', [PurchaseController::class, 'getQuotationById']);
    Route::get('/admin/purchase-order/{id}', [PurchaseController::class, 'getPurchaseOrderById']);
    Route::get('/admin/purchase/order/{id}/print', [PurchaseController::class, 'print'])->name('admin.purchase.order.print');

    // GRN routes
    Route::prefix('admin')->group(function () {
        Route::get('grnorder', [GRNController::class, 'grnPage'])->name('admin.grn.grnorder');
        Route::get('grndetails', [GRNController::class, 'grnDetails'])->name('admin.grn.grndetails');
        Route::post('grn/store', [GRNController::class, 'store'])->name('admin.grn.store');
        Route::get('grn/edit/{id}', [GRNController::class, 'edit'])->name('admin.grn.edit');
        Route::post('grn/update/{id}', [GRNController::class, 'update'])->name('admin.grn.update');
        Route::delete('grn/delete/{id}', [GRNController::class, 'destroy'])->name('admin.grn.destroy');
        Route::post('grn/import', [GRNController::class, 'import'])->name('admin.grn.import');
        Route::get('grn/view/{id}', [GRNController::class, 'show'])->name('admin.grn.view');
    });
    Route::get('admin/grn/available-orders', [GRNController::class, 'availableOrders']); 
    Route::get('admin/grn/order-details', [GRNController::class, 'orderDetails']);


    // Route Card routes
    Route::prefix('admin')->name('admin.routecard.')->group(function () {
        Route::get('routecardorder', [RouteCardController::class, 'routeCardPage'])->name('routecardorder');
        Route::get('routecarddetails', [RouteCardController::class, 'routeCardDetails'])->name('routecarddetails');
        Route::post('routecardorder', [RouteCardController::class, 'store'])->name('store');
        Route::get('routecard/view/{id}', [RouteCardController::class, 'show'])->name('show');
        Route::get('routecard/edit/{id}', [RouteCardController::class, 'edit'])->name('edit');
        Route::put('routecard/update/{id}', [RouteCardController::class, 'update'])->name('update');
        Route::delete('routecard/{routecard}', [RouteCardController::class, 'destroy'])->name('destroy');
    });
    Route::put('admin/routecard/process-reschedule/{id}', [RouteCardController::class, 'updateProcessAndReschedule']);
    Route::get('admin/routecard/get-process-list', [RouteCardController::class, 'getProcessList'])->name('routecard.get-process-list');
    Route::post('admin/routecard/approve/{id}', [RouteCardController::class, 'approve'])->name('admin.routecard.approve');
    Route::get('/admin/routecard/approved', [RouteCardController::class, 'approvedList']);
    Route::get('/admin/manufacturing/plan', [ManufacturingPlanningController::class, 'planPage']);
    Route::get('/admin/routecard/{id}/processes', [ManufacturingPlanningController::class, 'rcProcesses']); // API for processes
    // Blade page route
    Route::get('/admin/manufacturing/planning', function () {
        return view('admin.manufacturing.planning');
    })->name('admin.manufacturing.planning');
    Route::prefix('admin')->name('admin.routecard.')->group(function () {
        Route::put('routecard/process/{id}', [RouteCardController::class, 'updateProcess']);
        Route::post('routecard/process', [RouteCardController::class, 'storeProcess']);
        Route::delete('routecard/process/{id}', [RouteCardController::class, 'deleteProcess']);
    });
    Route::post('admin/routecard/plan/{id}', [RouteCardController::class, 'markPlanned']);
    Route::get('admin/routecard/planned', [RouteCardController::class, 'plannedList']);


    //plannning routes
    Route::prefix('admin/manufacturing')->group(function () {
        Route::get('plans', [ManufacturingPlanningController::class, 'index']);
        Route::get('plans/{id}', [ManufacturingPlanningController::class, 'show']);
        Route::post('plans', [ManufacturingPlanningController::class, 'store']);
        Route::put('plans/{id}', [ManufacturingPlanningController::class, 'update']);
        Route::delete('plans/{id}', [ManufacturingPlanningController::class, 'destroy']);
        Route::get('external-api', [ManufacturingPlanningController::class, 'fetchExternalApi']); // optional
    });


    // Project planning routes
    Route::get('/admin/projectplanning', [ProjectPlanningController::class, 'projectPlanning'])->name('superadmin.projectplanning.projectplanning');
    Route::post('admin/routecard/ready-production/{id}', [RouteCardController::class, 'markReadyProduction']);
    Route::get('/admin/manufacturing/plan/{id}', [ManufacturingPlanningController::class, 'planPageWithId'])->name('superadmin.manufacturing.plan');
    Route::get('admin/routecard/ready-to-production-list', [RouteCardController::class, 'readyToProductionList']);
    Route::post('admin/routecard/in-production/{id}', [RouteCardController::class, 'markInProduction']);
    Route::get('/admin/ready-to-production', function () {
        return view('admin.manufacturing.ready_to_production');
    })->name('admin.readytoproduction');

    Route::prefix('admin/manufacturing/production')->group(function () {
        Route::get('/in-progress', [ProductionController::class, 'inProgressList'])
            ->name('admin.production.inprogress.list');
        Route::get('/{rcId}', [ProductionController::class, 'productionBoard'])->name('admin.production.board');
        Route::post('/start-process/{id}', [ProductionController::class, 'startProcess']);
        Route::post('/end-process/{id}', [ProductionController::class, 'endProcess']);
        Route::post('/approve-qc/{id}', [ProductionController::class, 'approveQC']);
        Route::post('/reject-qc/{id}', [ProductionController::class, 'rejectQC']); // optional
    });

    // Quality Control Kanban
    Route::prefix('admin/quality')->group(function () {
        Route::get('qc-management', [QualityController::class, 'qcManagement']);
        Route::get('/qualitycontrol/{routeCard}', [QualityController::class, 'qualityControlBoard']);
        Route::get('/qualitycontrol-data/{routeCard}', [QualityController::class, 'qualityControlData']);
        Route::post('/qualitycontrol-status/{id}', [QualityController::class, 'updateQCStatus']);
        Route::post('/qualitycontrol', [QualityController::class, 'store']);
        Route::get('/qualitycontrol/{id}', [QualityController::class, 'show']);
        Route::put('/qualitycontrol/{id}', [QualityController::class, 'update']);
        Route::delete('/qualitycontrol/{id}', [QualityController::class, 'destroy']);
    });

  
    // SKU routes
    Route::prefix('admin')->name('admin.sku.')->group(function () {
        Route::get('skumaster', [SKUController::class, 'skuMaster'])->name('skumaster');
        Route::get('sku/data', [SKUController::class, 'skuData'])->name('data');
        Route::post('sku', [SKUController::class, 'store'])->name('store');
        Route::get('sku/{id}/edit', [SKUController::class, 'edit'])->name('edit');
        Route::put('sku/{id}', [SKUController::class, 'update'])->name('update');
        Route::delete('sku/{id}', [SKUController::class, 'destroy'])->name('destroy');
    });
    // SKU Approval Page
    Route::get('admin/skuapprovals', [SKUController::class, 'skuApproval'])->name('admin.sku.skuapproval');
    Route::get('admin/skuapproval/list', [SKUController::class, 'skuApprovalList'])->name('sku-approval.list');
    Route::post('admin/sku-approval', [SKUController::class, 'skuApprovalStore'])->name('sku-approval.store');
    Route::get('admin/sku-approval/{id}', [SKUController::class, 'skuApprovalShow'])->name('sku-approval.show');
    Route::put('admin/sku-approval/{id}', [SKUController::class, 'skuApprovalUpdate'])->name('sku-approval.update');
    Route::delete('admin/sku-approval/{id}', [SKUController::class, 'skuApprovalDestroy'])->name('sku-approval.destroy');
    // SKU Movement routes
    Route::get('admin/skumovement', [SKUController::class, 'skuMovement'])->name('admin.sku.skumovement');
    Route::get('admin/skumovement/list', [SKUController::class, 'skuMovementList']);
    Route::post('admin/skumovement/store', [SKUController::class, 'skuMovementStore']);
    Route::get('admin/skumovement/{id}', [SKUController::class, 'skuMovementShow']);
    Route::delete('admin/skumovement/{id}', [SKUController::class, 'skuMovementDelete']);


    // Machine routes
    Route::prefix('admin')->name('admin.machine.')->group(function () {
        Route::get('addmachine', [MachineController::class, 'addMachine'])->name('addmachine');
        Route::post('storemachine', [MachineController::class, 'storeMachine'])->name('store');
        Route::get('machinedetails', [MachineController::class, 'machineDetails'])->name('machinedetails');
        Route::get('editmachine/{id}', [MachineController::class, 'editMachine'])->name('edit');
        Route::post('updatemachine/{id}', [MachineController::class, 'updateMachine'])->name('update');
        Route::delete('deletemachine/{id}', [MachineController::class, 'deleteMachine'])->name('delete');
        Route::post('importmachines', [MachineController::class, 'importMachines'])
            ->name('import');
    });


    // Employee routes
    Route::get('admin/employeedetails', [EmployeeController::class, 'employeeDetails'])->name('admin.employee.employeedetails');
    Route::post('/admin/employees', [EmployeeController::class, 'store'])->name('admin.employees.store');
    Route::put('/admin/employees/{id}', [EmployeeController::class, 'update'])->name('admin.employees.update');
    Route::delete('/admin/employees/{id}', [EmployeeController::class, 'destroy'])->name('admin.employees.delete');
    Route::post('/admin/importemployees', [EmployeeController::class, 'importEmployees'])->name('admin.employee.import');
    Route::get('/admin/employees/{id}', [EmployeeController::class, 'show'])->name('employees.show');
    Route::get('/admin/employees/leave', [EmployeeController::class, 'employeeLeave'])->name('admin.employee.employeeleave');

    // Employee routes
    Route::get('/admin/employeedetails', [EmployeeController::class, 'employeeDetails'])->name('admin.employee.employeedetails');
    Route::get('/admin/employeeleave', [EmployeeController::class, 'employeeLeave'])->name('admin.employee.employeeleave');
    Route::post('/admin/employeeleave', [EmployeeController::class, 'storeEmployeeLeave'])->name('admin.employeeleave.store');
    Route::get('/admin/employeeleave/{id}', [EmployeeController::class, 'getEmployeeLeave']);
    Route::put('/admin/employeeleave/{id}', [EmployeeController::class, 'updateEmployeeLeave'])->name('admin.employeeleave.update');
    Route::delete('/admin/employeeleave/{id}', [EmployeeController::class, 'destroyEmployeeLeave'])->name('admin.employeeleave.destroy');
    Route::get('/admin/employee/{id}/name-dept', [EmployeeController::class, 'getEmployeeNameDept']);


    // Employee Attendance routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('employeeattendance', [EmployeeAttendanceController::class, 'index'])->name('employee.index');
        Route::post('/attendance/import', [EmployeeAttendanceController::class, 'import'])->name('attendance.import');
        Route::get('/attendance/edit/{id}', [EmployeeAttendanceController::class, 'edit'])->name('attendance.edit');
        Route::post('attendance/store', [EmployeeAttendanceController::class, 'store'])->name('attendance.store');
        Route::post('attendance/update/{id}', [EmployeeAttendanceController::class, 'update'])->name('attendance.update');
        Route::delete('/attendance/delete/{id}', [EmployeeAttendanceController::class, 'destroy'])->name('attendance.delete');
    });

    // Employee Daily Report routes
    Route::prefix('admin/employeedailyreports')->group(function () {

        Route::get('/', [EmployeeDailyReportController::class, 'index'])->name('employee.employeedailyreport');
        Route::post('/store', [EmployeeDailyReportController::class, 'store'])->name('employee.daily.store');
        Route::post('/update/{id}', [EmployeeDailyReportController::class, 'update'])->name('employee.daily.update');
        Route::delete('/delete/{id}', [EmployeeDailyReportController::class, 'destroy'])->name('employee.daily.delete');
        Route::post('/import', [EmployeeDailyReportController::class, 'import'])->name('employee.daily.import');
        Route::get('/edit/{id}', [EmployeeDailyReportController::class, 'edit'])->name('employee.daily.edit');
        Route::get('/calendar/{employee_id}/{month}', [EmployeeDailyReportController::class, 'calendar']);
        Route::get('/calendarview', [EmployeeDailyReportController::class, 'calendarView'])->name('employee.daily.calendar');
    });

    // ============================================
    // ACCOUNTS MANAGEMENT ROUTES
    // ============================================
    
    // Accounts Payable Routes
    Route::prefix('admin/accounts/payable')->name('admin.accounts.payable.')->group(function () {
        Route::get('/', [AccountsPayableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsPayableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsPayableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsPayableController::class, 'recordPayment'])->name('payment');
        Route::get('/export/pdf', [AccountsPayableController::class, 'exportPdf'])->name('export');
    });
    
    // Accounts Receivable Routes
    Route::prefix('admin/accounts/receivable')->name('admin.accounts.receivable.')->group(function () {
        Route::get('/', [AccountsReceivableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsReceivableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsReceivableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsReceivableController::class, 'recordPayment'])->name('payment');
    });
    
    // Financial Reports Routes
    Route::prefix('admin/accounts/reports')->name('admin.accounts.reports.')->group(function () {
        Route::get('/balance-sheet', [FinancialReportsController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/profit-loss', [FinancialReportsController::class, 'profitLoss'])->name('profit-loss');
        Route::get('/cash-flow', [FinancialReportsController::class, 'cashFlow'])->name('cash-flow');
    });
    
});

// SuperAdmin routes
Route::middleware(['auth', 'role:superadmin'])->group(function () {

    // Master routes
    // Company Type routes
    Route::prefix('superadmin')->name('superadmin.')->middleware(['auth', 'role:superadmin'])->group(function () {
        Route::get('companytypes', [SuperAdminCompanyTypeController::class, 'companyTypes'])->name('companytype.index');
        Route::get('companytypes/list', [SuperAdminCompanyTypeController::class, 'list'])->name('companytype.list');
        Route::post('companytypes/store', [SuperAdminCompanyTypeController::class, 'store'])->name('companytype.store');
        Route::post('companytypes/update/{companytype}', [SuperAdminCompanyTypeController::class, 'update'])->name('companytype.update');
        Route::delete('companytypes/delete/{companytype}', [SuperAdminCompanyTypeController::class, 'delete'])->name('companytype.delete');
    });
    // Account Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('accounttypes', [SuperAdminAccountTypeController::class, 'index'])->name('accounttype.index');
        Route::get('accounttypes/list', [SuperAdminAccountTypeController::class, 'list'])->name('accounttype.list');
        Route::get('accounttypes/{accounttype}', [SuperAdminAccountTypeController::class, 'show'])->name('accounttype.single');
        Route::post('accounttypes/store', [SuperAdminAccountTypeController::class, 'store'])->name('accounttype.store');
        Route::put('accounttypes/update/{accounttype}', [SuperAdminAccountTypeController::class, 'update'])->name('accounttype.update');
        Route::delete('accounttypes/delete/{accounttype}', [SuperAdminAccountTypeController::class, 'delete'])->name('accounttype.delete');
    });
    // Rfq Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('rfqtypes', [SuperAdminRfqTypeController::class, 'index'])->name('rfqtype.index');
        Route::get('rfqtypes/list', [SuperAdminRfqTypeController::class, 'list'])->name('rfqtype.list');
        Route::get('rfqtypes/{rfqtype}', [SuperAdminRfqTypeController::class, 'show'])->name('rfqtype.single');
        Route::post('rfqtypes/store', [SuperAdminRfqTypeController::class, 'store'])->name('rfqtype.store');
        Route::put('rfqtypes/update/{rfqtype}', [SuperAdminRfqTypeController::class, 'update'])->name('rfqtype.update');
        Route::delete('rfqtypes/delete/{rfqtype}', [SuperAdminRfqTypeController::class, 'delete'])->name('rfqtype.delete');
    });
    // Product Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('producttypes', [SuperAdminProductTypeController::class, 'index'])->name('producttype.index');
        Route::get('producttypes/list', [SuperAdminProductTypeController::class, 'list'])->name('producttype.list');
        Route::get('producttypes/{producttype}', [SuperAdminProductTypeController::class, 'show'])->name('producttype.single');
        Route::post('producttypes/store', [SuperAdminProductTypeController::class, 'store'])->name('producttype.store');
        Route::put('producttypes/update/{producttype}', [SuperAdminProductTypeController::class, 'update'])->name('producttype.update');
        Route::delete('producttypes/delete/{producttype}', [SuperAdminProductTypeController::class, 'delete'])->name('producttype.delete');
    });
    // Raw Material routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('rawmaterials', [SuperAdminRawMaterialController::class, 'index'])->name('rawmaterial.index');
        Route::get('rawmaterials/list', [SuperAdminRawMaterialController::class, 'list'])->name('rawmaterial.list');
        Route::post('rawmaterials/store', [SuperAdminRawMaterialController::class, 'store'])->name('rawmaterial.store');
        Route::get('rawmaterials/{rawmaterial}', [SuperAdminRawMaterialController::class, 'show'])->name('rawmaterial.single');
        Route::put('rawmaterials/update/{rawmaterial}', [SuperAdminRawMaterialController::class, 'update'])->name('rawmaterial.update');
        Route::delete('rawmaterials/delete/{rawmaterial}', [SuperAdminRawMaterialController::class, 'delete'])->name('rawmaterial.delete');
        
        Route::delete('/raw-material/{id}/delete-file', [SuperAdminRawMaterialController::class, 'deleteFile'])->name('rawmaterial.deletefile');
    });
    
    // Conversion Process routes
    Route::prefix('superadmin/conversionprocesses')->group(function () {
        Route::get('/', [SuperAdminConversionProcessController::class, 'index'])->name('superadmin.conversionprocess.index'); // returns Blade view
        Route::get('/list', [SuperAdminConversionProcessController::class, 'list'])->name('superadmin.conversionprocess.list');
        Route::post('/store', [SuperAdminConversionProcessController::class, 'store'])->name('superadmin.conversionprocess.store');
        Route::get('/{id}', [SuperAdminConversionProcessController::class, 'show'])->name('superadmin.conversionprocesses.single');
        Route::put('/update/{id}', [SuperAdminConversionProcessController::class, 'update'])->name('superadmin.conversionprocesses.update');
        Route::delete('/delete/{id}', [SuperAdminConversionProcessController::class, 'destroy'])->name('superadmin.conversionprocesses.delete');
    });
    
    // Process routes
    Route::prefix('superadmin/processes')->name('superadmin.process.')->group(function () {
        Route::get('/', [SuperAdminProcessController::class, 'index'])->name('index');         // Blade view
        Route::get('/api', [SuperAdminProcessController::class, 'api'])->name('api');          // AJAX data
        Route::post('/store', [SuperAdminProcessController::class, 'store'])->name('store');   // Create
        Route::get('/{id}', [SuperAdminProcessController::class, 'show'])->name('show');       // Show (edit)
        Route::put('/update/{id}', [SuperAdminProcessController::class, 'update'])->name('update'); // Update
        Route::delete('/delete/{id}', [SuperAdminProcessController::class, 'destroy'])->name('destroy'); // Delete
    });
    
    Route::post('superadmin/processes/assign', [SuperAdminProcessController::class, 'assign'])->name('superadmin.process.assign');
    Route::get('superadmin/process/assignments', [SuperAdminProcessController::class, 'assignmentsApi'])->name('superadmin.process.assignmentsApi');
    Route::post('superadmin/machine/assignments', [SuperAdminProcessController::class, 'assignOperators'])->name('superadmin.machine.assignOperators');
    Route::get('/superadmin/process/view-machines-summary', [SuperAdminProcessController::class, 'viewMachinesSummary'])->name('superadmin.process.viewMachinesSummary');
    Route::get('/superadmin/process/view-operators-summary', [SuperAdminProcessController::class, 'viewOperatorsSummary'])->name('superadmin.process.viewOperatorsSummary');
    Route::delete('superadmin/machine/assignments/{id?}', [SuperAdminProcessController::class, 'dismissOperators'])->name('superadmin.machine.dismissAssignment');
    // Stock Items routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('stockitems', [SuperAdminStockItemsController::class, 'index'])->name('stockitems.index');
        Route::post('stockitems', [SuperAdminStockItemsController::class, 'store'])->name('stockitems.store');
        Route::put('stockitems/{id}', [SuperAdminStockItemsController::class, 'update'])->name('stockitems.update');
        Route::delete('stockitems/{id}', [SuperAdminStockItemsController::class, 'destroy'])->name('stockitems.destroy');

        Route::post('categories/store', [SuperAdminStockItemsController::class, 'storeCategory'])->name('categories.store');
        
        Route::post('/superadmin/stockitems/import', [SuperAdminStockItemsController::class, 'importExcel'])->name('stockitems.import');
    });
    
    


    // Dashboard routes
    Route::get('superadmin/dashboard', [SuperAdminDashboardController::class, 'allDashboard'])->name('superadmin.dashboard.dashboard');
    Route::get('superadmin/employeedashboard', [SuperAdminDashboardController::class, 'employeeDashboard'])->name('superadmin.dashboard.empoyeedashboard');
    Route::get('superadmin/machinedashboard', [SuperAdminDashboardController::class, 'machineDashboard'])->name('superadmin.dashboard.machinedashboard');
    Route::get('superadmin/stockdashboard', [SuperAdminDashboardController::class, 'stockDashboard'])->name('superadmin.dashboard.stockdashboard');
    Route::get('superadmin/accountdashboard', [SuperAdminDashboardController::class, 'accountDashboard'])->name('superadmin.dashboard.accountdashboard');
    Route::get('superadmin/manufactingdashboard', [SuperAdminDashboardController::class, 'manufacturingDashboard'])->name('superadmin.dashboard.manufacturingdashboard');

    // ============================================
    // ACCOUNTS MANAGEMENT ROUTES (SuperAdmin)
    // ============================================
    
    // Accounts Payable Routes
    Route::prefix('superadmin/accounts/payable')->name('superadmin.accounts.payable.')->group(function () {
        Route::get('/', [AccountsPayableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsPayableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsPayableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsPayableController::class, 'recordPayment'])->name('payment');
    });
    
    // Accounts Receivable Routes
    Route::prefix('superadmin/accounts/receivable')->name('superadmin.accounts.receivable.')->group(function () {
        Route::get('/', [AccountsReceivableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsReceivableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsReceivableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsReceivableController::class, 'recordPayment'])->name('payment');
    });
    
    // Financial Reports Routes
    Route::prefix('superadmin/accounts/reports')->name('superadmin.accounts.reports.')->group(function () {
        Route::get('/balance-sheet', [FinancialReportsController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/profit-loss', [FinancialReportsController::class, 'profitLoss'])->name('profit-loss');
        Route::get('/cash-flow', [FinancialReportsController::class, 'cashFlow'])->name('cash-flow');
    });


    // Profile routes
    Route::get('superadmin/profile', [SuperAdminProfileController::class, 'index'])->name('superadmin.profile.index');
    Route::put('superadmin/profile', [SuperAdminProfileController::class, 'updateProfile'])->name('superadmin.profile.update');
    Route::put('superadmin/profile/password', [SuperAdminProfileController::class, 'updatePassword'])->name('superadmin.profile.password');

    // User Activity routes
    Route::get('superadmin/activity', [UserActivityController::class, 'index'])->name('superadmin.activity.index');
    Route::get('superadmin/activity/list', [UserActivityController::class, 'list'])->name('superadmin.activity.list');
    Route::get('superadmin/activity/export', [UserActivityController::class, 'export'])->name('superadmin.activity.export');
    Route::get('superadmin/activity/{id}', [UserActivityController::class, 'show'])->name('superadmin.activity.show');
    Route::get('superadmin/activity/user/{userId}/timeline', [UserActivityController::class, 'userTimeline'])->name('superadmin.activity.user.timeline');
    Route::post('superadmin/activity/cleanup', [UserActivityController::class, 'cleanup'])->name('superadmin.activity.cleanup');

    //Sku routes
    Route::get('superadmin/skuapprovals', [SuperAdminSKUController::class, 'skuApprovals'])->name('superadmin.sku.skuapproval');
    Route::get('superadmin/skumovement', [SuperAdminSKUController::class, 'skuMovement'])->name('superadmin.sku.skumovement');
    Route::get('superadmin/qualitycontrol', [SuperAdminSKUController::class, 'qualityControl'])->name('superadmin.qualitycontrol.qualitycontrol');

    // User routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('/userdetails', [SuperAdminUserController::class, 'userDetails'])->name('users.userdetails');
        Route::get('/users/list', [SuperAdminUserController::class, 'list'])->name('users.list');
        Route::get('/users/{user}', [SuperAdminUserController::class, 'show'])->name('users.show');
        Route::post('/users/store', [SuperAdminUserController::class, 'store'])->name('users.store');
        Route::post('/users/update/{user}', [SuperAdminUserController::class, 'update'])->name('users.update');
        Route::post('/users/toggle-status/{user}', [SuperAdminUserController::class, 'toggleStatus'])->name('users.toggleStatus');
        Route::delete('/users/delete/{user}', [SuperAdminUserController::class, 'delete'])->name('users.delete');
    });

    // Customer/Vendor routes
    // All SuperAdmin Customer Routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('/customers', [SuperAdminCustomerVendorController::class, 'getAllCustomers']);
        Route::get('addcustomer', [SuperAdminCustomerVendorController::class, 'addcustomer'])->name('customer.addcustomer');
        Route::post('/customer-vendor/register', [SuperAdminCustomerVendorController::class, 'store'])->name('customer.vendor.store');
        Route::get('customerlist', [SuperAdminCustomerVendorController::class, 'customerList'])->name('customer.customerlist');
        Route::get('/customers/{customer}', [SuperAdminCustomerVendorController::class, 'show'])->name('customer.show');
        Route::get('/customers/{customer}/edit', [SuperAdminCustomerVendorController::class, 'edit'])->name('customer.edit');
        Route::put('/customers/{customer}', [SuperAdminCustomerVendorController::class, 'update'])->name('customer.update');
        Route::delete('/customers/{customer}', [SuperAdminCustomerVendorController::class, 'destroy'])->name('customer.destroy');
        Route::post('/import-customers', [SuperAdminCustomerVendorController::class, 'importCustomers'])->name('customer.import');
    });

    // RFQ routes
    Route::prefix('superadmin/sales')->group(function () {
        Route::get('rfq', [SuperAdminRfqController::class, 'rfq'])->name('superadmin.salesbom.rfq.rfq');
        Route::post('rfq/store', [SuperAdminRfqController::class, 'store'])->name('superadmin.salesbom.rfq.store');
        Route::get('rfqdetails', [SuperAdminRfqController::class, 'rfqDetails'])->name('superadmin.salesbom.rfq.rfqdetails');
        Route::get('rfq/{id}/view', [SuperAdminRfqController::class, 'view'])->name('superadmin.salesbom.rfq.view');
        Route::get('rfq/{id}/edit', [SuperAdminRfqController::class, 'edit'])->name('superadmin.salesbom.rfq.edit');
        Route::put('rfq/{id}/update', [SuperAdminRfqController::class, 'update'])->name('superadmin.salesbom.rfq.update');
        Route::delete('rfq/{id}', [SuperAdminRfqController::class, 'destroy'])->name('superadmin.salesbom.rfq.destroy');
        Route::get('rfq/generate-id', [SuperAdminRfqController::class, 'generateRfqId'])->name('superadmin.salesbom.rfq.generateId');
        Route::post('rfq/{id}/approve', [SuperAdminRfqController::class, 'approve'])->name('superadmin.salesbom.rfq.approve');
        Route::post('rfq/{id}/reject', [SuperAdminRfqController::class, 'reject'])->name('superadmin.salesbom.rfq.reject');
        
        Route::delete('rfq/file/{id}', [SuperAdminRfqController::class, 'deleteFile'])->name('superadmin.salesbom.rfq.deletefile');
        
        Route::get('/raw-materials', [SuperAdminRfqController::class, 'getRawMaterials'])->name('superadmin.salesbom.rawmaterials.list');
        Route::post('/raw-materials', [SuperAdminRfqController::class, 'storeRawMaterial'])->name('superadmin.salesbom.rawmaterials.store');
        Route::get('/rfq/{id}/print', [SuperAdminRfqController::class, 'printRfq'])->name('superadmin.salesbom.rfq.print');
    });
    
    // Superadmin Sales Quotation Routes
    Route::prefix('superadmin/sales')->group(function () {
        Route::get('quotationorder', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'quotationPage'])->name('superadmin.salesbom.quotation.quotationorder');
        Route::get('quotationdetails', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'quotationDetails'])->name('superadmin.salesbom.quotation.quotationdetails');
        Route::post('quotations', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'store'])->name('superadmin.salesbom.quotations.store');
        Route::get('quotations/{id}/view', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'view'])->name('superadmin.salesbom.quotation.view');
        Route::get('quotations/{id}/edit', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'edit'])->name('superadmin.salesbom.quotation.edit');
        Route::post('quotations/{id}/update', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'update'])->name('superadmin.salesbom.quotation.update');
        Route::delete('quotations/{id}', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'destroy'])->name('superadmin.salesbom.quotation.delete');
        Route::get('quotations/ajax', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'quotationListAjax'])->name('superadmin.salesbom.quotation.ajax');
        Route::get('quotations/{id}/print', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'print'])->name('superadmin.salesbom.quotation.print');
        Route::post('quotations/{id}/approve', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'approve'])->name('superadmin.salesbom.quotation.approve');
        Route::post('quotations/{id}/reject', [App\Http\Controllers\SuperAdmin\SuperAdminQuotationController::class, 'reject'])->name('superadmin.salesbom.quotation.reject');
    });
    
    Route::get('superadmin/sales/rfq-details/{id}', [SuperAdminQuotationController::class, 'getRfqDetails']);
    Route::get('superadmin/sales/max-quotation-id', function () {
        $latest = \App\Models\Quotation::select('*')
            ->where('quotation_no', 'LIKE', 'UEPL/S/QT/%')
            ->orderByRaw("CAST(SUBSTRING_INDEX(quotation_no, '/', -1) AS UNSIGNED) DESC")
            ->first();
    
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[3]) ? ((int)$parts[3] + 1) : 1;
        }
    
        $newQuotationNo = 'UEPL/S/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
    
        return response()->json([
            'newQuotationNo' => $newQuotationNo,
        ]);
    });

    Route::get('superadmin/sales/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*'); // <-- this allows slashes!


    Route::prefix('superadmin')->group(function () {
        Route::get('generate-so-id', [SuperAdminSalesController::class, 'generateSOId']);
        Route::get('generate-grn-id', [SuperAdminSalesController::class, 'generateGRNId']);
        Route::get('salesorder', [SuperAdminSalesController::class, 'salesPage'])->name('superadmin.sales.salesorder');
        Route::get('salesdetails', [SuperAdminSalesController::class, 'salesDetails'])->name('superadmin.sales.salesdetails');
        Route::post('/sales/order/store', [SuperAdminSalesController::class, 'store'])->name('superadmin.sales.order.store');
        Route::get('/customers', [SuperAdminSalesController::class, 'getCustomers']);
        Route::get('/customer/{id}', [SuperAdminSalesController::class, 'getCustomerById']);
        Route::get('/sales/order/{id}', [SuperAdminSalesController::class, 'show'])->name('superadmin.sales.order.show');
        Route::get('/sales/order/{id}/edit', [SuperAdminSalesController::class, 'edit'])->name('superadmin.sales.order.edit');
        Route::delete('/sales/order/{id}', [SuperAdminSalesController::class, 'destroy'])->name('superadmin.sales.order.delete');
        Route::put('/sales/update/{id}', [SuperAdminSalesController::class, 'update'])->name('superadmin.sales.order.update');
        Route::post('sales/order/{id}/approve', [SuperAdminSalesController::class, 'approve'])->name('superadmin.sales.order.approve');
        Route::post('sales/order/{id}/reject', [SuperAdminSalesController::class, 'reject'])->name('superadmin.sales.order.reject');
    });
    
    Route::get('superadmin/quotations', [SuperAdminSalesController::class, 'getQuotations']);
    Route::get('superadmin/quotation/{id}', [SuperAdminSalesController::class, 'getQuotationById']);
    Route::get('/superadmin/sales-order/{id}', [SuperAdminSalesController::class, 'getSalesOrderById']);
    Route::get('/superadmin/sales/order/{id}/print', [SuperAdminSalesController::class, 'print'])->name('superadmin.sales.order.print');

    // Purchase routes
    // Redirect /superadmin/purchase to the purchase order list page
    Route::get('superadmin/purchase', function () {
        return redirect()->route('superadmin.purchase.purchasedetails');
    });

    // Superadmin Purchase RFQ Routes
    Route::prefix('superadmin/purchase')->group(function () {
        // Static routes must come BEFORE parameterized routes
        Route::get('rfq', [SuperAdminPurchaseRFQController::class, 'rfq'])->name('superadmin.purchasebom.rfq.rfq');
        Route::post('rfq/store', [SuperAdminPurchaseRFQController::class, 'store'])->name('superadmin.purchasebom.rfq.store');
        Route::get('rfqdetails', [SuperAdminPurchaseRFQController::class, 'rfqDetails'])->name('superadmin.purchasebom.rfq.rfqdetails');
        Route::get('rfq/generate-id', [SuperAdminPurchaseRFQController::class, 'generateRfqId'])->name('superadmin.purchasebom.rfq.generateId');
        Route::delete('rfq/file/{id}', [SuperAdminPurchaseRFQController::class, 'deleteFile'])->name('superadmin.purchasebom.rfq.deletefile');
        Route::get('/raw-materials', [SuperAdminPurchaseRFQController::class, 'getRawMaterials'])->name('superadmin.purchasebom.rawmaterials.list');
        Route::post('/raw-materials', [SuperAdminPurchaseRFQController::class, 'storeRawMaterial'])->name('superadmin.purchasebom.rawmaterials.store');

        // Parameterized routes come after static routes
        Route::get('rfq/{id}/view', [SuperAdminPurchaseRFQController::class, 'view'])->name('superadmin.purchasebom.rfq.view');
        Route::get('rfq/{id}/edit', [SuperAdminPurchaseRFQController::class, 'edit'])->name('superadmin.purchasebom.rfq.edit');
        Route::put('rfq/{id}/update', [SuperAdminPurchaseRFQController::class, 'update'])->name('superadmin.purchasebom.rfq.update');
        Route::delete('rfq/{id}', [SuperAdminPurchaseRFQController::class, 'destroy'])->name('superadmin.purchasebom.rfq.destroy');
        Route::post('rfq/{id}/approve', [SuperAdminPurchaseRFQController::class, 'approve'])->name('superadmin.purchasebom.rfq.approve');
        Route::post('rfq/{id}/reject', [SuperAdminPurchaseRFQController::class, 'reject'])->name('superadmin.purchasebom.rfq.reject');
        Route::get('rfq/{id}/print', [SuperAdminPurchaseRFQController::class, 'printRfq'])->name('superadmin.purchasebom.rfq.print');
    });
    
    Route::get('superadmin/purchase/rfq-details/{id}', [SuperAdminQuotationController::class, 'getRfqDetails']);
    Route::get('superadmin/purchase/max-quotation-id', function () {
        $latest = \App\Models\Quotation::orderByDesc('id')->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[2]) ? ((int)$parts[2] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/P/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json([
            'newQuotationNo' => $newQuotationNo,
        ]);
    });

    Route::get('superadmin/purchase/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*'); // <-- this allows slashes!
    // purchasebom Quotation routes
    Route::prefix('superadmin/purchase')->group(function () {
        Route::get('quotationorder', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'quotationPage'])->name('superadmin.purchasebom.quotation.quotationorder');
        Route::get('quotationdetails', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'quotationDetails'])->name('superadmin.purchasebom.quotation.quotationdetails');
        Route::post('quotations', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'store'])->name('superadmin.purchasebom.quotations.store');
        Route::get('quotations/{id}/view', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'view'])->name('superadmin.purchasebom.quotation.view');
        Route::get('quotations/{id}/edit', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'edit'])->name('superadmin.purchasebom.quotation.edit');
        Route::post('quotations/{id}/update', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'update'])->name('superadmin.purchasebom.quotation.update');
        Route::delete('quotations/{id}', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'destroy'])->name('superadmin.purchasebom.quotation.delete');
        Route::get('quotations/ajax', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'quotationListAjax'])->name('superadmin.purchasebom.quotation.ajax');
        Route::get('quotations/{id}/print', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'print'])->name('superadmin.purchasebom.quotation.print');
        Route::post('quotations/{id}/approve', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'approve'])->name('superadmin.purchasebom.quotation.approve');
        Route::post('quotations/{id}/reject', [App\Http\Controllers\SuperAdmin\SuperAdminPurchaseQuotationController::class, 'reject'])->name('superadmin.purchasebom.quotation.reject');
    });

    Route::prefix('superadmin')->group(function () {
        Route::get('generate-po-id', [SuperAdminPurchaseController::class, 'generatePOId']);
        Route::get('purchaseorder', [SuperAdminPurchaseController::class, 'purchasePage'])->name('superadmin.purchase.purchaseorder');
        Route::get('purchasedetails', [SuperAdminPurchaseController::class, 'purchaseDetails'])->name('superadmin.purchase.purchasedetails');
        Route::post('/purchase/order/store', [SuperAdminPurchaseController::class, 'store'])->name('superadmin.purchase.order.store');
        Route::get('/purchase/order/{id}', [SuperAdminPurchaseController::class, 'show'])->name('superadmin.purchase.order.show');
        Route::get('/purchase/order/{id}/edit', [SuperAdminPurchaseController::class, 'edit'])->name('superadmin.purchase.order.edit');
        Route::delete('/purchase/order/{id}', [SuperAdminPurchaseController::class, 'destroy'])->name('superadmin.purchase.order.delete');
        Route::put('/purchase/update/{id}', [SuperAdminPurchaseController::class, 'update'])->name('superadmin.purchase.order.update');
        Route::post('/purchase/order/{id}/approve', [SuperAdminPurchaseController::class, 'approve']);
        Route::post('/purchase/order/{id}/reject', [SuperAdminPurchaseController::class, 'reject']);
    });
    Route::get('superadmin/purchase/quotations', [SuperAdminPurchaseController::class, 'getQuotations']);
    Route::get('superadmin/purchase/quotation/{id}', [SuperAdminPurchaseController::class, 'getQuotationById']);
    Route::get('/superadmin/purchase-order/{id}', [SuperAdminPurchaseController::class, 'getPurchaseOrderById']);
    Route::get('/superadmin/purchase/order/{id}/print', [SuperAdminPurchaseController::class, 'print'])->name('superadmin.purchase.order.print');

    // GRN routes
    Route::prefix('superadmin')->group(function () {
        // GRN Master routes
        Route::get('grnorder', [SuperAdminGRNController::class, 'grnPage'])->name('superadmin.grn.grnorder');
        Route::get('grndetails', [SuperAdminGRNController::class, 'grnDetails'])->name('superadmin.grn.grndetails');
        Route::post('grn/store', [SuperAdminGRNController::class, 'store'])->name('superadmin.grn.store');
        Route::get('grn/edit/{id}', [SuperAdminGRNController::class, 'edit'])->name('superadmin.grn.edit');
        Route::post('grn/update/{id}', [SuperAdminGRNController::class, 'update'])->name('superadmin.grn.update');
        Route::delete('grn/delete/{id}', [SuperAdminGRNController::class, 'destroy'])->name('superadmin.grn.destroy');
        Route::post('grn/import', [SuperAdminGRNController::class, 'import'])->name('superadmin.grn.import');
        Route::get('grn/view/{id}', [SuperAdminGRNController::class, 'show'])->name('superadmin.grn.view');
    });
    Route::get('superadmin/grn/available-orders', [SuperAdminGRNController::class, 'availableOrders']);
    Route::get('superadmin/grn/order-details', [SuperAdminGRNController::class, 'orderDetails']);

    // Route Card routes
    // Route::prefix('superadmin')->name('superadmin.routecard.')->group(function () {
    //     Route::get('routecardorder', [SuperAdminRouteCardController::class, 'routeCardPage'])->name('routecardorder');
    //     Route::get('routecarddetails', [SuperAdminRouteCardController::class, 'routeCardDetails'])->name('routecarddetails');
    //     Route::post('routecardorder', [SuperAdminRouteCardController::class, 'store'])->name('store');
    //     Route::get('routecard/view/{id}', [SuperAdminRouteCardController::class, 'show'])->name('show');
    //     Route::get('routecard/edit/{id}', [SuperAdminRouteCardController::class, 'edit'])->name('edit');
    //     Route::put('routecard/update/{id}', [SuperAdminRouteCardController::class, 'update'])->name('update');
    //     Route::delete('routecard/{routecard}', [SuperAdminRouteCardController::class, 'destroy'])->name('destroy');
    // });
    // Route::put('superadmin/routecard/process-reschedule/{id}', [SuperAdminRouteCardController::class, 'updateProcessAndReschedule']);
    // Route::get('superadmin/routecard/get-process-list', [SuperAdminRouteCardController::class, 'getProcessList'])->name('routecard.get-process-list');

    // Route::get('/superadmin/routecard/approved', [SuperAdminRouteCardController::class, 'approvedList']);
    // Route::get('/superadmin/manufacturing/plan', [SuperAdminManufacturingPlanningController::class, 'planPage']);
    Route::get('/superadmin/routecard/{id}/processes', [SuperAdminManufacturingPlanningController::class, 'rcProcesses']); // API for processes
    // Blade page route
    // Route::get('/superadmin/manufacturing/planning', function () {
    //     return view('superadmin.manufacturing.planning');
    // })->name('superadmin.manufacturing.planning');
    Route::prefix('superadmin')->name('superadmin.routecard.')->group(function () {
        Route::post('routecard/{id}/approve', [SuperAdminRouteCardController::class, 'approve'])->name('approve');
        // ... other routes ...
        Route::put('routecard/process/{id}', [SuperAdminRouteCardController::class, 'updateProcess']);
        Route::post('routecard/process', [SuperAdminRouteCardController::class, 'storeProcess']);
        Route::delete('routecard/process/{id}', [SuperAdminRouteCardController::class, 'deleteProcess']);
        // ... other routes ...
    });
    Route::post('superadmin/routecard/plan/{id}', [SuperAdminRouteCardController::class, 'markPlanned']);
    Route::get('superadmin/routecard/planned', [SuperAdminRouteCardController::class, 'plannedList']);
    // API routes (for AJAX)
    Route::prefix('superadmin/manufacturing')->group(function () {

        Route::get('plans', [SuperAdminManufacturingPlanningController::class, 'index']);
        Route::get('plans/{id}', [SuperAdminManufacturingPlanningController::class, 'show']);
        Route::post('plans', [SuperAdminManufacturingPlanningController::class, 'store']);
        Route::put('plans/{id}', [SuperAdminManufacturingPlanningController::class, 'update']);
        Route::delete('plans/{id}', [SuperAdminManufacturingPlanningController::class, 'destroy']);
        Route::get('external-api', [SuperAdminManufacturingPlanningController::class, 'fetchExternalApi']); // optional
    });
    // Project planning routes
    Route::get('/superadmin/projectplanning', [SuperAdminProjectPlanningController::class, 'projectPlanning'])->name('superadmin.projectplanning.projectplanning');
    Route::post('superadmin/routecard/ready-production/{id}', [SuperAdminRouteCardController::class, 'markReadyProduction']);
    Route::get('/superadmin/manufacturing/plan/{id}', [SuperAdminManufacturingPlanningController::class, 'planPageWithId'])->name('superadmin.manufacturing.plan');
    Route::get('superadmin/routecard/ready-to-production-list', [SuperAdminRouteCardController::class, 'readyToProductionList']);
    Route::post('superadmin/routecard/in-production/{id}', [SuperAdminRouteCardController::class, 'markInProduction']);
    
    // Missing Route Process Routes (Added for Plan UI)
    Route::get('superadmin/routecard/get-process-list', [SuperAdminRouteCardController::class, 'getProcessList'])->name('superadmin.routecard.get-process-list');
    Route::put('superadmin/routecard/process-reschedule/{id}', [SuperAdminRouteCardController::class, 'updateProcessAndReschedule']);
    Route::post('superadmin/routecard/process', [SuperAdminRouteCardController::class, 'storeProcess']);
    Route::put('superadmin/routecard/process/{id}', [SuperAdminRouteCardController::class, 'updateProcess']);
    Route::delete('superadmin/routecard/process/{id}', [SuperAdminRouteCardController::class, 'deleteProcess']);

    Route::get('/superadmin/ready-to-production', function () {
        return view('superadmin.manufacturing.ready_to_production');
    })->name('superadmin.readytoproduction');

    Route::prefix('superadmin/manufacturing/production')->group(function () {
        Route::get('/in-progress', [SuperAdminProductionController::class, 'inProgressList'])
            ->name('superadmin.production.inprogress.list');
        Route::get('/{rcId}', [SuperAdminProductionController::class, 'productionBoard'])->name('superadmin.production.board');
        Route::post('/start-process/{id}', [SuperAdminProductionController::class, 'startProcess']);
        Route::post('/end-process/{id}', [SuperAdminProductionController::class, 'endProcess']);
        Route::post('/approve-qc/{id}', [SuperAdminProductionController::class, 'approveQC']);
        Route::post('/reject-qc/{id}', [SuperAdminProductionController::class, 'rejectQC']); 
        Route::post('/log-breakdown', [SuperAdminProductionController::class, 'logMachineBreakdown']);
        Route::post('/consume-material', [SuperAdminProductionController::class, 'consumeMaterial']);
    });

    // Gantt Chart Route
    Route::get('/superadmin/manufacturing/gantt', [SuperAdminManufacturingPlanningController::class, 'ganttPage'])->name('superadmin.manufacturing.gantt');
    Route::get('/superadmin/manufacturing/gantt-data', [SuperAdminManufacturingPlanningController::class, 'ganttData']);

    // Invoice routes
    // Superadmin Invoice
    Route::get('superadmin/invoiceorder', [SuperAdminInvoiceController::class, 'invoicePage'])->name('superadmin.invoice.invoiceorder');
    Route::get('superadmin/invoicedetails', [SuperAdminInvoiceController::class, 'invoiceDetails'])->name('superadmin.invoice.invoicedetails');
    Route::post('superadmin/tax-invoice', [SuperAdminInvoiceController::class, 'store'])->name('superadmin.tax-invoice.store');
    Route::get('superadmin/generate-invoice-id', [SuperAdminInvoiceController::class, 'generateInvoiceIdAjax'])->name('superadmin.invoice.generate');
    Route::get('superadmin/customer-vendor/{id}', function ($id) {
        $company = \App\Models\CustomerVendor::find($id);
        if (!$company) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'company' => [
                'billing_address' => $company->billing_address,
                'shipping_address' =>$company->shipping_address,
                'gst' => $company->gstno,
                'email' => $company->email,
                'mobile' => $company->mobile,
            ],
        ]);
    });
    Route::get('/superadmin/invoices/{invoice}/print', [SuperAdminInvoiceController::class, 'print'])->name('superadmin.invoice.print');
    // Edit Invoice (GET)
    Route::get('/superadmin/invoices/{invoice}/edit', [SuperAdminInvoiceController::class, 'edit'])->name('superadmin.invoice.edit');

    // Update Invoice (PUT/PATCH)
    Route::put('/superadmin/invoices/{invoice}', [SuperAdminInvoiceController::class, 'update'])->name('superadmin.invoice.update');

    // Delete Invoice (DELETE)
    Route::delete('/superadmin/invoices/{invoice}', [SuperAdminInvoiceController::class, 'destroy'])->name('superadmin.invoice.destroy');

    // Sales Management Group
    Route::prefix('superadmin/salesmanagement')->name('superadmin.salesmanagement.')->group(function () {
        Route::get('/', [SuperAdminSalesManagementController::class, 'index'])->name('index');

        // Customer Payments routes
        Route::get('/payments', [SuperAdminSalesManagementController::class, 'getPayments'])->name('payments');
        Route::get('/payments/unpaid-invoices', [SuperAdminSalesManagementController::class, 'getUnpaidInvoices'])->name('payments.unpaid');
        Route::post('/payments/store', [SuperAdminSalesManagementController::class, 'storePayment'])->name('payments.store');
        Route::get('/payments/{id}', [SuperAdminSalesManagementController::class, 'getPayment'])->name('payments.get');
        Route::put('/payments/{id}', [SuperAdminSalesManagementController::class, 'updatePayment'])->name('payments.update');
        Route::delete('/payments/{id}', [SuperAdminSalesManagementController::class, 'deletePayment'])->name('payments.delete');

        // Credit Notes routes
        Route::get('/credit-notes', [SuperAdminSalesManagementController::class, 'getCreditNotes'])->name('creditNotes');
        Route::get('/credit-notes/next-number', [SuperAdminSalesManagementController::class, 'getNextCreditNoteNumber'])->name('creditNotes.nextNumber');
        Route::post('/credit-notes/store', [SuperAdminSalesManagementController::class, 'storeCreditNote'])->name('creditNotes.store');
        Route::get('/credit-notes/{id}', [SuperAdminSalesManagementController::class, 'getCreditNote'])->name('creditNotes.get');
        Route::put('/credit-notes/{id}', [SuperAdminSalesManagementController::class, 'updateCreditNote'])->name('creditNotes.update');
        Route::delete('/credit-notes/{id}', [SuperAdminSalesManagementController::class, 'deleteCreditNote'])->name('creditNotes.delete');

        // Aging Report routes
        Route::get('/aging-report', [SuperAdminSalesManagementController::class, 'getAgingReport'])->name('agingReport');
        Route::get('/aging-export', [SuperAdminSalesManagementController::class, 'exportAgingReport'])->name('agingExport');

        // Debit Notes routes
        Route::get('/debit-notes', [SuperAdminSalesManagementController::class, 'getDebitNotes'])->name('debitNotes');
        Route::get('/debit-notes/next-number', [SuperAdminSalesManagementController::class, 'getNextDebitNoteNumber'])->name('debitNotes.nextNumber');
        Route::post('/debit-notes/store', [SuperAdminSalesManagementController::class, 'storeDebitNote'])->name('debitNotes.store');
        Route::get('/debit-notes/{id}', [SuperAdminSalesManagementController::class, 'getDebitNote'])->name('debitNotes.get');
        Route::put('/debit-notes/{id}', [SuperAdminSalesManagementController::class, 'updateDebitNote'])->name('debitNotes.update');
        Route::delete('/debit-notes/{id}', [SuperAdminSalesManagementController::class, 'deleteDebitNote'])->name('debitNotes.delete');

        // Statement of Accounts
        Route::get('/statement-of-accounts', [SuperAdminSalesManagementController::class, 'getStatementOfAccounts'])->name('statementOfAccounts');

        // Receipt Download
        Route::get('/payments/{id}/receipt', [SuperAdminSalesManagementController::class, 'downloadReceipt'])->name('payments.receipt');

        // Receipts Data
        Route::get('/receipts-data', [SuperAdminSalesManagementController::class, 'getReceipts'])->name('receipts.data');
    });

    // SKU routes
    Route::prefix('superadmin')->name('superadmin.sku.')->group(function () {
        // Page
        Route::get('skumaster', [SuperAdminSKUController::class, 'skuMaster'])->name('skumaster');
        // Data endpoint for DataTables
        Route::get('sku/data', [SuperAdminSKUController::class, 'skuData'])->name('data');
        // Store
        Route::post('sku', [SuperAdminSKUController::class, 'store'])->name('store');
        // Edit (show one SKU details)
        Route::get('sku/{id}/edit', [SuperAdminSKUController::class, 'edit'])->name('edit');
        // Update
        Route::put('sku/{id}', [SuperAdminSKUController::class, 'update'])->name('update');
        // Delete
        Route::delete('sku/{id}', [SuperAdminSKUController::class, 'destroy'])->name('destroy');
    });
    // SKU Approval Page
    Route::get('superadmin/skuapprovals', [SuperAdminSKUController::class, 'skuApproval'])->name('superadmin.sku.skuapproval');
    // SKU Approval Data
    Route::get('superadmin/skuapproval/list', [SuperAdminSKUController::class, 'skuApprovalList'])->name('sku-approval.list');
    // SKU Approval CRUD
    Route::post('superadmin/sku-approval', [SuperAdminSKUController::class, 'skuApprovalStore'])->name('sku-approval.store');
    Route::get('superadmin/sku-approval/{id}', [SuperAdminSKUController::class, 'skuApprovalShow'])->name('sku-approval.show');
    Route::put('superadmin/sku-approval/{id}', [SuperAdminSKUController::class, 'skuApprovalUpdate'])->name('sku-approval.update');
    Route::delete('superadmin/sku-approval/{id}', [SuperAdminSKUController::class, 'skuApprovalDestroy'])->name('sku-approval.destroy');
    Route::get('superadmin/skumovement', [SuperAdminSKUController::class, 'skuMovement'])->name('superadmin.sku.skumovement');
    Route::get('superadmin/skumovement/list', [SuperAdminSKUController::class, 'skuMovementList']);
    Route::post('superadmin/skumovement/store', [SuperAdminSKUController::class, 'skuMovementStore']);
    Route::get('superadmin/skumovement/{id}', [SuperAdminSKUController::class, 'skuMovementShow']);
    Route::delete('superadmin/skumovement/{id}', [SuperAdminSKUController::class, 'skuMovementDelete']);

    // Quality Control Kanban
    Route::prefix('superadmin/quality')->group(function () {
        Route::get('qc-management', [SuperAdminQualityController::class, 'qcManagement']);
        Route::get('/qualitycontrol/{routeCard}', [SuperAdminQualityController::class, 'qualityControlBoard']);
        Route::get('/qualitycontrol-data/{routeCard}', [SuperAdminQualityController::class, 'qualityControlData']);
        Route::post('/qualitycontrol-status/{id}', [SuperAdminQualityController::class, 'updateQCStatus']);
        Route::post('/qualitycontrol', [SuperAdminQualityController::class, 'store']);
        Route::get('/qualitycontrol/{id}', [SuperAdminQualityController::class, 'show']);
        Route::put('/qualitycontrol/{id}', [SuperAdminQualityController::class, 'update']);
        Route::delete('/qualitycontrol/{id}', [SuperAdminQualityController::class, 'destroy']);
    });


    // Machine routes
    Route::prefix('superadmin')->name('superadmin.machine.')->group(function () {
        Route::get('addmachine', [SuperAdminMachineController::class, 'addMachine'])->name('addmachine');
        Route::post('storemachine', [SuperAdminMachineController::class, 'storeMachine'])->name('store');
        Route::get('machinedetails', [SuperAdminMachineController::class, 'machineDetails'])->name('machinedetails');
        Route::get('editmachine/{id}', [SuperAdminMachineController::class, 'editMachine'])->name('edit');
        Route::post('updatemachine/{id}', [SuperAdminMachineController::class, 'updateMachine'])->name('update');
        Route::delete('deletemachine/{id}', [SuperAdminMachineController::class, 'deleteMachine'])->name('delete');
        Route::post('importmachines', [SuperAdminMachineController::class, 'importMachines'])
            ->name('import');
    });

    // Employee routes
    Route::get('superadmin/employeedetails', [SuperAdminEmployeeController::class, 'employeeDetails'])->name('superadmin.employee.employeedetails');
    Route::post('/superadmin/employees', [SuperAdminEmployeeController::class, 'store'])->name('superadmin.employees.store');
    Route::put('/superadmin/employees/{id}', [SuperAdminEmployeeController::class, 'update'])->name('superadmin.employees.update');
    Route::delete('/superadmin/employees/{id}', [SuperAdminEmployeeController::class, 'destroy'])->name('superadmin.employees.delete');
    Route::post('superadmin/importemployees', [SuperAdminEmployeeController::class, 'importEmployees'])->name('superadmin.employee.import');
    Route::delete('/superadmin/employees/{id}/profile-picture', [SuperAdminEmployeeController::class, 'deleteProfilePicture'])->name('superadmin.employees.profilepic.delete');

    Route::get('/superadmin/employees/{id}', [SuperAdminEmployeeController::class, 'show'])->name('employees.show');
    Route::get('/superadmin/employees/leave', [SuperAdminEmployeeController::class, 'employeeLeave'])->name('superadmin.employee.employeeleave');

    Route::get('/superadmin/employeepayroll', [SuperAdminEmployeeController::class, 'salaryDetails'])->name('superadmin.employee.employeepayroll');
    Route::post('/superadmin/salary-details', [SuperAdminEmployeeController::class, 'storeSalaryDetail'])->name('superadmin.salary.store');
    Route::get('/superadmin/employee/{id}/name', [SuperAdminEmployeeController::class, 'getEmployeeById']);
    Route::get('/superadmin/salary-details/{id}', [SuperAdminEmployeeController::class, 'getSalaryDetail'])->name('superadmin.salary.get'); // AJAX
    Route::put('/superadmin/salary-details/{id}', [SuperAdminEmployeeController::class, 'updateSalaryDetail'])->name('superadmin.salary.update');
    Route::delete('/superadmin/salary-details/{id}', [SuperAdminEmployeeController::class, 'destroySalaryDetail'])->name('superadmin.salary.destroy');
    Route::get('/superadmin/salary-details/{id}/payslip', [SuperAdminEmployeeController::class, 'generatePayslip'])->name('superadmin.salary.payslip');
    Route::post('/superadmin/payslip/bulk-download', [SuperAdminEmployeeController::class, 'bulkDownloadPayslips'])->name('superadmin.payslip.bulk-download');
    Route::post('/superadmin/payroll/generate', [SuperAdminEmployeeController::class, 'generatePayroll'])->name('superadmin.payroll.generate');
    Route::get('/superadmin/payroll/data', [SuperAdminEmployeeController::class, 'getPayrollData'])->name('superadmin.payroll.data');
    // Employee routes
    Route::get('superadmin/employeedetails', [SuperAdminEmployeeController::class, 'employeeDetails'])->name('superadmin.employee.employeedetails');
   Route::get('superadmin/employeesdata/{id}/cl-available', [SuperAdminEmployeeController::class, 'getEmployeeClAvailable']);
   Route::get('/superadmin/employee/{employee}/cl-balance', [SuperAdminEmployeeController::class, 'getEmployeeClBalance'])->name('superadmin.employee.clbalance');
    // Main leave list page
    Route::get('superadmin/employeeleave', [SuperAdminEmployeeController::class, 'employeeLeave'])->name('superadmin.employee.employeeleave');
    // Store new leave
    Route::post('superadmin/employeeleave', [SuperAdminEmployeeController::class, 'storeEmployeeLeave'])->name('superadmin.employeeleave.store');
    // Get leave data for edit
    Route::get('superadmin/employeeleave/{id}', [SuperAdminEmployeeController::class, 'getEmployeeLeave']);
    // Update leave
    Route::put('superadmin/employeeleave/{id}', [SuperAdminEmployeeController::class, 'updateEmployeeLeave'])->name('superadmin.employeeleave.update');
    // Update leave status (AJAX)
    Route::post('superadmin/employeeleave/{id}/status', [SuperAdminEmployeeController::class, 'updateLeaveStatus'])->name('superadmin.employeeleave.status');
    // Delete leave
    Route::delete('superadmin/employeeleave/{id}', [SuperAdminEmployeeController::class, 'destroyEmployeeLeave'])->name('superadmin.employeeleave.destroy');
    // Get Employee name/department by employee_id (for autofill)
    Route::get('superadmin/employee/{id}/name-dept', [SuperAdminEmployeeController::class, 'getEmployeeNameDept']);


    // Route::get('superadmin/employeeattendance', [SuperAdminEmployeeController::class, 'employeeAttendance'])->name('superadmin.employee.employeeattendance');
    // Route::post('superadmin/employeeattendance', [SuperAdminEmployeeController::class, 'storeEmployeeAttendance'])->name('superadmin.employeeattendance.store');
    // Route::get('superadmin/employeeattendance/{id}', [SuperAdminEmployeeController::class, 'getEmployeeAttendance']);
    // Route::put('superadmin/employeeattendance/{id}', [SuperAdminEmployeeController::class, 'updateEmployeeAttendance'])->name('superadmin.employeeattendance.update');
    // Route::delete('superadmin/employeeattendance/{id}', [SuperAdminEmployeeController::class, 'destroyEmployeeAttendance'])->name('superadmin.employeeattendance.destroy');
    // Route::get(
    //     'superadmin/employeeattendance/employee/{employee_id}/details',
    //     [SuperAdminEmployeeController::class, 'getEmployeeAttendanceEmployee']
    // );
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('employeeattendance', [SuperAdminEmployeeAttendanceController::class, 'index'])->name('employee.index');
        Route::post('/attendance/import', [SuperAdminEmployeeAttendanceController::class, 'import'])->name('attendance.import');
        Route::get('/attendance/edit/{id}', [SuperAdminEmployeeAttendanceController::class, 'edit'])->name('attendance.edit');
        Route::post('attendance/store', [SuperAdminEmployeeAttendanceController::class, 'store'])->name('attendance.store');
        Route::post('attendance/update/{id}', [SuperAdminEmployeeAttendanceController::class, 'update'])->name('attendance.update');
        Route::delete('/attendance/delete/{id}', [SuperAdminEmployeeAttendanceController::class, 'destroy'])->name('attendance.delete');
    });
    Route::prefix('superadmin/employeedailyreports')->group(function () {

        Route::get('/', [SuperAdminEmployeeDailyReportController::class, 'index'])->name('employee.employeedailyreport');
        Route::post('/store', [SuperAdminEmployeeDailyReportController::class, 'store'])->name('employee.daily.store');
        Route::post('/update/{id}', [SuperAdminEmployeeDailyReportController::class, 'update'])->name('employee.daily.update');
        Route::delete('/delete/{id}', [SuperAdminEmployeeDailyReportController::class, 'destroy'])->name('employee.daily.delete');
        Route::post('/import', [SuperAdminEmployeeDailyReportController::class, 'import'])->name('superadmin.employee.daily.import');
        Route::get('/edit/{id}', [SuperAdminEmployeeDailyReportController::class, 'edit'])->name('employee.daily.edit');
        Route::get('/calendar/{employee_id}/{month}', [SuperAdminEmployeeDailyReportController::class, 'calendar']);
        Route::get('/calendarview', [SuperAdminEmployeeDailyReportController::class, 'calendarView'])->name('employee.daily.calendar');
    });
    
    Route::get('superadmin/attendance-matrix', [SuperAdminEmployeeAttendanceController::class, 'attendanceMatrix'])->name('superadmin.attendance.matrix');
    
    Route::prefix('superadmin/purchasemanagement')->group(function () {
        Route::get('/', [PurchaseManagementController::class, 'index'])->name('superadmin.purchase.index');
        Route::get('/create', [PurchaseManagementController::class, 'create'])->name('superadmin.purchase.create');
        Route::post('/', [PurchaseManagementController::class, 'store'])->name('superadmin.purchase.store');
        Route::get('/accounts', [PurchaseManagementController::class, 'accounts'])->name('superadmin.purchase.accounts');
        Route::get('/{purchase}', [PurchaseManagementController::class, 'show'])->name('superadmin.purchase.show');
        Route::get('/{purchase}/edit', [PurchaseManagementController::class, 'edit'])->name('superadmin.purchase.edit');
        Route::post('/{purchase}/update', [PurchaseManagementController::class, 'update'])->name('superadmin.purchase.update');
        Route::delete('/{purchase}', [PurchaseManagementController::class, 'destroy'])->name('superadmin.purchase.destroy');
        
        // GRN Integration
        Route::get('/purchase/pending-grns', [PurchaseManagementController::class, 'getPendingGRNs'])->name('superadmin.purchase.pendingGRNs');
        Route::get('/purchase/grn/{id}/details', [PurchaseManagementController::class, 'getGRNDetails'])->name('superadmin.purchase.grnDetails');
        
        // Debit Notes (Vendor)
        Route::get('/purchase/debit-notes/list', [PurchaseManagementController::class, 'getDebitNotes'])->name('superadmin.purchase.debitNotes.list');
        Route::post('/purchase/debit-notes/store', [PurchaseManagementController::class, 'storeDebitNote'])->name('superadmin.purchase.debitNotes.store');
        Route::put('/purchase/debit-notes/{id}', [PurchaseManagementController::class, 'updateDebitNote'])->name('superadmin.purchase.debitNotes.update');
        Route::delete('/purchase/debit-notes/{id}', [PurchaseManagementController::class, 'deleteDebitNote'])->name('superadmin.purchase.debitNotes.delete');
        Route::get('/purchase/debit-notes/next-number', [PurchaseManagementController::class, 'getNextDebitNoteNumber'])->name('superadmin.purchase.debitNotes.nextNumber');
        Route::get('/purchase/debit-notes/{id}', [PurchaseManagementController::class, 'getDebitNote'])->name('superadmin.purchase.debitNotes.show');

        // Route::delete('/{purchase}', [PurchaseManagementController::class, 'destroy'])->name('superadmin.purchase.destroy');

        // Add more for payments, credits etc.
        Route::delete('/purchase/{id}/delete-file', [PurchaseManagementController::class, 'deleteFile'])->name('purchase.deletefile');
    });
    
    Route::get('superadmin/purchasemanage/export', [PurchaseManagementController::class, 'export'])->name('superadmin.purchase.export');
    Route::get('superadmin/creditnotes/next-no', [PurchaseManagementController::class, 'getNextCreditNoteNo']);
    Route::get('superadmin/purchase/next-invoice-no', [PurchaseManagementController::class, 'getNextInvoiceNumber']);
    Route::post('superadmin/creditnotes', [PurchaseManagementController::class, 'creditNoteStore']);
    Route::get('superadmin/purchasemanage/payments', [PurchaseManagementController::class, 'payments'])->name('superadmin.purchase.payments');
    Route::get('superadmin/purchasemanage/{id}', [PurchaseManagementController::class, 'Vendorshow']);
    Route::get('superadmin/creditnotes/data', [PurchaseManagementController::class, 'creditNotesData'])->name('superadmin.creditnotes.data');
    Route::get('superadmin/creditnotes/{id}', [PurchaseManagementController::class, 'showCreditNote']);
    Route::get('superadmin/purchasedata/aging-report', [PurchaseManagementController::class, 'agingReport'])->name('superadmin.purchase.aging');
    Route::get('superadmin/purchasedata/aging-report/export', [PurchaseManagementController::class, 'exportAgingReport'])->name('superadmin.purchase.aging.export');
    
    
    
    Route::any('superadmin/employeereport', [SuperAdminReportController::class, 'employeeReport'])->name('superadmin.report.employeereport');
    Route::any('superadmin/customerreport', [SuperAdminReportController::class, 'customerReport'])->name('superadmin.report.customerreport');
    Route::post('superadmin/customerreport/export', [SuperAdminReportController::class, 'exportCustomerReport'])->name('superadmin.report.customerreport.export');
    Route::post('/superadmin/employee-report/export', [SuperAdminReportController::class, 'exportEmployeeReport'])->name('superadmin.exportEmployeeReport');
    Route::any('superadmin/machinereport', [SuperAdminReportController::class, 'machineReport'])->name('superadmin.report.machinereport');
    Route::post('superadmin/machinereport/export', [SuperAdminReportController::class, 'exportMachineReport'])->name('superadmin.report.machinereport.export');
    Route::any('superadmin/billreport', [SuperAdminReportController::class, 'billReport'])->name('superadmin.report.billreport');
    Route::post('superadmin/billreport/export', [SuperAdminReportController::class, 'exportBillReport'])->name('superadmin.report.billreport.export');
    Route::get('superadmin/employeedailyreport', [SuperAdminEmployeeController::class, 'employeeDailyReport'])->name('superadmin.employee.employeedailyreport');
    Route::any('superadmin/inventoryreport', [SuperAdminReportController::class, 'inventoryReport'])->name('superadmin.report.inventoryreport');
    Route::post('superadmin/inventoryreport/export', [SuperAdminReportController::class, 'exportInventoryReport'])->name('superadmin.report.inventoryreport.export');
    Route::get('superadmin/employeecalendar', [SuperAdminEmployeeController::class, 'employeeCalendar'])->name('superadmin.employee.employeecalendar');
});


// Manager routes
Route::middleware(['auth', 'role:manager'])->group(function () {

    // Dashboard routes
    Route::get('manager/dashboard', [ManagerDashboardController::class, 'allDashboard'])->name('manager.dashboard.alldashboard');
    Route::get('manager/employeedashboard', [ManagerDashboardController::class, 'employeeDashboard'])->name('manager.dashboard.empoyeedashboard');
    Route::get('manager/machinedashboard', [ManagerDashboardController::class, 'machineDashboard'])->name('manager.dashboard.machinedashboard');
    Route::get('manager/stockdashboard', [ManagerDashboardController::class, 'stockDashboard'])->name('manager.dashboard.stockdashboard');
    Route::get('manager/accountdashboard', [ManagerDashboardController::class, 'accountDashboard'])->name('manager.dashboard.accountdashboard');
    Route::get('manager/manufactingdashboard', [ManagerDashboardController::class, 'manufacturingDashboard'])->name('manager.dashboard.manufacturingdashboard');

    //Sku routes
    Route::get('manager/skuapprovals', [ManagerSKUController::class, 'skuApprovals'])->name('manager.sku.skuapproval');
    Route::get('manager/skumovement', [ManagerSKUController::class, 'skuMovement'])->name('manager.sku.skumovement');
    Route::get('manager/qualitycontrol', [ManagerSKUController::class, 'qualityControl'])->name('manager.qualitycontrol.qualitycontrol');

    // Customer/Vendor routes
    // All Manager Customer Routes
    Route::prefix('manager')->name('manager.')->group(function () {
        Route::get('/customers', [ManagerCustomerVendorController::class, 'getAllCustomers']);
        Route::get('addcustomer', [ManagerCustomerVendorController::class, 'addcustomer'])->name('customer.addcustomer');
        Route::post('/customer-vendor/register', [ManagerCustomerVendorController::class, 'store'])->name('customer.vendor.store');
        Route::get('customerlist', [ManagerCustomerVendorController::class, 'customerList'])->name('customer.customerlist');
        Route::get('/customers/{customer}', [ManagerCustomerVendorController::class, 'show'])->name('customer.show');
        Route::get('/customers/{customer}/edit', [ManagerCustomerVendorController::class, 'edit'])->name('customer.edit');
        Route::put('/customers/{customer}', [ManagerCustomerVendorController::class, 'update'])->name('customer.update');
        Route::delete('/customers/{customer}', [ManagerCustomerVendorController::class, 'destroy'])->name('customer.destroy');
        Route::post('/import-customers', [ManagerCustomerVendorController::class, 'importCustomers'])->name('customer.import');
    });

    // RFQ routes
    Route::prefix('manager')->group(function () {
        Route::get('rfq', [ManagerRfqController::class, 'rfq'])->name('manager.rfq.rfq');
        Route::post('rfq/store', [ManagerRfqController::class, 'store'])->name('manager.rfq.store');
        Route::get('rfqdetails', [ManagerRfqController::class, 'rfqDetails'])->name('manager.rfq.rfqdetails');
        Route::get('rfq/{id}/view', [ManagerRfqController::class, 'view'])->name('manager.rfq.view');
        Route::get('rfq/{id}/edit', [ManagerRfqController::class, 'edit'])->name('manager.rfq.edit');
        Route::put('rfq/{id}/update', [ManagerRfqController::class, 'update'])->name('manager.rfq.update');
        Route::delete('rfq/{id}', [ManagerRfqController::class, 'destroy'])->name('manager.rfq.destroy');
        Route::get('rfq/generate-id', [ManagerRfqController::class, 'generateRfqId'])->name('manager.rfq.generateId');
    });
    Route::get('manager/raw-materials', [ManagerRfqController::class, 'getRawMaterials'])->name('manager.rawmaterials.list');
    Route::post('manager/raw-materials', [ManagerRfqController::class, 'storeRawMaterial'])->name('manager.rawmaterials.store');
    Route::get('manager/rfq/{id}/print', [ManagerRfqController::class, 'printRfq'])->name('manager.rfq.print');
    // manager Quotation Routes
    Route::prefix('manager')->group(function () {
        Route::get('quotationorder', [ManagerQuotationController::class, 'quotationPage'])->name('manager.quotation.quotationorder');
        Route::get('quotationdetails', [ManagerQuotationController::class, 'quotationDetails'])->name('manager.quotation.quotationdetails');
        Route::post('quotations', [ManagerQuotationController::class, 'store'])->name('manager.quotations.store');
        Route::get('quotations/{id}/view', [ManagerQuotationController::class, 'view'])->name('manager.quotation.view');
        Route::get('quotations/{id}/edit', [ManagerQuotationController::class, 'edit'])->name('manager.quotation.edit');
        Route::post('quotations/{id}/update', [ManagerQuotationController::class, 'update'])->name('manager.quotation.update');
        Route::delete('quotations/{id}', [ManagerQuotationController::class, 'destroy'])->name('manager.quotation.delete');
        Route::get('quotations/ajax', [ManagerQuotationController::class, 'quotationListAjax'])->name('manager.quotation.ajax');
        Route::get('quotations/{id}/print', [ManagerQuotationController::class, 'print'])->name('manager.quotation.print');
    });
    Route::get('manager/rfq-details/{id}', [ManagerQuotationController::class, 'getRfqDetails']);
    Route::get('manager/max-quotation-id', function () {
        $latest = \App\Models\Quotation::orderByDesc('id')->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[2]) ? ((int)$parts[2] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json([
            'newQuotationNo' => $newQuotationNo,
        ]);
    });

    Route::get('manager/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*'); // <-- this allows slashes!


    Route::prefix('manager')->group(function () {
        Route::get('generate-so-id', [ManagerSalesController::class, 'generateSOId']);
        Route::get('generate-grn-id', [ManagerSalesController::class, 'generateGRNId']);
        Route::get('salesorder', [ManagerSalesController::class, 'salesPage'])->name('manager.sales.salesorder');
        Route::get('salesdetails', [ManagerSalesController::class, 'salesDetails'])->name('manager.sales.salesdetails');
        Route::post('/sales/order/store', [ManagerSalesController::class, 'store'])->name('manager.sales.order.store');
        Route::get('/customers', [ManagerSalesController::class, 'getCustomers']);
        Route::get('/customer/{id}', [ManagerSalesController::class, 'getCustomerById']);
        Route::get('/sales/order/{id}', [ManagerSalesController::class, 'show'])->name('manager.sales.order.show');
        Route::get('/sales/order/{id}/edit', [ManagerSalesController::class, 'edit'])->name('manager.sales.order.edit');
        Route::delete('/sales/order/{id}', [ManagerSalesController::class, 'destroy'])->name('manager.sales.order.delete');
        Route::put('/sales/update/{id}', [ManagerSalesController::class, 'update'])->name('manager.sales.order.update');
    });
    Route::get('manager/quotations', [ManagerSalesController::class, 'getQuotations']);
    Route::get('manager/quotation/{id}', [ManagerSalesController::class, 'getQuotationById']);
    Route::get('/manager/sales-order/{id}', [ManagerSalesController::class, 'getSalesOrderById']);
    Route::get('/manager/sales/order/{id}/print', [ManagerSalesController::class, 'print'])->name('manager.sales.order.print');

    Route::prefix('manager')->group(function () {
        Route::get('generate-po-id', [ManagerPurchaseController::class, 'generatePOId']);
        Route::get('purchaseorder', [ManagerPurchaseController::class, 'purchasePage'])->name('manager.purchase.purchaseorder');
        Route::get('purchasedetails', [ManagerPurchaseController::class, 'purchaseDetails'])->name('manager.purchase.purchasedetails');
        Route::post('/purchase/order/store', [ManagerPurchaseController::class, 'store'])->name('manager.purchase.order.store');
        Route::get('/purchase/order/{id}', [ManagerPurchaseController::class, 'show'])->name('manager.purchase.order.show');
        Route::get('/purchase/order/{id}/edit', [ManagerPurchaseController::class, 'edit'])->name('manager.purchase.order.edit');
        Route::delete('/purchase/order/{id}', [ManagerPurchaseController::class, 'destroy'])->name('manager.purchase.order.delete');
        Route::put('/purchase/update/{id}', [ManagerPurchaseController::class, 'update'])->name('manager.purchase.order.update');
    });
    Route::get('manager/purchase/quotations', [ManagerPurchaseController::class, 'getQuotations']);
    Route::get('manager/purchase/quotation/{id}', [ManagerPurchaseController::class, 'getQuotationById']);
    Route::get('/manager/purchase-order/{id}', [ManagerPurchaseController::class, 'getPurchaseOrderById']);
    Route::get('/manager/purchase/order/{id}/print', [ManagerPurchaseController::class, 'print'])->name('manager.purchase.order.print');

    // GRN routes
    Route::prefix('manager')->group(function () {
        // GRN Master routes
        Route::get('grnorder', [ManagerGRNController::class, 'grnPage'])->name('manager.grn.grnorder');
        Route::get('grndetails', [ManagerGRNController::class, 'grnDetails'])->name('manager.grn.grndetails');
        Route::post('grn/store', [ManagerGRNController::class, 'store'])->name('manager.grn.store');
        Route::get('grn/edit/{id}', [ManagerGRNController::class, 'edit'])->name('manager.grn.edit');
        Route::post('grn/update/{id}', [ManagerGRNController::class, 'update'])->name('manager.grn.update');
        Route::delete('grn/delete/{id}', [ManagerGRNController::class, 'destroy'])->name('manager.grn.destroy');
        Route::post('grn/import', [ManagerGRNController::class, 'import'])->name('manager.grn.import');
        Route::get('grn/view/{id}', [ManagerGRNController::class, 'show'])->name('manager.grn.view');
    });
    Route::get('manager/grn/available-orders', [ManagerGRNController::class, 'availableOrders']);
    Route::get('manager/grn/order-details', [ManagerGRNController::class, 'orderDetails']);

    // Route Card routes
    Route::prefix('manager')->name('manager.routecard.')->group(function () {
        Route::get('routecardorder', [ManagerRouteCardController::class, 'routeCardPage'])->name('routecardorder');
        Route::get('routecarddetails', [ManagerRouteCardController::class, 'routeCardDetails'])->name('routecarddetails');
        Route::post('routecardorder', [ManagerRouteCardController::class, 'store'])->name('store');
        Route::get('routecard/view/{id}', [ManagerRouteCardController::class, 'show'])->name('show');
        Route::get('routecard/edit/{id}', [ManagerRouteCardController::class, 'edit'])->name('edit');
        Route::put('routecard/update/{id}', [ManagerRouteCardController::class, 'update'])->name('update');
        Route::delete('routecard/{routecard}', [ManagerRouteCardController::class, 'destroy'])->name('destroy');
    });
    Route::put('manager/routecard/process-reschedule/{id}', [ManagerRouteCardController::class, 'updateProcessAndReschedule']);
    Route::get('manager/routecard/get-process-list', [ManagerRouteCardController::class, 'getProcessList'])->name('routecard.get-process-list');
    Route::post('manager/routecard/approve/{id}', [ManagerRouteCardController::class, 'approve'])->name('manager.routecard.approve');
    Route::get('/manager/routecard/approved', [ManagerRouteCardController::class, 'approvedList']);
    Route::get('/manager/manufacturing/plan', [ManagerManufacturingPlanningController::class, 'planPage']);
    Route::get('/manager/routecard/{id}/processes', [ManagerManufacturingPlanningController::class, 'rcProcesses']); // API for processes
    // Blade page route
    Route::get('/manager/manufacturing/planning', function () {
        return view('manager.manufacturing.planning');
    })->name('manager.manufacturing.planning');
    Route::prefix('manager')->name('manager.routecard.')->group(function () {
        // ... other routes ...
        Route::put('routecard/process/{id}', [ManagerRouteCardController::class, 'updateProcess']);
        Route::post('routecard/process', [ManagerRouteCardController::class, 'storeProcess']);
        Route::delete('routecard/process/{id}', [ManagerRouteCardController::class, 'deleteProcess']);
        // ... other routes ...
    });
    Route::post('manager/routecard/plan/{id}', [ManagerRouteCardController::class, 'markPlanned']);
    Route::get('manager/routecard/planned', [ManagerRouteCardController::class, 'plannedList']);
    // API routes (for AJAX)
    // New Planning Routes
    Route::get('manufacturing/ready-to-plan', [ManagerRouteCardController::class, 'readyToPlan'])->name('manager.planning.ready');
    Route::get('manufacturing/planning-dashboard', [ManagerRouteCardController::class, 'planningDashboard'])->name('manager.planning.dashboard');
    Route::post('manufacturing/reschedule', [ManagerRouteCardController::class, 'reschedule'])->name('manager.planning.reschedule');

    Route::prefix('manager/manufacturing')->group(function () {

        Route::get('plans', [ManagerManufacturingPlanningController::class, 'index']);
        Route::get('plans/{id}', [ManagerManufacturingPlanningController::class, 'show']);
        Route::post('plans', [ManagerManufacturingPlanningController::class, 'store']);
        Route::put('plans/{id}', [ManagerManufacturingPlanningController::class, 'update']);
        Route::delete('plans/{id}', [ManagerManufacturingPlanningController::class, 'destroy']);
        Route::get('external-api', [ManagerManufacturingPlanningController::class, 'fetchExternalApi']); // optional
    });
    // Project planning routes
    Route::get('/manager/projectplanning', [ManagerProjectPlanningController::class, 'projectPlanning'])->name('manager.projectplanning.projectplanning');
    Route::post('manager/routecard/ready-production/{id}', [ManagerRouteCardController::class, 'markReadyProduction']);
    Route::get('/manager/manufacturing/plan/{id}', [ManagerManufacturingPlanningController::class, 'planPageWithId'])->name('manager.manufacturing.plan');
    Route::get('manager/routecard/ready-to-production-list', [ManagerRouteCardController::class, 'readyToProductionList']);
    Route::post('manager/routecard/in-production/{id}', [ManagerRouteCardController::class, 'markInProduction']);
    Route::get('/manager/ready-to-production', function () {
        return view('manager.manufacturing.ready_to_production');
    })->name('manager.readytoproduction');

    Route::prefix('manager/manufacturing/production')->group(function () {
        Route::get('/in-progress', [ManagerProductionController::class, 'inProgressList'])
            ->name('manager.production.inprogress.list');
        Route::get('/{rcId}', [ManagerProductionController::class, 'productionBoard'])->name('manager.production.board');
        Route::post('/start-process/{id}', [ManagerProductionController::class, 'startProcess']);
        Route::get('/route-card/{id}', [ManagerProductionController::class, 'viewRouteCard'])->name('manager.manufacturing.route-card.view');
        Route::post('/end-process/{id}', [ManagerProductionController::class, 'endProcess']);
        Route::post('/approve-qc/{id}', [ManagerProductionController::class, 'approveQC']);
        Route::post('/reject-qc/{id}', [ManagerProductionController::class, 'rejectQC']); // optional
        
        Route::post('/update-resource/{id}', [ManagerProductionController::class, 'updateMachineOperator'])->name('manager.production.updateResource');
        Route::post('/report-breakdown', [ManagerProductionController::class, 'reportBreakdown'])->name('manager.production.reportBreakdown');
    });

    // Invoice routes
    // manager Invoice
    Route::get('manager/invoiceorder', [ManagerInvoiceController::class, 'invoicePage'])->name('manager.invoice.invoiceorder');
    Route::get('manager/invoicedetails', [ManagerInvoiceController::class, 'invoiceDetails'])->name('manager.invoice.invoicedetails');
    Route::post('manager/tax-invoice', [ManagerInvoiceController::class, 'store'])->name('manager.tax-invoice.store');
    Route::get('manager/generate-invoice-id', [ManagerInvoiceController::class, 'generateInvoiceIdAjax'])->name('manager.invoice.generate');
    Route::get('manager/customer-vendor/{id}', function ($id) {
        $company = \App\Models\CustomerVendor::find($id);
        if (!$company) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'company' => [
                'address' => $company->billing_Address ?: $company->shipping_Address,
                'gst' => $company->gstno,
                'email' => $company->email,
                'mobile' => $company->mobile,
            ],
        ]);
    });
    Route::get('/manager/invoices/{invoice}/print', [ManagerInvoiceController::class, 'print'])->name('manager.invoice.print');
    // Edit Invoice (GET)
    Route::get('/manager/invoices/{invoice}/edit', [ManagerInvoiceController::class, 'edit'])->name('manager.invoice.edit');

    // Update Invoice (PUT/PATCH)
    Route::put('/manager/invoices/{invoice}', [ManagerInvoiceController::class, 'update'])->name('manager.invoice.update');


    // SKU routes
    Route::prefix('manager')->name('manager.sku.')->group(function () {
        // Page
        Route::get('skumaster', [ManagerSKUController::class, 'skuMaster'])->name('skumaster');
        // Data endpoint for DataTables
        Route::get('sku/data', [ManagerSKUController::class, 'skuData'])->name('data');
        // Store
        Route::post('sku', [ManagerSKUController::class, 'store'])->name('store');
        // Edit (show one SKU details)
        Route::get('sku/{id}/edit', [ManagerSKUController::class, 'edit'])->name('edit');
        // Update
        Route::put('sku/{id}', [ManagerSKUController::class, 'update'])->name('update');
        // Delete
        Route::delete('sku/{id}', [ManagerSKUController::class, 'destroy'])->name('destroy');
    });
    // SKU Approval Page
    Route::get('manager/skuapprovals', [ManagerSKUController::class, 'skuApproval'])->name('manager.sku.skuapproval');
    // SKU Approval Data
    Route::get('manager/skuapproval/list', [ManagerSKUController::class, 'skuApprovalList'])->name('sku-approval.list');
    // SKU Approval CRUD
    Route::post('manager/sku-approval', [ManagerSKUController::class, 'skuApprovalStore'])->name('sku-approval.store');
    Route::get('manager/sku-approval/{id}', [ManagerSKUController::class, 'skuApprovalShow'])->name('sku-approval.show');
    Route::put('manager/sku-approval/{id}', [ManagerSKUController::class, 'skuApprovalUpdate'])->name('sku-approval.update');
    Route::delete('manager/sku-approval/{id}', [ManagerSKUController::class, 'skuApprovalDestroy'])->name('sku-approval.destroy');
    Route::get('manager/skumovement', [ManagerSKUController::class, 'skuMovement'])->name('manager.sku.skumovement');
    Route::get('manager/skumovement/list', [ManagerSKUController::class, 'skuMovementList']);
    Route::post('manager/skumovement/store', [ManagerSKUController::class, 'skuMovementStore']);
    Route::get('manager/skumovement/{id}', [ManagerSKUController::class, 'skuMovementShow']);
    Route::delete('manager/skumovement/{id}', [ManagerSKUController::class, 'skuMovementDelete']);

    // Quality Control Kanban
    Route::prefix('manager/quality')->group(function () {
        Route::get('qc-management', [ManagerQualityController::class, 'qcManagement']);
        Route::get('/qualitycontrol/{routeCard}', [ManagerQualityController::class, 'qualityControlBoard']);
        Route::get('/qualitycontrol-data/{routeCard}', [ManagerQualityController::class, 'qualityControlData']);
        Route::post('/qualitycontrol-status/{id}', [ManagerQualityController::class, 'updateQCStatus']);
        Route::post('/qualitycontrol', [ManagerQualityController::class, 'store']);
        Route::get('/qualitycontrol/{id}', [ManagerQualityController::class, 'show']);
        Route::put('/qualitycontrol/{id}', [ManagerQualityController::class, 'update']);
        Route::delete('/qualitycontrol/{id}', [ManagerQualityController::class, 'destroy']);
    });


    // Machine routes
    Route::prefix('manager')->name('manager.machine.')->group(function () {
        Route::get('addmachine', [ManagerMachineController::class, 'addMachine'])->name('addmachine');
        Route::post('storemachine', [ManagerMachineController::class, 'storeMachine'])->name('store');
        Route::get('machinedetails', [ManagerMachineController::class, 'machineDetails'])->name('machinedetails');
        Route::get('editmachine/{id}', [ManagerMachineController::class, 'editMachine'])->name('edit');
        Route::post('updatemachine/{id}', [ManagerMachineController::class, 'updateMachine'])->name('update');
        Route::delete('deletemachine/{id}', [ManagerMachineController::class, 'deleteMachine'])->name('delete');
        Route::post('importmachines', [ManagerMachineController::class, 'importMachines'])
            ->name('import');
    });

    // Employee routes
    Route::get('manager/employeedetails', [ManagerEmployeeController::class, 'employeeDetails'])->name('manager.employee.employeedetails');
    Route::post('/manager/employees', [ManagerEmployeeController::class, 'store'])->name('manager.employees.store');
    Route::put('/manager/employees/{id}', [ManagerEmployeeController::class, 'update'])->name('manager.employees.update');
    Route::delete('/manager/employees/{id}', [ManagerEmployeeController::class, 'destroy'])->name('manager.employees.delete');
    Route::post('manager/importemployees', [ManagerEmployeeController::class, 'importEmployees'])->name('manager.employee.import');

    Route::get('/manager/employees/{id}', [ManagerEmployeeController::class, 'show'])->name('employees.show');
    Route::get('/manager/employees/leave', [ManagerEmployeeController::class, 'employeeLeave'])->name('manager.employee.employeeleave');

     // Employee routes
    Route::get('manager/employeedetails', [ManagerEmployeeController::class, 'employeeDetails'])->name('manager.employee.employeedetails');

    // Main leave list page
    Route::get('manager/employeeleave', [ManagerEmployeeController::class, 'employeeLeave'])->name('manager.employee.employeeleave');
    // Store new leave
    Route::post('manager/employeeleave', [ManagerEmployeeController::class, 'storeEmployeeLeave'])->name('manager.employeeleave.store');
    // Get leave data for edit
    Route::get('manager/employeeleave/{id}', [ManagerEmployeeController::class, 'getEmployeeLeave']);
    // Update leave
    Route::put('manager/employeeleave/{id}', [ManagerEmployeeController::class, 'updateEmployeeLeave'])->name('manager.employeeleave.update');
    // Delete leave
    Route::delete('manager/employeeleave/{id}', [ManagerEmployeeController::class, 'destroyEmployeeLeave'])->name('manager.employeeleave.destroy');
    // Get Employee name/department by employee_id (for autofill)
    Route::get('manager/employee/{id}/name-dept', [ManagerEmployeeController::class, 'getEmployeeNameDept']);


    // Route::get('manager/employeeattendance', [ManagerEmployeeController::class, 'employeeAttendance'])->name('manager.employee.employeeattendance');
    // Route::post('manager/employeeattendance', [ManagerEmployeeController::class, 'storeEmployeeAttendance'])->name('manager.employeeattendance.store');
    // Route::get('manager/employeeattendance/{id}', [ManagerEmployeeController::class, 'getEmployeeAttendance']);
    // Route::put('manager/employeeattendance/{id}', [ManagerEmployeeController::class, 'updateEmployeeAttendance'])->name('manager.employeeattendance.update');
    // Route::delete('manager/employeeattendance/{id}', [ManagerEmployeeController::class, 'destroyEmployeeAttendance'])->name('manager.employeeattendance.destroy');
    // Route::get(
    //     'manager/employeeattendance/employee/{employee_id}/details',
    //     [ManagerEmployeeController::class, 'getEmployeeAttendanceEmployee']
    // );
    Route::prefix('manager')->name('manager.')->group(function () {
        Route::get('employeeattendance', [ManagerEmployeeAttendanceController::class, 'index'])->name('employee.index');
        Route::post('/attendance/import', [ManagerEmployeeAttendanceController::class, 'import'])->name('attendance.import');
        Route::get('/attendance/edit/{id}', [ManagerEmployeeAttendanceController::class, 'edit'])->name('attendance.edit');
        Route::post('attendance/store', [ManagerEmployeeAttendanceController::class, 'store'])->name('attendance.store');
        Route::post('attendance/update/{id}', [ManagerEmployeeAttendanceController::class, 'update'])->name('attendance.update');
        Route::delete('/attendance/delete/{id}', [ManagerEmployeeAttendanceController::class, 'destroy'])->name('attendance.delete');
    });
    Route::prefix('manager/employeedailyreports')->group(function () {

        Route::get('/', [ManagerEmployeeDailyReportController::class, 'index'])->name('employee.employeedailyreport');
        Route::post('/store', [ManagerEmployeeDailyReportController::class, 'store'])->name('employee.daily.store');
        Route::post('/update/{id}', [ManagerEmployeeDailyReportController::class, 'update'])->name('employee.daily.update');
        Route::delete('/delete/{id}', [ManagerEmployeeDailyReportController::class, 'destroy'])->name('employee.daily.delete');
        Route::post('/import', [ManagerEmployeeDailyReportController::class, 'import'])->name('employee.daily.import');
        Route::get('/edit/{id}', [ManagerEmployeeDailyReportController::class, 'edit'])->name('employee.daily.edit');
        Route::get('/calendar/{employee_id}/{month}', [ManagerEmployeeDailyReportController::class, 'calendar']);
        Route::get('/calendarview', [ManagerEmployeeDailyReportController::class, 'calendarView'])->name('employee.daily.calendar');
    });
    
    Route::prefix('manager/purchasemanagement')->group(function () {
        Route::get('/', [ManagerPurchaseManagementController::class, 'index'])->name('manager.purchase.index');
        Route::get('/create', [ManagerPurchaseManagementController::class, 'create'])->name('manager.purchase.create');
        Route::post('/', [ManagerPurchaseManagementController::class, 'store'])->name('manager.purchase.store');
        Route::get('/{purchase}', [ManagerPurchaseManagementController::class, 'show'])->name('manager.purchase.show');
        Route::get('/{purchase}/edit', [ManagerPurchaseManagementController::class, 'edit'])->name('manager.purchase.edit');
        Route::put('/{purchase}/update', [ManagerPurchaseManagementController::class, 'update'])->name('manager.purchase.update');
        Route::delete('/{purchase}', [ManagerPurchaseManagementController::class, 'destroy'])->name('manager.purchase.destroy');

        // Add more for payments, credits etc.
    });
    Route::get('manager/purchasemanage/export', [ManagerPurchaseManagementController::class, 'export'])->name('manager.purchase.export');
    Route::get('manager/creditnotes/next-no', [ManagerPurchaseManagementController::class, 'getNextCreditNoteNo']);
    Route::get('/purchase/next-invoice-no', [ManagerPurchaseManagementController::class, 'getNextInvoiceNumber']);
    Route::post('manager/creditnotes', [ManagerPurchaseManagementController::class, 'creditNoteStore']);
    Route::get('manager/purchasemanage/payments', [ManagerPurchaseManagementController::class, 'payments'])->name('manager.purchase.payments');
    Route::get('manager/purchasemanage/{id}', [ManagerPurchaseManagementController::class, 'Vendorshow']);
    Route::get('manager/creditnotes/data', [ManagerPurchaseManagementController::class, 'creditNotesData'])->name('manager.creditnotes.data');
    Route::get('manager/creditnotes/{id}', [ManagerPurchaseManagementController::class, 'showCreditNote']);
    Route::get('manager/purchasedata/aging-report', [ManagerPurchaseManagementController::class, 'agingReport'])->name('manager.purchase.aging');
    
    
    
    
    Route::any('manager/employeereport', [ManagerReportController::class, 'employeeReport'])->name('manager.report.employeereport');
    Route::any('manager/customerreport', [ManagerReportController::class, 'customerReport'])->name('manager.report.customerreport');
    Route::post('manager/customerreport/export', [ManagerReportController::class, 'exportCustomerReport'])->name('manager.report.customerreport.export');
    Route::post('/manager/employee-report/export', [ManagerReportController::class, 'exportEmployeeReport'])->name('manager.exportEmployeeReport');
    Route::any('manager/machinereport', [ManagerReportController::class, 'machineReport'])->name('manager.report.machinereport');
    Route::post('manager/machinereport/export', [ManagerReportController::class, 'exportMachineReport'])->name('manager.report.machinereport.export');
    Route::any('manager/billreport', [ManagerReportController::class, 'billReport'])->name('manager.report.billreport');
    Route::post('manager/billreport/export', [ManagerReportController::class, 'exportBillReport'])->name('manager.report.billreport.export');
    Route::get('manager/employeedailyreport', [ManagerEmployeeController::class, 'employeeDailyReport'])->name('manager.employee.employeedailyreport');
    Route::any('manager/inventoryreport', [ManagerReportController::class, 'inventoryReport'])->name('manager.report.inventoryreport');
    Route::post('manager/inventoryreport/export', [ManagerReportController::class, 'exportInventoryReport'])->name('manager.report.inventoryreport.export');
    Route::get('manager/employeecalendar', [ManagerEmployeeController::class, 'employeeCalendar'])->name('manager.employee.employeecalendar');
});

// Inactive role routes (commented out)
/*
Route::middleware(['auth', 'role:manager'])->group(function () {
    Route::get('/manager', [ManagerController::class, 'index'])->name('manager.dashboard');
});

Route::middleware(['auth', 'role:user'])->group(function () {
    Route::get('/user', [UserController::class, 'index'])->name('user.dashboard');
});
*/
require __DIR__ . '/web.v1.php';
require __DIR__ . '/auth.php';
    // Salary Structure Routes
    Route::post('superadmin/salary-structure/store', [App\Http\Controllers\SuperAdmin\SuperAdminSalaryStructureController::class, 'store'])->name('superadmin.salary-structure.store');
    Route::get('superadmin/salary-structure', [App\Http\Controllers\SuperAdmin\SuperAdminSalaryStructureController::class, 'index'])->name('superadmin.salary-structure.index');
    Route::get('superadmin/salary-structure/get/{employeeId}', [App\Http\Controllers\SuperAdmin\SuperAdminSalaryStructureController::class, 'getStructure']);
    Route::post('superadmin/salary-structure/import', [App\Http\Controllers\SuperAdmin\SuperAdminSalaryStructureController::class, 'import'])->name('superadmin.salary-structure.import');
    Route::get('superadmin/salary-structure/sample', [App\Http\Controllers\SuperAdmin\SuperAdminSalaryStructureController::class, 'downloadSample'])->name('superadmin.salary-structure.sample');

    // Salary Calculation & Stats API
    Route::get('superadmin/employee/monthly-stats/{employeeId}/{monthYear}', [App\Http\Controllers\SuperAdmin\SuperAdminEmployeeController::class, 'getMonthlyStats']);
    
    // Holiday Master Routes
    Route::resource('superadmin/holiday', App\Http\Controllers\SuperAdmin\SuperAdminHolidayController::class, [
        'names' => 'superadmin.holiday'
    ]);






