@extends('layouts.dashboard.superadminapp')

@section('title', isset($quotation) ? 'Edit Purchase Quotation' : 'Create Purchase Quotation')

@section('styles')
<style>
    .section-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        margin-bottom: 1.5rem;
    }
    .section-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .section-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    }
    .section-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    }
    .section-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    }
    .form-label {
        font-weight: 600;
        color: #5a5c69;
        font-size: 0.85rem;
        margin-bottom: 0.25rem;
    }
    .required-star {
        color: #e74a3b;
    }
    .file-preview {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        margin-top: 0.5rem;
    }
    .file-preview img {
        max-width: 100px;
        max-height: 80px;
        border-radius: 0.25rem;
        border: 1px solid #e3e6f0;
    }
    .existing-file {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.35rem 0.5rem;
        background: #e3e6f0;
        border-radius: 0.35rem;
        margin-bottom: 0.5rem;
        font-size: 0.85rem;
    }
    .existing-file a {
        color: #4e73df;
    }
    .existing-file .delete-file-btn {
        color: #e74a3b;
        cursor: pointer;
    }
    .poq-items-table {
        font-size: 0.8rem;
    }
    .poq-items-table th {
        background: #f8f9fc;
        font-weight: 600;
        font-size: 0.75rem;
        white-space: nowrap;
    }
    .poq-items-table input, .poq-items-table select, .poq-items-table textarea {
        font-size: 0.8rem;
        padding: 0.25rem 0.5rem;
    }
    .totals-breakdown label {
        font-size: 0.85rem;
        font-weight: 600;
        color: #5a5c69;
    }
    .totals-breakdown input {
        font-size: 0.9rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | {{ isset($quotation) ? 'Edit' : 'Create' }} Purchase Quotation</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <form id="quotationContent" method="POST"
        action="{{ isset($quotation) ? route('superadmin.purchasequotation.update', $quotation->id) : route('superadmin.purchasequotation.store') }}"
        enctype="multipart/form-data">
        @csrf
        @if (isset($quotation))
            @method('PUT')
        @endif

        <!-- RFQ & Vendor Information -->
        <div class="card section-card">
            <div class="card-header">
                <i class="fas fa-file-alt mr-2"></i> RFQ & Vendor Information
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">RFQ No</label>
                        @if (isset($quotation))
                            <input type="text" class="form-control" value="{{ $quotation->rfq_no }}" readonly>
                            <input type="hidden" name="rfq_no" value="{{ $quotation->rfq_no }}">
                        @else
                            <select name="rfq_no" id="rfqNo" class="form-control" onchange="getRfqDetails(this)">
                                <option value="">Select RFQ</option>
                                @foreach ($purchaseRfqs as $rfq)
                                    <option value="{{ $rfq->rfq_no }}"
                                        data-rfq='{{ json_encode([
                                            ...$rfq->toArray(),
                                            'vendor' => [
                                                'company' => $rfq->vendor->company ?? '',
                                                'billing_address' => $rfq->vendor->billing_address ?? '',
                                                'gstno' => $rfq->vendor->gstno ?? '',
                                                'mobile' => $rfq->vendor->mobile ?? '',
                                                'email' => $rfq->vendor->email ?? '',
                                            ],
                                        ]) }}'>
                                        {{ $rfq->rfq_no }}
                                    </option>
                                @endforeach
                            </select>
                        @endif
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Quotation ID</label>
                        <input type="text" id="quotationNo" name="quotation_no" class="form-control"
                            value="{{ old('quotation_no', isset($quotation) ? $quotation->quotation_no : $newQuotationNo ?? '') }}"
                            readonly>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Quotation Date <span class="required-star">*</span></label>
                        <input type="date" id="quotationDate" name="quotation_date" class="form-control"
                            value="{{ formateDate(old('quotation_date', isset($quotation) ? $quotation->quotation_date : date('Y-m-d'))) }}"
                            required>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Vendor Name <span class="required-star">*</span></label>
                        <input type="text" id="vendorName" name="vendor_name" class="form-control"
                            value="{{ old('vendor_name', $quotation->vendor_name ?? '') }}" required>
                        <input type="hidden" name="vendor_id" id="vendorId"
                            value="{{ old('vendor_id', $quotation->vendor_id ?? '') }}">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">RFQ Date</label>
                        <input type="date" id="rfqDate" name="rfq_date" class="form-control"
                            value="{{ formateDate(old('rfq_date', isset($quotation) ? $quotation->rfq_date : '')) }}">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Vendor Reference No</label>
                        <input type="text" id="vendorReferenceNo" name="vendor_reference_no" class="form-control"
                            value="{{ old('vendor_reference_no', $quotation->vendor_reference_no ?? '') }}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Address</label>
                        <textarea id="address" name="address" class="form-control" rows="2">{{ old('address', $quotation->address ?? '') }}</textarea>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">GST</label>
                        <input type="text" id="gst" name="gst" class="form-control"
                            value="{{ old('gst', $quotation->gst ?? '') }}">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Contact Number</label>
                        <input type="tel" id="phone" name="phone" class="form-control"
                            value="{{ old('phone', $quotation->phone ?? '') }}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" id="email" name="email" class="form-control"
                            value="{{ old('email', $quotation->email ?? '') }}">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Delivery Terms</label>
                        <input type="text" id="deliveryTerms" name="delivery_terms" class="form-control"
                            value="{{ old('delivery_terms', $quotation->delivery_terms ?? ($quotation->rfq->delivery_terms ?? '')) }}">
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Details -->
        <div class="card section-card">
            <div class="card-header bg-info-gradient">
                <i class="fas fa-info-circle mr-2"></i> Additional Details
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Note</label>
                        <textarea name="note" id="note" class="form-control" rows="2">{{ old('note', $quotation->note ?? '') }}</textarea>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Description</label>
                        <textarea id="description" name="description" class="form-control" rows="2">{{ old('description', $quotation->description ?? '') }}</textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Additional Charges</label>
                        <input type="number" id="additionalCharges" name="additional_charges" class="form-control"
                            value="{{ old('additional_charges', $quotation->additional_charges ?? '0.00') }}"
                            oninput="calculateTotals()" step="0.01">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Vendor Quotation Files</label>
                        <input type="file" id="vendorqtFiles" name="vendorqtFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <small class="text-muted">Accepts: PDF, JPG, PNG</small>

                        @if(isset($quotation) && $quotation->files->count())
                            <div class="mt-2">
                                @foreach($quotation->files as $file)
                                    <div class="existing-file" id="file-preview-{{ $file->id }}">
                                        <i class="fas fa-file text-primary"></i>
                                        @if(Str::endsWith($file->file_path, ['.jpg', '.jpeg', '.png']))
                                            <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank">{{ $file->file_name }}</a>
                                        @elseif(Str::endsWith($file->file_path, ['.pdf']))
                                            <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank">{{ $file->file_name }}</a>
                                        @else
                                            {{ $file->file_name }}
                                        @endif
                                        <i class="fas fa-times delete-file-btn ml-auto" onclick="deleteFile({{ $file->id }})" title="Delete"></i>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                        <div id="vendorqtFiles_preview" class="file-preview"></div>
                    </div>
                </div>

                <!-- Hidden fields -->
                <div class="d-none">
                    <input type="number" id="quantity" name="quantity" value="{{ old('quantity', $quotation->quantity ?? '') }}">
                    <input type="text" id="quantityUOM" name="quantity_uom" value="{{ old('quantity_uom', $quotation->quantity_uom ?? '') }}">
                </div>
            </div>
        </div>

        <!-- Quotation Items -->
        <div class="card section-card">
            <div class="card-header bg-success-gradient">
                <i class="fas fa-list mr-2"></i> Quotation Items <span class="required-star">*</span>
            </div>
            <div class="card-body">
                @include('v1.purchasequotation.poitems', [
                    'items' => old('items', isset($quotation) ? $quotation->items : []),
                ])
            </div>
        </div>

        <!-- Hidden field for INR in words -->
        <input type="hidden" name="inr_in_words" id="inr_in_words" value="">

        <!-- Form Actions -->
        <div class="d-flex justify-content-between mb-4">
            <a href="{{ route('superadmin.purchasequotation.list') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left mr-1"></i> Back to List
            </a>
            <div>
                <button class="btn btn-outline-danger mr-2" type="reset">
                    <i class="fas fa-undo mr-1"></i> Clear
                </button>
                <button class="btn btn-success" type="submit" id="submitBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    <span class="btn-text"><i class="fas fa-save mr-1"></i> {{ isset($quotation) ? 'Update' : 'Save' }} Quotation</span>
                </button>
            </div>
        </div>
    </form>

    <!-- Add Item Modal -->
    @include('v1.purchasequotation.poitemmodal')
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    // File preview
    const input = document.getElementById('vendorqtFiles');
    if (input) {
        input.addEventListener('change', function (event) {
            const previewContainer = document.getElementById('vendorqtFiles_preview');
            previewContainer.innerHTML = '';

            const files = event.target.files;
            if (files.length > 0) {
                Array.from(files).forEach(file => {
                    const fileType = file.type;
                    if (fileType.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function (e) {
                            const img = document.createElement('img');
                            img.src = e.target.result;
                            img.classList.add('img-thumbnail');
                            previewContainer.appendChild(img);
                        };
                        reader.readAsDataURL(file);
                    } else {
                        const link = document.createElement('a');
                        link.href = URL.createObjectURL(file);
                        link.target = '_blank';
                        link.textContent = file.name;
                        link.classList.add('d-block', 'mb-1', 'text-primary');
                        previewContainer.appendChild(link);
                    }
                });
            }
        });
    }

    // Form submit with loading
    document.getElementById('quotationContent').addEventListener('submit', function() {
        var btn = document.getElementById('submitBtn');
        btn.disabled = true;
        btn.querySelector('.spinner-border').classList.remove('d-none');
        btn.querySelector('.btn-text').textContent = '{{ isset($quotation) ? "Updating..." : "Saving..." }}';
    });
});

const rfqItems = @json($quotation->items ?? []);

function getRfqDetails(select) {
    if (!select || !select.selectedIndex || !select.options[select.selectedIndex].dataset.rfq) {
        clearRfqForm();
        return;
    }

    let rfq;
    try {
        rfq = JSON.parse(select.options[select.selectedIndex].dataset.rfq);
        clearRfqForm();
    } catch (e) {
        console.error('Invalid RFQ data', e);
        clearRfqForm();
        return;
    }

    if (!rfq) {
        clearRfqForm();
        return;
    }

    // Fill form fields
    document.getElementById('rfqDate').value = rfq.rfq_date || '';
    document.getElementById('vendorReferenceNo').value = rfq.vendor_reference_no || '';
    document.getElementById('deliveryTerms').value = rfq.delivery_terms || '';
    document.getElementById('quantity').value = rfq.quantity || '';
    document.getElementById('quantityUOM').value = rfq.uom || '';
    document.getElementById('note').value = rfq.note || '';
    document.getElementById('description').value = rfq.description || '';

    const vendor = rfq.vendor || {};
    document.getElementById('vendorName').value = vendor.company || '';
    document.getElementById('vendorId').value = rfq.vendor_id || '';
    document.getElementById('address').value = vendor.billing_address || '';
    document.getElementById('gst').value = vendor.gstno || '';
    document.getElementById('phone').value = vendor.mobile || '';
    document.getElementById('email').value = vendor.email || '';

    // Dispatch rows if items exist
    if (rfq.items?.length > 0) {
        const pqoItemsTable = document.getElementById('pqoItems');
        if (pqoItemsTable) {
            const removeButtons = pqoItemsTable.querySelectorAll('button[onclick*="removeRow"]');
            removeButtons.forEach(btn => {
                removeRow(btn);
            });
        }

        rfq.items.forEach((item, index) => {
            const row = {
                rowCount: index + 1,
                stockItem: item.stock_item?.id || item.stock_item_id || '',
                stockItemName: item.stock_item?.item_name || `Item ${index + 1}`,
                description: item.description || '',
                quantity: item.quantity || 0,
                uom: item.uom || '',
                supplyLeadTime: "",
                unitRate: 0,
                tds: 0,
                discount: 0,
                sgst: item.stock_item?.sgst || '0',
                cgst: item.stock_item?.cgst || '0',
                igst: item.stock_item?.igst || '0',
                amount: 0,
                value: 0
            };
            const event = new CustomEvent('row-added', { detail: row });
            pqoItemsTable.dispatchEvent(event);
        });
    }
    calculateTotals();
}

function clearRfqForm() {
    const fields = [
        'rfqDate', 'vendorReferenceNo', 'deliveryTerms', 'quantity', 'quantityUOM',
        'note', 'description', 'vendorName', 'vendorId', 'address',
        'gst', 'phone', 'email', 'additionalCharges'
    ];
    fields.forEach(id => {
        const el = document.getElementById(id);
        if (el) el.value = '';
    });

    const pqoItemsTable = document.getElementById('pqoItems');
    if (pqoItemsTable) {
        const removeButtons = pqoItemsTable.querySelectorAll('button[onclick*="removeRow"]');
        removeButtons.forEach(btn => {
            removeRow(btn);
        });
    }
    calculateTotals();
}

function deleteFile(fileId) {
    if (!confirm("Are you sure you want to delete this file?")) return;

    fetch("{{ route('superadmin.purchasequotation.delete-file') }}", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": "{{ csrf_token() }}",
            "Content-Type": "application/json"
        },
        body: JSON.stringify({ id: fileId })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const el = document.getElementById('file-preview-' + fileId);
            if (el) el.remove();
        } else {
            alert("Failed to delete file.");
        }
    })
    .catch(() => alert("An error occurred while deleting the file."));
}
</script>
@endsection
