<div class="d-flex justify-content-between align-items-center mb-3">
    <h5>Credit Notes</h5>
    <button class="btn btn-primary btn-sm" id="addCreditNoteBtn">
        <i class="fas fa-plus me-1"></i> Add Credit Note
    </button>
</div>

<div class="filter-section">
    <div class="row">
        <div class="col-md-3">
            <label class="form-label">Date Range</label>
            <input type="text" class="form-control credit-date-range"
                placeholder="Select date range" readonly>
        </div>
        <div class="col-md-3">
            <label class="form-label">Vendors</label>
            <select class="form-select" id="credit-party">
                <option value="">Select Vendor</option>
                @foreach ($vendors as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Credit Note No</label>
            <input type="text" class="form-control credit-note-filter"
                placeholder="Credit Note No">
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button class="btn btn-primary me-2" id="applyCreditFilters">Apply Filters</button>
            <button class="btn btn-outline-secondary" id="resetCreditFilters">Reset</button>
        </div>
    </div>
</div>

<table id="creditTable" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr>
            <th>Credit Note No</th>
            <th>Date</th>
            <th>Vendor</th>
            <th>Invoice No</th>
            <th>Amount</th>
            <th>Reason</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <!-- Data will be loaded here -->
    </tbody>
</table>

<!-- Credit Note Modal -->
<div class="modal fade" id="creditNoteModal" tabindex="-1" aria-labelledby="creditNoteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="creditNoteModalLabel">Add Credit Note</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">X</button>
            </div>
            <form id="creditNoteForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_note_no" class="form-label">Credit Note No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="credit_note_no" name="credit_note_no" required readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_note_date" class="form-label">Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="credit_note_date" name="date" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_note_party" class="form-label">Vendors <span class="text-danger">*</span></label>
                                <select class="form-select" id="credit_note_party" name="party_id" required>
                                    <option value="">Select Vendor</option>
                                    @foreach ($vendors as $vendor)
                                        <option value="{{ $vendor->id }}">{{ $vendor->company }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_note_invoice" class="form-label">Invoice No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="credit_note_invoice" name="invoice_no" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_note_amount" class="form-label">Amount <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="credit_note_amount" name="amount" step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_note_reason" class="form-label">Reason <span class="text-danger">*</span></label>
                                <select class="form-select" id="credit_note_reason" name="reason" required>
                                    <option value="">Select Reason</option>
                                    <option value="Defective Goods">Defective Goods</option>
                                    <option value="Wrong Quantity">Wrong Quantity</option>
                                    <option value="Price Adjustment">Price Adjustment</option>
                                    <option value="Return">Return</option>
                                    <option value="Discount">Discount</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="credit_note_description" class="form-label">Description</label>
                        <textarea class="form-control" id="credit_note_description" name="description" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Credit Note</button>
                </div>
            </form>
        </div>
    </div>
</div>