<!-- Header -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Credit/Debit Notes</h6>
    <button class="btn btn-primary btn-sm" id="addCreditNoteBtn">
        <i class="fas fa-plus mr-1"></i> Add Credit/Debit Note
    </button>
</div>

<!-- Filter Section -->
<div class="filter-card">
    <div class="row">
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Date Range</label>
            <input type="text" class="form-control form-control-sm credit-date-range"
                placeholder="Select date range" readonly>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Customer</label>
            <select class="form-control form-control-sm" id="credit-party">
                <option value="">All Customers</option>
                @foreach ($customers as $customer)
                    <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Credit/Debit Note No</label>
            <input type="text" class="form-control form-control-sm credit-note-filter"
                placeholder="Search by note number">
        </div>
        <div class="col-md-3 d-flex align-items-end mb-2">
            <button class="btn btn-primary btn-sm mr-1" id="applyCreditFilters">
                <i class="fas fa-filter"></i> Apply
            </button>
            <button class="btn btn-secondary btn-sm" id="resetCreditFilters">
                <i class="fas fa-undo"></i> Reset
            </button>
        </div>
    </div>
</div>

<!-- Credit Notes Table -->
<div class="table-responsive">
    <table id="creditTable" class="table table-bordered table-striped table-sm w-100">
        <thead class="thead-light">
            <tr>
                <th>Credit Note No</th>
                <th>Date</th>
                <th>Customer</th>
                <th>Invoice No</th>
                <th class="text-right">Amount</th>
                <th>Reason</th>
                <th class="text-center">Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data loaded via AJAX -->
        </tbody>
    </table>
</div>

<!-- Credit Note Modal -->
<div class="modal fade" id="creditNoteModal" tabindex="-1" aria-labelledby="creditNoteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="creditNoteModalLabel">
                    <i class="fas fa-file-invoice mr-2"></i> Add Credit Note
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="creditNoteForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Credit Note No <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" id="credit_note_no" name="credit_note_no" required readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Date <span class="text-danger">*</span>
                                </label>
                                <input type="date" class="form-control" id="credit_note_date" name="date" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Customer <span class="text-danger">*</span>
                                </label>
                                <select class="form-control" id="credit_note_party" name="party_id" required>
                                    <option value="">Select Customer</option>
                                    @foreach ($customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">Invoice No</label>
                                <input type="text" class="form-control" id="credit_note_invoice" name="invoice_no" placeholder="Related invoice number">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Amount <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">₹</span>
                                    </div>
                                    <input type="number" class="form-control" id="credit_note_amount" name="amount" step="0.01" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Reason <span class="text-danger">*</span>
                                </label>
                                <select class="form-control" id="credit_note_reason" name="reason" required>
                                    <option value="">Select Reason</option>
                                    <option value="Defective Goods">Defective Goods</option>
                                    <option value="Wrong Quantity">Wrong Quantity</option>
                                    <option value="Price Adjustment">Price Adjustment</option>
                                    <option value="Return">Return</option>
                                    <option value="Discount">Discount</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="small font-weight-bold">Description</label>
                        <textarea class="form-control" id="credit_note_description" name="description" rows="3" placeholder="Additional details..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save mr-1"></i> Save
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
