<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Quotation #{{ $quotation->quotation_no }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 15mm 10mm 12mm 10mm;
        }
        @media print {
            html, body {
                width: 100%;
                height: 100%;
            }
            .no-print {
                display: none !important;
            }
            body {
                background: #fff !important;
            }
            .container {
                box-shadow: none !important;
                margin: 0 !important;
                padding: 0 0 5mm 0 !important;
                width: 100% !important;
                border-radius: 0 !important;
            }
            table.details-table {
                page-break-inside: auto;
            }
            table.details-table thead {
                display: table-header-group;
            }
            table.details-table tfoot {
                display: table-footer-group;
            }
            table.details-table tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            .section-title {
                page-break-after: avoid;
            }
        }

        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 1000px;
            margin: 10px auto;
            background: #fff;
            padding: 20px 20px 14px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 16px rgba(80, 100, 144, .09);
        }
        .header {
            display: flex;
            align-items: center;
            border-bottom: 2px solid #506690;
            padding-bottom: 6px;
            margin-bottom: 18px;
        }
        .logo {
            width: 70px;
            margin-right: 18px;
        }
        .company-details { flex: 1; }
        .company-details h2 {
            margin: 0;
            color: #506690;
            letter-spacing: 1.1px;
            font-size: 22px;
        }
        .company-details p {
            margin: 2px 0 0 0;
            color: #555;
            font-size: 12px;
        }
        .quotation-title {
            text-align: center;
            margin: 0 0 15px 0;
            color: #263850;
            font-size: 20px;
        }
        .info-table {
            width: 100%;
            margin-bottom: 12px;
            border-collapse: collapse;
        }
        .info-table td {
            padding: 4px 6px;
            vertical-align: top;
            font-size: 12px;
        }
        .section-title {
            background: #f1f4f9;
            color: #506690;
            font-weight: bold;
            padding: 4px 8px;
            border-radius: 3px;
            margin-bottom: 7px;
            margin-top: 14px;
            font-size: 14px;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 14px;
        }
        .details-table th, .details-table td {
            border: 1px solid #dbe5f1;
            padding: 5px 6px;
            font-size: 11px;
        }
        .details-table th {
            background: #f6faff;
            color: #263850;
            font-weight: 600;
        }
        .totals-table {
            width: 42%;
            margin-left: auto;
            font-size: 13px;
            margin-bottom: 10px;
        }
        .totals-table td {
            padding: 3px 6px;
        }
        .right { text-align: right; }
        .terms {
            margin-top: 8px;
            color: #555;
            font-size: 11px;
        }
        .footer {
            margin-top: 14px;
            text-align: right;
        }
        .signatory {
            margin-top: 24px;
            text-align: right;
            font-weight: bold;
            font-size: 12px;
        }
        .no-print {
            margin-bottom: 12px;
        }
        .btn {
            background: #506690;
            color: #fff;
            padding: 6px 18px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        .btn:hover {
            background: #354063;
        }
        @media print {
            .footer {
                position: fixed;
                bottom: 15mm;
                right: 10mm;
                left: 10mm;
                text-align: right;
            }
        }

    </style>
</head>
<body>
    @php
        $raw_materials = is_array($quotation->raw_materials) ? $quotation->raw_materials : json_decode($quotation->raw_materials, true) ?? [];
        $conversion_costs = is_array($quotation->conversion_costs) ? $quotation->conversion_costs : json_decode($quotation->conversion_costs, true) ?? [];
        $packing_charges = is_array($quotation->packing_charges) ? $quotation->packing_charges : json_decode($quotation->packing_charges, true) ?? [];
    @endphp

    <div class="container">
        <div class="no-print" style="text-align:right;">
            <button class="btn" onclick="window.print()">Print</button>
            <button class="btn" onclick="window.close()">Close</button>
        </div>
        <div class="header">
            <img class="logo" src="{{ asset('cbimage.png') }}" alt="Company Logo">
            <div class="company-details">
                <h2>UMBREY ENGINEERING PVT LTD</h2>
                <p>No. 31, 2nd Phase, Peenya Industrial Area, Bengaluru 560 058, Karnataka, India<br>
                GSTN: 29AAACU2461N1ZY &nbsp; | &nbsp; PAN: AAACU2461N</p>
                <p style="font-size:11px;margin:2px 0 0 0;">Email: info@umbreygroups.com</p>
            </div>
            <div style="text-align:right;font-size:12px;">
                <strong>Quotation #: </strong> {{ $quotation->quotation_no }}<br>
                <strong>Date:</strong> {{ \Carbon\Carbon::parse($quotation->quotation_date)->format('d/m/Y') }}<br>
            </div>
        </div>

        <h1 class="quotation-title">QUOTATION</h1>

        <div class="section-title">Customer Details</div>
        <table class="info-table">
            <tr>
                <td style="width:33%;"><b>Company:</b> {{ $quotation->customer->company ?? '-' }}<br>
                    <b>Contact:</b> {{ $quotation->phone ?? '-' }}<br>
                    <b>Email:</b> {{ $quotation->email ?? '-' }}<br>
                    <b>GST No:</b> {{ $quotation->gst ?? '-' }}
                </td>
                <td style="width:33%;"><b>Address:</b><br>{{ $quotation->address ?? '-' }}</td>
                <td style="width:34%;">
                    <b>Customer Ref :</b> {{ $quotation->cust_ref_no ?? '-' }}<br>
                    <b>RFQ :</b> {{ $quotation->rfq_no ?? '-' }}<br>
                    <b>RFQ Date:</b> {{ $quotation->rfq_date ? \Carbon\Carbon::parse($quotation->rfq_date)->format('d/m/Y') : '-' }}
                </td>
            </tr>
        </table>

        <div class="section-title">Quotation Details</div>
        <table class="details-table">
            <thead>
                <tr>
                    <th>Part No</th>
                    <th>Project Mat No</th>
                    <th>Drawing No</th>
                    <th>Drawing Rev</th>
                    <th>Qty</th>
                    <th>UOM</th>
                    <th>Description</th>
                    <th>Product Type</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $quotation->part_no }}</td>
                    <td>{{ $quotation->project_material_no }}</td>
                    <td>{{ $quotation->drawing_no }}</td>
                    <td>{{ $quotation->drawing_rev }}</td>
                    <td class="right">{{ $quotation->quantity }}</td>
                    <td>{{ $quotation->quantity_uom }}</td>
                    <td>{{ $quotation->description }}</td>
                    <td>{{ $quotation->product_type }}</td>
                </tr>
            </tbody>
        </table>

        {{-- RAW MATERIAL CHARGES --}}
        @if (count($raw_materials))
        <div class="section-title">Raw Material Charges</div>
        <table class="details-table">
            <thead>
                <tr>
                    <th>Sl.</th>
                    <th>Raw Material</th>
                    <th>Type</th>
                    <th>Rate(INR)</th>
                    <th>Scrap Rate(INR)</th>
                    <th>Finish Wt(KG)</th>
                    <th>Qty(NOs)</th>
                    <th>Size 1(INR)</th>
                    <th>Size 2(INR)</th>
                    <th>Size 3(INR)</th>
                    <th>RM Weight(KG)</th>
                    <th>RM Cost(INR)</th>
                    <th>Value(INR)</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($raw_materials as $i => $item)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $item['material'] ?? ($item['RawMaterial'] ?? '-') }}</td>
                    <td>{{ $item['type'] ?? ($item['rawmaterialtype'] ?? '-') }}</td>
                    <td class="right">{{ $item['rate'] ?? ($item['MaterialaRate'] ?? '-') }}</td>
                    <td class="right">{{ $item['scrap_rate'] ?? ($item['ScrapRate'] ?? '-') }}</td>
                    <td class="right">{{ $item['finish_weight'] ?? ($item['FinishWeight'] ?? '-') }}</td>
                    <td class="right">{{ $item['quantity'] ?? ($item['Quantity'] ?? '-') }}</td>
                    <td class="right">{{ $item['size1'] ?? ($item['Size 1'] ?? '-') }}</td>
                    <td class="right">{{ $item['size2'] ?? ($item['Size 2'] ?? '-') }}</td>
                    <td class="right">{{ $item['size3'] ?? ($item['Size 3'] ?? '-') }}</td>
                    <td class="right">{{ $item['rm_weight'] ?? ($item['RM Weight'] ?? '-') }}</td>
                    <td class="right">{{ $item['rm_cost'] ?? ($item['RM Cost'] ?? '-') }}</td>
                    <td class="right">{{ $item['value'] ?? ($item['Value'] ?? '-') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif

        {{-- CONVERSION COSTS --}}
        @if (count($conversion_costs))
        <div class="section-title">Conversion Costs</div>
        <table class="details-table">
            <thead>
                <tr>
                    <th>Sl.</th>
                    <th>Description</th>
                    <th>Qty</th>
                    <th>UOM</th>
                    <th>Rate(INR)</th>
                    <th>Value(INR)</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($conversion_costs as $i => $item)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $item['desc'] ?? ($item['conversionCost'] ?? '-') }}</td>
                    <td class="right">{{ $item['quantity'] ?? ($item['Quantity'] ?? '-') }}</td>
                    <td>{{ $item['unit'] ?? ($item['Unit'] ?? '-') }}</td>
                    <td class="right">{{ $item['rate'] ?? ($item['Rate'] ?? '-') }}</td>
                    <td class="right">{{ $item['value'] ?? ($item['Value'] ?? '-') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif

        {{-- PACKING CHARGES --}}
        @if (count($packing_charges))
        <div class="section-title">Packing Charges</div>
        <table class="details-table">
            <thead>
                <tr>
                    <th>Sl.</th>
                    <th>Description</th>
                    <th>Qty</th>
                    <th>UOM</th>
                    <th>Rate(INR)</th>
                    <th>Value(INR)</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($packing_charges as $i => $item)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $item['desc'] ?? ($item['Description'] ?? '-') }}</td>
                    <td class="right">{{ $item['quantity'] ?? ($item['Quantity'] ?? '-') }}</td>
                    <td>{{ $item['unit'] ?? ($item['Unit'] ?? '-') }}</td>
                    <td class="right">{{ $item['rate'] ?? ($item['Rate'] ?? '-') }}</td>
                    <td class="right">{{ $item['value'] ?? ($item['Value'] ?? '-') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif

        

        <div class="clearfix"></div>
        <div class="section-title">Quotation Summary :</div>
        <table class="totals-table" align="right">
            <tr>
                <td class="right">Sub Total :</td>
                <td class="right"><strong>{{ number_format($quotation->sub_total, 2) }}</strong></td>
            </tr>
            <tr>
                <td class="right">Discount :</td>
                <td class="right"><strong>{{ number_format($quotation->discount, 2) }} %</strong></td>
            </tr>
            <tr>
                <td class="right">Round Up :</td>
                <td class="right"><strong>{{ number_format($quotation->round_up, 2) }}</strong></td>
            </tr>
            <tr>
                <td class="right">Grand Total :</td>
                <td class="right"><strong style="font-size:16px; color:#263850;">₹ {{ number_format($quotation->grand_total, 2) }}</strong></td>
            </tr>
            <tr>
                <td class="right">Grand Total in Words in INR :</td>
                <td class="right">
                    <strong id="amount-in-words" style="font-size:16px; color:#263850;"></strong>
                </td>
            </tr>
        </table>
        <p style="min-height:18px;font-size:12px;">Note : {{ $quotation->note }}</p>

        <div class="terms">
            <strong>Terms & Conditions:</strong>
            <ul style="margin:0 0 0 18px;">
                <li>Delivery: As mutually agreed</li>
                <li>Terms: Ex Works at UEPL Peenya</li>
                <li>Price: Firm</li>
                <li>Payments: 30 days</li>
                <li>Taxes: As applicable</li>
                <li>Validity: 30 days</li>
            </ul>
        </div><br>
        <div class="footer">
            <div class="signatory">
                For Umbrey Engineering PVT LTD,<br><br>
                Authorised Signatory
            </div>
        </div>
    </div>
    <script>
        function convertNumberToWords(amount) {
            var words = [];
            words[0] = '';
            words[1] = 'One';
            words[2] = 'Two';
            words[3] = 'Three';
            words[4] = 'Four';
            words[5] = 'Five';
            words[6] = 'Six';
            words[7] = 'Seven';
            words[8] = 'Eight';
            words[9] = 'Nine';
            words[10] = 'Ten';
            words[11] = 'Eleven';
            words[12] = 'Twelve';
            words[13] = 'Thirteen';
            words[14] = 'Fourteen';
            words[15] = 'Fifteen';
            words[16] = 'Sixteen';
            words[17] = 'Seventeen';
            words[18] = 'Eighteen';
            words[19] = 'Nineteen';
            words[20] = 'Twenty';
            words[30] = 'Thirty';
            words[40] = 'Forty';
            words[50] = 'Fifty';
            words[60] = 'Sixty';
            words[70] = 'Seventy';
            words[80] = 'Eighty';
            words[90] = 'Ninety';
    
            if (amount === 0) return 'Zero';
            if (amount > 999999999) return 'Overflow';
    
            var crore = Math.floor(amount / 10000000);
            amount -= crore * 10000000;
            var lakh = Math.floor(amount / 100000);
            amount -= lakh * 100000;
            var thousand = Math.floor(amount / 1000);
            amount -= thousand * 1000;
            var hundred = Math.floor(amount / 100);
            amount -= hundred * 100;
            var ten = Math.floor(amount / 10);
            var one = amount % 10;
    
            var str = '';
            if (crore > 0) str += convertNumberToWords(crore) + ' Crore ';
            if (lakh > 0) str += convertNumberToWords(lakh) + ' Lakh ';
            if (thousand > 0) str += convertNumberToWords(thousand) + ' Thousand ';
            if (hundred > 0) str += convertNumberToWords(hundred) + ' Hundred ';
            if (ten > 1) str += words[ten * 10] + ' ';
            if (ten === 1) str += words[ten * 10 + one] + ' ';
            else if (one > 0) str += words[one] + ' ';
    
            return str.trim();
        }
    
        // On page load
        document.addEventListener("DOMContentLoaded", function () {
            let grandTotal = parseFloat(`{{ $quotation->grand_total }}`);
            let integerPart = Math.floor(grandTotal);
            let paisePart = Math.round((grandTotal - integerPart) * 100);
    
            let inWords = convertNumberToWords(integerPart);
            if (paisePart > 0) {
                inWords += ' and ' + convertNumberToWords(paisePart) + ' Paise';
            }
            inWords += ' Only';
    
            document.getElementById("amount-in-words").innerText = inWords;
        });
    </script>

</body>
</html>
