@extends('layouts.dashboard.superadminapp')

@section('title', 'My Profile')

@section('styles')
<style>
    .profile-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border-radius: 10px;
        padding: 30px;
        color: #fff;
        margin-bottom: 25px;
    }
    .profile-avatar {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        border: 4px solid rgba(255,255,255,0.3);
        background: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 3rem;
        color: #4e73df;
        font-weight: bold;
    }
    .profile-name {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 5px;
    }
    .profile-role {
        font-size: 0.95rem;
        opacity: 0.9;
        text-transform: capitalize;
    }
    .profile-email {
        font-size: 0.9rem;
        opacity: 0.85;
    }
    .profile-card {
        border-radius: 10px;
        border: none;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    }
    .profile-card .card-header {
        border-radius: 10px 10px 0 0;
        padding: 15px 20px;
    }
    .profile-card .card-body {
        padding: 25px;
    }
    .form-group label {
        font-weight: 600;
        color: #5a5c69;
        margin-bottom: 8px;
    }
    .form-control:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
    .btn-update {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border: none;
        padding: 10px 30px;
        font-weight: 600;
    }
    .btn-update:hover {
        background: linear-gradient(135deg, #224abe 0%, #1a3a8a 100%);
    }
    .info-item {
        padding: 15px 0;
        border-bottom: 1px solid #e3e6f0;
    }
    .info-item:last-child {
        border-bottom: none;
    }
    .info-label {
        font-weight: 600;
        color: #858796;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .info-value {
        font-weight: 500;
        color: #5a5c69;
        font-size: 1rem;
    }
    .password-toggle {
        cursor: pointer;
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: #858796;
    }
    .password-toggle:hover {
        color: #4e73df;
    }
    .input-group-password {
        position: relative;
    }
    .input-group-password .form-control {
        padding-right: 45px;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | My Profile</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<!-- Profile Header -->
<div class="profile-header">
    <div class="row align-items-center">
        <div class="col-auto">
            <div class="profile-avatar">
                {{ strtoupper(substr($user->name, 0, 1)) }}
            </div>
        </div>
        <div class="col">
            <div class="profile-name">{{ $user->name }}</div>
            <div class="profile-role">
                <i class="fas fa-user-shield mr-1"></i> {{ $user->role }}
            </div>
            <div class="profile-email mt-2">
                <i class="fas fa-envelope mr-1"></i> {{ $user->email }}
            </div>
        </div>
        <div class="col-auto text-right d-none d-md-block">
            <div class="mb-2">
                <span class="badge badge-light px-3 py-2">
                    <i class="fas fa-calendar-alt mr-1"></i>
                    Member since {{ $user->created_at->format('M d, Y') }}
                </span>
            </div>
            @if($user->status == 1 || strtolower($user->status ?? '') == 'active')
                <span class="badge badge-success px-3 py-2">
                    <i class="fas fa-check-circle mr-1"></i> Active Account
                </span>
            @else
                <span class="badge badge-danger px-3 py-2">
                    <i class="fas fa-times-circle mr-1"></i> Inactive Account
                </span>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <!-- Profile Information -->
    <div class="col-lg-6 mb-4">
        <div class="card profile-card">
            <div class="card-header" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-user-edit mr-2"></i> Update Profile Information
                </h6>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('superadmin.profile.update') }}">
                    @csrf
                    @method('PUT')

                    <div class="form-group">
                        <label for="name"><i class="fas fa-user mr-1"></i> Full Name</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                               id="name" name="name" value="{{ old('name', $user->name) }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="email"><i class="fas fa-envelope mr-1"></i> Email Address</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                               id="email" name="email" value="{{ old('email', $user->email) }}" required>
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group mb-0">
                        <button type="submit" class="btn btn-success btn-update">
                            <i class="fas fa-save mr-2"></i> Update Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Change Password -->
    <div class="col-lg-6 mb-4">
        <div class="card profile-card">
            <div class="card-header" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-lock mr-2"></i> Change Password
                </h6>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('superadmin.profile.password') }}">
                    @csrf
                    @method('PUT')

                    <div class="form-group">
                        <label for="current_password"><i class="fas fa-key mr-1"></i> Current Password</label>
                        <div class="input-group-password">
                            <input type="password" class="form-control @error('current_password') is-invalid @enderror"
                                   id="current_password" name="current_password" required>
                            <span class="password-toggle" onclick="togglePassword('current_password')">
                                <i class="fas fa-eye"></i>
                            </span>
                            @error('current_password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password"><i class="fas fa-lock mr-1"></i> New Password</label>
                        <div class="input-group-password">
                            <input type="password" class="form-control @error('password') is-invalid @enderror"
                                   id="password" name="password" required>
                            <span class="password-toggle" onclick="togglePassword('password')">
                                <i class="fas fa-eye"></i>
                            </span>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <small class="form-text text-muted">Minimum 8 characters</small>
                    </div>

                    <div class="form-group">
                        <label for="password_confirmation"><i class="fas fa-check-circle mr-1"></i> Confirm New Password</label>
                        <div class="input-group-password">
                            <input type="password" class="form-control"
                                   id="password_confirmation" name="password_confirmation" required>
                            <span class="password-toggle" onclick="togglePassword('password_confirmation')">
                                <i class="fas fa-eye"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group mb-0">
                        <button type="submit" class="btn btn-warning btn-update text-white">
                            <i class="fas fa-key mr-2"></i> Update Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Account Information -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card profile-card">
            <div class="card-header" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-info-circle mr-2"></i> Account Information
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="info-item px-4">
                    <div class="info-label">User ID</div>
                    <div class="info-value">#{{ str_pad($user->id, 5, '0', STR_PAD_LEFT) }}</div>
                </div>
                <div class="info-item px-4">
                    <div class="info-label">Account Type</div>
                    <div class="info-value text-capitalize">{{ $user->role }}</div>
                </div>
                <div class="info-item px-4">
                    <div class="info-label">Email Verified</div>
                    <div class="info-value">
                        @if($user->email_verified_at)
                            <span class="text-success"><i class="fas fa-check-circle mr-1"></i> Verified on {{ $user->email_verified_at->format('M d, Y') }}</span>
                        @else
                            <span class="text-warning"><i class="fas fa-exclamation-circle mr-1"></i> Not Verified</span>
                        @endif
                    </div>
                </div>
                <div class="info-item px-4">
                    <div class="info-label">Account Created</div>
                    <div class="info-value">{{ $user->created_at->format('F d, Y \a\t h:i A') }}</div>
                </div>
                <div class="info-item px-4">
                    <div class="info-label">Last Updated</div>
                    <div class="info-value">{{ $user->updated_at->format('F d, Y \a\t h:i A') }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6 mb-4">
        <div class="card profile-card">
            <div class="card-header" style="background: linear-gradient(135deg, #858796 0%, #5a5c69 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-shield-alt mr-2"></i> Security Tips
                </h6>
            </div>
            <div class="card-body">
                <div class="d-flex align-items-start mb-3">
                    <div class="mr-3">
                        <span class="fa-stack fa-lg">
                            <i class="fas fa-circle fa-stack-2x text-primary"></i>
                            <i class="fas fa-key fa-stack-1x fa-inverse"></i>
                        </span>
                    </div>
                    <div>
                        <h6 class="font-weight-bold mb-1">Use Strong Passwords</h6>
                        <p class="text-muted mb-0 small">Create passwords with at least 8 characters, including uppercase, lowercase, numbers, and special characters.</p>
                    </div>
                </div>
                <div class="d-flex align-items-start mb-3">
                    <div class="mr-3">
                        <span class="fa-stack fa-lg">
                            <i class="fas fa-circle fa-stack-2x text-success"></i>
                            <i class="fas fa-sync-alt fa-stack-1x fa-inverse"></i>
                        </span>
                    </div>
                    <div>
                        <h6 class="font-weight-bold mb-1">Change Password Regularly</h6>
                        <p class="text-muted mb-0 small">Update your password every 90 days to maintain account security.</p>
                    </div>
                </div>
                <div class="d-flex align-items-start">
                    <div class="mr-3">
                        <span class="fa-stack fa-lg">
                            <i class="fas fa-circle fa-stack-2x text-warning"></i>
                            <i class="fas fa-user-secret fa-stack-1x fa-inverse"></i>
                        </span>
                    </div>
                    <div>
                        <h6 class="font-weight-bold mb-1">Keep Credentials Private</h6>
                        <p class="text-muted mb-0 small">Never share your login credentials with anyone, even colleagues.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = field.nextElementSibling.querySelector('i');

    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>
@endsection
