@extends('layouts.dashboard.superadminapp')

@section('title', 'Manage Processes')
<style>
    .btn {
        width: auto;
    }
</style>
@section('content')
    <div class="container">
        <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h5 mb-0 text-gray-800">UEPL / Production Details</h1>
            <div class="display-date">
                <span id="day">day</span>, <span id="daynum">00</span> <span id="month">month</span> <span
                    id="year">0000</span>
            </div>
            <div class="display-time"></div>
        </div>

        <div class="card shadow">
            <div class="card-header d-flex justify-content-between align-items-center gap-3">
                <span class="fw-bold"><i class="fas fa-table me-2"></i> </span>
                <button class="btn btn-primary btn-sm" id="addProcessBtn">
                    <i class="fas fa-plus"></i> Add Process
                </button>
                <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#assignModal"
                    data-assign-mode="m2o">
                    <i class="fas fa-cogs"></i> Assign Machines
                </button>
                <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#machineModel"
                    data-assign-mode="o2m">
                    <i class="fas fa-cogs"></i> Assign Operators
                </button>
                <!-- <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#assignmentsModal">
                    <i class="fas fa-list"></i> View Assignments
                    </button> -->
                <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewMachinesModal">
                    <i class="fas fa-tools"></i> View Machines
                </button>
                <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewOperatorsModal">
                    <i class="fas fa-user-cog"></i> View Operators
                </button>
            </div>
            <div class="card-body">
                <table class="table table-bordered" id="processTable">
                    <thead>
                        <tr>
                            <th>Sl No</th>
                            <th>Product Type</th>
                            <th>Process Name</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody><!-- Loaded via JS --></tbody>
                </table>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="processModal" tabindex="-1">
            <div class="modal-dialog">
                <form id="processForm">
                    @csrf
                    <input type="hidden" id="process_id" name="process_id">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Add/Edit Process</h5>
                            <button type="button" class="btn-close" data-dismiss="modal">X</button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label>Product Type</label>
                                <select class="form-select" name="product_type_id" id="product_type_id" required>
                                    @foreach ($productTypes as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3">
                                <label>Process Name</label>
                                <input type="text" class="form-control" name="name" id="name" required>
                            </div>
                            <div class="mb-3">
                                <label>Order</label>
                                <input type="number" class="form-control" name="order" id="order" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button class="btn btn-primary" type="submit">Save</button>
                            <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Assign Machines/Operators Modal -->
    <div class="modal fade" id="assignModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="assignForm">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Assign Machines and Operators</h5>
                        <button type="button" class="btn-close" data-dismiss="modal"><span>×</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label>Product Type</label>
                            <select class="form-select" id="assign_product_type_id">
                                <option value="">Select Type</option>
                                @foreach ($productTypes as $type)
                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label>Process</label>
                            <select class="form-select" id="assign_process_dropdown" name="process_id" required>
                                <option value="">Select process</option>
                                <!-- Loaded via JS -->
                            </select>
                        </div>

                        <!-- <div class="mb-3">
                                <label class="form-label">Assignment Mode</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="assignment_mode" id="mode_m2o" value="m2o" checked>
                                    <label class="form-check-label" for="mode_m2o">
                                        Multiple Machines → One Operator
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="assignment_mode" id="mode_o2m" value="o2m">
                                    <label class="form-check-label" for="mode_o2m">
                                        Multiple Operators → One Machine
                                    </label>
                                </div>
                            </div> -->

                        <div class="mb-3 form-group">
                            <label>Machines</label>
                            <select class="form-control selectpicker" name="machines[]" id="assign_machines" multiple>
                                @foreach ($machines as $machine)
                                    <option value="{{ $machine->id }}">{{ $machine->machine_name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3 form-group">
                            <label>Operators</label>
                            <select class="form-control selectpicker" name="operators" id="assign_operators">
                                @foreach ($employees as $emp)
                                    <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-primary" type="submit">Assign</button>
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="viewMachinesModal" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Assigned Machines</h5>
                    <button type="button" class="btn-close" data-dismiss="modal"><span>×</span></button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <table class="table table-bordered align-middle" id="machinesSummaryTable">
                            <thead class="table-light text-center">
                                <tr>
                                    <th>Sl No</th>
                                    <th>Product Type</th>
                                    <th>Process</th>
                                    <th>Assigned Machines</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    @include('superadmin.master.viewoperators')
    @include('superadmin.master.assign_operators')

@endsection
@section('scripts')

    @stack('viewoperators_scripts')
    @yield('viewoperators_scripts')

    @stack('assign_operators_scripts')
    @yield('assign_operators_scripts')
    <script>
        const machinesSummaryTableInstance = $('#machinesSummaryTable').DataTable({
            responsive: true,
            scrollX: false,
            autoWidth: false,
            columnDefs: [
                {
                    targets: 0,
                    className: 'control',
                    orderable: false,
                    render: function(data, type, row, meta) {
                        return type === 'display' ?
                            `<span>${meta.row + 1}</span>
                            <i class="fas toggle-row-details ms-2 fa-chevron-down" data-row-index="${meta.row}"></i>` :
                            meta.row + 1;
                    }
                }
            ],
            order: [
                [1, 'asc']
            ]
        });
        const processTableInstance = $('#processTable').DataTable();
        // View Machines Modal Load
        $('#viewMachinesModal').on('show.bs.modal', function() {
            fetch("{{ route('superadmin.process.viewMachinesSummary') }}")
                .then(res => res.json())
                .then(data => {
                    machinesSummaryTableInstance.backdata = {}
                    machinesSummaryTableInstance.clear();
                    data.data.forEach((row, index) => {
                        machinesSummaryTableInstance.backdata[index] = row;
                        machinesSummaryTableInstance.row.add([
                            index + 1,
                            row.product_type.name,
                            row.name,
                            formatOperators(row.machines.map(v => v.machine_name), 3),
                            `
                            <button id="edit-process" class="btn btn-sm btn-info" 
                                data-machines="${row.machines.map(v => v.id).join(', ')}" 
                                data-process="${row.id}"
                                data-process-type="${row.product_type.id}">
                                <i class="fas fa-edit"></i> 
                            </button>
                            <button id="delete-process" class="btn btn-sm btn-danger">
                                <i class="fas fa-trash-alt"></i> 
                            </button>
                            `
                        ]);
                    });
                    machinesSummaryTableInstance.draw();
                });
        });

        $('#machinesSummaryTable').on('click', '#edit-process', function() {
            const machines = $(this).data('machines').toString().split(',').map(Number);
            const processId = $(this).data('process');
            const processTypeId = $(this).data('process-type');
            $('#viewMachinesModal .btn-close').click();
            $('#assign_machines').val(machines);
            $('#assign_machines').selectpicker('refresh');
            $('#assign_product_type_id').val(processTypeId);
            $('#assign_process_dropdown').attr('data-process', processId);
            $('#assign_product_type_id').change();
            $('#assignModal').modal('show');
        });

        $('#machinesSummaryTable').on('click', '#delete-process', function() {
            const row = $(this).closest('tr');
            const processId = row.find('#edit-process').data('process');
            if (confirm('Are you sure to delete this process?')) {
                fetch("{{ url('superadmin/processes/delete') }}/" + processId, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        }
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            row.remove();
                            alert(data.message);
                        } else {
                            alert("Error deleting process.");
                        }
                    });
            }
        });

        $('#machinesSummaryTable').on('click', '.toggle-row-details', function() {
            const rowIndex = $(this).data('row-index');
            const row = machinesSummaryTableInstance.row(rowIndex);
            const brow = machinesSummaryTableInstance.backdata[rowIndex];
            const $icon = $(this);
            if (row.child.isShown()) {
                row.child.hide();
                $icon.removeClass('fa-chevron-up').addClass('fa-chevron-down');
            } else {
                //const rowData = row.data();
                const detailsContent = `
                    <div class="row-details">
                        <h6>Machine Details</h6>
                        ${formatOperators(brow.machines.map(v=>v.machine_name),0)}
                    </div>
                `;
                row.child(detailsContent).show();
                $icon.removeClass('fa-chevron-down').addClass('fa-chevron-up');
            }
        });

        $('#assignModal').on('show.bs.modal', function(event) {
            const button = event?.relatedTarget; // Button that triggered the modal
            const assignMode = button?.dataset?.assignMode || "m2o"; // Extract mode from data
            const machinesSelect = $('#assign_machines');
            const operatorsSelect = $('#assign_operators');
            if (assignMode == "m2o") {
                operatorsSelect.parent().parent().addClass("d-none");
                operatorsSelect.removeAttr('required');
                machinesSelect.parent().parent().removeClass("d-none");
                machinesSelect.attr('required', true);
            } else {
                machinesSelect.parent().parent().addClass("d-none");
                machinesSelect.removeAttr('required');
                operatorsSelect.parent().parent().removeClass("d-none");
                operatorsSelect.attr('required', true);
            }
            // handleAssignMode(assignMode);
            console.log("Assign Mode:", assignMode);
        });

        function handleAssignMode(mode = null) {
            const modeRadios = document.querySelectorAll('input[name="assignment_mode"]');
            const machinesSelect = $('#assign_machines');
            const operatorsSelect = $('#assign_operators');

            function applyMode(mode) {
                machinesSelect.selectpicker('destroy');
                operatorsSelect.selectpicker('destroy');
                machinesSelect.val([]);
                operatorsSelect.val([]);
                if (mode === 'o2m') {
                    machinesSelect.removeAttr('multiple').attr('name', 'machines');
                    operatorsSelect.attr('multiple', true).attr('name', 'operators[]');
                } else {
                    machinesSelect.attr('multiple', true).attr('name', 'machines[]');
                    operatorsSelect.removeAttr('multiple').attr('name', 'operators');
                }

                machinesSelect.selectpicker();
                operatorsSelect.selectpicker();
                machinesSelect.cle
            }
            if (mode) {
                applyMode(mode);
            } else {
                modeRadios.forEach(radio => {
                    radio.addEventListener('change', function() {
                        if (this.checked) {
                            applyMode(this.value);
                        }
                    });
                });
                // Set default mode on page load
                // applyMode(document.querySelector('input[name="assignment_mode"]:checked')?.value);
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            handleAssignMode();
            const processModal = new bootstrap.Modal(document.getElementById('processModal'));
            const form = document.getElementById('processForm');
            const tableBody = document.querySelector('#processTable tbody');
            let deleteId = null;
            // ✅ Updated to call new API route
            function loadProcesses() {
                //processTableInstance
                fetch("{{ route('superadmin.process.api') }}")
                    .then(res => res.json())
                    .then(data => {
                        data.data.forEach((proc,index) => {
                            processTableInstance.row.add([
                                index +1,
                                proc.product_type?.name || '',
                                proc.name,
                                proc.order,
                                `
                            <button class="btn btn-sm btn-info editBtn" data-id="${proc.id}" title="Edit">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger deleteBtn" data-id="${proc.id}" title="Delete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                            `
                            ]);
                        });

                        processTableInstance.draw(); // Re-draw with new data
                    })
                    .catch(err => {
                        console.error("Error loading processes:", err);
                        alert("Failed to load process data.");
                    });
            }
            loadProcesses();
            document.getElementById('addProcessBtn').addEventListener('click', () => {
                form.reset();
                document.getElementById('process_id').value = '';
                processModal.show();
            });

            form.addEventListener('submit', function(e) {
                e.preventDefault();
                const id = document.getElementById('process_id').value;
                const formData = new FormData(this);
                if (id) formData.append('_method', 'PUT');
                console.log('Submitting form with data:', Object.fromEntries(formData.entries()));
                // ✅ Use route helper or string paths consistent with route definitions
                const url = id ?
                    `/superadmin/processes/update/${id}` :
                    "{{ route('superadmin.process.store') }}";

                fetch(url, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        },
                        body: formData
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            processModal.hide();
                            loadProcesses();
                            alert(data.message);
                        }
                    });
            });

            tableBody.addEventListener('click', function(e) {
                const editBtn = e.target.closest('.editBtn');
                const deleteBtn = e.target.closest('.deleteBtn');

                if (editBtn) {
                    const id = $(editBtn).data('id');
                    $.ajax({
                        url: "{{ url('superadmin/processes') }}/" + id,
                        type: 'GET',
                        success: function(data) {
                            $('#process_id').val(data.id);
                            $('#name').val(data.name);
                            $('#order').val(data.order);
                            $('#product_type_id').val(data.product_type_id);
                            processModal.show();
                        }
                    });
                }


                if (deleteBtn) {
                    deleteId = deleteBtn.dataset.id;
                    if (deleteId) {
                        if (confirm('Are you sure to delete?')) {
                            $.ajax({
                                url: "{{ url('superadmin/processes/delete') }}/" + deleteId,
                                type: 'DELETE',
                                data: {
                                    '_token': '{{ csrf_token() }}'
                                },
                                success: function(res) {
                                    if (res.success) {
                                        loadProcesses();
                                        alert(res.message);
                                    }
                                }
                            });
                        }
                    }

                }
            });
        });
        $('#assign_product_type_id').on('change', function() {
            const typeId = this.value;
            const selectedProcess = $('#assign_process_dropdown').data('process') || '';
            console.log("Selected Product Type ID:", typeId, "Current Process:", selectedProcess);
            fetch("{{ url('superadmin/processes/api') }}?product_type_id=" + typeId)
                .then(res => res.json())
                .then(data => {
                    const dropdown = document.getElementById('assign_process_dropdown');
                    dropdown.innerHTML = '<option value=\"\">Select process</option>';
                    data.data.forEach(proc => {
                        dropdown.innerHTML +=
                            `<option value=\"${proc.id}\" "${selectedProcess==proc.id?'checked':''}" >${proc.name}</option>`;
                    });
                    $('#assign_process_dropdown').val(selectedProcess);
                });
        });
        document.getElementById('assignForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const form = this;
            const formData = new FormData(form);
            fetch("{{ route('superadmin.process.assign') }}", {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    form.reset();
                    $('#assign_machines').selectpicker('refresh');
                    $('#assign_operators').selectpicker('refresh');
                    alert(data.message || (data.success ? "Assigned!" : "Error!"));
                    if (data.success) {
                        $('#assignModal').modal('hide');
                    }
                })
                .catch(err => {
                    console.error("Error:", err);
                    alert("An error occurred while submitting the form.");
                });
        });
    </script>
@endsection
