@extends('layouts.dashboard.superadminapp')

@section('title', 'Employee Dashboard')

@section('styles')
<style>
    .stat-card {
        border-radius: 12px;
        padding: 24px;
        color: #fff;
        transition: transform 0.2s, box-shadow 0.2s;
        position: relative;
        overflow: hidden;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }
    .stat-card .stat-icon {
        position: absolute;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 3.5rem;
        opacity: 0.3;
    }
    .stat-card .stat-value {
        font-size: 2.5rem;
        font-weight: 700;
        line-height: 1;
    }
    .stat-card .stat-label {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 5px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .stat-card .stat-info {
        font-size: 0.8rem;
        margin-top: 10px;
        opacity: 0.8;
    }
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-danger { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }

    .chart-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
    }
    .chart-card .card-header {
        border-radius: 12px 12px 0 0;
        padding: 16px 20px;
    }
    .chart-card .card-body {
        padding: 20px;
    }

    .quick-link-card {
        background: #fff;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        transition: all 0.2s;
        border: 2px solid transparent;
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(78,115,223,0.2);
    }
    .quick-link-card i {
        font-size: 2rem;
        margin-bottom: 10px;
    }
    .quick-link-card .link-title {
        font-weight: 600;
        color: #333;
    }

    .progress-stat {
        margin-bottom: 15px;
    }
    .progress-stat .progress-label {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        font-weight: 500;
    }
    .progress {
        height: 8px;
        border-radius: 4px;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Employee Dashboard</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

@php
    $attendanceRate = $totalEmployees ? round(($presentToday / $totalEmployees) * 100, 1) : 0;
    $absenceRate = $totalEmployees ? round(($absentToday / $totalEmployees) * 100, 1) : 0;
    $leaveRate = $totalEmployees ? round(($onLeaveToday / $totalEmployees) * 100, 1) : 0;
@endphp

<!-- Summary Statistics -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-primary shadow">
            <i class="fas fa-users stat-icon"></i>
            <div class="stat-value">{{ $totalEmployees }}</div>
            <div class="stat-label">Total Employees</div>
            <div class="stat-info">
                <i class="fas fa-building mr-1"></i> Across all departments
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-success shadow">
            <i class="fas fa-user-check stat-icon"></i>
            <div class="stat-value">{{ $presentToday }}</div>
            <div class="stat-label">Present Today</div>
            <div class="stat-info">
                <i class="fas fa-chart-line mr-1"></i> {{ $attendanceRate }}% attendance rate
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-danger shadow">
            <i class="fas fa-user-times stat-icon"></i>
            <div class="stat-value">{{ $absentToday }}</div>
            <div class="stat-label">Absent Today</div>
            <div class="stat-info">
                <i class="fas fa-exclamation-triangle mr-1"></i> {{ $absenceRate }}% absence rate
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-warning shadow">
            <i class="fas fa-umbrella-beach stat-icon"></i>
            <div class="stat-value">{{ $onLeaveToday }}</div>
            <div class="stat-label">On Leave</div>
            <div class="stat-info">
                <i class="fas fa-calendar-check mr-1"></i> {{ $leaveRate }}% on approved leave
            </div>
        </div>
    </div>
</div>

<!-- Attendance Overview Bar -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-chart-pie mr-2"></i> Today's Attendance Overview
        </h6>
    </div>
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="progress-stat">
                    <div class="progress-label">
                        <span><i class="fas fa-circle text-success mr-1"></i> Present</span>
                        <span>{{ $presentToday }} ({{ $attendanceRate }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-success" style="width: {{ $attendanceRate }}%"></div>
                    </div>
                </div>
                <div class="progress-stat">
                    <div class="progress-label">
                        <span><i class="fas fa-circle text-danger mr-1"></i> Absent</span>
                        <span>{{ $absentToday }} ({{ $absenceRate }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-danger" style="width: {{ $absenceRate }}%"></div>
                    </div>
                </div>
                <div class="progress-stat mb-0">
                    <div class="progress-label">
                        <span><i class="fas fa-circle text-warning mr-1"></i> On Leave</span>
                        <span>{{ $onLeaveToday }} ({{ $leaveRate }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-warning" style="width: {{ $leaveRate }}%"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-center">
                <div class="h1 font-weight-bold {{ $attendanceRate >= 80 ? 'text-success' : ($attendanceRate >= 60 ? 'text-warning' : 'text-danger') }}">
                    {{ $attendanceRate }}%
                </div>
                <p class="text-muted mb-0">Overall Attendance Rate</p>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Monthly Attendance Chart -->
    <div class="col-lg-8 mb-4">
        <div class="chart-card shadow">
            <div class="card-header" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-bar mr-2"></i> Monthly Attendance Trend ({{ date('Y') }})
                </h6>
            </div>
            <div class="card-body">
                <canvas id="attendanceChart" height="120"></canvas>
            </div>
        </div>
    </div>

    <!-- Department Distribution Chart -->
    <div class="col-lg-4 mb-4">
        <div class="chart-card shadow">
            <div class="card-header" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-sitemap mr-2"></i> Department Distribution
                </h6>
            </div>
            <div class="card-body">
                <canvas id="departmentChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Quick Links -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-link mr-2"></i> Quick Actions
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.employee.employeedetails') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-users text-primary"></i>
                        <div class="link-title">Employees</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.employee.index') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-clipboard-check text-success"></i>
                        <div class="link-title">Attendance</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.employee.employeeleave') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-calendar-minus text-warning"></i>
                        <div class="link-title">Leave</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.employee.employeepayroll') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-money-bill-wave text-info"></i>
                        <div class="link-title">Payroll</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.employee.employeedailyreport') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-file-alt text-danger"></i>
                        <div class="link-title">Daily Report</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.report.employeereport') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-chart-line text-secondary"></i>
                        <div class="link-title">Reports</div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Department Breakdown Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-building mr-2"></i> Department Breakdown
        </h6>
    </div>
    <div class="card-body p-0">
        <table class="table table-sm mb-0">
            <thead class="thead-light">
                <tr>
                    <th>Department</th>
                    <th class="text-center">Employees</th>
                    <th class="text-center">Percentage</th>
                    <th>Distribution</th>
                </tr>
            </thead>
            <tbody>
                @forelse($departmentDist as $dept => $count)
                    @php
                        $percentage = $totalEmployees > 0 ? round(($count / $totalEmployees) * 100, 1) : 0;
                    @endphp
                    <tr>
                        <td class="font-weight-bold">{{ $dept ?: 'Unassigned' }}</td>
                        <td class="text-center">
                            <span class="badge badge-primary">{{ $count }}</span>
                        </td>
                        <td class="text-center">{{ $percentage }}%</td>
                        <td>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-info" style="width: {{ $percentage }}%"></div>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No department data available</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script>
    // Pass PHP data to JS
    window.attendanceMonthly = @json($attendanceMonthly);
    window.departmentDist = @json($departmentDist);

    // Monthly Attendance Chart
    const attendanceLabels = [];
    const attendanceData = [];

    // Generate all 12 months
    for (let i = 1; i <= 12; i++) {
        attendanceLabels.push(moment(i, 'M').format('MMM'));
        attendanceData.push(window.attendanceMonthly[i] || 0);
    }

    const attendanceCtx = document.getElementById('attendanceChart').getContext('2d');
    new Chart(attendanceCtx, {
        type: 'bar',
        data: {
            labels: attendanceLabels,
            datasets: [{
                label: 'Present Employees',
                data: attendanceData,
                backgroundColor: 'rgba(78, 115, 223, 0.8)',
                borderColor: 'rgba(78, 115, 223, 1)',
                borderWidth: 1,
                borderRadius: 5,
                barThickness: 25
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: {
                    grid: { display: false }
                }
            }
        }
    });

    // Department Distribution Doughnut Chart
    const depLabels = Object.keys(window.departmentDist).map(d => d || 'Unassigned');
    const depData = Object.values(window.departmentDist);

    const departmentCtx = document.getElementById('departmentChart').getContext('2d');
    new Chart(departmentCtx, {
        type: 'doughnut',
        data: {
            labels: depLabels,
            datasets: [{
                data: depData,
                backgroundColor: [
                    '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b',
                    '#858796', '#5a5c69', '#6f42c1', '#fd7e14', '#20c9a6'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: { padding: 15, usePointStyle: true }
                }
            },
            cutout: '60%'
        }
    });

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday: 'long' });
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = now.toLocaleString('en-us', { month: 'long' });
        document.getElementById('year').textContent = now.getFullYear();
        document.querySelector('.display-time').textContent = now.toLocaleTimeString();
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
</script>
@endsection
