@extends('layouts.dashboard.managerapp')

@section('title', 'Ready to Plan')

@section('content')
<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Ready to Plan</h1>
    <p class="mb-4">Select an Approved Sales Order to create a Production Plan.</p>

    <div class="card shadow border-0 rounded-3">
        <div class="card-header bg-white py-3 d-flex align-items-center justify-content-between border-bottom">
            <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-clipboard-list me-2"></i> Unplanned Sales Orders</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="bg-light text-secondary text-uppercase small fw-bold">
                        <tr>
                            <th class="py-3 ps-4">Order No</th>
                            <th class="py-3">Customer</th>
                            <th class="py-3">Order Date</th>
                            <th class="py-3">Total Amount</th>
                            <th class="py-3 text-end pe-4">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($orders as $order)
                        <tr>
                            <td class="ps-4 fw-bold text-dark">{{ $order->sales_order_no }}</td>
                            <td>{{ $order->customer->company_name ?? '-' }}</td>
                            <td>{{ $order->order_date }}</td>
                            <td>{{ $order->grand_total }}</td>
                            <td class="text-end pe-4">
                                <a href="{{ route('manager.routecard.routecardorder', ['order_no' => $order->sales_order_no]) }}" class="btn btn-primary btn-sm rounded-pill px-3 shadow-sm">
                                    <i class="fas fa-magic me-1"></i> Create Plan
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center py-5 text-muted">
                                <i class="fas fa-box-open fa-3x mb-3 text-gray-300"></i><br>
                                No unplanned approved orders found.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
