@extends('layouts.dashboard.managerapp')

@section('title', 'Employee Calendar')

@section('content')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>

<style>
    .fc-day-sun {
        background-color: #ffe5e5 !important;
    }
    .summary .card {
        padding: 10px 15px;
        margin-bottom: 10px;
        border-left: 5px solid #0d6efd;
        background: #f8f9fa;
        border-radius: 4px;
    }
    .summary .card span {
        font-weight: bold;
        float: right;
        color: #333;
    }
</style>

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-primary">UEPL / Employee Monthly Summary</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Content Row -->
<div class="row">
    <div class="col-lg-12">
        <div class="row">
            <div class="col-lg-8">
                <div class="row g-2">
                    <div class="col-lg-5">
                        <label for="month-year">Select Month:</label>
                        <input type="month" id="month-year" name="monthYear" class="form-control" onchange="createCalendar()" required>
                    </div>
                    <div class="col-lg-5">
                        <label for="employee_name">Select Employee:</label>
                        <select id="employee_name" name="employee_name" class="form-control" onchange="createCalendar()">
                            <option value="">-- Select --</option>
                            @foreach($employees as $emp)
                                <option value="{{ $emp->employee_id }}">{{ $emp->name }} ({{ $emp->employee_id }})</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <br>
                <div id="calendar" class="calendar border rounded shadow-sm p-2"></div>
                <br>
            </div>

            <div class="col-lg-4">
                <h5 class="text-primary mb-3">Summary</h5>
                <div class="summary">
                    <div class="card">Days Worked: <span id="days-worked">0</span></div>
                    <div class="card">Sundays Eligible: <span id="sundays-eligible">0</span></div>
                    <div class="card">Holidays: <span id="holiday-count">0</span></div>
                    <div class="card">Earned Leaves: <span id="earned-leave">0</span></div>
                    <div class="card">Leave Enjoyed: <span id="enjoy-leave-count">0</span></div>
                    <div class="card">Balance Leave: <span id="balance-leave-count">0</span></div>
                    <div class="card">Total Paid Days: <span id="total-paid-days">0</span></div>
                    <div class="card">Absent Days: <span id="absent-count">0</span></div>
                    <div class="card">1st Shifts: <span id="first-shift-count">0</span></div>
                    <div class="card">Night Shifts: <span id="night-shift-count">0</span></div>
                    <div class="card">OT Hours: <span id="ot-hours">0</span></div>
                    <div class="card">Shortage Hours: <span id="shortage-hours">0</span></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const calendarEl = document.getElementById('calendar');
    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        height: 500,
        dayCellDidMount: function(info) {
            if (info.date.getDay() === 0) {
                info.el.style.backgroundColor = '#ffe5e5';
            }
        },
        events: []
    });
    calendar.render();

    window.createCalendar = function () {
        const employeeId = document.getElementById('employee_name').value;
        const monthYear = document.getElementById('month-year').value;
        if (!employeeId || !monthYear) return;

        fetch(`{{ url('manager/employeedailyreport/calendar') }}/${employeeId}/${monthYear}`)
            .then(res => res.json())
            .then(data => {
                calendar.removeAllEvents();
                data.days.forEach(day => {
                    calendar.addEvent({
                        title: day.status,
                        start: day.date,
                        color: getColor(day.status)
                    });
                });

                const summaryMap = {
                    'days_worked': 'days-worked',
                    'sundays_eligible': 'sundays-eligible',
                    'holiday_count': 'holiday-count',
                    'earned_leave': 'earned-leave',
                    'enjoy_leave_count': 'enjoy-leave-count',
                    'balance_leave_count': 'balance-leave-count',
                    'total_paid_days': 'total-paid-days',
                    'absent_count': 'absent-count',
                    'first_shift_count': 'first-shift-count',
                    'night_shift_count': 'night-shift-count',
                    'ot_hours': 'ot-hours',
                    'shortage_hours': 'shortage-hours'
                };

                for (const key in data.summary) {
                    const el = document.getElementById(summaryMap[key]);
                    if (el) el.textContent = data.summary[key] ?? '0';
                }
            });
    }

    function getColor(status) {
        switch (status) {
            case 'Present': return '#28a745';
            case 'Absent': return '#dc3545';
            case 'Leave': return '#ffc107';
            default: return '#6c757d';
        }
    }
});
</script>
@endsection