@extends('layouts.dashboard.adminapp')

@section('title', 'Sales Order List')

@section('styles')
    <!-- DataTables Bootstrap 5 styling for buttons -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
    <style>
        div.dt-buttons {
            float: left;
            display: flex !important;
            margin-bottom: 1rem;
        }

        .dataTable {
            overflow-x: auto !important;
            display: table !important;
        }

        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }

        .btn-delete {
            min-width: 80px;
        }

        .page-header-icon {
            font-size: 2rem;
            color: #506690;
            vertical-align: middle;
        }
        .btn-delete {
    min-width: auto !important;
}
    </style>
@endsection

@section('content')
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="p-2 d-sm-flex align-items-center justify-content-between mb-4 border-bottom bg-white">
            <h1 class="h5 mb-0 text-gray-800 d-flex align-items-center">
                UEPL | Sales Order List
            </h1>
            <div class="display-date">
                <span id="day">day</span>,
                <span id="daynum">00</span>
                <span id="month">month</span>
                <span id="year">0000</span>
            </div>
            <div class="display-time"></div>
        </div>

        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card mb-5">
                   
                    <div class="card-header d-flex align-items-center justify-content-between" style="float: left;flex-direction: row-reverse;">
                        <a href="{{ route('admin.sales.salesorder') }}" class="btn btn-primary btn-sm"
                            style="float: right; margin-right: 10px;" title="Add Sales Order">
                            <i class="fa fa-plus-square me-1"></i> 
                        </a>
                </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle" id="salesOrderTable"
                                style="width:100%">
                                <thead class="align-middle">
                                    <tr>
                                        <th>ID</th>
                                        <th>Sales Order No.</th>
                                        <th>Date</th>
                                        <th>Company Name</th>
                                        <th>Grand Total</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($orders as $order)
                                        <tr id="row-{{ $order->id }}">
                                            <td>{{ $order->id }}</td>
                                            <td>{{ $order->sales_order_no }}</td>
                                            <td>{{ \Carbon\Carbon::parse($order->sales_order_date)->format('d M Y') }}</td>
                                            <td>{{ $order->customer ? $order->customer->company : '-' }}</td>
                                            <td>₹{{ number_format($order->grand_total, 2) }}</td>
                                            <td>
                                                @if ($order->status === 'Active' || $order->status == 1)
                                                    <span class="badge bg-success text-white">Active</span>
                                                @else
                                                    <span
                                                        class="badge bg-secondary text-white">{{ $order->status ?? 'Inactive' }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.sales.order.show', $order->id) }}"
                                                    class="btn btn-info btn-sm me-1" title="View">
                                                    <i class="fa fa-eye"></i> 
                                                </a>
                                                <a href="{{ route('admin.sales.order.print', $order->id) }}"
                                                    class="btn btn-secondary btn-sm me-1" target="_blank" title="Print PDF">
                                                    <i class="fa fa-print"></i> 
                                                </a>
                                                <a href="{{ route('admin.sales.order.edit', $order->id) }}"
                                                    class="btn btn-warning btn-sm me-1" title="Edit">
                                                    <i class="fa fa-edit"></i> 
                                                </a>
                                                <button class="btn btn-danger btn-sm btn-delete delete-btn"
                                                    data-id="{{ $order->id }}" title="Delete">
                                                    <i class="fa fa-trash"></i> 
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div> <!-- .table-responsive -->
                    </div> <!-- .card-body -->
                </div> <!-- .card -->
            </div> <!-- .col -->
        </div> <!-- .row -->
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#salesOrderTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                pageLength: 10,
                responsive: true,
                language: {
                    "emptyTable": "No sales orders found"
                }
            });

            // Handle Delete Button Click
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                if (confirm('Are you sure you want to delete this Sales Order?')) {
                    $.ajax({
                        url: '{{ url("/admin/sales/order") }}/' + id,
                        type: 'DELETE',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            table.row('#row-' + id).remove().draw(false);
                            toastr.success(response.message || "Deleted successfully");
                        },
                        error: function(xhr) {
                            toastr.error("Failed to delete sales order.");
                        }
                    });
                }
            });
        });
    </script>
@endsection
