@extends('layouts.dashboard.superadminapp')

@section('title', 'Receivable Details - ' . $invoice->invoice_no)

@section('styles')
<style>
    .detail-card { border-left: 4px solid #4e73df; }
    .payment-card { border-left: 4px solid #1cc88a; }
    .history-card { border-left: 4px solid #36b9cc; }
    .detail-row { padding: 8px 0; border-bottom: 1px solid #e3e6f0; }
    .detail-row:last-child { border-bottom: none; }
    .detail-label { font-weight: 600; color: #858796; font-size: 0.8rem; text-transform: uppercase; }
    .detail-value { color: #5a5c69; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">
        <a href="{{ route('superadmin.accounts.receivable.index') }}" class="text-decoration-none">
            <i class="fas fa-arrow-left mr-2"></i>
        </a>
        Invoice: {{ $invoice->invoice_no }}
    </h1>
    @php
        $status = $balance <= 0 ? 'paid' : ($totalPaid > 0 ? 'partial' : 'pending');
    @endphp
    <span class="badge badge-{{ $status == 'paid' ? 'success' : ($status == 'partial' ? 'info' : 'warning') }} px-3 py-2" style="font-size: 1rem;">
        {{ ucfirst($status) }}
    </span>
</div>

<div class="row">
    <!-- Invoice Details -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow detail-card">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-file-invoice mr-2"></i> Invoice Details
                </h6>
            </div>
            <div class="card-body">
                <div class="detail-row">
                    <div class="detail-label">Invoice Number</div>
                    <div class="detail-value">{{ $invoice->invoice_no }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Invoice Date</div>
                    <div class="detail-value">{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d M Y') }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Buyer Order No</div>
                    <div class="detail-value">{{ $invoice->buyer_order_no ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Payment Terms</div>
                    <div class="detail-value">{{ $invoice->terms_payment ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Delivery Note</div>
                    <div class="detail-value">{{ $invoice->delivery_note ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Customer Details -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-user mr-2"></i> Customer Details
                </h6>
            </div>
            <div class="card-body">
                <div class="detail-row">
                    <div class="detail-label">Customer Name</div>
                    <div class="detail-value">{{ $invoice->company->company_name ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Phone</div>
                    <div class="detail-value">{{ $invoice->phone ?? $invoice->company->phone ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Email</div>
                    <div class="detail-value">{{ $invoice->email ?? $invoice->company->email ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">GSTN</div>
                    <div class="detail-value">{{ $invoice->gst ?? $invoice->company->gstn ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Address</div>
                    <div class="detail-value">{{ $invoice->address ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Amount Summary & Payment Form -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-calculator mr-2"></i> Amount Summary
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-sm mb-0">
                    <tr>
                        <td>Taxable Value</td>
                        <td class="text-right">₹{{ number_format($invoice->taxable_value ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>SGST</td>
                        <td class="text-right">₹{{ number_format($invoice->sgst ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>CGST</td>
                        <td class="text-right">₹{{ number_format($invoice->cgst ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>IGST</td>
                        <td class="text-right">₹{{ number_format($invoice->igst ?? 0, 2) }}</td>
                    </tr>
                    <tr class="font-weight-bold" style="background-color: #f8f9fc;">
                        <td>Total Amount</td>
                        <td class="text-right">₹{{ number_format($invoice->total_amount ?? 0, 2) }}</td>
                    </tr>
                    <tr class="text-success">
                        <td>Amount Received</td>
                        <td class="text-right">₹{{ number_format($totalPaid, 2) }}</td>
                    </tr>
                    <tr class="font-weight-bold text-danger">
                        <td>Balance Due</td>
                        <td class="text-right">₹{{ number_format($balance, 2) }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    @if($balance > 0)
    <div class="col-lg-6 mb-4">
        <div class="card shadow payment-card">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-money-bill-wave mr-2"></i> Record Payment
                </h6>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if(session('error'))
                    <div class="alert alert-danger">{{ session('error') }}</div>
                @endif
                
                <form method="POST" action="{{ route('superadmin.accounts.receivable.payment', $invoice->id) }}">
                    @csrf
                    <div class="form-group">
                        <label class="font-weight-bold">Payment Amount (₹) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="payment_amount" class="form-control" 
                               max="{{ $balance }}" placeholder="Enter amount" required>
                        <small class="text-muted">Max: ₹{{ number_format($balance, 2) }}</small>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Payment Date <span class="text-danger">*</span></label>
                        <input type="date" name="payment_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Payment Method</label>
                        <select name="payment_method" class="form-control">
                            <option value="">Select Method</option>
                            <option value="Cash">Cash</option>
                            <option value="Cheque">Cheque</option>
                            <option value="Bank Transfer">Bank Transfer</option>
                            <option value="UPI">UPI</option>
                            <option value="NEFT/RTGS">NEFT/RTGS</option>
                            <option value="Credit Card">Credit Card</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Reference No</label>
                        <input type="text" name="reference_no" class="form-control" placeholder="Transaction/Cheque No">
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" placeholder="Optional notes"></textarea>
                    </div>
                    <button type="submit" class="btn btn-success btn-block">
                        <i class="fas fa-check mr-2"></i> Record Payment
                    </button>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>

<!-- Payment History -->
@if($paymentHistory->count() > 0)
<div class="card shadow mb-4 history-card">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-history mr-2"></i> Payment History
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="thead-light">
                    <tr>
                        <th>Payment No</th>
                        <th>Date</th>
                        <th>Method</th>
                        <th>Reference</th>
                        <th class="text-right">Amount</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($paymentHistory as $payment)
                        <tr>
                            <td class="font-weight-bold">{{ $payment->payment_no }}</td>
                            <td>{{ \Carbon\Carbon::parse($payment->payment_date)->format('d M Y') }}</td>
                            <td>{{ $payment->payment_method ?? '-' }}</td>
                            <td>{{ $payment->reference_no ?? '-' }}</td>
                            <td class="text-right text-success font-weight-bold">₹{{ number_format($payment->payment_amount, 2) }}</td>
                            <td>{{ $payment->notes ?? '-' }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot class="font-weight-bold" style="background-color: #f8f9fc;">
                    <tr>
                        <td colspan="4" class="text-right">Total Received:</td>
                        <td class="text-right text-success">₹{{ number_format($totalPaid, 2) }}</td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endif

<!-- Invoice Items -->
@if($invoice->items && $invoice->items->count() > 0)
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #858796 0%, #5a5c69 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-list mr-2"></i> Invoice Items
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <th>Description</th>
                        <th>HSN/SAC</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Rate</th>
                        <th class="text-right">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoice->items as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item->description ?? $item->item_name ?? 'N/A' }}</td>
                            <td>{{ $item->hsn_code ?? '-' }}</td>
                            <td class="text-right">{{ $item->quantity ?? 0 }}</td>
                            <td class="text-right">₹{{ number_format($item->rate ?? $item->unit_price ?? 0, 2) }}</td>
                            <td class="text-right">₹{{ number_format($item->amount ?? 0, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

@endsection
