<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DailyAttendanceReport extends Model
{
    use HasFactory;

    protected $table = 'daily_attendance_reports';

    protected $fillable = [
        'attendance_date',
        'employee_id',
        'employee_name',
        'shift',
        'in_spfid_1',
        'out_spfid_1',
        'in_spfid_2',
        'out_spfid_2',
        'first_half',
        'second_half',
        'late_in',
        'early_out',
        'hourly_paid_leave',
        'hourly_unpaid_leave',
        'over_time',
        'auth_ot',
        'auth_coff',
        'work_hours',
        'man_entry',
        'reason',
    ];

    protected $casts = [
        'attendance_date' => 'date',
    ];
}
