<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContactPerson extends Model
{
    use HasFactory;
    
    protected $table = "contact_persons";

    protected $fillable = [
        'customer_vendor_id', 'name', 'email', 'mobile', 'designation'
    ];

    public function customerVendor()
    {
        return $this->belongsTo(CustomerVendor::class, 'customer_vendor_id');
    }
}

