<?php

if (!function_exists('getColumnLabel')) {
    function getColumnLabel($index)
    {
        $columns = [
            'Employee Name',
            'Employee ID',
            'Gender',
            'Date of Birth',
            'Date of Joining',
            'Department',
            'Designation',
            'Days Worked',
            'Sundays Eligible',
            'Holidays',
            'Leave Enjoyed',
            'Total Paid Days',
            'Absent',
            '1st Shifts',
            'Night Shifts',
            'OT Hours',
            'Shortage Hours',
            'Actions'
        ];

        return $columns[$index] ?? "Column {$index}";
    }
}

function nextNumber($prefix, $table, $column, $numIndex = 2)
{
    $maxNumber = \Illuminate\Support\Facades\DB::table($table)->max($column);
    if ($maxNumber) {
        $number = explode('/', $maxNumber);
        $number = intval($number[$numIndex]) + 1;
        return $prefix . '/' . str_pad($number, 4, '0', STR_PAD_LEFT);
    }
    return $prefix . '/0001';
}

function formateDate($date, $format = 'Y-m-d')
{
    return date($format, strtotime($date));
}

function numberToWords($num) {
    $ones = ["", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"];
    $teens = ["", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen",
        "Nineteen"
    ];
    $tens = ["", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"];
    $higherUnits = ["", "Thousand", "Lakh", "Crore"];

    if (is_nan($num) || $num === 0) return 'Zero';

    $word = '';

    $processHundred = function($number) use ($ones, $teens, $tens) {
        $result = '';
        if ($number > 99) {
            $result .= $ones[floor($number / 100)] . ' Hundred ';
            $number %= 100;
        }
        if ($number > 10 && $number < 20) {
            $result .= $teens[$number - 10] . ' ';
        } else {
            $result .= $tens[floor($number / 10)] . ' ';
            $result .= $ones[$number % 10] . ' ';
        }
        return trim($result);
    };

    // Process the number in pairs for Indian format (thousands, lakhs, crores)
    $crorePart = floor($num / 10000000);
    $lakhPart = floor(($num % 10000000) / 100000);
    $thousandPart = floor(($num % 100000) / 1000);
    $hundredPart = $num % 1000;

    if ($crorePart > 0) {
        $word .= $processHundred($crorePart) . ' Crore ';
    }
    if ($lakhPart > 0) {
        $word .= $processHundred($lakhPart) . ' Lakh ';
    }
    if ($thousandPart > 0) {
        $word .= $processHundred($thousandPart) . ' Thousand ';
    }
    if ($hundredPart > 0) {
        $word .= $processHundred($hundredPart) . ' Only';
    }

    return trim($word);
}