@extends('layouts.dashboard.superadminapp')

@section('title', 'Purchase Quotations List')

@section('content')
    <style>
        div.dt-buttons {
            float: left;
            display: flex !important;
            margin-bottom: 1rem;
        }

        .dataTable {
            overflow-x: auto !important;
            display: table !important;
        }

        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }

        .btn-delete {
            min-width: 80px;
        }

        .page-header-icon {
            font-size: 2rem;
            color: #506690;
            vertical-align: middle;
        }
    </style>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800 pl-2">UEPL | Purchase Quotations</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Table Section -->
    <div class="card shadow mb-4">
        <div class="card-header">
            <div class="mb-3">
                <a href="{{ route('superadminv1.purchasequotation.index') }}" class="btn btn-primary btn-sm ms-2"
                    style="float: right" title="Create New">
                    <i class="fa fa-plus-square" aria-hidden="true"></i>
                </a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered align-middle" id="quotationsTable" width="100%" cellspacing="0">
                    <thead class="table-light">
                        <tr class="text-center">
                            <th>ID</th>
                            <th>Quotation No</th>
                            <th>Vendor</th>
                            <th>Date</th>
                            <th>Items</th>
                            <th>Grand Total</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($quotations as $quotation)
                            <tr id="row-{{ $quotation->id }}">
                                <td>{{ $quotation->id }}</td>
                                <td>{{ $quotation->quotation_no }}</td>
                                <td>{{ $quotation->vendor_name }}</td>
                                <td>{{ $quotation->quotation_date }}</td>
                                <td>{{ $quotation->items_count ?? $quotation->items->count() }}</td>
                                <td>{{ $quotation->grand_total }}</td>
                                <td>{{ $quotation -> status}}</td>
                                <td class="text-center">
                                    <!--<a href="{{ route('superadminv1.purchasequotation.print', $quotation->id) }}"-->
                                    <!--    class="btn btn-success btn-sm rfq-back-btn" target="_blank">-->
                                    <!--    <i class="fa fa-print" title="Print"></i>-->
                                    <!--</a>-->
                                    <a href="{{ route('superadminv1.purchasequotation.show', $quotation->id) }}"
                                        class="btn btn-info btn-sm btn-action" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadminv1.purchasequotation.index', ['id' => $quotation->id]) }}"
                                        class="btn btn-warning btn-sm me-1 btn-action" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <button class="btn btn-danger btn-sm btn-action delete-btn"
                                        data-id="{{ $quotation->id }}" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                    @if ($quotation->status === 'pending')
                                        <a href="{{ route('superadminv1.purchasequotation.approve', $quotation->id) }}"
                                            class="btn btn-success btn-sm btn-action approve-btn"
                                            data-id="{{ $quotation->id }}" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </a>
                                        <a href="{{ route('superadminv1.purchasequotation.reject', $quotation->id) }}"
                                            class="btn btn-danger btn-sm btn-action reject-btn"
                                            data-id="{{ $quotation->id }}" title="Reject">
                                            <i class="fa fa-times"></i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No quotations found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            $('#quotationsTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                pageLength: 10,
                ordering: true,
                searching: true,
                responsive: true,
            });

            // Delete Quotation with SweetAlert2 confirm
          $(document).on('click', '.delete-btn', function() {
    var id = $(this).data('id');
    Swal.fire({
        title: 'Are you sure?',
        text: "You want to delete this quotation!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, Delete!',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
               url: "{{ url('superadmin/v1/purchasequotation/destroy') }}/" + id,
                type: 'DELETE',
                data: {
                    _token: "{{ csrf_token() }}",
                    _method: 'DELETE'
                },
                success: function(response) {
                    $('#row-' + id).fadeOut(500, function() {
                        $(this).remove();
                    });
                    Swal.fire('Deleted!', 'Quotation deleted successfully.', 'success');
                },
                error: function(xhr) {
                    Swal.fire('Error', 'Error occurred while deleting.', 'error');
                    console.error(xhr.responseText);
                }
            });
        }
    });
});
});
    </script>
@endsection
