@extends('layouts.dashboard.superadminapp')

@section('title', isset($quotation) ? 'Edit Purchase Quotation' : 'Create Purchase Quotation')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <!-- <div class="card purchase-quotation-form"> -->
    <!-- <div class="card-header d-flex justify-content-between align-items-center">
                <h1 class="h5 mb-0">{{ isset($quotation) ? 'Edit' : 'Create' }} Purchase Quotation</h1>
                <a href="{{ route('superadminv1.purchasequotation.list') }}" class="btn btn-secondary">Back to List</a>
            </div> -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | Purchase Quotation</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>
    <div class="row bg-white">
        <div class="col-lg-12">
            <h1 class="pt-5 pb-5">Purchase Quotation</h1>
            <form id="quotationContent" method="POST"
                action="{{ isset($quotation) ? route('superadminv1.purchasequotation.update', $quotation->id) : route('superadminv1.purchasequotation.store') }}"
                enctype="multipart/form-data">
                @csrf
                @if (isset($quotation))
                    @method('PUT')
                @endif
                <div class="row">
                    <div class="col-md-6">
                        <label for="rfqNo">RFQ No</label>
                        @if (isset($quotation))
                            <input type="text" class="form-control" value="{{ $quotation->rfq_no }}" readonly>
                            <input type="hidden" name="rfq_no" value="{{ $quotation->rfq_no }}">
                        @else
                            <select name="rfq_no" id="rfqNo" class="form-control" onchange="getRfqDetails(this)">
                                <option value="">Select RFQ</option>
                                @foreach ($purchaseRfqs as $rfq)
                                    <option value="{{ $rfq->rfq_no }}"
                                        data-rfq='{{ json_encode([
                                            ...$rfq->toArray(),
                                            'vendor' => [
                                                'company' => $rfq->vendor->company ?? '',
                                                'billing_address' => $rfq->vendor->billing_address ?? '',
                                                'gstno' => $rfq->vendor->gstno ?? '',
                                                'mobile' => $rfq->vendor->mobile ?? '',
                                                'email' => $rfq->vendor->email ?? '',
                                            ],
                                        ]) }}'>
                                        {{ $rfq->rfq_no }}
                                    </option>
                                @endforeach
                            </select>
                        @endif
                    </div>
                    <div class="col-md-6">
                        <label for="vendorName">Vendors Name <span class="required" title="required">*</span></label>

                        <input type="text" id="vendorName" name="vendor_name" class="form-control"
                            value="{{ old('vendor_name', $quotation->vendor_name ?? '') }}" required>
                            
                        <input type="hidden" name="vendor_id" id="vendorId"
                            value="{{ old('vendor_id', $quotation->vendor_id?? '') }}">
                    </div>
                </div><br>
                <div class="row">
                    <div class="col-md-6">
                        <label for="address">Address</label>
                        <textarea id="address" name="address" class="form-control" rows="1">{{ old('address', $quotation->address ?? '') }}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label for="rfqDate">RFQ Date</label>
                        <input type="date" id="rfqDate" name="rfq_date" class="form-control"
                            value="{{ formateDate(old('rfq_date', isset($quotation) ? $quotation->rfq_date : '')) }}">
                    </div>
                </div><br>
                <div class="row">
                    <div class="col-md-6">
                        <label for="gst">GST</label>
                        <input type="text" id="gst" name="gst" class="form-control"
                            value="{{ old('gst', $quotation->gst ?? '') }}">
                    </div>
                    <div class="col-md-6">
                        <label for="quotationNo">Quotation ID</label>
                        <input type="text" id="quotationNo" name="quotation_no" class="form-control"
                            value="{{ old('quotation_no', isset($quotation) ? $quotation->quotation_no : $newQuotationNo ?? '') }}"
                            readonly>
                    </div>
                </div><br>
                <div class="row">
                    {{-- Vendor Reference No --}}
                    <div class="col-md-6">
                        <label for="vendorReferenceNo">Vendor Reference No</label>
                        <input type="text" id="vendorReferenceNo" name="vendor_reference_no" class="form-control"
                            value="{{ old('vendor_reference_no', $quotation->vendor_reference_no ?? '') }}">
                    </div>
                    <div class="col-md-6">
                        <label>Vendor Quotations</label>
                        <input type="file" id="vendorqtFiles" name="vendorqtFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="vendorqtFiles_preview" class="mt-2">
                            @if(isset($quotation) && $quotation->files->count())
                                <div class="row">
                                    @foreach($quotation->files as $file)
                                        <div class="col-md-6 mb-2" id="file-preview-{{ $file->id }}">
                                            @if(Str::endsWith($file->file_path, ['.jpg', '.jpeg', '.png']))
                                                <img src="{{ asset('storage/' . $file->file_path) }}" alt="{{ $file->file_name }}" class="img-thumbnail" style="max-height: 150px;">
                                            @elseif(Str::endsWith($file->file_path, ['.pdf']))
                                                <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank" style=color:blue;>{{ $file->file_name }}</a>
                                            @else
                                                {{ $file->file_name }}
                                            @endif
                    
                                            <button type="button" class="btn btn-sm btn-danger mt-1" onclick="deleteFile({{ $file->id }})">Delete</button>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>

                </div><br>
                <div class="row">
                    <div class="col-md-6">
                        <label for="phone">Contact Number</label>
                        <input type="tel" id="phone" name="phone" class="form-control"
                            value="{{ old('phone', $quotation->phone ?? '') }}">
                    </div>
                    <div class="col-md-6">
                        <label for="quotationDate">Quotation Date <span class="required"
                                title="required">*</span></label>
                        <input type="date" id="quotationDate" name="quotation_date" class="form-control"
                            value="{{ formateDate(old('quotation_date', isset($quotation) ? $quotation->quotation_date : date('Y-m-d'))) }}"
                            required>
                    </div>
                </div><br>
                <div class="row">
                    <div class="col-md-6">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" class="form-control"
                            value="{{ old('email', $quotation->email ?? '') }}">
                    </div>
                    <div class="col-md-6">
                        <label for="deliveryTerms">Delivery Terms</label>
                        <input type="text" id="deliveryTerms" name="delivery_terms" class="form-control"
                            value="{{ old('delivery_terms', $quotation->delivery_terms ?? ($quotation->rfq->delivery_terms ?? '')) }}">
                    </div>
                </div><br>

                <div class="row d-none">
                    <div class="col-md-6">
                        <label for="quantity">Quantity</label>
                        <input type="number" id="quantity" name="quantity" class="form-control"
                            value="{{ old('quantity', $quotation->quantity ?? '') }}">
                    </div>
                    <div class="col-md-6">
                        <label for="quantityUOM">Unit of Measurement</label>
                        <input type="text" id="quantityUOM" name="quantity_uom" class="form-control"
                            value="{{ old('quantity_uom', $quotation->quantity_uom ?? '') }}">
                    </div>
                </div><br>
                <div class="row">
                    <div class="col-md-6">
                        <label for="note">Note</label>
                        <textarea name="note" id="note" class="form-control">{{ old('note', $quotation->note ?? '') }}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" class="form-control" rows="2">{{ old('description', $quotation->description ?? '') }}</textarea>
                    </div>
                </div><br>
                <div class="row">
                    <div class="col-md-6">
                        <label for="additionalCharges">Additional Charges</label>
                        <input type="number" id="additionalCharges" name="additional_charges" class="form-control"
                            value="{{ old('additional_charges', $quotation->additional_charges ?? '0.00') }}"
                            oninput="calculateTotals()">
                    </div>
                </div><br>
                <hr>
                @include('v1.purchasequotation.poitems', [
                    'items' => old('items', isset($quotation) ? $quotation->items : []),
                ])
                <div class="row px-5 py-4">
                    <div class="btn pt-5 pb-5">
                        <button class="btn btn-success" type="submit">{{ isset($quotation) ? 'Update' : 'Save' }}
                            Quotation</button>
                    </div>
                    <div class="btn pt-5 pb-5">
                        <button class="btn btn-danger" type="reset">Clear</button>
                    </div>
                </div>
                <input type="hidden" name="inr_in_words" id="inr_in_words" value="">
            </form>
            
            <!-- Add Item Modal -->
            @include('v1.purchasequotation.poitemmodal')
        </div>

    @endsection

    @section('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const input = document.getElementById('vendorqtFiles');
            
                if (input) {
                    input.addEventListener('change', function (event) {
                        const previewContainer = document.getElementById('vendorqtFiles_preview');
                        previewContainer.innerHTML = ''; // Clear previous previews
            
                        const files = event.target.files;
                        if (files.length > 0) {
                            Array.from(files).forEach(file => {
                                const fileType = file.type;
                                if (fileType.startsWith('image/')) {
                                    const reader = new FileReader();
                                    reader.onload = function (e) {
                                        const img = document.createElement('img');
                                        img.src = e.target.result;
                                        img.style.maxWidth = '150px';
                                        img.style.marginRight = '10px';
                                        img.classList.add('img-thumbnail', 'mb-2');
                                        previewContainer.appendChild(img);
                                    };
                                    reader.readAsDataURL(file);
                                } else {
                                    const link = document.createElement('a');
                                    link.href = URL.createObjectURL(file);
                                    link.target = '_blank';
                                    link.textContent = file.name;
                                    link.classList.add('d-block', 'mb-1', 'text-primary');
                                    previewContainer.appendChild(link);
                                }
                            });
                        }
                    });
                }
            });
            

            const rfqItems = {{ json_encode($quotation->items ?? []) }};
            function getRfqDetails(select) {
                const rfq = JSON.parse(select.options[select.selectedIndex].dataset.rfq);

                document.getElementById('rfqDate').value = rfq.rfq_date;
                document.getElementById('vendorReferenceNo').value = rfq.vendor_reference_no;
                document.getElementById('deliveryTerms').value = rfq.delivery_terms;
                document.getElementById('quantity').value = rfq.quantity;
                document.getElementById('quantityUOM').value = rfq.uom;
                document.getElementById('note').value = rfq.note;
                document.getElementById('description').value = rfq.description;
                document.getElementById('rfqNo').value = rfq.rfq_no;

                // Vendor info from RFQ
                document.getElementById('vendorName').value = rfq.vendor.company || '';
                document.getElementById('vendorId').value = rfq.vendor_id || '';
                document.getElementById('address').value = rfq.vendor.billing_address || '';
                document.getElementById('gst').value = rfq.vendor.gstno || '';
                document.getElementById('phone').value = rfq.vendor.mobile || '';
                document.getElementById('email').value = rfq.vendor.email || '';
                console.log({rfq,rfqItems});

                if(rfq.items.length > 0 && rfqItems.length == 0) {
                    rfq.items.forEach((item,index) => {
                        const row = {
                            rowCount:index+1,
                            stockItem:item.stock_item?.id || item.stock_item_id || '',
                            stockItemName:item.stock_item?.item_name || 'Item ' + (index+1),
                            description:item.description,
                            quantity:item.quantity,
                            uom:item.uom,
                            supplyLeadTime:"",
                            unitRate:0,
                            tds:0,
                            discount:0,
                            sgst:item.stock_item?.sgst || '0',
                            cgst:item.stock_item?.cgst || '0',
                            igst:item.stock_item?.igst || '0',
                            amount:0,
                            value:0
                        };
                        const event = new CustomEvent('row-added', { detail: row });
                        document.getElementById('pqoItems').dispatchEvent(event);
                    });
                }
            }
        </script>
        <script>
            function deleteFile(fileId) {
                if (!confirm("Are you sure you want to delete this file?")) return;
        
                fetch("{{ route('superadminv1.purchasequotation.delete-file') }}", {
                    method: "POST",
                    headers: {
                        "X-CSRF-TOKEN": "{{ csrf_token() }}",
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify({ id: fileId })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const el = document.getElementById('file-preview-' + fileId);
                        if (el) el.remove();
                    } else {
                        alert("Failed to delete file.");
                    }
                })
                .catch(() => alert("An error occurred while deleting the file."));
            }
        </script>


    @endsection
