<!-- Purchase Orders Tab -->
<div class="table-responsive">
    <table id="purchaseInvoiceTable" class="table table-bordered table-striped w-100" >
        <thead>
            <tr>
                <th>Vendor Invoice No</th>
                <th>Purchase No</th>
                <th>Purchase Date</th>
                <th>Vendor</th>
                <th>Age</th>
                <th>Payment Status</th>
                <th>Items</th>
                <th>Subtotal</th>
                <th>Total Invoice Amount</th>
                <th>Total Paid Amount</th>
                <th>Total Balance Amount</th>
                <th>Status</th>
                <th>Action</th>
                <th>Files</th>
            </tr>
        </thead>
        <tbody>
            @if (isset($list) && $list->count() > 0)
                @foreach ($list as $item)
                    <tr>
                        <td>{{ $item->vendor_invoice_no ?? '-' }}</td>
                        <td>{{ $item->purchase_no ?? '-' }}</td>
                        <td>{{ $item->purchase_date ? \Carbon\Carbon::parse($item->purchase_date)->format('d/m/Y') : '-' }}
                        </td>
                        <td>{{ $item->company_name ?? '-' }}</td>
                        <td>
                            @php
                                $age = $item->purchase_date ? \Carbon\Carbon::parse($item->purchase_date)->diffInDays(now()) : 0;
                                $age = $age < 0 ? 0 : ceil($age);
                            @endphp
                            {{ $age }} days
                        </td>
                        <td>{{ ucfirst($item->payment_status ?? 'unpaid') }}</td>
                        <td>{{ $item->items->count() ?? 0 }}</td>
                        <td>₹{{ number_format($item->subtotal ?? 0, 2) }}</td>
                        <td>₹{{ number_format($item->grand_total ?? 0, 2) }}</td>
                        <td>₹{{ number_format($item->paid_amount ?? 0, 2) }}</td>
                        <td>₹{{ number_format($item->balance_amount ?? 0, 2) }}</td>
                        <td>
                            @php
                                $status = $item->status ?? 'pending';
                                $statusClass = 'badge-secondary';
                                switch ($status) {
                                    case 'approved':
                                        $statusClass = 'badge-success';
                                        break;
                                    case 'rejected':
                                        $statusClass = 'badge-danger';
                                        break;
                                    case 'pending':
                                    default:
                                        $statusClass = 'badge-warning';
                                        break;
                                }
                            @endphp
                            <span class="badge {{ $statusClass }}">{{ ucfirst($status) }}</span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('superadmin.purchase.show', $item->id) }}"
                                    class="btn btn-sm btn-outline-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-outline-success edit-purchase-invoice"
                                    data-id="{{ $item->id }}" data-row="{{ base64_encode(json_encode($item)) }}"
                                    title="Edit">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <!--<a href="{{ route('superadmin.purchase.print', $item->id) }}"-->
                                <!--    class="btn btn-sm btn-outline-info" title="Print" target="_blank">-->
                                <!--    <i class="fas fa-print"></i>-->
                                <!--</a>-->
                                @if ($item->status === 'pending')
                                    <a href="{{ route('superadmin.purchase.approve', $item->id) }}"
                                        class="btn btn-sm btn-outline-success" title="Approve"
                                        onclick="return confirm('Are you sure you want to approve this purchase order?')">
                                        <i class="fas fa-check"></i>
                                    </a>
                                    <a href="{{ route('superadmin.purchase.reject', $item->id) }}"
                                        class="btn btn-sm btn-outline-danger" title="Reject"
                                        onclick="return confirm('Are you sure you want to reject this purchase order?')">
                                        <i class="fas fa-times"></i>
                                    </a>
                                @endif
                                <button type="button" class="btn btn-sm btn-outline-danger delete-purchase-invoice"
                                    data-id="{{ $item->id }}" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                @foreach($item->files as $file)
                                    <a href="{{ asset('storage/' . $file->file_path) }}"
                                        class="btn btn-sm btn-outline-info" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.purchase.deleteFile', ['id' => $file->id]) }}" 
                                        class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                @endforeach
                            </div>
                        </td>
                    </tr>
                @endforeach    
            @endif
        </tbody>
    </table>
</div>

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // destroy the table if already data table is initialized
            if ($.fn.DataTable.isDataTable('#purchaseInvoiceTable')) {
                $('#purchaseInvoiceTable').DataTable().destroy();
            }
            // handle not data in table also
            $('#purchaseInvoiceTable').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print', 'colvis'
                ],
                responsive: true,
                
                
            });
        });
    </script>
@endpush
