<div class="filter-section mb-3">
    <form id="filterForm" action="{{ route('superadmin.purchase.index') }}" method="get" class="row">
        @php
            $startDate = request()->input('filters.purchase_date:range')
                ? explode(' - ', request()->input('filters.purchase_date:range'))[0]
                : null;
            $endDate = request()->input('filters.purchase_date:range')
                ? explode(' - ', request()->input('filters.purchase_date:range'))[1]
                : null;
            $dateRange = isset($startDate)? $startDate . ' - ' . $endDate : null;
        @endphp
        <div class="col-md-3">
            <label class="form-label">Date Range</label>
            <input 
                type="text" 
                class="form-control filter-item date-range" 
                name="filters[purchase_date:range]"
                value="{{$dateRange}}"
                autocomplete="off"
                placeholder="Select Date Range"
            />
        </div>

        <div class="col-md-2">
            <label class="form-label">Party</label>
            <select class="form-control filter-item" name="filters[vendor_id]" required>
                <option value="">Select Vendor</option>
                @foreach ($vendors ?? [] as $vendor)
                    <option value="{{ $vendor->id }}" {{ request()->input('filters.vendor_id') == $vendor->id ? 'selected' : '' }}>
                        {{ $vendor->company }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Invoice No</label>
            <input 
                type="text" 
                class="form-control filter-item" 
                placeholder="Invoice No" 
                name="filters[vendor_invoice_no]"
                value="{{ request()->input('filters.vendor_invoice_no', '') }}"
            >
        </div>

        <div class="col-md-2">
            <label class="form-label">Payment Status</label>
            <select class="form-control filter-item" name="filters[payment_status]">
                <option value="">All</option>
                @foreach (['paid', 'partial', 'unpaid'] as $status)
                    <option value="{{ $status }}" {{ request()->input('filters.payment_status') == $status ? 'selected' : '' }}>
                        {{ ucfirst($status) }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Invoice Age (Days)</label>
            @php
                $invoiceAge = request()->input('filters.purchase_date:gte');
                $now = now();
                $ageRange = collect([7, 15, 30, 45])->mapWithKeys(fn($days) => [
                    $days => $now->copy()->subDays($days)->format('Y-m-d')
                ]);
            @endphp
            <select class="form-control filter-item" name="filters[purchase_date:gte]">
                <option value="">All</option>
                @foreach ($ageRange as $key => $value)
                    <option value="{{ $value }}" {{ $invoiceAge == $value ? 'selected' : '' }}>
                        {{ $key }} Days
                    </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-1 d-flex align-items-center justify-content-end pl-2">
            <button 
                type="button" 
                class="btn btn-primary" 
                id="resetFilter"
                onclick="event.preventDefault(); document.getElementById('filterForm').reset(); location.href = '{{ route('superadmin.purchase.index') }}';"
                >
                Reset
            </button>
        </div>
    </form>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        
        // $('#resetFilter').on('click', function (e) {
        //     e.preventDefault();
        //     $('#filterForm')[0].reset();
        //     locaton.href = "{{ route('superadmin.purchase.index') }}";
        // });

        if ($.fn.daterangepicker) {
            $('.date-range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear',
                    format: 'YYYY-MM-DD'
                }
            }).on('apply.daterangepicker', function (ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));
                $(this).closest("form").submit();
            }).on('cancel.daterangepicker', function () {
                $(this).val('');
            });
        }

        $(".filter-item").on("change", function () {
            $(this).closest("form").submit();
        });
    });
</script>

