<style>
    .chart-container {
        height: 300px;
        margin-bottom: 30px;
    }

    .filter-section {
        background-color: #f8f9fc;
    }
</style>
<div class="chart-container">
    <canvas id="agingChart"></canvas>
</div>

<div class="filter-section">
    <div class="row">
        <div class="col-md-4">
            <label class="form-label">As of Date</label>
            <input type="text" class="form-control aging-date" placeholder="Select date">
        </div>
        <div class="col-md-4">
            <label class="form-label">Party</label>
            <select class="form-select" id="party" required>
                <option value="">Select Party</option>
                @foreach ($vendors as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->company }}</option>
                @endforeach

            </select>
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button class="btn btn-primary me-2" id="applyAgingFilters">Apply Filters</button>
            <button class="btn btn-outline-secondary" id="resetAgingFilters">Reset</button>
        </div>
    </div>
</div>

<table id="agingTable" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr>
            <th>Party</th>
            <th>Current</th>
            <th>1-30 Days</th>
            <th>31-60 Days</th>
            <th>61-90 Days</th>
            <th>>90 Days</th>
            <th>Total Due</th>
        </tr>
    </thead>

</table>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        let agingChart; // For keeping chart instance and destroying it before redraw

        function loadAgingChart() {
            // Get filters
            let asOfDate = $('.aging-date').val();
            let partyId = $('#pills-aging #party').val();

            $.get("{{ route('superadmin.purchase.aging') }}", {
                as_of_date: asOfDate,
                party_id: partyId
            }, function(response) {
                // Calculate totals for each bucket across all parties
                let totalBuckets = {
                    current: 0,
                    '1_30': 0,
                    '31_60': 0,
                    '61_90': 0,
                    over_90: 0
                };

                response.data.forEach(row => {
                    totalBuckets.current += Number(row.current);
                    totalBuckets['1_30'] += Number(row['1_30']);
                    totalBuckets['31_60'] += Number(row['31_60']);
                    totalBuckets['61_90'] += Number(row['61_90']);
                    totalBuckets.over_90 += Number(row['over_90']);
                });

                // Chart.js
                const ctx = document.getElementById('agingChart').getContext('2d');
                // Destroy old chart if present
                if (agingChart) {
                    agingChart.destroy();
                }

                agingChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: [
                            'Current', '1-30 Days', '31-60 Days', '61-90 Days', '>90 Days'
                        ],
                        datasets: [{
                            label: 'Pending Amount',
                            data: [
                                totalBuckets.current,
                                totalBuckets['1_30'],
                                totalBuckets['31_60'],
                                totalBuckets['61_90'],
                                totalBuckets.over_90
                            ]
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                display: false
                            },
                            title: {
                                display: true,
                                text: 'Aging Report - Pending Amounts'
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });
            });
        }

        $('#applyAgingFilters').click(loadAgingChart);
        $('.aging-date, #pills-aging #party').on('change', loadAgingChart);
        // Optionally, auto-load on page/tab load:
        $(document).ready(function() {
            loadAgingChart();
        });
    });
</script>
