<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt - {{ $payment->payment_no }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fc;
            padding: 20px;
        }
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 40px;
            border: 1px solid #dee2e6;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #4e73df;
            padding-bottom: 20px;
            margin-bottom: 30px;
            position: relative;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #4e73df;
            text-transform: uppercase;
        }
        .title {
            font-size: 20px;
            font-weight: bold;
            margin-top: 10px;
            color: #5a5c69;
        }
        .receipt-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .info-group {
            width: 48%;
        }
        .label {
            font-weight: bold;
            color: #858796;
            font-size: 14px;
            margin-bottom: 5px;
        }
        .value {
            font-size: 16px;
            color: #5a5c69;
            margin-bottom: 15px;
        }
        .amount-box {
            background-color: #f8f9fc;
            border: 1px solid #e3e6f0;
            padding: 20px;
            text-align: center;
            margin-bottom: 30px;
            border-radius: 5px;
        }
        .amount-value {
            font-size: 32px;
            font-weight: bold;
            color: #4e73df;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #858796;
            border-top: 1px solid #e3e6f0;
            padding-top: 20px;
        }
        .signature-area {
            display: flex;
            justify-content: flex-end;
            margin-top: 50px;
        }
        .signature-line {
            width: 200px;
            border-top: 1px solid #000;
            text-align: center;
            padding-top: 10px;
        }
        @media print {
            body { background-color: #fff; }
            .receipt-container { box-shadow: none; border: none; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="receipt-container">
        <div class="header">
            <div class="logo">IndusPro</div>
            <div class="title">PAYMENT RECEIPT</div>
        </div>

        <div class="receipt-info">
            <div class="info-group">
                <div class="label">Receipt No</div>
                <div class="value">{{ $payment->payment_no }}</div>

                <div class="label">Payment Date</div>
                <div class="value">{{ $payment->payment_date->format('d M, Y') }}</div>

                <div class="label">Payment Method</div>
                <div class="value">{{ ucfirst($payment->payment_method) }}</div>
                
                @if($payment->reference_no)
                <div class="label">Reference No</div>
                <div class="value">{{ $payment->reference_no }}</div>
                @endif
            </div>

            <div class="info-group" style="text-align: right;">
                <div class="label">Received From</div>
                <div class="value">
                    <strong>{{ $payment->party->company ?? 'Unknown' }}</strong><br>
                    {{ $payment->party->gstin ?? '' }}
                </div>

                <div class="label">Towards Invoice</div>
                <div class="value">{{ $payment->invoice_no }}</div>
            </div>
        </div>

        <div class="amount-box">
            <div class="label">Amount Received</div>
            <div class="amount-value">₹{{ number_format($payment->payment_amount, 2) }}</div>
            <div class="value" style="margin-top: 5px; font-size: 14px;">
                (Rupees {{ ucfirst(number_format($payment->payment_amount, 2)) }} Only)
            </div>
        </div>

        @if($payment->notes)
        <div style="margin-bottom: 20px;">
            <div class="label">Notes</div>
            <div class="value">{{ $payment->notes }}</div>
        </div>
        @endif

        <div class="signature-area">
            <div class="signature-line">
                Authorized Signatory
            </div>
        </div>

        <div class="footer">
            This is a computer generated receipt and does not require a physical signature.
            <br>Generated on {{ date('d M, Y h:i A') }}
        </div>
    </div>
</body>
</html>
