<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>RFQ #{{ $rfq->rfq_no }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 15mm 10mm 12mm 10mm;
        }
        @media print {
            html, body { width: 100%; height: 100%; }
            .no-print { display: none !important; }
            body { background: #fff !important; }
            .container { box-shadow: none !important; margin: 0 !important; padding: 0 0 5mm 0 !important; width: 100% !important; border-radius: 0 !important; }
        }
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #f4f4f4;
            margin: 0; padding: 0;
        }
        .container {
            width: 1000px;
            margin: 10px auto;
            background: #fff;
            padding: 20px 20px 14px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 16px rgba(80, 100, 144, .09);
        }
        .header {
            display: flex; align-items: center; border-bottom: 2px solid #506690; padding-bottom: 6px; margin-bottom: 18px;
        }
        .logo { width: 70px; margin-right: 18px; }
        .company-details { flex: 1; }
        .company-details h2 { margin: 0; color: #506690; letter-spacing: 1.1px; font-size: 22px; }
        .company-details p { margin: 2px 0 0 0; color: #555; font-size: 12px; }
        .rfq-title { text-align: center; margin: 0 0 15px 0; color: #263850; font-size: 20px; }
        .info-table { width: 100%; margin-bottom: 12px; border-collapse: collapse; }
        .info-table td { padding: 4px 6px; vertical-align: top; font-size: 12px; }
        .section-title {
            background: #f1f4f9;
            color: #506690;
            font-weight: bold;
            padding: 4px 8px;
            border-radius: 3px;
            margin-bottom: 7px;
            margin-top: 14px;
            font-size: 14px;
        }
        .details-table { width: 100%; border-collapse: collapse; margin-bottom: 14px; }
        .details-table th, .details-table td { border: 1px solid #dbe5f1; padding: 5px 6px; font-size: 11px; }
        .details-table th { background: #f6faff; color: #263850; font-weight: 600; }
        .right { text-align: right; }
        .signatory { margin-top: 24px; text-align: right; font-weight: bold; font-size: 12px; }
        .no-print { margin-bottom: 12px; }
        .btn {
            background: #506690; color: #fff; padding: 6px 18px; border: none;
            border-radius: 4px; cursor: pointer; font-size: 14px;
        }
        .btn:hover { background: #354063; }
    </style>
</head>
<body>
    <div class="container">
        <div class="no-print" style="text-align:right;">
            <button class="btn" onclick="window.print()">Print</button>
            <button class="btn" onclick="window.close()">Close</button>
        </div>
        <div class="header">
            <img class="logo" src="{{ asset('cbimage.png') }}" alt="Company Logo">
            <div class="company-details">
                <h2>UMBREY ENGINEERING PVT LTD</h2>
                <p>No. 31, 2nd Phase, Peenya Industrial Area, Bengaluru 560 058, Karnataka, India<br>
                    GSTN: 29AAACU2461N1ZY &nbsp; | &nbsp; PAN: AAACU2461N</p>
                <p style="font-size:11px;margin:2px 0 0 0;">Email: info@umbreygroups.com</p>
            </div>
            <div style="text-align:right;font-size:12px;">
                <strong>RFQ #: </strong> {{ $rfq->rfq_no }}<br>
                <strong>Date:</strong> {{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d/m/Y') }}<br>
            </div>
        </div>
        <h1 class="rfq-title">REQUEST FOR QUOTATION</h1>

        <div class="section-title">Customer Details</div>
        <table class="info-table">
            <tr>
                <td style="width:33%;"><b>Company:</b> {{ $rfq->customerInfo->company ?? '-' }}<br>
                    <b>Contact:</b> {{ $rfq->customerInfo->mobile ?? '-' }}<br>
                    <b>Email:</b> {{ $rfq->customerInfo->email ?? '-' }}<br>
                    <b>GST No:</b> {{ $rfq->customerInfo->gstno ?? '-' }}
                </td>
                <td style="width:33%;"><b>Address:</b><br>{{ $rfq->customerInfo->billing_address ?? '-' }}</td>
                <td style="width:34%;">
                    <b>Customer Ref #:</b> {{ $rfq->cus_ref_no ?? '-' }}<br>
                    <b>RFQ Type:</b> {{ $rfq->rfq_type ?? '-' }}<br>
                    <b>Product Type:</b> {{ $rfq->product_type ?? '-' }}
                </td>
            </tr>
        </table>

        <div class="section-title">RFQ Details</div>
        <table class="info-table">
            <tr>
                <td><b>Part No:</b> {{ $rfq->part_no ?? '-' }}</td>
                <td><b>Project Mat No:</b> {{ $rfq->project_material_no ?? '-' }}</td>
                <td><b>Drawing No:</b> {{ $rfq->drawing_no ?? '-' }}</td>
            </tr>
            <tr>
                <td><b>Drawing Rev:</b> {{ $rfq->drawing_rev ?? '-' }}</td>
                <td><b>Quantity:</b> {{ $rfq->quantity ?? '-' }}</td>
                <td><b>UOM:</b> {{ $rfq->uom ?? '-' }}</td>
            </tr>
            <tr>
                <td colspan="3"><b>Note:</b> {{ $rfq->note ?? '-' }}</td>
            </tr>
        </table>

        <div class="section-title">Raw Materials</div>
        <table class="details-table">
            <thead>
                <tr>
                    <th style="width:10%;">Sl.</th>
                    <th>Material Name</th>
                </tr>
            </thead>
            <tbody>
                @forelse($rawMaterialNames as $i => $matName)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $matName }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="2" style="text-align:center;">No Raw Materials</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        {{-- Uncomment if you want to show file attachments
        <div class="section-title">Attachments</div>
        <table class="details-table">
            <tbody>
                @if ($rfq->drawing_file)
                    <tr>
                        <th>Drawing File</th>
                        <td>{{ basename($rfq->drawing_file) }}</td>
                    </tr>
                @endif
                @if ($rfq->material_specification_file)
                    <tr>
                        <th>Material Specification</th>
                        <td>{{ basename($rfq->material_specification_file) }}</td>
                    </tr>
                @endif
                @if ($rfq->rfq_form_file)
                    <tr>
                        <th>RFQ Form</th>
                        <td>{{ basename($rfq->rfq_form_file) }}</td>
                    </tr>
                @endif
                @if ($rfq->annexure_file)
                    <tr>
                        <th>Annexure</th>
                        <td>{{ basename($rfq->annexure_file) }}</td>
                    </tr>
                @endif
            </tbody>
        </table>
        --}}

        <div class="signatory">
            For Umbrey Engineering PVT LTD,<br><br>
            Authorised Signatory
        </div>
    </div>
</body>
</html>
