@extends('layouts.dashboard.superadminapp')

@section('title', 'Route Card Details')

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Route Card Details</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-route mr-2"></i> Route Card Details - {{ $routeCard->route_no }}
        </h6>
        <div>
            <a href="{{ route('superadmin.routecard.edit', $routeCard->id) }}" class="btn btn-warning btn-sm mr-1">
                <i class="fa fa-edit mr-1"></i> Edit
            </a>
            <a href="{{ route('superadmin.routecard.details') }}" class="btn btn-light btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RC No</label>
                <div class="font-weight-bold">{{ $routeCard->route_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RC Date</label>
                <div class="font-weight-bold">{{ $routeCard->route_date ? \Carbon\Carbon::parse($routeCard->route_date)->format('d M Y') : '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Order No</label>
                <div class="font-weight-bold">{{ $routeCard->order_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Order Date</label>
                <div class="font-weight-bold">{{ $routeCard->order_date ? \Carbon\Carbon::parse($routeCard->order_date)->format('d M Y') : '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GRN No</label>
                <div class="font-weight-bold">{{ $routeCard->grn_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GRN Date</label>
                <div class="font-weight-bold">{{ $routeCard->grn_date ? \Carbon\Carbon::parse($routeCard->grn_date)->format('d M Y') : '-' }}</div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Company Name</label>
                <div class="font-weight-bold">{{ $routeCard->company_name ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Address</label>
                <div class="font-weight-bold">{{ $routeCard->company_address ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GST No</label>
                <div class="font-weight-bold">{{ $routeCard->company_gstn ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Phone</label>
                <div class="font-weight-bold">{{ $routeCard->company_phone ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Email</label>
                <div class="font-weight-bold">{{ $routeCard->company_email ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Quotation No</label>
                <div class="font-weight-bold">{{ $routeCard->quotation_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RFQ No</label>
                <div class="font-weight-bold">{{ $routeCard->rfq_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Part No</label>
                <div class="font-weight-bold">{{ $routeCard->part_no ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Product Type</label>
                <div class="font-weight-bold">{{ $routeCard->product_type ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Project Start Date</label>
                <div class="font-weight-bold">{{ $routeCard->project_start_date ? \Carbon\Carbon::parse($routeCard->project_start_date)->format('d M Y H:i') : '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Status</label>
                <div class="font-weight-bold">
                    @if ($routeCard->status == 'approved')
                        <span class="badge badge-success">Approved</span>
                    @elseif($routeCard->status == 'rejected')
                        <span class="badge badge-danger">Rejected</span>
                    @elseif($routeCard->status == 'planned')
                        <span class="badge badge-info">Planned</span>
                    @elseif($routeCard->status == 'ready_to_production')
                        <span class="badge badge-primary">Ready</span>
                    @elseif($routeCard->status == 'in_production')
                        <span class="badge badge-warning">In Progress</span>
                    @else
                        <span class="badge badge-secondary">{{ ucfirst($routeCard->status ?? 'Pending') }}</span>
                    @endif
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Description</label>
                <div class="font-weight-bold">{{ $routeCard->description ?? '-' }}</div>
            </div>
        </div>

        <hr>

        <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-tasks mr-2"></i>Process Details</h6>

        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
                <thead class="thead-light">
                    <tr>
                        <th width="60">Sl No</th>
                        <th>Process</th>
                        <th>Source</th>
                        <th>Machine</th>
                        <th>Operator</th>
                        <th>Cycle Time</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($routeCardProcesses as $i => $proc)
                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>{{ $proc->process ?? '-' }}</td>
                            <td style="text-transform: capitalize">{{ $proc->source ?? '-' }}</td>
                            <td>{{ $proc->attchedMachine->machine_name ?? $proc->machine ?? '-' }}</td>
                            <td>{{ $proc->attchedOperator->name ?? $proc->operator ?? '-' }}</td>
                            <td>{{ str_pad($proc->cycle_hours ?? 0, 2, '0', STR_PAD_LEFT) }}:{{ str_pad($proc->cycle_minutes ?? 0, 2, '0', STR_PAD_LEFT) }}</td>
                            <td>{{ $proc->start_date ? \Carbon\Carbon::parse($proc->start_date)->format('d M Y H:i') : '-' }}</td>
                            <td>{{ $proc->end_date ? \Carbon\Carbon::parse($proc->end_date)->format('d M Y H:i') : '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">No Process Records Found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <hr>

        <div class="d-flex justify-content-end">
            <a href="{{ route('superadmin.routecard.edit', $routeCard->id) }}" class="btn btn-warning btn-sm mr-2">
                <i class="fa fa-edit mr-1"></i> Edit
            </a>
            <a href="{{ route('superadmin.routecard.details') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
</div>
@endsection
