<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>RFQ #{{ $rfq->rfq_no }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 15mm 10mm 12mm 10mm;
        }
        @media print {
            html, body { width: 100%; height: 100%; }
            .no-print { display: none !important; }
            body { background: #fff !important; }
            .container { box-shadow: none !important; margin: 0 !important; padding: 0 0 5mm 0 !important; width: 100% !important; border-radius: 0 !important; }
        }
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #f4f4f4;
            margin: 0; padding: 0;
        }
        .container {
            width: 1000px;
            margin: 10px auto;
            background: #fff;
            padding: 20px 20px 14px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 16px rgba(80, 100, 144, .09);
        }
        .header {
            display: flex; align-items: center; border-bottom: 2px solid #506690; padding-bottom: 6px; margin-bottom: 18px;
        }
        .logo { width: 70px; margin-right: 18px; }
        .company-details { flex: 1; }
        .company-details h2 { margin: 0; color: #506690; letter-spacing: 1.1px; font-size: 22px; }
        .company-details p { margin: 2px 0 0 0; color: #555; font-size: 12px; }
        .rfq-title { text-align: center; margin: 0 0 15px 0; color: #263850; font-size: 20px; }
        .info-table { width: 100%; margin-bottom: 12px; border-collapse: collapse; }
        .info-table td { padding: 4px 6px; vertical-align: top; font-size: 12px; }
        .section-title {
            background: #f1f4f9;
            color: #506690;
            font-weight: bold;
            padding: 4px 8px;
            border-radius: 3px;
            margin-bottom: 7px;
            margin-top: 14px;
            font-size: 14px;
        }
        .details-table { width: 100%; border-collapse: collapse; margin-bottom: 14px; }
        .details-table th, .details-table td { border: 1px solid #dbe5f1; padding: 5px 6px; font-size: 11px; }
        .details-table th { background: #f6faff; color: #263850; font-weight: 600; }
        .right { text-align: right; }
        .signatory { margin-top: 24px; text-align: right; font-weight: bold; font-size: 12px; }
        .no-print { margin-bottom: 12px; }
        .btn {
            background: #506690; color: #fff; padding: 6px 18px; border: none;
            border-radius: 4px; cursor: pointer; font-size: 14px;
        }
        .btn:hover { background: #354063; }
    </style>
</head>
<body>
    <div class="container">
        <div class="no-print" style="text-align:right;">
            <button class="btn" onclick="window.print()">Print</button>
            <button class="btn" onclick="window.close()">Close</button>
        </div>
        <div class="header">
            <img class="logo" src="{{ asset('cbimage.png') }}" alt="Company Logo">
            <div class="company-details">
                <h2>UMBREY ENGINEERING PVT LTD</h2>
                <p>No. 31, 2nd Phase, Peenya Industrial Area, Bengaluru 560 058, Karnataka, India<br>
                    GSTN: 29AAACU2461N1ZY &nbsp; | &nbsp; PAN: AAACU2461N</p>
                <p style="font-size:11px;margin:2px 0 0 0;">Email: info@umbreygroups.com</p>
            </div>
            <div style="text-align:right;font-size:12px;">
                <strong>RFQ #: </strong> {{ $rfq->rfq_no }}<br>
                <strong>Date:</strong> {{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d/m/Y') }}<br>
            </div>
        </div>
        <h1 class="rfq-title">REQUEST FOR QUOTATION</h1>

<div class="section-title">Customer Details</div>
<table class="info-table" style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
    <tr>
        <td style="width:33%; vertical-align: top; padding: 8px; border: 1px solid #ccc;">
            <b>Company:</b> {{ $rfq->customerInfo->company ?? '-' }}<br>
            <b>Contact:</b> {{ $rfq->customerInfo->mobile ?? '-' }}<br>
            <b>Email:</b> {{ $rfq->customerInfo->email ?? '-' }}<br>
            <b>GST No:</b> {{ $rfq->customerInfo->gstno ?? '-' }}
        </td>
        <td style="width:33%; vertical-align: top; padding: 8px; border: 1px solid #ccc;">
            <b>Address:</b><br>{{ $rfq->customerInfo->billing_address ?? '-' }}
        </td>
        <td style="width:34%; vertical-align: top; padding: 8px; border: 1px solid #ccc;">
            <b>Customer Ref #:</b> {{ $rfq->vendor_reference_no ?? '-' }}<br>
            <b>RFQ Type:</b> {{ $rfq->rfq_type ?? '-' }}<br>
            <b>Status:</b> {{ ucfirst($rfq->status ?? '-') }}
        </td>
    </tr>
</table>

<div class="section-title">RFQ Details</div>
<table class="info-table" style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
    <tr>
        <td style="padding: 8px; border: 1px solid #ccc;"><b>RFQ No:</b> {{ $rfq->rfq_no ?? '-' }}</td>
        <td style="padding: 8px; border: 1px solid #ccc;"><b>RFQ Date:</b> {{ $rfq->rfq_date ?? '-' }}</td>
        <td style="padding: 8px; border: 1px solid #ccc;"><b>Delivery Terms:</b> {{ $rfq->delivery_terms ?? '-' }}</td>
    </tr>
    <tr>
        <td colspan="3" style="padding: 8px; border: 1px solid #ccc;"><b>Note Ⅰ:</b> {{ $rfq->description ?? '-' }}</td>
    </tr>
    <tr>
        <td colspan="3" style="padding: 8px; border: 1px solid #ccc;"><b>Note ⅠⅠ:</b> {{ $rfq->note ?? '-' }}</td>
    </tr>
</table>

<div class="section-title">RFQ Item Details</div>
<table class="details-table" style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
    <thead>
        <tr>
            <th style="border: 1px solid #ccc; padding: 8px; width: 5%;">Sl.</th>
            <th style="border: 1px solid #ccc; padding: 8px;">Item</th>
            <th style="border: 1px solid #ccc; padding: 8px;">Description</th>
            <th style="border: 1px solid #ccc; padding: 8px; width: 10%;">Quantity</th>
            <th style="border: 1px solid #ccc; padding: 8px; width: 10%;">UOM</th>
            <th style="border: 1px solid #ccc; padding: 8px; width: 15%;">Required By</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($rfq->items as $index => $item)
            <tr>
                <td style="border: 1px solid #ccc; padding: 8px; text-align: center;">{{ $index + 1 }}</td>
                <td style="border: 1px solid #ccc; padding: 8px;">{{ $item->stockItem->item_name ?? '-' }}</td>
                <td style="border: 1px solid #ccc; padding: 8px;">{{ $item->description ?? '-' }}</td>
                <td style="border: 1px solid #ccc; padding: 8px; text-align: center;">{{ $item->quantity ?? '-' }}</td>
                <td style="border: 1px solid #ccc; padding: 8px; text-align: center;">{{ $item->uom ?? '-' }}</td>
                <td style="border: 1px solid #ccc; padding: 8px;">{{ $item->required_by ?? '-' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="6" style="border: 1px solid #ccc; padding: 8px; text-align: center;">No items added to this RFQ.</td>
            </tr>
        @endforelse
    </tbody>
</table>

<div class="signatory" style="margin-top: 50px;">
    From Umbrey Engineering PVT LTD,<br><br><br>
    Authorised Signatory
</div>

</body>
</html>
