@extends('layouts.dashboard.superadminapp')

@section('title', 'Manage Raw Materials')

<style>
    .btn {
        width: auto;
    }

    #filePreview {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }

    #filePreview .file-box {
        position: relative;
        max-width: 120px;
        word-break: break-word;
        padding: 5px;
        border: 1px solid #ccc;
        border-radius: 6px;
        text-align: center;
        overflow: hidden;
    }

    #filePreview img {
        max-width: 100%;
        height: auto;
    }

    .remove-file-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        transform: translate(50%, -50%);
        background-color: red;
        color: white;
        border: none;
        border-radius: 50%;
        font-size: 12px;
        width: 20px;
        height: 20px;
        cursor: pointer;
        z-index: 10;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.4);
    }
    
    #existingFile {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }
    
    #existingFile .file-box {
        position: relative;
        max-width: 120px;
        border: 1px solid #ccc;
        border-radius: 6px;
        padding: 5px;
        text-align: center;
        overflow: hidden;
        word-break: break-word;
        display: inline-block;
        margin: 5px;
        background-color: #fff;
    }
    
    #existingFile .file-box img {
        max-width: 100%;
        height: auto;
        display: block;
    }
    
    #existingFile .remove-existing-file-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        background-color: red;
        color: white;
        border: none;
        border-radius: 50%;
        font-size: 12px;
        width: 20px;
        height: 20px;
        cursor: pointer;
        z-index: 10;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.4);
    }

    
</style>

@section('content')
<div class="container-fluid">
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / Raw Materials</h1>
        <div class="display-date">
            <span id="day">day</span>, <span id="daynum">00</span> <span id="month">month</span> <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3" title="Add Raw Materials">
            <span class="fw-bold"></span>
            <button class="btn btn-primary btn-sm" id="addMaterialBtn">
                <i class="fas fa-plus-square"></i>
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="rawMaterialTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>Sl No</th>
                            <th>Raw Material</th>
                            <th>ISO Specification</th>
                            <th>Material Density</th>
                            <th>Material Type</th>
                            <th>Files</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- AJAX Loaded -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit Modal -->
    <div class="modal fade" id="addRawMaterialModal" tabindex="-1" role="dialog"
        aria-labelledby="addRawMaterialLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form id="addRawMaterialForm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addRawMaterialLabel">Add New Raw Material</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="width:auto" id="addRawMaterialFormIcon">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <input type="hidden" name="material_id" id="material_id">
                    <div class="modal-body">
                        <div class="mb-2">
                            <label>Raw Material Grade *</label>
                            <input type="text" name="rm_grade" class="form-control" required>
                        </div>
                        <div class="mb-2">
                            <label>ISO Specification</label>
                            <input type="text" name="iso_specification" class="form-control">
                        </div>
                        <div class="mb-2">
                            <label>Material Density(KG/m³) *</label>
                            <input type="number" name="density" class="form-control" step="any" required>
                        </div>
                        <div class="mb-2">
                            <label for="raw_material_type">Raw Material Type</label>
                            <input list="raw_material_options" name="raw_material_type" id="raw_material_type" class="form-control" placeholder="Select or enter raw material type">
                        
                            <datalist id="raw_material_options">
                                <option value="Forged Road Bar">
                                <option value="Steel">
                                <option value="Step Forging">
                                <option value="Channel">
                                <option value="Round Bars">
                                <option value="Flat Bars">
                                <option value="Angle Bars">
                                <option value="I-Beams and H-Beams">
                                <option value="Steel Metal">
                                <option value="Wire Rods">
                                <option value="Billets and Blooms">
                                <option value="Copper Rods/Bars">
                                <option value="Aluminum Extrusions">
                                <option value="Brass Rods/Sheets">
                                <option value="Titanium Bars/Sheets">
                            </datalist>
                        </div>

                        
                        <div class="mb-2">
                            <label for="material_file">Upload Material File</label>
                            {{--<input type="file" name="material_file" id="material_file" class="form-control" accept=".jpeg,.png,.jpg,.gif,.webp,.pdf,.doc,.docx,.xls,.xlsx">--}}
                            <input type="file" name="material_file[]" id="material_file" class="form-control" multiple accept=".jpeg,.png,.jpg,.gif,.webp,.pdf,.doc,.docx,.xls,.xlsx">
                        
                            <!-- Existing File Section (Only on Edit) -->
                            <div id="existingFile" class="mt-2" style="display: none;">

                            </div>
                        
                            <!-- Hidden to track removal in JS -->
                            <input type="hidden" name="remove_existing_file" id="remove_existing_file" value="0">
                        
                            <!-- Preview for image files -->
                            <div id="filePreview" class="mt-2 row">
                                
                            </div>
                            
                        </div>

                        <!--
                        <div class="mb-2">
                            <label>Mechanical Properties</label>
                            <input type="text" name="mechanical_properties" class="form-control">
                        </div>
                        <div class="mb-2">
                            <label>Chemical Properties</label>
                            <input type="text" name="chemical_properties" class="form-control">
                        </div>
                        -->
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal" id="addRawMaterialFormBtn">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteRawMaterialModal" tabindex="-1" aria-labelledby="deleteRawMaterialLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Raw Material</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="deleteRawMaterialModalIcon"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Raw Material?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="deleteRawMaterialModalBtn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    
</div>

@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const addRawMaterialModal = new bootstrap.Modal(document.getElementById('addRawMaterialModal'));
        const deleteRawMaterialModal = new bootstrap.Modal(document.getElementById('deleteRawMaterialModal'));
        let deleteId = null;

        function resetMaterialForm() {
            const form = document.getElementById('addRawMaterialForm');
            form.reset();
            document.getElementById('material_id').value = '';
            document.getElementById('remove_existing_file').value = '0';
            selectedFiles = [];
            document.getElementById('filePreview').innerHTML = '';
            updateFileInputCount();
    
            const existingFile = document.getElementById('existingFile');
            if (existingFile) {
                existingFile.style.display = 'none';
            }
    
            document.getElementById('material_file').value = '';
        }

        function loadRawMaterials() {
            fetch("{{ route('superadmin.rawmaterial.list') }}")
                .then(res => res.json())
                .then(data => {
                    const tbody = document.querySelector('#rawMaterialTable tbody');
                    tbody.innerHTML = '';
        
                    data.data.forEach((item, index) => {
                        let filePreview = '-';
        
                        if (item.files && item.files.length > 0) {
                            filePreview = '<div class="d-flex flex-column align-items-center gap-1">';
                            item.files.forEach(file => {
                                const fileUrl = `{{ asset('storage') }}/${file.file_path}`;
                                filePreview += `
                                    <div class="d-flex align-items-center gap-1">
                                        <a href="${fileUrl}" target="_blank" class="btn btn-sm btn-outline-secondary" title="View File">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <button class="btn btn-sm btn-outline-danger" onclick="deletefilelist('${file.id}')" title="Delete File">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </div>
                                `;
                            });
                            filePreview += '</div>';
                        }
        
                        tbody.innerHTML += `
                            <tr class="text-center align-middle">
                                <td>${index + 1}</td>
                                <td>${item.rm_grade}</td>
                                <td>${item.iso_specification || '-'}</td>
                                <td>${item.density || '-'}</td>
                                <td>${item.raw_material_type || '-'}</td>
                                <td>${filePreview}</td>
                                <td>
                                    <button class="btn btn-sm btn-info editMaterialBtn" data-id="${item.id}" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger deleteMaterialBtn" data-id="${item.id}" title="Delete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        `;
                    });
                })
                .catch(() => alert('Failed to load raw materials.'));
        }

        loadRawMaterials();

        // Add Button Click
        document.getElementById('addMaterialBtn').addEventListener('click', () => {
            resetMaterialForm();
            document.getElementById('addRawMaterialLabel').textContent = 'Add New Raw Material';
            addRawMaterialModal.show();
        });

        // Modal Close Reset
        ['addRawMaterialFormIcon', 'addRawMaterialFormBtn'].forEach(id => {
            document.getElementById(id).addEventListener('click', () => {
                resetMaterialForm();
                addRawMaterialModal.hide();
            });
        });

        // File Input Preview

        // Edit / Delete
        document.getElementById('rawMaterialTable').addEventListener('click', function (e) {
            const editBtn = e.target.closest('.editMaterialBtn');
            const deleteBtn = e.target.closest('.deleteMaterialBtn');

            if (editBtn) {
                const id = editBtn.dataset.id;
                fetch("{{ route('superadmin.rawmaterial.single', ':id') }}".replace(':id', id))
                    .then(res => res.json())
                    .then(data => {
                        document.getElementById('material_id').value = data.id;
                        document.querySelector('[name="rm_grade"]').value = data.rm_grade || '';
                        document.querySelector('[name="iso_specification"]').value = data.iso_specification || '';
                        document.querySelector('[name="density"]').value = data.density || '';
                        document.querySelector('[name="raw_material_type"]').value = data.raw_material_type || '';
            
                        // Clear current file preview
                        selectedFiles = [];
                        const previewContainer = document.getElementById('existingFile');
                        previewContainer.innerHTML = '';
            
                        // Render existing uploaded files from database
                        if (data.files && data.files.length > 0) {
                            previewContainer.style.display = 'block';
                            data.files.forEach(file => {
                                const box = document.createElement('div');
                                box.classList.add('file-box');
                                
                                const removeBtn = document.createElement('button');
                                removeBtn.setAttribute('type', 'button'); // <- ADD THIS
                                removeBtn.innerHTML = '&times;';
                                removeBtn.className = 'remove-existing-file-btn';
                                removeBtn.setAttribute('onclick', `deletefile('${file.id}')`);
                                
                                box.appendChild(removeBtn);
            
                                if (file.file_path.toLowerCase().match(/\.(jpeg|jpg|png|gif|bmp|webp)$/)) {
                                    const img = document.createElement('img');
                                    img.src = `{{ asset('storage') }}/${file.file_path}`;
                                    box.appendChild(img);
                                } else {
                                    const link = document.createElement('a');
                                    link.href = `{{ asset('storage') }}/${file.file_path}`;
                                    link.target = '_blank';
                                    link.textContent = file.file_name;
                                    link.className = 'btn btn-sm btn-outline-primary';
                                    box.appendChild(link);
                                }
            
                                previewContainer.appendChild(box);
                            });
                        }
            
                        updateFileInputCount();
            
                        document.getElementById('addRawMaterialLabel').textContent = 'Edit Raw Material';
                        addRawMaterialModal.show();
                    })
                    .catch(() => alert('Failed to load raw material data.'));
            }

            if (deleteBtn) {
                deleteId = deleteBtn.dataset.id;
                deleteRawMaterialModal.show();
            }
        });

        // Submit Add/Edit
        document.getElementById('addRawMaterialForm').addEventListener('submit', function (e) {
            e.preventDefault();
            const id = document.getElementById('material_id').value;
            const url = id
                ? "{{ route('superadmin.rawmaterial.update', ':id') }}".replace(':id', id)
                : "{{ route('superadmin.rawmaterial.store') }}";

            const formData = new FormData(this);
            
            selectedFiles.forEach(file => {
                formData.append('material_file[]', file);
            });

            if (id) formData.append('_method', 'PUT');

            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
                body: formData,
            })
                .then(async res => {
                    const data = await res.json();

                    if (res.ok && data.success) {
                        resetMaterialForm();
                        addRawMaterialModal.hide();
                        loadRawMaterials();
                        alert(data.message);
                    } else if (res.status === 422) {
                        const firstField = Object.keys(data.errors)[0];
                        const firstError = data.errors[firstField][0];
                        alert(firstError);
                    } else {
                        alert(data.message || 'Something went wrong.');
                    }
                })
                .catch(() => alert('Server error.'));
        });

        // Delete
        document.getElementById('confirmDeleteBtn').addEventListener('click', function () {
            if (!deleteId) return;

            fetch("{{ route('superadmin.rawmaterial.delete', ':id') }}".replace(':id', deleteId), {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        deleteRawMaterialModal.hide();
                        loadRawMaterials();
                        alert(data.message);
                    } else {
                        alert(data.message || 'Delete failed.');
                    }
                })
                .catch(() => alert('Error deleting material.'));
        });

        document.getElementById('deleteRawMaterialModalIcon').addEventListener('click', () => deleteRawMaterialModal.hide());
        
        document.getElementById('deleteRawMaterialModalBtn').addEventListener('click', () => deleteRawMaterialModal.hide());
    });
    
</script>

<script>

    let selectedFiles = [];

    const fileInput = document.getElementById('material_file');
    const fileCountDisplay = document.createElement('span');
    fileCountDisplay.id = 'fileCountDisplay';
    fileInput.insertAdjacentElement('afterend', fileCountDisplay);

    fileInput.addEventListener('change', function (event) {
        selectedFiles = selectedFiles.concat(Array.from(event.target.files));
        event.target.value = ''; // Clear native input
        renderFilePreview();
        updateFileInputCount();
    });

    function renderFilePreview() {
        const container = document.getElementById('filePreview');
        container.innerHTML = '';

        selectedFiles.forEach((file, index) => {
            const box = document.createElement('div');
            box.classList.add('file-box');

            const removeBtn = document.createElement('button');
            removeBtn.innerHTML = '&times;';
            removeBtn.className = 'remove-file-btn';
            removeBtn.onclick = () => {
                selectedFiles.splice(index, 1);
                renderFilePreview();
                updateFileInputCount();
            };

            box.appendChild(removeBtn);

            if (file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    box.appendChild(img);
                };
                reader.readAsDataURL(file);
            } else {
                const link = document.createElement('a');
                link.href = URL.createObjectURL(file);
                link.target = '_blank';
                link.textContent = file.name;
                link.className = 'btn btn-sm btn-outline-primary';
                box.appendChild(link);
            }

            container.appendChild(box);
        });
    }

    function updateFileInputCount() {
        if (selectedFiles.length > 0) {
            fileCountDisplay.textContent = `${selectedFiles.length} file${selectedFiles.length > 1 ? 's' : ''} selected`;
        } else {
            fileCountDisplay.textContent = '';
        }
    }
    
    function deletefile(fileId) {
        if (!fileId) return;
    
        if (!confirm("Are you sure you want to delete this file?")) return;
    
        fetch(`{{ route('superadmin.rawmaterial.deletefile', ':id') }}`.replace(':id', fileId), {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            }
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                // Remove the file-box visually
                const btn = document.querySelector(`button[onclick="deletefile('${fileId}')"]`);
                const box = btn.closest('.file-box');
                if (box) box.remove();
    
                updateFileInputCount();
            } else {
                alert(data.message || 'Could not delete file.');
            }
        })
        .catch(() => alert('Server error. Please try again.'));
    }
    
    function deletefilelist(fileId) {
        if (!fileId) return;
    
        if (!confirm("Are you sure you want to delete this file?")) return;
    
        fetch(`{{ route('superadmin.rawmaterial.deletefile', ':id') }}`.replace(':id', fileId), {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            }
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                // Remove the file-box visually
                location.reload();
            } else {
                alert(data.message || 'Could not delete file.');
            }
        })
        .catch(() => alert('Server error. Please try again.'));
    }

</script>

@endsection
