@extends('layouts.dashboard.superadminapp')

@section('title', 'Machine Details')

@section('styles')
<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
    }
    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }
    .dt-buttons .btn {
        margin-right: 0.5rem !important;
        padding: 0.25rem 0.75rem !important;
        font-size: 0.95rem !important;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Machine Details</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if ($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>
        <ul class="mb-0 d-inline-block">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<!-- Machine Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-cogs mr-2"></i> Machines Data
        </h6>
        <div>
            <button class="btn btn-success btn-sm mr-1" data-toggle="modal" data-target="#bulkImportModal">
                <i class="fas fa-file-excel mr-1"></i> Bulk Add
            </button>
            <a href="{{ route('superadmin.machine.addmachine') }}" class="btn btn-light btn-sm">
                <i class="fas fa-plus mr-1"></i> Add Machine
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm" id="machineTable" width="100%" cellspacing="0">
                <thead class="thead-light">
                    <tr>
                        <th>Machine ID</th>
                        <th>Machine Name</th>
                        <th>Machine SL No</th>
                        <th>Make</th>
                        <th>Model Type</th>
                        <th>Diameter (mm)</th>
                        <th>Length (m)</th>
                        <th>Weight (kg)</th>
                        <th>Remarks</th>
                        <th width="100" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($machines as $machine)
                        <tr id="row-{{ $machine->id }}">
                            <td>{{ $machine->machine_id }}</td>
                            <td>{{ $machine->machine_name }}</td>
                            <td>{{ $machine->machine_sl_no }}</td>
                            <td>{{ $machine->make }}</td>
                            <td>{{ $machine->model_type }}</td>
                            <td>{{ $machine->diameter }}</td>
                            <td>{{ $machine->length }}</td>
                            <td>{{ $machine->weight }}</td>
                            <td>{{ $machine->remarks }}</td>
                            <td>
                                <div class="text-center" style="white-space: nowrap;">
                                    <a href="{{ route('superadmin.machine.edit', $machine->id) }}" class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <button class="btn btn-danger btn-sm delete-btn" data-id="{{ $machine->id }}" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Bulk Import Modal -->
<div class="modal fade" id="bulkImportModal" tabindex="-1" role="dialog" aria-labelledby="bulkImportModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="POST" action="{{ route('superadmin.machine.import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-header" style="background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);">
                    <h5 class="modal-title text-white" id="bulkImportModalLabel">
                        <i class="fas fa-file-excel mr-2"></i> Bulk Add Machines
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="small font-weight-bold">Upload Excel File (.xlsx) <span class="text-danger">*</span></label>
                        <input class="form-control" type="file" id="excel_file" name="excel_file" accept=".xlsx" required>
                        <small class="text-muted">
                            <a href="{{ asset('templates/machine_import_template.xlsx') }}" download>
                                <i class="fas fa-download mr-1"></i> Download Sample Template
                            </a>
                        </small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">
                        <i class="fa fa-times mr-1"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-success btn-sm">
                        <i class="fa fa-upload mr-1"></i> Import
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    // DataTable with export buttons
    $('#machineTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', className: 'btn btn-secondary btn-sm' },
            { extend: 'csv', className: 'btn btn-secondary btn-sm' },
            { extend: 'excel', className: 'btn btn-secondary btn-sm' },
            { extend: 'pdf', className: 'btn btn-secondary btn-sm' },
            { extend: 'print', className: 'btn btn-secondary btn-sm' },
            { extend: 'colvis', className: 'btn btn-secondary btn-sm' }
        ],
        pageLength: 10,
        responsive: true,
        language: {
            emptyTable: "No machines found"
        }
    });

    // Handle delete button with SweetAlert2
    $(document).on('click', '.delete-btn', function() {
        var id = $(this).data('id');
        Swal.fire({
            title: 'Delete Machine?',
            text: "Are you sure you want to delete this machine?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, Delete!',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '{{ url("superadmin/deletemachine") }}/' + id,
                    type: 'DELETE',
                    data: { _token: '{{ csrf_token() }}' },
                    success: function(data) {
                        if (data.success) {
                            $('#row-' + id).remove();
                            Swal.fire('Deleted!', 'Machine deleted successfully.', 'success');
                        } else {
                            Swal.fire('Error!', 'Delete failed', 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error!', 'Error deleting record', 'error');
                    }
                });
            }
        });
    });
});
</script>
@endsection
