@extends('layouts.dashboard.superadminapp')

@section('title', 'Account Dashboard')

@section('styles')
<style>
    .stat-card {
        border-radius: 12px;
        padding: 24px;
        color: #fff;
        transition: transform 0.2s, box-shadow 0.2s;
        position: relative;
        overflow: hidden;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }
    .stat-card .stat-icon {
        position: absolute;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 3.5rem;
        opacity: 0.3;
    }
    .stat-card .stat-value {
        font-size: 2rem;
        font-weight: 700;
        line-height: 1;
    }
    .stat-card .stat-label {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 5px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .stat-card .stat-info {
        font-size: 0.8rem;
        margin-top: 10px;
        opacity: 0.8;
    }
    .stat-card .stat-growth {
        display: inline-block;
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 600;
        margin-top: 8px;
    }
    .stat-card .stat-growth.positive {
        background: rgba(255,255,255,0.2);
        color: #fff;
    }
    .stat-card .stat-growth.negative {
        background: rgba(255,255,255,0.2);
        color: #fff;
    }
    .bg-gradient-revenue { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-expense { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-gradient-profit { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-cost { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-gradient-secondary { background: linear-gradient(135deg, #858796 0%, #5a5c69 100%); }

    .chart-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
    }
    .chart-card .card-header {
        border-radius: 12px 12px 0 0;
        padding: 16px 20px;
    }
    .chart-card .card-body {
        padding: 20px;
    }

    .quick-link-card {
        background: #fff;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        transition: all 0.2s;
        border: 2px solid transparent;
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(78,115,223,0.2);
    }
    .quick-link-card i {
        font-size: 2rem;
        margin-bottom: 10px;
    }
    .quick-link-card .link-title {
        font-weight: 600;
        color: #333;
    }

    .summary-item {
        padding: 12px 0;
        border-bottom: 1px solid #eee;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .summary-item:last-child {
        border-bottom: none;
    }
    .summary-item .summary-label {
        color: #666;
        font-size: 0.9rem;
    }
    .summary-item .summary-value {
        font-weight: 700;
        color: #333;
        font-size: 1rem;
    }

    .filter-btn {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 0.85rem;
        transition: all 0.2s;
    }
    .filter-btn.active {
        background: #fff;
        color: #4e73df;
    }

    .invoice-status {
        padding: 4px 12px;
        border-radius: 15px;
        font-size: 0.75rem;
        font-weight: 600;
    }
    .invoice-status.pending {
        background: #fff3cd;
        color: #856404;
    }
    .invoice-status.paid {
        background: #d4edda;
        color: #155724;
    }
    .invoice-status.overdue {
        background: #f8d7da;
        color: #721c24;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Account Dashboard</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

@php
    $profitMargin = $revenue > 0 ? round(($grossProfit / $revenue) * 100, 1) : 0;
    $expenseRatio = $revenue > 0 ? round(($expenses / $revenue) * 100, 1) : 0;
@endphp

<!-- Summary Statistics -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-revenue shadow">
            <i class="fas fa-rupee-sign stat-icon"></i>
            <div class="stat-value">{{ number_format($revenue) }}</div>
            <div class="stat-label">Revenue</div>
            <div class="stat-growth positive">
                <i class="fas fa-arrow-up mr-1"></i> {{ $revenueGrowth }} vs last month
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-expense shadow">
            <i class="fas fa-file-invoice-dollar stat-icon"></i>
            <div class="stat-value">{{ number_format($expenses) }}</div>
            <div class="stat-label">Expenses</div>
            <div class="stat-growth negative">
                <i class="fas fa-arrow-up mr-1"></i> {{ $expensesGrowth }} vs last month
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-profit shadow">
            <i class="fas fa-chart-line stat-icon"></i>
            <div class="stat-value">{{ number_format($grossProfit) }}</div>
            <div class="stat-label">Gross Profit</div>
            <div class="stat-growth positive">
                <i class="fas fa-arrow-up mr-1"></i> {{ $profitGrowth }} vs last month
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-cost shadow">
            <i class="fas fa-cogs stat-icon"></i>
            <div class="stat-value">{{ number_format($productionCost) }}</div>
            <div class="stat-label">Production Cost</div>
            <div class="stat-growth positive">
                <i class="fas fa-arrow-up mr-1"></i> {{ $prodCostGrowth }} vs last month
            </div>
        </div>
    </div>
</div>

<!-- Profit Overview -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-chart-pie mr-2"></i> Financial Overview - {{ date('F Y') }}
        </h6>
    </div>
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-4 text-center mb-3 mb-md-0">
                <div class="h1 font-weight-bold {{ $profitMargin >= 20 ? 'text-success' : ($profitMargin >= 10 ? 'text-warning' : 'text-danger') }}">
                    {{ $profitMargin }}%
                </div>
                <p class="text-muted mb-0">Profit Margin</p>
            </div>
            <div class="col-md-4 text-center mb-3 mb-md-0">
                <div class="h1 font-weight-bold text-info">
                    {{ $expenseRatio }}%
                </div>
                <p class="text-muted mb-0">Expense Ratio</p>
            </div>
            <div class="col-md-4 text-center">
                <div class="h1 font-weight-bold {{ $grossProfit > 0 ? 'text-success' : 'text-danger' }}">
                    {{ $grossProfit > 0 ? '+' : '' }}{{ number_format($grossProfit) }}
                </div>
                <p class="text-muted mb-0">Net Position</p>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Revenue vs Expenses Chart -->
    <div class="col-lg-8 mb-4">
        <div class="chart-card shadow">
            <div class="card-header d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-area mr-2"></i> Revenue vs Expenses (Last 6 Months)
                </h6>
                <div>
                    <button class="btn btn-sm btn-light filter-btn active" data-filter="monthly">Monthly</button>
                    <button class="btn btn-sm btn-outline-light filter-btn" data-filter="quarterly">Quarterly</button>
                </div>
            </div>
            <div class="card-body">
                <canvas id="revenueExpenseChart" height="120"></canvas>
            </div>
        </div>
    </div>

    <!-- Cost Breakdown Chart -->
    <div class="col-lg-4 mb-4">
        <div class="chart-card shadow">
            <div class="card-header" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-pie mr-2"></i> Cost Breakdown
                </h6>
            </div>
            <div class="card-body">
                <canvas id="costBreakdownChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-link mr-2"></i> Quick Actions
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.invoice.invoiceorder') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-file-invoice text-primary"></i>
                        <div class="link-title">Invoices</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.salesmanagement.index') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-hand-holding-usd text-success"></i>
                        <div class="link-title">Sales Mgmt</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.purchase.index') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-shopping-cart text-warning"></i>
                        <div class="link-title">Purchase</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.grn.grnorder') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-truck-loading text-info"></i>
                        <div class="link-title">GRN</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.employee.employeepayroll') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-money-check-alt text-danger"></i>
                        <div class="link-title">Payroll</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.report.customerreport') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-chart-bar text-secondary"></i>
                        <div class="link-title">Reports</div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Financial Summary & Pending Invoices -->
<div class="row">
    <!-- Financial Summary -->
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-calculator mr-2"></i> Financial Summary
                </h6>
            </div>
            <div class="card-body">
                @foreach($summary as $row)
                    <div class="summary-item">
                        <span class="summary-label">{{ $row['title'] }}</span>
                        <span class="summary-value">{{ $row['value'] }}</span>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Pending Invoices -->
    <div class="col-md-8 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-clock mr-2"></i> Recent Invoices
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>Invoice No</th>
                                <th>Date</th>
                                <th>Reference</th>
                                <th class="text-right">Amount</th>
                                <th class="text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($pendingInvoices as $invoice)
                                <tr>
                                    <td class="font-weight-bold">{{ $invoice->invoice_no }}</td>
                                    <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d M Y') }}</td>
                                    <td>{{ $invoice->reference_no ?? '-' }}</td>
                                    <td class="text-right font-weight-bold">{{ number_format($invoice->total_amount, 2) }}</td>
                                    <td class="text-center">
                                        <span class="invoice-status pending">Pending</span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-4">
                                        <i class="fas fa-check-circle fa-2x mb-2 d-block text-success"></i>
                                        No pending invoices
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cost Breakdown Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #858796 0%, #5a5c69 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-list-alt mr-2"></i> Cost Distribution Details
        </h6>
    </div>
    <div class="card-body p-0">
        <table class="table table-sm mb-0">
            <thead class="thead-light">
                <tr>
                    <th>Cost Category</th>
                    <th class="text-right">Amount</th>
                    <th class="text-center">Percentage</th>
                    <th>Distribution</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $totalCost = array_sum($costBreakdown);
                    $colors = ['primary', 'success', 'info', 'warning', 'danger'];
                    $colorIndex = 0;
                @endphp
                @foreach($costBreakdown as $category => $amount)
                    @php
                        $percentage = $totalCost > 0 ? round(($amount / $totalCost) * 100, 1) : 0;
                        $color = $colors[$colorIndex % count($colors)];
                        $colorIndex++;
                    @endphp
                    <tr>
                        <td class="font-weight-bold">{{ $category }}</td>
                        <td class="text-right">{{ number_format($amount, 2) }}</td>
                        <td class="text-center">{{ $percentage }}%</td>
                        <td>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-{{ $color }}" style="width: {{ $percentage }}%"></div>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot class="thead-light">
                <tr class="font-weight-bold">
                    <td>Total</td>
                    <td class="text-right">{{ number_format($totalCost, 2) }}</td>
                    <td class="text-center">100%</td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Pass PHP data to JS
    window.months = @json($months);
    window.chartRevenue = @json($chartRevenue);
    window.chartExpenses = @json($chartExpenses);
    window.costBreakdown = @json($costBreakdown);

    // Revenue vs Expenses Chart
    const revenueExpenseCtx = document.getElementById('revenueExpenseChart').getContext('2d');
    new Chart(revenueExpenseCtx, {
        type: 'line',
        data: {
            labels: window.months,
            datasets: [
                {
                    label: 'Revenue',
                    data: window.chartRevenue,
                    borderColor: '#1cc88a',
                    backgroundColor: 'rgba(28, 200, 138, 0.1)',
                    fill: true,
                    tension: 0.4,
                    borderWidth: 3,
                    pointBackgroundColor: '#1cc88a',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 5,
                    pointHoverRadius: 7
                },
                {
                    label: 'Expenses',
                    data: window.chartExpenses,
                    borderColor: '#e74a3b',
                    backgroundColor: 'rgba(231, 74, 59, 0.1)',
                    fill: true,
                    tension: 0.4,
                    borderWidth: 3,
                    pointBackgroundColor: '#e74a3b',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 5,
                    pointHoverRadius: 7
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: { usePointStyle: true, padding: 20 }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(0,0,0,0.05)' },
                    ticks: {
                        callback: function(value) {
                            return '' + value.toLocaleString();
                        }
                    }
                },
                x: {
                    grid: { display: false }
                }
            }
        }
    });

    // Cost Breakdown Doughnut Chart
    const costLabels = Object.keys(window.costBreakdown);
    const costData = Object.values(window.costBreakdown);

    const costCtx = document.getElementById('costBreakdownChart').getContext('2d');
    new Chart(costCtx, {
        type: 'doughnut',
        data: {
            labels: costLabels,
            datasets: [{
                data: costData,
                backgroundColor: [
                    '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b',
                    '#858796', '#5a5c69', '#6f42c1'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: { padding: 15, usePointStyle: true }
                }
            },
            cutout: '60%'
        }
    });

    // Filter buttons functionality
    document.querySelectorAll('.filter-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.filter-btn').forEach(b => {
                b.classList.remove('active');
                b.classList.add('btn-outline-light');
                b.classList.remove('btn-light');
            });
            this.classList.add('active');
            this.classList.remove('btn-outline-light');
            this.classList.add('btn-light');
        });
    });

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday: 'long' });
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = now.toLocaleString('en-us', { month: 'long' });
        document.getElementById('year').textContent = now.getFullYear();
        document.querySelector('.display-time').textContent = now.toLocaleTimeString();
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
</script>
@endsection
