@extends('layouts.dashboard.managerapp')

@section('title', 'Planning Dashboard')

@section('content')
<div class="container-fluid px-4 py-4">
    <style>
        .dashboard-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            padding: 2rem;
            color: white;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .stat-card {
            border: none;
            border-radius: 15px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            overflow: hidden;
            background: #fff;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        .stat-icon-bg {
            position: absolute;
            right: -20px;
            bottom: -20px;
            opacity: 0.15;
            font-size: 8rem;
            transform: rotate(-15deg);
        }
        .bg-gradient-danger { background: linear-gradient(45deg, #ff9a9e 0%, #fecfef 99%, #fecfef 100%); }
        .bg-gradient-warning { background: linear-gradient(120deg, #f6d365 0%, #fda085 100%); }
        .bg-gradient-info { background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%); }
        
        .table-custom thead th {
            border-top: none;
            border-bottom: 2px solid #e3e6f0;
            background-color: #f8f9fc;
            color: #5a5c69;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.85rem;
            letter-spacing: 0.05em;
        }
        .table-custom tbody tr {
            transition: background-color 0.2s;
        }
        .table-custom tbody tr:hover {
            background-color: #fafbfc;
        }
        .priority-dot {
            height: 10px;
            width: 10px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 5px;
        }
        .badge-pill-custom {
            padding: 0.5em 1em;
            border-radius: 50rem;
            font-weight: 500;
        }
    </style>

    <!-- Header Section -->
    <div class="d-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 fw-bold text-gray-800">Production Planning</h1>
            <p class="text-muted mb-0">Overview of schedules, priorities, and timelines.</p>
        </div>
        <form method="POST" action="{{ route('manager.planning.reschedule') }}">
            @csrf
            <button type="submit" class="btn btn-primary btn-lg shadow-sm" style="border-radius: 30px; padding-left: 1.5rem; padding-right: 1.5rem;">
                <i class="fas fa-magic me-2"></i> Smart Schedule
            </button>
        </form>
    </div>

    <!-- Stats Row -->
    <div class="row mb-5">
        <div class="col-md-4 mb-4">
            <div class="card stat-card h-100 border-left-danger">
                <div class="card-body position-relative">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-danger text-uppercase mb-1">High Priority</div>
                            <div class="h2 mb-0 fw-bold text-gray-800">{{ $stats['high'] ?? 0 }}</div>
                            <div class="text-muted small mt-2">Immediate Attention</div>
                        </div>
                        <div class="ms-3">
                             <div class="icon-circle bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-fire fa-lg"></i>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card stat-card h-100 border-left-warning">
                <div class="card-body position-relative">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">Medium Priority</div>
                            <div class="h2 mb-0 fw-bold text-gray-800">{{ $stats['medium'] ?? 0 }}</div>
                            <div class="text-muted small mt-2">On Track</div>
                        </div>
                        <div class="ms-3">
                             <div class="icon-circle bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-layer-group fa-lg"></i>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card stat-card h-100 border-left-info">
                <div class="card-body position-relative">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-info text-uppercase mb-1">Low Priority</div>
                            <div class="h2 mb-0 fw-bold text-gray-800">{{ $stats['low'] ?? 0 }}</div>
                            <div class="text-muted small mt-2">Planned</div>
                        </div>
                        <div class="ms-3">
                             <div class="icon-circle bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-calendar-alt fa-lg"></i>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Timeline / Schedule Section -->
    <div class="card shadow border-0 rounded-lg">
        <div class="card-header bg-white py-3 border-0 d-flex justify-content-between align-items-center">
            <h5 class="m-0 fw-bold text-primary"><i class="fas fa-stream me-2"></i> Master Production Schedule</h5>
            <span class="badge bg-light text-dark border">Ranked by Priority &amp; Time</span>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-custom mb-0 align-middle">
                    <thead>
                        <tr>
                            <th class="ps-4">Priority</th>
                            <th>Route Card</th>
                            <th>Project Start</th>
                            <th>Process Step</th>
                            <th>Resource (Machine/Op)</th>
                            <th>Scheduled Start</th>
                            <th>Scheduled End</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($timeline as $item)
                        <tr>
                            <td class="ps-4">
                                @if($item->priority == 'High')
                                    <span class="badge badge-pill-custom bg-danger bg-opacity-10 text-danger"><i class="fas fa-bolt me-1"></i> High</span>
                                @elseif($item->priority == 'Medium')
                                     <span class="badge badge-pill-custom bg-warning bg-opacity-10 text-warning text-dark"><i class="fas fa-circle me-1" style="font-size:0.6em;"></i> Medium</span>
                                @else
                                     <span class="badge badge-pill-custom bg-info bg-opacity-10 text-info"><i class="fas fa-arrow-down me-1"></i> Low</span>
                                @endif
                            </td>
                            <td class="fw-bold text-dark">{{ $item->route_no }}</td>
                            <td class="text-muted">{{ \Carbon\Carbon::parse($item->project_start_date)->format('M d, Y') }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm me-2 bg-light rounded-circle text-center" style="width:30px;height:30px;line-height:30px;">
                                        <small class="fw-bold">{{ substr($item->process, 0, 1) }}</small>
                                    </div>
                                    {{ $item->process }}
                                </div>
                            </td>
                            <td><i class="fas fa-cogs text-secondary me-1"></i> {{ $item->machine_name ?: 'Unassigned' }}</td>
                            <td class="text-primary fw-medium">{{ \Carbon\Carbon::parse($item->start_date)->format('d M H:i') }}</td>
                            <td class="text-secondary">{{ \Carbon\Carbon::parse($item->end_date)->format('d M H:i') }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-5 text-muted">
                                <i class="fas fa-calendar-times fa-3x mb-3 text-gray-300"></i><br>
                                No scheduled processes found.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
@endsection
