<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Admin Dashboard">
    <meta name="author" content="Indus Pro">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <link rel="icon" type="image/png" href="{{ asset('img/logo-sm-blue.png') }}">

    <title>@yield('title', 'Admin Dashboard')</title>

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/css/bootstrap-select.min.css">



    <!-- DataTables Bootstrap 5 & Plugins CSS -->
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">

    <!-- Toastr (Notifications) -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    
    <!-- Tempus Dominus Bootstrap 4 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.39.0/css/tempusdominus-bootstrap-4.min.css" />

    <!-- Your custom styles (if any) -->
    <link href="{{ asset('css/style.min.css') }}" rel="stylesheet">
    <style>
        .flex-wrap {
            flex-wrap: nowrap !important;
        }

        div.dataTables_wrapper div.dataTables_filter label {
            text-align: right;
        }

        button.btn.btn-danger.btn-sm.delete-btn {
            width: 61px;
        }
        .modal-header .btn-close {
            background-color: #fff;
            color: #4e73df;
        }
    </style>
    @stack('head')
    @yield('styles')
</head>

<body id="page-top" style="font-family: 'Poppins', sans-serif;">

    <div id="wrapper">
        @include('partials.superadminsidebar')

        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                @include('partials.topbar')
                <div class="container-fluid">
                    @yield('content')
                </div>
            </div>
            @include('partials.footer')
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/js/bootstrap-select.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.39.0/js/tempusdominus-bootstrap-4.min.js"></script>

    <!-- DataTables Core & Bootstrap 5 JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.colVis.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

    <!-- Toastr Notifications -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- SB Admin 2 (or your own custom JS, optional) -->
    {{-- <script src="{{ asset('js/sb-admin-2.min.js') }}"></script> --}}
    @include('layouts.scripts.methods')
    <script>
        $(document).ready(function() {
            updateDateTime();
            // Update every second
            setInterval(updateDateTime, 1000);
            $('.selectpicker').selectpicker();
            $('.datetimepicker').on("focus",function(event,...args){
                $(this).data('prev',$(this).val());
            });
            $('.datetimepicker').on("input",function(event,...args){
                let prev = $(this).data('prev');
                let value = (new Date($(this).val())).getTime();
                let minTime = $(this).data('min') ? (new Date($(this).data('min'))).getTime() : 0;
                let maxTime = $(this).data('max') ? (new Date($(this).data('max'))).getTime() : Infinity;
                let error = minTime > value ? true : false;
                error = maxTime < value ? true : error;
                console.log({minTime,value,error});
                if(error) { 
                    $(this).val(prev);
                    if($(this).data('min') && $(this).data('max')) { alert(`Should be with in ${$(this).data('min')} - ${$(this).data('max')} `);  }
                    if($(this).data('min')) { alert(`Should be grater than ${$(this).data('min')}`);  }
                    if($(this).data('max')) { alert(`Should be lesser than ${$(this).data('max')}`);  } 
                    
                }
            });
            $('#sidebarToggle').on('click', function(e) {
                e.preventDefault();
                $('body').toggleClass('sidebar-toggled');
                $('#accordionSidebar').toggleClass('toggled');
            });
        });
    </script>
    @stack('scripts')
    @yield('scripts')
</body>

</html>
