@extends('layouts.dashboard.adminapp')

@section('title', 'RFQ Details')

@section('content')
    <style>
        .rfq-view-card {
            background: linear-gradient(120deg, #f6d365 0%, #fda085 100%);
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
            border: none;
        }

        .rfq-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem 1rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .rfq-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .rfq-body {
            background: #fff;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .rfq-label {
            color: #4f4f4f;
            font-weight: 600;
        }

        .rfq-value {
            color: #2b2b2b;
            font-weight: 700;
        }

        .rfq-detail-row {
            margin-bottom: 1rem;
        }

        .rfq-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }

        @media (max-width: 991px) {
            .rfq-body {
                padding: 1.2rem;
            }

            .rfq-header {
                padding: 1rem 1rem 0.7rem 1rem;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-10">
                <div class="card rfq-view-card">
                    <div class="rfq-header">
                        <h3>
                            <i class="fas fa-file-alt"></i> RFQ Details
                        </h3>
                        <a href="{{ route('admin.rfq.rfqdetails') }}" class="btn btn-light rfq-back-btn">
                            <i class="fa fa-arrow-left"></i> Back
                        </a>
                    </div>
                    <div class="rfq-body">
                        <div class="row">
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">RFQ No:</span>
                                <div class="rfq-value">{{ $rfq->rfq_no }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">RFQ Date:</span>
                                <div class="rfq-value">{{ $rfq->rfq_date }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Customer:</span>
                                <div class="rfq-value">{{ $rfq->customerInfo->company ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Customer Ref No:</span>
                                <div class="rfq-value">{{ $rfq->cus_ref_no }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">RFQ Type:</span>
                                <div class="rfq-value">{{ $rfq->rfq_type }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Product Type:</span>
                                <div class="rfq-value">{{ $rfq->product_type }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Part No:</span>
                                <div class="rfq-value">{{ $rfq->part_no }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Project Material No:</span>
                                <div class="rfq-value">{{ $rfq->project_material_no }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Drawing No:</span>
                                <div class="rfq-value">{{ $rfq->drawing_no }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Drawing Revision:</span>
                                <div class="rfq-value">{{ $rfq->drawing_rev }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Quantity:</span>
                                <div class="rfq-value">{{ $rfq->quantity }}</div>
                            </div>
                            <div class="col-md-6 rfq-detail-row">
                                <span class="rfq-label">Unit of Measurement:</span>
                                <div class="rfq-value">{{ $rfq->uom }}</div>
                            </div>
                            <div class="col-md-12 rfq-detail-row">
                                <span class="rfq-label">Note:</span>
                                <div class="rfq-value">{{ $rfq->note }}</div>
                            </div>
                            <div class="col-md-12 rfq-detail-row">
                                <span class="rfq-label">Raw Material:</span>
                                <div class="rfq-value">
                                    @php
                                        $rawMaterials = json_decode($rfq->raw_material, true);
                                    @endphp
                                    @if (is_array($rawMaterials) && count($rawMaterials))
                                        <ol class="mb-0 ps-3">
                                            @foreach ($rawMaterials as $i => $matId)
                                                <li>
                                                    {{ $rawMaterialNames[$matId] ?? 'Unknown Material' }}
                                                </li>
                                            @endforeach
                                        </ol>
                                    @else
                                        <span>-</span>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <hr class="my-4">

                        <h5 class="mb-3"><i class="fas fa-paperclip me-2"></i>Attachments</h5>
                        <div class="row">
                            @if ($rfq->drawing_file)
                                <div class="col-md-4 mb-2">
                                    <span class="rfq-label">Drawing File:</span><br>
                                    <a href="{{ Storage::url($rfq->drawing_file) }}" target="_blank"
                                        class="btn btn-info btn-sm mt-1">View</a>
                                </div>
                            @endif
                            @if ($rfq->material_specification_file)
                                <div class="col-md-4 mb-2">
                                    <span class="rfq-label">Material Specification:</span><br>
                                    <a href="{{ Storage::url($rfq->material_specification_file) }}" target="_blank"
                                        class="btn btn-info btn-sm mt-1">View</a>
                                </div>
                            @endif
                            @if ($rfq->rfq_form_file)
                                <div class="col-md-4 mb-2">
                                    <span class="rfq-label">RFQ Form:</span><br>
                                    <a href="{{ Storage::url($rfq->rfq_form_file) }}" target="_blank"
                                        class="btn btn-info btn-sm mt-1">View</a>
                                </div>
                            @endif
                            @if ($rfq->annexure_file)
                                <div class="col-md-4 mb-2">
                                    <span class="rfq-label">Annexure:</span><br>
                                    <a href="{{ Storage::url($rfq->annexure_file) }}" target="_blank"
                                        class="btn btn-info btn-sm mt-1">View</a>
                                </div>
                            @endif
                        </div>

                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ route('admin.rfq.rfqdetails') }}" class="btn btn-light rfq-back-btn">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
