@extends('layouts.dashboard.adminapp')

@section('title', 'Manufacturing Dashboard')
@section('content')
    <style>
        button { width: auto; }
        /* Optional: Card icon alignment for consistent look */
        .card .col-auto { display: flex; align-items: center; }
        .card-footer { background: #fff; border-top: none; }
        .alert-item .badge-warning { background: #f59e42; color: #fff; }
        .alert-item .badge-error { background: #ef4444; color: #fff; }
        .alert-item { margin-bottom: 0.5rem; }
    </style>

    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / Manufacturing Dashboard </h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 mb-4">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Manufacturing Dashboard</h6>
                    </div>
                </div>
            </div>
        </div>
        <!-- Dashboard Cards -->
        <div class="row mb-4">
            <div class="col-12 col-sm-6 col-lg-3 mb-4">
                <div class="card border-left-primary shadow h-100">
                    <div class="card-body d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">Total Production</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($totalProduction ?? 0) }}</div>
                        </div>
                        <div class="col-auto ms-3">
                            <i class="fas fa-box-open fa-3x text-gray-300"></i>
                        </div>
                    </div>
                    <div class="card-footer border-0">
                        <a href="#" class="btn btn-light btn-icon-split w-100">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-lg-3 mb-4">
                <div class="card border-left-success shadow h-100">
                    <div class="card-body d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-md font-weight-bold text-success text-uppercase mb-1">Machine Utilization</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $machineUtilization ?? 0 }}%</div>
                        </div>
                        <div class="col-auto ms-3">
                            <i class="fas fa-tools fa-3x text-success"></i>
                        </div>
                    </div>
                    <div class="card-footer border-0">
                        <a href="#" class="btn btn-light btn-icon-split w-100">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-lg-3 mb-4">
                <div class="card border-left-info shadow h-100">
                    <div class="card-body d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-md font-weight-bold text-info text-uppercase mb-1">Quality Rate</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $qualityRate ?? 100 }}%</div>
                        </div>
                        <div class="col-auto ms-3">
                            <i class="fas fa-check-circle fa-3x text-info"></i>
                        </div>
                    </div>
                    <div class="card-footer border-0">
                        <a href="#" class="btn btn-light btn-icon-split w-100">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-lg-3 mb-4">
                <div class="card border-left-warning shadow h-100">
                    <div class="card-body d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-md font-weight-bold text-warning text-uppercase mb-1">OEE</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $oeeRate ?? 0 }}%</div>
                        </div>
                        <div class="col-auto ms-3">
                            <i class="fas fa-clock fa-3x text-warning"></i>
                        </div>
                    </div>
                    <div class="card-footer border-0">
                        <a href="#" class="btn btn-light btn-icon-split w-100">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Charts Row -->
        <div class="row mb-4">
            <div class="col-12 col-xl-6 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Production Trend</h6>
                        <div>
                            <button class="btn btn-sm btn-primary me-1 btn-time active" data-period="week">Week</button>
                            <button class="btn btn-sm btn-outline-primary me-1 btn-time" data-period="month">Month</button>
                            <button class="btn btn-sm btn-outline-primary btn-time" data-period="quarter">Quarter</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="production-chart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-12 col-xl-6 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Defect Analysis</h6>
                        <div>
                            <button class="btn btn-sm btn-primary me-1 btn-time active" data-period="week">Week</button>
                            <button class="btn btn-sm btn-outline-primary btn-time" data-period="month">Month</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="defect-chart"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <!-- Status, Production by Line, Alerts Row -->
        <div class="row mb-4">
            <div class="col-12 col-md-6 col-xl-4 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header">
                        <h6 class="mb-0">Machine Status</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="machine-status-chart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-4 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header">
                        <h6 class="mb-0">Production by Line</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="production-line-chart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-12 col-xl-4 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header">
                        <h6 class="mb-0">Recent Alerts</h6>
                    </div>
                    <div class="card-body">
                        <div class="activity-list" id="alert-list">
                            @forelse($recentAlerts as $alert)
                                <div class="alert-item">
                                    <span class="badge badge-warning">{{ $alert['type'] }}</span>
                                    <span>{{ $alert['message'] }}</span>
                                    <span class="text-muted small ms-2">{{ $alert['time'] }}</span>
                                </div>
                            @empty
                                <div class="text-muted">No alerts.</div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
    <script>
        window.productionTrend = @json($productionTrend ?? []);
        window.defectTrend = @json($defectTrend ?? []);
        window.machineStatus = @json($machineStatus ?? []);
        window.productionByLine = @json($productionByLine ?? []);

        // Production Trend Chart
        const prodLabels = Object.keys(window.productionTrend).map(date => moment(date).format('DD MMM'));
        const prodData = Object.values(window.productionTrend);
        new Chart(document.getElementById('production-chart'), {
            type: 'line',
            data: {
                labels: prodLabels,
                datasets: [{
                    label: 'Units Produced',
                    data: prodData,
                    borderColor: 'rgba(54,162,235,1)',
                    backgroundColor: 'rgba(54,162,235,0.2)',
                    fill: true,
                    tension: 0.2
                }]
            }
        });

        // Defect Analysis Chart
        const defectLabels = Object.keys(window.defectTrend).length ? Object.keys(window.defectTrend) : prodLabels;
        const defectData = Object.values(window.defectTrend).length ? Object.values(window.defectTrend) : prodData.map(() => Math.floor(Math.random() * 3));
        new Chart(document.getElementById('defect-chart'), {
            type: 'bar',
            data: {
                labels: defectLabels,
                datasets: [{
                    label: 'Defects',
                    data: defectData,
                    backgroundColor: 'rgba(255,99,132,0.7)'
                }]
            }
        });

        // Machine Status Pie Chart
        new Chart(document.getElementById('machine-status-chart'), {
            type: 'pie',
            data: {
                labels: Object.keys(window.machineStatus),
                datasets: [{
                    data: Object.values(window.machineStatus),
                    backgroundColor: ['#34d399', '#fbbf24', '#d1d5db']
                }]
            }
        });

        // Production by Line Bar Chart
        new Chart(document.getElementById('production-line-chart'), {
            type: 'bar',
            data: {
                labels: Object.keys(window.productionByLine),
                datasets: [{
                    label: 'Output',
                    data: Object.values(window.productionByLine),
                    backgroundColor: 'rgba(59,130,246,0.7)'
                }]
            }
        });

        // Dynamic Date
        function updateDateTime() {
            const now = new Date();
            document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday: 'long' });
            document.getElementById('daynum').textContent = now.getDate();
            document.getElementById('month').textContent = now.toLocaleString('en-us', { month: 'long' });
            document.getElementById('year').textContent = now.getFullYear();
            document.querySelector('.display-time').textContent = now.toLocaleTimeString();
        }
        updateDateTime();
        setInterval(updateDateTime, 1000);
    </script>
@endsection
