@extends('layouts.dashboard.adminapp')

@section('title', 'Employee Dashboard')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / Employee Dashboard </h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Content Row -->
    <div class="row bg-white">
        <div class="col-lg-12">
            <h1>Employee Dashboard</h1><br><br>

            <!-- Cards Container -->
            <div class="row">

                <!-- Total Employees -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Total Employee</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalEmployees }}</div>
                                    <div class="card-body">
                                        {{-- Placeholder: +5% from last month --}}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-users fa-3x text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Present Today -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-success text-uppercase mb-1">
                                        Present Today</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $presentToday }}</div>
                                    <div class="card-body">
                                        @php
                                            $attendanceRate = $totalEmployees ? round(($presentToday / $totalEmployees) * 100) : 0;
                                        @endphp
                                        {{ $attendanceRate }}% attendance rate
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-user-check fa-3x text-success"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Absent Today -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-info text-uppercase mb-1">
                                        Absent Today
                                    </div>
                                    <div class="row no-gutters align-items-center">
                                        <div class="col-auto">
                                            <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800">{{ $absentToday }}</div>
                                            <div class="card-body">
                                                @php
                                                    $absenceRate = $totalEmployees ? round(($absentToday / $totalEmployees) * 100) : 0;
                                                @endphp
                                                {{ $absenceRate }}% absence rate
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-user-times fa-3x text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- On Leave -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-warning text-uppercase mb-1">
                                        On Leave</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $onLeaveToday }}</div>
                                    <div class="card-body">
                                        {{-- You may add: {{ $onLeaveToday }} approved requests --}}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-umbrella-beach fa-3x text-warning"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Charts Container -->
            <div class="charts-container">
                <div class="row">
                    <!-- Monthly Attendance Chart -->
                    <div class="col-md-6">
                        <div class="chart-card">
                            <div class="chart-header">
                                <h3 class="chart-title">Monthly Attendance</h3>
                            </div>
                            <div class="chart-container">
                                <canvas id="attendanceChart" style="width: 100% !important; position: relative !important;"></canvas>
                            </div>
                        </div>
                    </div>
                    <!-- Department Distribution Chart -->
                    <div class="col-md-6">
                        <div class="chart-card">
                            <div class="chart-header">
                                <h3 class="chart-title">Department Distribution</h3>
                            </div>
                            <div class="chart-container">
                                <canvas id="departmentChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- /.container-fluid -->
    </div>

</div>
<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>

{{-- Pass PHP data to JS --}}
<script>
    // Attendance Monthly: {1: 100, 2: 80, ...} (month: presentCount)
    window.attendanceMonthly = @json($attendanceMonthly);
    // Department Distribution: {"HR": 10, "Dev": 30, ...}
    window.departmentDist = @json($departmentDist);
</script>

<script>
// Monthly Attendance Chart
const attendanceLabels = Object.keys(window.attendanceMonthly).map(month => {
    // Convert numeric month to full name
    return moment(month, 'M').format('MMMM');
});
const attendanceData = Object.values(window.attendanceMonthly);

const attendanceCtx = document.getElementById('attendanceChart').getContext('2d');
new Chart(attendanceCtx, {
    type: 'bar',
    data: {
        labels: attendanceLabels,
        datasets: [{
            label: 'Present Employees',
            data: attendanceData,
            backgroundColor: 'rgba(54, 162, 235, 0.7)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 1
        }]
    },
    options: {
        scales: { y: { beginAtZero: true } },
        responsive: true
    }
});

// Department Distribution Pie Chart
const depLabels = Object.keys(window.departmentDist);
const depData = Object.values(window.departmentDist);

const departmentCtx = document.getElementById('departmentChart').getContext('2d');
new Chart(departmentCtx, {
    type: 'pie',
    data: {
        labels: depLabels,
        datasets: [{
            data: depData,
            backgroundColor: [
                'rgba(255, 99, 132, 0.7)',
                'rgba(54, 162, 235, 0.7)',
                'rgba(255, 206, 86, 0.7)',
                'rgba(75, 192, 192, 0.7)',
                'rgba(153, 102, 255, 0.7)',
                'rgba(255, 159, 64, 0.7)',
                'rgba(99, 255, 192, 0.7)'
            ]
        }]
    },
    options: {
        responsive: true
    }
});

// Dynamic Date
function updateDateTime() {
    const now = new Date();
    document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday:'long' });
    document.getElementById('daynum').textContent = now.getDate();
    document.getElementById('month').textContent = now.toLocaleString('en-us', { month:'long' });
    document.getElementById('year').textContent = now.getFullYear();
    document.querySelector('.display-time').textContent = now.toLocaleTimeString();
}
updateDateTime();
setInterval(updateDateTime, 1000);

</script>
@endsection
