@extends('layouts.dashboard.adminapp')

@section('title', 'Customer/Vendor List')

@section('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
    <style>
        .dataTable {
            display: revert !important;
        }

        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }

        .card {
            border-radius: 16px !important;
            box-shadow: 0 6px 32px 0 rgba(44, 62, 80, 0.07), 0 1.5px 4px 0 rgba(44, 62, 80, 0.03) !important;
        }

        .custom-page-title {
            font-size: 2.2rem;
            font-weight: 600;
            color: #444;
            letter-spacing: .5px;
            margin-bottom: 1rem;
            text-align: center;
        }

        .custom-page-title i {
            font-size: 2.6rem;
            color: #5a8dee;
            margin-right: 10px;
            vertical-align: middle;
        }

        .add-customer-btn {
            min-width: 180px;
            font-weight: 500;
            font-size: 1.07rem;
        }

        .badge {
            font-size: 0.95em;
            padding: 5px 12px;
            border-radius: 12px;
        }

        .btn-info,
        .btn-warning,
        .btn-danger {
            min-width: 62px;
            font-weight: 500;
            font-size: 0.97rem;
        }

        .btn-danger {
            min-width: 80px;
        }

        th,
        td {
            vertical-align: middle !important;
        }

        .table-responsive {
            overflow-x: auto;
        }

    </style>
@endsection
@if (session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}

    </div>
@endif
@if (session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}

    </div>
@endif
@section('content')

    <!-- Header Bar with date/time and Add button -->
        <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h5 mb-0 text-gray-800 pl-2">UEPL | Customer & Vendor List</h1>
            <div class="display-date">
                <span id="day">day</span>,
                <span id="daynum">00</span>
                <span id="month">month</span>
                <span id="year">0000</span>
            </div>
            <div class="display-time"></div>
        </div>
        
    <!--<div class="container-fluid bg-white py-3" style="border-radius: 18px;">-->
        


        <!-- Centered title/icon -->


        

        <!-- Card with DataTable -->
        <div class="card mb-5 bg-white">
            <div class="card-header d-flex align-items-center justify-content-between" style="font-size: 1.15rem; font-weight: 500;">
            <div>
            </div>
            <div class="d-flex">
                <a href="#" class="btn btn-success btn-sm ms-2" data-toggle="modal" data-target="#bulkImportModal" title="Bulk Import" style="margin-right:10px;">
                    <i class="fas fa-upload"></i>
                </a>
                <a href="{{ route('admin.customer.addcustomer') }}" class="btn btn-primary btn-sm ms-2" title="Add New"><i class="fa fa-plus-square" aria-hidden="true"></i></a>
            </div>
        </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered align-middle" id="customerTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Company Role</th>
                                <th>Company Name</th>
                                <th>Company Acronym</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Secondary Mobile</th>
                                <th>Company Type</th>
                                <th>Logo</th>
                                <th>GST</th>
                                <th>PAN</th>
                                <th>MSME/Udyam</th>
                                <th>IEC</th>
                                <th>Billing Address</th>
                                <th>Shipping Address</th>
                                <th>Website</th>
                                <th>Bank Name</th>
                                <th>Bank Branch</th>
                                <th>Account Number</th>
                                <th>Account Type</th>
                                <th>Account Holder Name</th>
                                <th>Account Currency</th>
                                <th>IFSC Code</th>
                                <th>SWIFT/BIC Code</th>
                                <th>Status</th>
                                <!-- Contact Persons -->
                                <th>Contact Name 1</th>
                                <th>Contact Email 1</th>
                                <th>Contact Mobile 1</th>
                                <th>Contact Designation 1</th>
                                <th style="min-width: 160px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $i = 1;
                            @endphp
                            @foreach ($customers as $customer)
                                <tr id="row-{{ $customer->id }}">
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $customer->company_role }}</td>
                                    <td>{{ $customer->company }}</td>
                                    <td>{{ $customer->company_nickname }}</td>
                                    <td>{{ $customer->email }}</td>
                                    <td>{{ $customer->mobile }}</td>
                                    <td>{{ $customer->secondary_mobile }}</td>
                                    <td>{{ $customer->company_type }}</td>
                                    <td>
                                        @if ($customer->image)
                                            <img src="{{ asset('storage/' . $customer->image) }}" alt="Logo"
                                                style="width: 50px; height: 50px; border-radius: 50%;">
                                        @else
                                            No Logo
                                        @endif
                                    <td>{{ $customer->gstno }}</td>
                                    <td>{{ $customer->panno }}</td>
                                    <td>{{ $customer->msmeno }}</td>
                                    <td>{{ $customer->iecno }}</td>
                                    <td>{{ $customer->billing_address }}</td>
                                    <td>{{ $customer->shipping_address }}</td>
                                    <td>{{ $customer->url }}</td>
                                    <td>{{ $customer->bank_name }}</td>
                                    <td>{{ $customer->branch_name }}</td>
                                    <td>{{ $customer->account_number }}</td>
                                    <td>{{ $customer->account_type }}</td>
                                    <td>{{ $customer->account_holder_name }}</td>
                                    <td>{{ $customer->account_currency }}</td>
                                    <td>{{ $customer->ifsc_code }}</td>
                                    <td>{{ $customer->swift_code }}</td>
                                    <td>
                                        @if ($customer->status == 1)
                                            <span class="badge bg-success text-white">Active</span>
                                        @else
                                            <span class="badge bg-secondary text-white">Inactive</span>
                                        @endif
                                    </td>
                                    <!-- Contact Person 1 -->
                                    <td>{{ $customer->contactPersons[0]->name ?? '' }}</td>
                                    <td>{{ $customer->contactPersons[0]->email ?? '' }}</td>
                                    <td>{{ $customer->contactPersons[0]->mobile ?? '' }}</td>
                                    <td>{{ $customer->contactPersons[0]->designation ?? '' }}</td>
                                    <td>
                                        <a href="{{ route('admin.customer.show', $customer->id) }}"
                                            class="btn btn-info btn-sm me-1"><i class="fa fa-eye" title="View"></i></a>
                                        <a href="{{ route('admin.customer.edit', $customer->id) }}"
                                            class="btn btn-warning btn-sm me-1"><i class="fa fa-edit" title="Edit"></i></a>
                                        <button class="btn btn-danger btn-sm delete-btn"
                                            data-id="{{ $customer->id }}"><i class="fa fa-trash" title="Delete"></i></button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    <!--</div>-->
    <!-- Bulk Import Modal -->
    <div class="modal fade" id="bulkImportModal" tabindex="-1" aria-labelledby="bulkImportModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form method="POST" action="{{ route('admin.customer.import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Bulk Upload Customers/Vendors</h5>
                        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"
                            style="width: auto">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="excel_file" class="form-label">Upload Excel File (.xlsx)</label>
                            <input class="form-control" type="file" id="excel_file" name="excel_file" accept=".xlsx"
                                required>
                            <small>
                                <a href="{{ asset('templates/customer_vendor_import_template.xlsx') }}" download>
                                    Download Sample Template
                                </a>
                            </small>
                        </div>
                        <div class="mb-2 text-muted">
                            <b>Note:</b> Only XLSX format allowed. Download and follow the template!
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Import</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            // DataTable
            var table = $('#customerTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                pageLength: 10,
                responsive: true,
                language: {
                    "emptyTable": "No customers found"
                }
            });

            // AJAX Delete
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                if (confirm('Are you sure you want to delete this customer?')) {
                    $.ajax({
                        url: '{{ url('admin/customers') }}/' + id,
                        type: 'DELETE',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            table.row('#row-' + id).remove().draw(false);
                            toastr.success('Customer deleted successfully!');
                        },
                        error: function(xhr) {
                            toastr.error('Could not delete customer.');
                        }
                    });
                }
            });
            // Wrap buttons and filter in a flex container
            const wrapper = $('<div class="d-flex justify-content-between align-items-center flex-wrap mb-3"></div>');
            wrapper.append($('.dt-buttons')).append($('#customerTable_filter'));
            $('#customerTable_wrapper').prepend(wrapper);
        });
    </script>
@endsection
